/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.openwire.NotEnoughBytesException;
import org.hornetq.utils.UTF8Util;

public class DataInputWrapper
implements DataInput {
    private static final int DEFAULT_CAPACITY = 0x100000;
    private static final NotEnoughBytesException exception = new NotEnoughBytesException();
    private ByteBuffer internalBuffer;

    public DataInputWrapper() {
        this(0x100000);
    }

    public DataInputWrapper(int capacity) {
        this.internalBuffer = ByteBuffer.allocateDirect(capacity);
        this.internalBuffer.mark();
        this.internalBuffer.limit(0);
    }

    public void receiveData(byte[] data) {
        int newSize = data.length;
        int freeSpace = this.internalBuffer.capacity() - this.internalBuffer.limit();
        if (freeSpace < newSize) {
            this.internalBuffer.reset();
            this.internalBuffer.compact();
            if (this.internalBuffer.remaining() < newSize) {
                // empty if block
            }
            int pos = this.internalBuffer.position();
            this.internalBuffer.position(0);
            this.internalBuffer.mark();
            this.internalBuffer.position(pos);
        } else {
            this.internalBuffer.position(this.internalBuffer.limit());
            this.internalBuffer.limit(this.internalBuffer.capacity());
        }
        this.internalBuffer.put(data);
        this.internalBuffer.limit(this.internalBuffer.position());
        this.internalBuffer.reset();
    }

    public void receiveData(HornetQBuffer buffer) {
        int newSize = buffer.readableBytes();
        byte[] newData = new byte[newSize];
        buffer.readBytes(newData);
        this.receiveData(newData);
    }

    public void mark() {
        this.internalBuffer.mark();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    private void checkSize(int n) throws NotEnoughBytesException {
        if (this.internalBuffer.remaining() < n) {
            throw exception;
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.checkSize(len);
        this.internalBuffer.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.checkSize(n);
        int pos = this.internalBuffer.position();
        this.internalBuffer.position(pos + n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkSize(1);
        byte b = this.internalBuffer.get();
        return b != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.checkSize(1);
        return this.internalBuffer.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkSize(1);
        return 0xFF & this.internalBuffer.get();
    }

    @Override
    public short readShort() throws IOException {
        this.checkSize(2);
        return this.internalBuffer.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.checkSize(2);
        return 0xFFFF & this.internalBuffer.getShort();
    }

    @Override
    public char readChar() throws IOException {
        this.checkSize(2);
        return this.internalBuffer.getChar();
    }

    @Override
    public int readInt() throws IOException {
        this.checkSize(4);
        return this.internalBuffer.getInt();
    }

    @Override
    public long readLong() throws IOException {
        this.checkSize(8);
        return this.internalBuffer.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.checkSize(4);
        return this.internalBuffer.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.checkSize(8);
        return this.internalBuffer.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder sb = new StringBuilder("");
        char c = this.readChar();
        while (c != '\n') {
            sb.append(c);
            c = this.readChar();
        }
        return sb.toString();
    }

    @Override
    public String readUTF() throws IOException {
        UTF8Util.StringUtilBuffer buffer = UTF8Util.getThreadLocalBuffer();
        int size = this.readUnsignedShort();
        if (size > buffer.byteBuffer.length) {
            buffer.resizeByteBuffer(size);
        }
        if (size > buffer.charBuffer.length) {
            buffer.resizeCharBuffer(size);
        }
        int count = 0;
        int charCount = 0;
        this.readFully(buffer.byteBuffer, 0, size);
        block4: while (count < size) {
            byte byte1;
            if ((byte1 = buffer.byteBuffer[count++]) > 0 && byte1 <= 127) {
                buffer.charBuffer[charCount++] = (char)byte1;
                continue;
            }
            int c = byte1 & 0xFF;
            switch (c >> 4) {
                case 12: 
                case 13: {
                    byte byte2 = buffer.byteBuffer[count++];
                    buffer.charBuffer[charCount++] = (char)((c & 0x1F) << 6 | byte2 & 0x3F);
                    continue block4;
                }
                case 14: {
                    byte byte2 = buffer.byteBuffer[count++];
                    byte byte3 = buffer.byteBuffer[count++];
                    buffer.charBuffer[charCount++] = (char)((c & 0xF) << 12 | (byte2 & 0x3F) << 6 | (byte3 & 0x3F) << 0);
                    continue block4;
                }
            }
            throw new InternalError("unhandled utf8 byte " + c);
        }
        return new String(buffer.charBuffer, 0, charCount);
    }

    public boolean readable() {
        return this.internalBuffer.hasRemaining();
    }
}

