/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.JMSSecurityException;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ControlCommand;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.FlushCommand;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.state.CommandVisitor;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.TransmitCallback;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQSecurityException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.openwire.AMQConnectorImpl;
import org.hornetq.core.protocol.openwire.DataInputWrapper;
import org.hornetq.core.protocol.openwire.NotEnoughBytesException;
import org.hornetq.core.protocol.openwire.OpenWireProtocolManager;
import org.hornetq.core.protocol.openwire.OpenWireUtil;
import org.hornetq.core.protocol.openwire.SendingResult;
import org.hornetq.core.protocol.openwire.amq.AMQBrokerStoppedException;
import org.hornetq.core.protocol.openwire.amq.AMQConnectionContext;
import org.hornetq.core.protocol.openwire.amq.AMQConsumerBrokerExchange;
import org.hornetq.core.protocol.openwire.amq.AMQMapTransportConnectionStateRegister;
import org.hornetq.core.protocol.openwire.amq.AMQMessageAuthorizationPolicy;
import org.hornetq.core.protocol.openwire.amq.AMQProducerBrokerExchange;
import org.hornetq.core.protocol.openwire.amq.AMQSession;
import org.hornetq.core.protocol.openwire.amq.AMQSingleTransportConnectionStateRegister;
import org.hornetq.core.protocol.openwire.amq.AMQTransaction;
import org.hornetq.core.protocol.openwire.amq.AMQTransportConnectionState;
import org.hornetq.core.protocol.openwire.amq.AMQTransportConnectionStateRegister;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.utils.ConcurrentHashSet;

public class OpenWireConnection
implements RemotingConnection,
CommandVisitor {
    private final OpenWireProtocolManager protocolManager;
    private final Connection transportConnection;
    private final AMQConnectorImpl acceptorUsed;
    private final long creationTime;
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private boolean destroyed = false;
    private final Object sendLock = new Object();
    private boolean dataReceived;
    private OpenWireFormat wireFormat;
    private AMQTransportConnectionStateRegister connectionStateRegister = new AMQSingleTransportConnectionStateRegister();
    private boolean faultTolerantConnection;
    private AMQConnectionContext context;
    private AMQMessageAuthorizationPolicy messageAuthorizationPolicy;
    private boolean networkConnection;
    private boolean manageable;
    private boolean pendingStop;
    private Throwable stopError = null;
    private final TaskRunnerFactory stopTaskRunnerFactory = null;
    private boolean starting;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final ReentrantReadWriteLock serviceLock = new ReentrantReadWriteLock();
    private final CountDownLatch stopped = new CountDownLatch(1);
    protected TaskRunner taskRunner;
    private boolean active;
    protected final List<Command> dispatchQueue = new LinkedList<Command>();
    private boolean markedCandidate;
    private boolean blockedCandidate;
    private long timeStamp;
    private boolean inServiceException;
    private final AtomicBoolean asyncException = new AtomicBoolean(false);
    private final Map<ConsumerId, AMQConsumerBrokerExchange> consumerExchanges = new HashMap<ConsumerId, AMQConsumerBrokerExchange>();
    private final Map<ProducerId, AMQProducerBrokerExchange> producerExchanges = new HashMap<ProducerId, AMQProducerBrokerExchange>();
    private AMQTransportConnectionState state;
    private final Set<String> tempQueues = new ConcurrentHashSet();
    protected final Map<ConnectionId, ConnectionState> brokerConnectionStates;
    private DataInputWrapper dataInput = new DataInputWrapper();
    private Map<TransactionId, TransactionInfo> txMap = new ConcurrentHashMap<TransactionId, TransactionInfo>();
    private volatile AMQSession advisorySession;

    public OpenWireConnection(Acceptor acceptorUsed, Connection connection, OpenWireProtocolManager openWireProtocolManager, OpenWireFormat wf) {
        this.protocolManager = openWireProtocolManager;
        this.transportConnection = connection;
        this.acceptorUsed = new AMQConnectorImpl(acceptorUsed);
        this.wireFormat = wf;
        this.brokerConnectionStates = this.protocolManager.getConnectionStates();
        this.creationTime = System.currentTimeMillis();
    }

    public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
        try {
            this.dataInput.receiveData(buffer);
        }
        catch (Throwable t) {
            HornetQServerLogger.LOGGER.error((Object)"decoding error", t);
            return;
        }
        while (this.dataInput.readable()) {
            try {
                Object object = null;
                try {
                    object = this.wireFormat.unmarshal((DataInput)this.dataInput);
                    this.dataInput.mark();
                }
                catch (NotEnoughBytesException e) {
                    return;
                }
                Command command = (Command)object;
                boolean responseRequired = command.isResponseRequired();
                int commandId = command.getCommandId();
                if (command.getClass() == KeepAliveInfo.class) {
                    KeepAliveInfo info = (KeepAliveInfo)command;
                    if (!info.isResponseRequired()) continue;
                    info.setResponseRequired(false);
                    this.protocolManager.sendReply(this, (Command)info);
                    continue;
                }
                if (command.getClass() == WireFormatInfo.class) {
                    this.negotiate((WireFormatInfo)command);
                    continue;
                }
                if (command.getClass() == ConnectionInfo.class || command.getClass() == ConsumerInfo.class || command.getClass() == RemoveInfo.class || command.getClass() == SessionInfo.class || command.getClass() == ProducerInfo.class || ActiveMQMessage.class.isAssignableFrom(command.getClass()) || command.getClass() == MessageAck.class || command.getClass() == TransactionInfo.class || command.getClass() == DestinationInfo.class || command.getClass() == ShutdownInfo.class) {
                    Response response = null;
                    if (this.pendingStop) {
                        response = new ExceptionResponse(this.stopError);
                    } else {
                        response = command.visit((CommandVisitor)this);
                        if (response instanceof ExceptionResponse && !responseRequired) {
                            Throwable cause = ((ExceptionResponse)response).getException();
                            this.serviceException(cause);
                            response = null;
                        }
                    }
                    if (responseRequired && response == null) {
                        response = new Response();
                    }
                    if (this.context != null) {
                        if (this.context.isDontSendReponse()) {
                            this.context.setDontSendReponse(false);
                            response = null;
                        }
                        this.context = null;
                    }
                    if (response == null || this.protocolManager.isStopping()) continue;
                    response.setCorrelationId(commandId);
                    this.dispatchSync((Command)response);
                    continue;
                }
                this.protocolManager.handleCommand(this, command);
            }
            catch (IOException e) {
                HornetQServerLogger.LOGGER.error((Object)"error decoding", (Throwable)e);
            }
            catch (Throwable t) {
                HornetQServerLogger.LOGGER.error((Object)"error decoding", t);
            }
        }
    }

    private void negotiate(WireFormatInfo command) throws IOException {
        this.wireFormat.renegotiateWireFormat(command);
    }

    public Object getID() {
        return this.transportConnection.getID();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        this.failureListeners.add(listener);
    }

    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        return this.failureListeners.remove(listener);
    }

    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        return this.closeListeners.remove(listener);
    }

    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    public List<FailureListener> getFailureListeners() {
        return Collections.emptyList();
    }

    public List<FailureListener> removeFailureListeners() {
        ArrayList<FailureListener> ret = new ArrayList<FailureListener>(this.failureListeners);
        this.failureListeners.clear();
        return ret;
    }

    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    public HornetQBuffer createBuffer(int size) {
        return HornetQBuffers.dynamicBuffer((int)size);
    }

    public void fail(HornetQException me) {
        HornetQServerLogger.LOGGER.connectionFailureDetected(me.getMessage(), me.getType());
        this.callFailureListeners(me);
        this.callClosingListeners();
        this.destroyed = true;
        this.transportConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        this.transportConnection.close();
        try {
            this.deleteTempQueues();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.sendLock;
        synchronized (object) {
            this.callClosingListeners();
        }
    }

    private void deleteTempQueues() throws Exception {
        for (String q : this.tempQueues) {
            this.protocolManager.deleteQueue(q);
        }
    }

    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void disconnect(boolean criticalError) {
        this.fail(null);
    }

    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    public void flush() {
    }

    private void callFailureListeners(HornetQException me) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                HornetQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    private void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                HornetQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    public void init() {
        WireFormatInfo info = this.wireFormat.getPreferedWireFormatInfo();
        this.protocolManager.send(this, (Command)info);
    }

    public ConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicalSend(Command command) throws IOException {
        try {
            ByteSequence bytes = this.wireFormat.marshal((Object)command);
            HornetQBuffer buffer = OpenWireUtil.toHornetQBuffer(bytes);
            Object object = this.sendLock;
            synchronized (object) {
                this.getTransportConnection().write(buffer, false, false);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            HornetQServerLogger.LOGGER.error((Object)"error sending", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response processAddConnection(ConnectionInfo info) throws Exception {
        WireFormatInfo wireFormatInfo = this.wireFormat.getPreferedWireFormatInfo();
        if (wireFormatInfo != null && wireFormatInfo.getVersion() <= 2) {
            info.setClientMaster(true);
        }
        Object object = this.brokerConnectionStates;
        synchronized (object) {
            this.state = (AMQTransportConnectionState)this.brokerConnectionStates.get(info.getConnectionId());
            if (this.state == null) {
                this.state = new AMQTransportConnectionState(info, this);
                this.brokerConnectionStates.put(info.getConnectionId(), this.state);
            }
            this.state.incrementReference();
        }
        object = this.state.getConnectionMutex();
        synchronized (object) {
            if (this.state.getConnection() != this) {
                this.state.getConnection().disconnect(true);
                this.state.setConnection(this);
                this.state.reset(info);
            }
        }
        this.registerConnectionState(info.getConnectionId(), this.state);
        this.faultTolerantConnection = info.isFaultTolerant();
        String clientId = info.getClientId();
        this.context = new AMQConnectionContext();
        this.context.setBroker(this.protocolManager);
        this.context.setClientId(clientId);
        this.context.setClientMaster(info.isClientMaster());
        this.context.setConnection(this);
        this.context.setConnectionId(info.getConnectionId());
        this.context.setConnector(this.acceptorUsed);
        this.context.setMessageAuthorizationPolicy(this.getMessageAuthorizationPolicy());
        this.context.setNetworkConnection(this.networkConnection);
        this.context.setFaultTolerant(this.faultTolerantConnection);
        this.context.setTransactions(new ConcurrentHashMap<TransactionId, AMQTransaction>());
        this.context.setUserName(info.getUserName());
        this.context.setWireFormatInfo(wireFormatInfo);
        this.context.setReconnect(info.isFailoverReconnect());
        this.manageable = info.isManageable();
        this.context.setConnectionState(this.state);
        this.state.setContext(this.context);
        this.state.setConnection(this);
        if (info.getClientIp() == null) {
            info.setClientIp(this.getRemoteAddress());
        }
        try {
            this.protocolManager.addConnection(this.context, info);
        }
        catch (Exception e) {
            Map<ConnectionId, ConnectionState> map = this.brokerConnectionStates;
            synchronized (map) {
                this.brokerConnectionStates.remove(info.getConnectionId());
            }
            this.unregisterConnectionState(info.getConnectionId());
            if (e instanceof SecurityException) {
                this.delayedStop(2000, "Failed with SecurityException: " + e.getLocalizedMessage(), e);
            }
            ExceptionResponse resp = new ExceptionResponse((Throwable)e);
            return resp;
        }
        if (info.isManageable()) {
            ConnectionControl command = this.acceptorUsed.getConnectionControl();
            command.setFaultTolerant(this.protocolManager.isFaultTolerantConfiguration());
            if (info.isFailoverReconnect()) {
                command.setRebalanceConnection(false);
            }
            this.dispatchAsync((Command)command);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchAsync(Command message) {
        if (!this.stopping.get()) {
            if (this.taskRunner == null) {
                this.dispatchSync(message);
            } else {
                List<Command> list = this.dispatchQueue;
                synchronized (list) {
                    this.dispatchQueue.add(message);
                }
                try {
                    this.taskRunner.wakeup();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        } else if (message.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)message;
            TransmitCallback sub = md.getTransmitCallback();
            this.protocolManager.postProcessDispatch(md);
            if (sub != null) {
                sub.onFailure();
            }
        }
    }

    public void dispatchSync(Command message) {
        try {
            this.processDispatch(message);
        }
        catch (IOException e) {
            this.serviceExceptionAsync(e);
        }
    }

    public void serviceExceptionAsync(final IOException e) {
        if (this.asyncException.compareAndSet(false, true)) {
            new Thread("Async Exception Handler"){

                @Override
                public void run() {
                    OpenWireConnection.this.serviceException(e);
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceException(Throwable e) {
        if (e instanceof IOException) {
            this.serviceTransportException((IOException)e);
        } else if (e.getClass() == AMQBrokerStoppedException.class) {
            if (!this.stopping.get()) {
                ConnectionError ce = new ConnectionError();
                ce.setException(e);
                this.dispatchSync((Command)ce);
                this.stopError = e;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                this.stopAsync();
            }
        } else if (!this.stopping.get() && !this.inServiceException) {
            this.inServiceException = true;
            try {
                ConnectionError ce = new ConnectionError();
                ce.setException(e);
                if (this.pendingStop) {
                    this.dispatchSync((Command)ce);
                } else {
                    this.dispatchAsync((Command)ce);
                }
            }
            finally {
                this.inServiceException = false;
            }
        }
    }

    public void serviceTransportException(IOException e) {
    }

    public void setMarkedCandidate(boolean markedCandidate) {
        this.markedCandidate = markedCandidate;
        if (!markedCandidate) {
            this.timeStamp = 0L;
            this.blockedCandidate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(Command command) throws IOException {
        try {
            this.setMarkedCandidate(true);
            this.physicalSend(command);
        }
        finally {
            this.setMarkedCandidate(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDispatch(Command command) throws IOException {
        MessageDispatch messageDispatch = (MessageDispatch)(command.isMessageDispatch() ? command : null);
        try {
            if (!this.stopping.get()) {
                if (messageDispatch != null) {
                    this.protocolManager.preProcessDispatch(messageDispatch);
                }
                this.dispatch(command);
            }
        }
        catch (IOException e) {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.protocolManager.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onFailure();
                }
                messageDispatch = null;
                throw e;
            }
        }
        finally {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.protocolManager.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onSuccess();
                }
            }
        }
    }

    private AMQMessageAuthorizationPolicy getMessageAuthorizationPolicy() {
        return this.messageAuthorizationPolicy;
    }

    protected synchronized AMQTransportConnectionState unregisterConnectionState(ConnectionId connectionId) {
        return this.connectionStateRegister.unregisterConnectionState(connectionId);
    }

    protected synchronized AMQTransportConnectionState registerConnectionState(ConnectionId connectionId, AMQTransportConnectionState state) {
        AMQTransportConnectionState cs = null;
        if (!this.connectionStateRegister.isEmpty() && !this.connectionStateRegister.doesHandleMultipleConnectionStates()) {
            AMQMapTransportConnectionStateRegister newRegister = new AMQMapTransportConnectionStateRegister();
            newRegister.intialize(this.connectionStateRegister);
            this.connectionStateRegister = newRegister;
        }
        cs = this.connectionStateRegister.registerConnectionState(connectionId, state);
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayedStop(final int waitTime, String reason, Throwable cause) {
        if (waitTime > 0) {
            OpenWireConnection openWireConnection = this;
            synchronized (openWireConnection) {
                this.pendingStop = true;
                this.stopError = cause;
            }
            try {
                this.stopTaskRunnerFactory.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(waitTime);
                            OpenWireConnection.this.stopAsync();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAsync() {
        OpenWireConnection openWireConnection = this;
        synchronized (openWireConnection) {
            this.pendingStop = true;
            if (this.starting) {
                return;
            }
        }
        if (this.stopping.compareAndSet(false, true)) {
            List<AMQTransportConnectionState> connectionStates = this.listConnectionStates();
            for (AMQTransportConnectionState cs : connectionStates) {
                AMQConnectionContext connectionContext = cs.getContext();
                if (connectionContext == null) continue;
                connectionContext.getStopping().set(true);
            }
            try {
                this.stopTaskRunnerFactory.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        OpenWireConnection.this.serviceLock.writeLock().lock();
                        try {
                            OpenWireConnection.this.doStop();
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            OpenWireConnection.this.stopped.countDown();
                            OpenWireConnection.this.serviceLock.writeLock().unlock();
                        }
                    }
                });
            }
            catch (Throwable t) {
                this.stopped.countDown();
            }
        }
    }

    protected synchronized List<AMQTransportConnectionState> listConnectionStates() {
        return this.connectionStateRegister.listConnectionStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        this.acceptorUsed.onStopped(this);
        try {
            this.getTransportConnection().close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.taskRunner != null) {
            this.taskRunner.shutdown(1L);
            this.taskRunner = null;
        }
        this.active = false;
        List<Command> e = this.dispatchQueue;
        synchronized (e) {
            for (Command command : this.dispatchQueue) {
                if (!command.isMessageDispatch()) continue;
                MessageDispatch md = (MessageDispatch)command;
                TransmitCallback sub = md.getTransmitCallback();
                this.protocolManager.postProcessDispatch(md);
                if (sub == null) continue;
                sub.onFailure();
            }
            this.dispatchQueue.clear();
        }
        if (!this.protocolManager.isStopped()) {
            List<AMQTransportConnectionState> connectionStates = this.listConnectionStates();
            connectionStates = this.listConnectionStates();
            for (AMQTransportConnectionState cs : connectionStates) {
                cs.getContext().getStopping().set(true);
                try {
                    this.processRemoveConnection(cs.getInfo().getConnectionId(), 0L);
                }
                catch (Throwable ignore) {
                    ignore.printStackTrace();
                }
            }
        }
    }

    public Response processAddConsumer(ConsumerInfo info) {
        ExceptionResponse resp = null;
        try {
            this.protocolManager.addConsumer(this, info);
        }
        catch (Exception e) {
            resp = e instanceof HornetQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : new ExceptionResponse((Throwable)e);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AMQConsumerBrokerExchange addConsumerBrokerExchange(ConsumerId id) {
        AMQConsumerBrokerExchange result = this.consumerExchanges.get(id);
        if (result == null) {
            Map<ConsumerId, AMQConsumerBrokerExchange> map = this.consumerExchanges;
            synchronized (map) {
                ConsumerInfo info;
                ConsumerState cs;
                result = new AMQConsumerBrokerExchange();
                AMQTransportConnectionState state = this.lookupConnectionState(id);
                this.context = state.getContext();
                result.setConnectionContext(this.context);
                SessionState ss = state.getSessionState(id.getParentId());
                if (ss != null && (cs = ss.getConsumerState(id)) != null && (info = cs.getInfo()) != null && info.getDestination() != null && info.getDestination().isPattern()) {
                    result.setWildcard(true);
                }
                this.consumerExchanges.put(id, result);
            }
        }
        return result;
    }

    protected synchronized AMQTransportConnectionState lookupConnectionState(ConsumerId id) {
        return this.connectionStateRegister.lookupConnectionState(id);
    }

    protected synchronized AMQTransportConnectionState lookupConnectionState(ProducerId id) {
        return this.connectionStateRegister.lookupConnectionState(id);
    }

    public int getConsumerCount(ConnectionId connectionId) {
        int result = 0;
        AMQTransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs != null) {
            for (SessionId sessionId : cs.getSessionIds()) {
                SessionState sessionState = cs.getSessionState(sessionId);
                if (sessionState == null) continue;
                result += sessionState.getConsumerIds().size();
            }
        }
        return result;
    }

    public int getProducerCount(ConnectionId connectionId) {
        int result = 0;
        AMQTransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs != null) {
            for (SessionId sessionId : cs.getSessionIds()) {
                SessionState sessionState = cs.getSessionState(sessionId);
                if (sessionState == null) continue;
                result += sessionState.getProducerIds().size();
            }
        }
        return result;
    }

    public synchronized AMQTransportConnectionState lookupConnectionState(ConnectionId connectionId) {
        return this.connectionStateRegister.lookupConnectionState(connectionId);
    }

    public Response processAddDestination(DestinationInfo dest) throws Exception {
        ExceptionResponse resp = null;
        try {
            this.protocolManager.addDestination(this, dest);
        }
        catch (Exception e) {
            resp = e instanceof HornetQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : new ExceptionResponse((Throwable)e);
        }
        return resp;
    }

    public Response processAddProducer(ProducerInfo info) throws Exception {
        this.protocolManager.addProducer(this, info);
        return null;
    }

    public Response processAddSession(SessionInfo info) throws Exception {
        ConnectionId connectionId = info.getSessionId().getParentId();
        AMQTransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs != null && !cs.getSessionIds().contains(info.getSessionId())) {
            this.protocolManager.addSession(this, info);
            try {
                cs.addSession(info);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                this.protocolManager.removeSession(cs.getContext(), info);
            }
        }
        return null;
    }

    public Response processBeginTransaction(TransactionInfo info) throws Exception {
        TransactionId txId = info.getTransactionId();
        if (!this.txMap.containsKey(txId)) {
            this.txMap.put(txId, info);
        }
        return null;
    }

    public Response processBrokerInfo(BrokerInfo arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processCommitTransactionOnePhase(TransactionInfo info) throws Exception {
        this.protocolManager.commitTransactionOnePhase(info);
        TransactionId txId = info.getTransactionId();
        this.txMap.remove(txId);
        return null;
    }

    public Response processCommitTransactionTwoPhase(TransactionInfo info) throws Exception {
        this.protocolManager.commitTransactionTwoPhase(info);
        TransactionId txId = info.getTransactionId();
        this.txMap.remove(txId);
        return null;
    }

    public Response processConnectionControl(ConnectionControl arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processConnectionError(ConnectionError arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processConsumerControl(ConsumerControl arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processControlCommand(ControlCommand arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processEndTransaction(TransactionInfo info) throws Exception {
        TransactionId txId = info.getTransactionId();
        if (!this.txMap.containsKey(txId)) {
            this.txMap.put(txId, info);
        }
        return null;
    }

    public Response processFlush(FlushCommand arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processForgetTransaction(TransactionInfo info) throws Exception {
        TransactionId txId = info.getTransactionId();
        this.txMap.remove(txId);
        this.protocolManager.forgetTransaction(info.getTransactionId());
        return null;
    }

    public Response processKeepAlive(KeepAliveInfo arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processMessage(Message messageSend) {
        ExceptionResponse resp = null;
        try {
            ProducerId producerId = messageSend.getProducerId();
            AMQProducerBrokerExchange producerExchange = this.getProducerBrokerExchange(producerId);
            AMQConnectionContext pcontext = producerExchange.getConnectionContext();
            ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
            boolean sendProducerAck = !messageSend.isResponseRequired() && producerInfo.getWindowSize() > 0 && !pcontext.isInRecoveryMode();
            AMQSession session = this.protocolManager.getSession(producerId.getParentId());
            if (producerExchange.canDispatch(messageSend)) {
                SendingResult result = session.send(producerExchange, messageSend, sendProducerAck);
                if (result.isBlockNextSend()) {
                    if (!this.context.isNetworkConnection() && result.isSendFailIfNoSpace()) {
                        throw new ResourceAllocationException("Usage Manager Memory Limit reached. Stopping producer (" + producerId + ") to prevent flooding " + result.getBlockingAddress() + "." + " See http://activemq.apache.org/producer-flow-control.html for more info");
                    }
                    if (producerInfo.getWindowSize() > 0 || messageSend.isResponseRequired()) {
                        if (this.context == null) {
                            this.context = new AMQConnectionContext();
                        }
                        this.context.setDontSendReponse(true);
                    } else {
                        session.blockingWaitForSpace(producerExchange, result);
                    }
                } else if (sendProducerAck) {
                    ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), messageSend.getSize());
                    this.dispatchAsync((Command)ack);
                }
            }
        }
        catch (Exception e) {
            resp = e instanceof HornetQSecurityException ? new ExceptionResponse((Throwable)new JMSSecurityException(e.getMessage())) : new ExceptionResponse((Throwable)e);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AMQProducerBrokerExchange getProducerBrokerExchange(ProducerId id) throws IOException {
        AMQProducerBrokerExchange result = this.producerExchanges.get(id);
        if (result == null) {
            Map<ProducerId, AMQProducerBrokerExchange> map = this.producerExchanges;
            synchronized (map) {
                SessionState ss;
                result = new AMQProducerBrokerExchange();
                AMQTransportConnectionState state = this.lookupConnectionState(id);
                this.context = state.getContext();
                result.setConnectionContext(this.context);
                if (this.context.isReconnect() || this.context.isNetworkConnection() && this.acceptorUsed.isAuditNetworkProducers()) {
                    result.setLastStoredSequenceId(this.protocolManager.getPersistenceAdapter().getLastProducerSequenceId(id));
                }
                if ((ss = state.getSessionState(id.getParentId())) != null) {
                    result.setProducerState(ss.getProducerState(id));
                    ProducerState producerState = ss.getProducerState(id);
                    if (producerState != null && producerState.getInfo() != null) {
                        ProducerInfo info = producerState.getInfo();
                        result.setMutable(info.getDestination() == null || info.getDestination().isComposite());
                    }
                }
                this.producerExchanges.put(id, result);
            }
        } else {
            this.context = result.getConnectionContext();
        }
        return result;
    }

    public Response processMessageAck(MessageAck ack) throws Exception {
        ConsumerId consumerId = ack.getConsumerId();
        SessionId sessionId = consumerId.getParentId();
        AMQSession session = this.protocolManager.getSession(sessionId);
        session.acknowledge(ack);
        return null;
    }

    public Response processMessageDispatch(MessageDispatch arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processMessageDispatchNotification(MessageDispatchNotification arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processMessagePull(MessagePull arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processPrepareTransaction(TransactionInfo info) throws Exception {
        this.protocolManager.prepareTransaction(info);
        return null;
    }

    public Response processProducerAck(ProducerAck arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processRecoverTransactions(TransactionInfo info) throws Exception {
        AMQTransportConnectionState cs = this.lookupConnectionState(info.getConnectionId());
        Set sIds = cs.getSessionIds();
        TransactionId[] recovered = this.protocolManager.recoverTransactions(sIds);
        return new DataArrayResponse((DataStructure[])recovered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response processRemoveConnection(ConnectionId id, long lastDeliveredSequenceId) throws Exception {
        AMQTransportConnectionState cs = this.lookupConnectionState(id);
        if (cs != null) {
            cs.shutdown();
            for (SessionId sessionId : cs.getSessionIds()) {
                try {
                    this.processRemoveSession(sessionId, lastDeliveredSequenceId);
                }
                catch (Throwable e) {}
            }
            try {
                this.protocolManager.removeConnection(cs.getContext(), cs.getInfo(), null);
            }
            catch (Throwable e) {
                // empty catch block
            }
            AMQTransportConnectionState state = this.unregisterConnectionState(id);
            if (state != null) {
                Map<ConnectionId, ConnectionState> map = this.brokerConnectionStates;
                synchronized (map) {
                    if (state.decrementReference() == 0) {
                        this.brokerConnectionStates.remove(id);
                    }
                }
            }
        }
        return null;
    }

    public Response processRemoveConsumer(ConsumerId id, long lastDeliveredSequenceId) throws Exception {
        SessionId sessionId = id.getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        AMQTransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot remove a consumer from a connection that had not been registered: " + connectionId);
        }
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot remove a consumer from a session that had not been registered: " + sessionId);
        }
        ConsumerState consumerState = ss.removeConsumer(id);
        if (consumerState == null) {
            throw new IllegalStateException("Cannot remove a consumer that had not been registered: " + id);
        }
        ConsumerInfo info = consumerState.getInfo();
        info.setLastDeliveredSequenceId(lastDeliveredSequenceId);
        this.protocolManager.removeConsumer(cs.getContext(), consumerState.getInfo());
        this.removeConsumerBrokerExchange(id);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsumerBrokerExchange(ConsumerId id) {
        Map<ConsumerId, AMQConsumerBrokerExchange> map = this.consumerExchanges;
        synchronized (map) {
            this.consumerExchanges.remove(id);
        }
    }

    public Response processRemoveDestination(DestinationInfo info) throws Exception {
        ActiveMQDestination dest = info.getDestination();
        if (dest.isQueue()) {
            String qName = "jms.queue." + dest.getPhysicalName();
            this.protocolManager.deleteQueue(qName);
        }
        return null;
    }

    public Response processRemoveProducer(ProducerId id) throws Exception {
        this.protocolManager.removeProducer(id);
        return null;
    }

    public Response processRemoveSession(SessionId id, long lastDeliveredSequenceId) throws Exception {
        ConnectionId connectionId = id.getParentId();
        AMQTransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot remove session from connection that had not been registered: " + connectionId);
        }
        SessionState session = cs.getSessionState(id);
        if (session == null) {
            throw new IllegalStateException("Cannot remove session that had not been registered: " + id);
        }
        session.shutdown();
        for (ConsumerId consumerId : session.getConsumerIds()) {
            try {
                this.processRemoveConsumer(consumerId, lastDeliveredSequenceId);
            }
            catch (Throwable e) {}
        }
        for (ProducerId producerId : session.getProducerIds()) {
            try {
                this.processRemoveProducer(producerId);
            }
            catch (Throwable e) {}
        }
        cs.removeSession(id);
        this.protocolManager.removeSession(cs.getContext(), session.getInfo());
        return null;
    }

    public Response processRemoveSubscription(RemoveSubscriptionInfo arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public Response processRollbackTransaction(TransactionInfo info) throws Exception {
        this.protocolManager.rollbackTransaction(info);
        TransactionId txId = info.getTransactionId();
        this.txMap.remove(txId);
        return null;
    }

    public Response processShutdown(ShutdownInfo info) throws Exception {
        return null;
    }

    public Response processWireFormat(WireFormatInfo arg0) throws Exception {
        throw new IllegalStateException("not implemented! ");
    }

    public int getMaximumConsumersAllowedPerConnection() {
        return this.acceptorUsed.getMaximumConsumersAllowedPerConnection();
    }

    public int getMaximumProducersAllowedPerConnection() {
        return this.acceptorUsed.getMaximumProducersAllowedPerConnection();
    }

    public void deliverMessage(MessageDispatch dispatch) {
        Message m = dispatch.getMessage();
        if (m != null) {
            long endTime = System.currentTimeMillis();
            m.setBrokerOutTime(endTime);
        }
        this.protocolManager.send(this, (Command)dispatch);
    }

    public WireFormat getMarshaller() {
        return this.wireFormat;
    }

    public void registerTempQueue(SimpleString qName) {
        this.tempQueues.add(qName.toString());
    }

    public void disconnect(String reason, boolean fail) {
        this.destroy();
    }

    public void fail(HornetQException e, String message) {
        this.destroy();
    }

    public void setAdvisorySession(AMQSession amqSession) {
        this.advisorySession = amqSession;
    }

    public AMQSession getAdvisorySession() {
        return this.advisorySession;
    }

    public AMQConnectionContext getConext() {
        return this.state.getContext();
    }
}

