/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire;

import io.netty.channel.ChannelPipeline;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.InvalidClientIDException;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.InetAddressUtil;
import org.apache.activemq.util.LongSequenceGenerator;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.protocol.openwire.BrokerState;
import org.hornetq.core.protocol.openwire.OpenWireConnection;
import org.hornetq.core.protocol.openwire.OpenWireMessageConverter;
import org.hornetq.core.protocol.openwire.amq.AMQConnectionContext;
import org.hornetq.core.protocol.openwire.amq.AMQPersistenceAdapter;
import org.hornetq.core.protocol.openwire.amq.AMQProducerBrokerExchange;
import org.hornetq.core.protocol.openwire.amq.AMQServerSession;
import org.hornetq.core.protocol.openwire.amq.AMQSession;
import org.hornetq.core.protocol.openwire.amq.AMQTransportConnectionState;
import org.hornetq.core.remoting.impl.netty.NettyServerConnection;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.spi.core.protocol.ConnectionEntry;
import org.hornetq.spi.core.protocol.MessageConverter;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.security.HornetQSecurityManager;

public class OpenWireProtocolManager
implements ProtocolManager {
    private static final IdGenerator BROKER_ID_GENERATOR = new IdGenerator();
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final HornetQServer server;
    private OpenWireFormatFactory wireFactory;
    private boolean tightEncodingEnabled = true;
    private boolean prefixPacketSize = true;
    private BrokerState brokerState;
    private BrokerId brokerId;
    protected final ProducerId advisoryProducerId = new ProducerId();
    protected final Map<ConnectionId, ConnectionState> brokerConnectionStates = Collections.synchronizedMap(new HashMap());
    private final CopyOnWriteArrayList<OpenWireConnection> connections = new CopyOnWriteArrayList();
    protected final ConcurrentHashMap<ConnectionId, ConnectionInfo> connectionInfos = new ConcurrentHashMap();
    private final Map<String, AMQConnectionContext> clientIdSet = new HashMap<String, AMQConnectionContext>();
    private String brokerName;
    private Map<SessionId, AMQSession> sessions = new ConcurrentHashMap<SessionId, AMQSession>();
    private Map<TransactionId, AMQSession> transactions = new ConcurrentHashMap<TransactionId, AMQSession>();

    public OpenWireProtocolManager(HornetQServer server) {
        this.server = server;
        this.wireFactory = new OpenWireFormatFactory();
        this.wireFactory.setCacheEnabled(false);
        this.brokerState = new BrokerState();
        this.advisoryProducerId.setConnectionId(ID_GENERATOR.generateId());
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        OpenWireFormat wf = (OpenWireFormat)this.wireFactory.createWireFormat();
        OpenWireConnection owConn = new OpenWireConnection(acceptorUsed, connection, this, wf);
        owConn.init();
        return new ConnectionEntry((RemotingConnection)owConn, null, System.currentTimeMillis(), 60000L);
    }

    public MessageConverter getConverter() {
        return new OpenWireMessageConverter();
    }

    public void removeHandler(String name) {
    }

    public void handleBuffer(RemotingConnection connection, HornetQBuffer buffer) {
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
    }

    public boolean isProtocol(byte[] array) {
        int remainingLen;
        if (array.length < 8) {
            throw new IllegalArgumentException("Protocol header length changed " + array.length);
        }
        int start = this.prefixPacketSize ? 4 : 0;
        int j = 0;
        if (array[start] != 1) {
            return false;
        }
        WireFormatInfo info = new WireFormatInfo();
        byte[] magic = info.getMagic();
        int useLen = (remainingLen = array.length - ++start) > magic.length ? magic.length : remainingLen;
        useLen += start;
        for (int i = start; i < useLen; ++i) {
            if (array[i] != magic[j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void handshake(NettyServerConnection connection, HornetQBuffer buffer) {
    }

    public void handleCommand(OpenWireConnection openWireConnection, Object command) {
        Command amqCmd = (Command)command;
        byte type = amqCmd.getDataStructureType();
        switch (type) {
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot handle command: " + command);
            }
        }
    }

    public void sendReply(final OpenWireConnection connection, final Command command) {
        this.server.getStorageManager().afterCompleteOperations(new IOAsyncTask(){

            public void onError(int errorCode, String errorMessage) {
                HornetQServerLogger.LOGGER.errorProcessingIOCallback(Integer.valueOf(errorCode), errorMessage);
            }

            public void done() {
                OpenWireProtocolManager.this.send(connection, command);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(OpenWireConnection connection, Command command) {
        if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
            HornetQServerLogger.LOGGER.trace((Object)("sending " + command));
        }
        OpenWireConnection openWireConnection = connection;
        synchronized (openWireConnection) {
            if (connection.isDestroyed()) {
                return false;
            }
            try {
                connection.physicalSend(command);
            }
            catch (Exception e) {
                return false;
            }
            catch (Throwable t) {
                return false;
            }
            return true;
        }
    }

    public Map<ConnectionId, ConnectionState> getConnectionStates() {
        return this.brokerConnectionStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addConnection(AMQConnectionContext context, ConnectionInfo info) throws Exception {
        String password;
        String username = info.getUserName();
        if (!this.validateUser(username, password = info.getPassword())) {
            throw new SecurityException("User name [" + username + "] or password is invalid.");
        }
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection request");
        }
        Map<String, AMQConnectionContext> map = this.clientIdSet;
        synchronized (map) {
            AMQConnectionContext oldContext = this.clientIdSet.get(clientId);
            if (oldContext != null) {
                if (!context.isAllowLinkStealing()) throw new InvalidClientIDException("Broker: " + this.getBrokerName() + " - Client: " + clientId + " already connected from " + oldContext.getConnection().getRemoteAddress());
                this.clientIdSet.remove(clientId);
                if (oldContext.getConnection() != null) {
                    OpenWireConnection connection = oldContext.getConnection();
                    connection.disconnect(true);
                }
            } else {
                this.clientIdSet.put(clientId, context);
            }
        }
        this.connections.add(context.getConnection());
        ActiveMQTopic topic = AdvisorySupport.getConnectionAdvisoryTopic();
        ConnectionInfo copy = info.copy();
        copy.setPassword("");
        this.fireAdvisory(context, topic, (Command)copy);
        this.connectionInfos.put(copy.getConnectionId(), copy);
        this.addSessions(context.getConnection(), context.getConnectionState().getSessionIds());
    }

    private void fireAdvisory(AMQConnectionContext context, ActiveMQTopic topic, Command copy) throws Exception {
        this.fireAdvisory(context, topic, copy, null);
    }

    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(BROKER_ID_GENERATOR.generateId());
        }
        return this.brokerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAdvisory(AMQConnectionContext context, ActiveMQTopic topic, Command command, ConsumerId targetConsumerId) throws Exception {
        ActiveMQMessage advisoryMessage = new ActiveMQMessage();
        advisoryMessage.setStringProperty("originBrokerName", this.getBrokerName());
        String id = this.getBrokerId() != null ? this.getBrokerId().getValue() : "NOT_SET";
        advisoryMessage.setStringProperty("originBrokerId", id);
        String url = "tcp://localhost:61616";
        advisoryMessage.setStringProperty("originBrokerURL", url);
        advisoryMessage.setDataStructure((DataStructure)command);
        advisoryMessage.setPersistent(false);
        advisoryMessage.setType("Advisory");
        advisoryMessage.setMessageId(new MessageId(this.advisoryProducerId, this.messageIdGenerator.getNextSequenceId()));
        advisoryMessage.setTargetConsumerId(targetConsumerId);
        advisoryMessage.setDestination((ActiveMQDestination)topic);
        advisoryMessage.setResponseRequired(false);
        advisoryMessage.setProducerId(this.advisoryProducerId);
        boolean originalFlowControl = context.isProducerFlowControl();
        AMQProducerBrokerExchange producerExchange = new AMQProducerBrokerExchange();
        producerExchange.setConnectionContext(context);
        producerExchange.setMutable(true);
        producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
        try {
            context.setProducerFlowControl(false);
            AMQSession sess = context.getConnection().getAdvisorySession();
            if (sess != null) {
                sess.send(producerExchange, (Message)advisoryMessage, false);
            }
        }
        finally {
            context.setProducerFlowControl(originalFlowControl);
        }
    }

    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddressUtil.getLocalHostName().toLowerCase(Locale.ENGLISH);
            }
            catch (Exception e) {
                this.brokerName = "localhost";
            }
        }
        return this.brokerName;
    }

    public boolean isFaultTolerantConfiguration() {
        return false;
    }

    public void postProcessDispatch(MessageDispatch md) {
    }

    public boolean isStopped() {
        return false;
    }

    public void preProcessDispatch(MessageDispatch messageDispatch) {
    }

    public boolean isStopping() {
        return false;
    }

    public void addProducer(OpenWireConnection theConn, ProducerInfo info) {
        SessionId sessionId = info.getProducerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        AMQTransportConnectionState cs = theConn.lookupConnectionState(connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot add a producer to a connection that had not been registered: " + connectionId);
        }
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot add a producer to a session that had not been registered: " + sessionId);
        }
        if (!ss.getProducerIds().contains(info.getProducerId())) {
            ActiveMQDestination destination = info.getDestination();
            if (destination != null && !AdvisorySupport.isAdvisoryTopic((ActiveMQDestination)destination) && theConn.getProducerCount(connectionId) >= theConn.getMaximumProducersAllowedPerConnection()) {
                throw new IllegalStateException("Can't add producer on connection " + connectionId + ": at maximum limit: " + theConn.getMaximumProducersAllowedPerConnection());
            }
            AMQSession amqSession = this.sessions.get(sessionId);
            if (amqSession == null) {
                throw new IllegalStateException("Session not exist! : " + sessionId);
            }
            amqSession.createProducer(info);
            try {
                ss.addProducer(info);
            }
            catch (IllegalStateException e) {
                amqSession.removeProducer(info);
            }
        }
    }

    public void addConsumer(OpenWireConnection theConn, ConsumerInfo info) throws Exception {
        SessionId sessionId = info.getConsumerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        AMQTransportConnectionState cs = theConn.lookupConnectionState(connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot add a consumer to a connection that had not been registered: " + connectionId);
        }
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException(this.server + " Cannot add a consumer to a session that had not been registered: " + sessionId);
        }
        if (!ss.getConsumerIds().contains(info.getConsumerId())) {
            ActiveMQDestination destination = info.getDestination();
            if (destination != null && !AdvisorySupport.isAdvisoryTopic((ActiveMQDestination)destination) && theConn.getConsumerCount(connectionId) >= theConn.getMaximumConsumersAllowedPerConnection()) {
                throw new IllegalStateException("Can't add consumer on connection " + connectionId + ": at maximum limit: " + theConn.getMaximumConsumersAllowedPerConnection());
            }
            AMQSession amqSession = this.sessions.get(sessionId);
            if (amqSession == null) {
                throw new IllegalStateException("Session not exist! : " + sessionId);
            }
            amqSession.createConsumer(info);
            try {
                ss.addConsumer(info);
                theConn.addConsumerBrokerExchange(info.getConsumerId());
            }
            catch (IllegalStateException e) {
                amqSession.removeConsumer(info);
            }
        }
    }

    public void addSessions(OpenWireConnection theConn, Set<SessionId> sessionSet) {
        for (SessionId sid : sessionSet) {
            this.addSession(theConn, theConn.getState().getSessionState(sid).getInfo(), true);
        }
    }

    public AMQSession addSession(OpenWireConnection theConn, SessionInfo ss) {
        return this.addSession(theConn, ss, false);
    }

    public AMQSession addSession(OpenWireConnection theConn, SessionInfo ss, boolean internal) {
        AMQSession amqSession = new AMQSession(theConn.getState().getInfo(), ss, this.server, theConn, this);
        amqSession.initialize();
        amqSession.setInternal(internal);
        this.sessions.put(ss.getSessionId(), amqSession);
        return amqSession;
    }

    public void removeConnection(AMQConnectionContext context, ConnectionInfo info, Throwable error) {
        this.connections.remove(context.getConnection());
        this.connectionInfos.remove(info.getConnectionId());
        String clientId = info.getClientId();
        if (clientId != null) {
            this.clientIdSet.remove(clientId);
        }
    }

    public void removeSession(AMQConnectionContext context, SessionInfo info) throws Exception {
        AMQSession session = this.sessions.remove(info.getSessionId());
        if (session != null) {
            session.close();
        }
    }

    public void removeConsumer(AMQConnectionContext context, ConsumerInfo info) throws Exception {
        SessionId sessionId = info.getConsumerId().getParentId();
        AMQSession session = this.sessions.get(sessionId);
        session.removeConsumer(info);
    }

    public void removeProducer(ProducerId id) {
        SessionId sessionId = id.getParentId();
        AMQSession session = this.sessions.get(sessionId);
        session.removeProducer(id);
    }

    public AMQPersistenceAdapter getPersistenceAdapter() {
        return null;
    }

    public AMQSession getSession(SessionId sessionId) {
        return this.sessions.get(sessionId);
    }

    public void addDestination(OpenWireConnection connection, DestinationInfo info) throws Exception {
        ActiveMQDestination dest = info.getDestination();
        if (dest.isQueue()) {
            SimpleString qName = new SimpleString("jms.queue." + dest.getPhysicalName());
            ConnectionState state = connection.brokerConnectionStates.get(info.getConnectionId());
            ConnectionInfo connInfo = state.getInfo();
            if (connInfo != null) {
                String user = connInfo.getUserName();
                String pass = connInfo.getPassword();
                AMQServerSession fakeSession = new AMQServerSession(user, pass);
                CheckType checkType = dest.isTemporary() ? CheckType.CREATE_NON_DURABLE_QUEUE : CheckType.CREATE_DURABLE_QUEUE;
                ((HornetQServerImpl)this.server).getSecurityStore().check(qName, checkType, (ServerSession)fakeSession);
            }
            this.server.createQueue(qName, qName, null, false, true);
            if (dest.isTemporary()) {
                connection.registerTempQueue(qName);
            }
        }
        if (!AdvisorySupport.isAdvisoryTopic((ActiveMQDestination)dest)) {
            AMQConnectionContext context = connection.getConext();
            DestinationInfo advInfo = new DestinationInfo(context.getConnectionId(), 0, dest);
            ActiveMQTopic topic = AdvisorySupport.getDestinationAdvisoryTopic((ActiveMQDestination)dest);
            this.fireAdvisory(context, topic, (Command)advInfo);
        }
    }

    public void deleteQueue(String q) throws Exception {
        this.server.destroyQueue(new SimpleString(q));
    }

    public void commitTransactionOnePhase(TransactionInfo info) throws Exception {
        AMQSession txSession = this.transactions.get(info.getTransactionId());
        if (txSession != null) {
            txSession.commitOnePhase(info);
        }
        this.transactions.remove(info.getTransactionId());
    }

    public void prepareTransaction(TransactionInfo info) throws Exception {
        XATransactionId xid = (XATransactionId)info.getTransactionId();
        AMQSession txSession = this.transactions.get(xid);
        if (txSession != null) {
            txSession.prepareTransaction(xid);
        }
    }

    public void commitTransactionTwoPhase(TransactionInfo info) throws Exception {
        XATransactionId xid = (XATransactionId)info.getTransactionId();
        AMQSession txSession = this.transactions.get(xid);
        if (txSession != null) {
            txSession.commitTwoPhase(xid);
        }
        this.transactions.remove(xid);
    }

    public void rollbackTransaction(TransactionInfo info) throws Exception {
        AMQSession txSession = this.transactions.get(info.getTransactionId());
        if (txSession != null) {
            txSession.rollback(info);
        }
        this.transactions.remove(info.getTransactionId());
    }

    public TransactionId[] recoverTransactions(Set<SessionId> sIds) {
        ArrayList<TransactionId> recovered = new ArrayList<TransactionId>();
        if (sIds != null) {
            for (SessionId sid : sIds) {
                AMQSession s = this.sessions.get(sid);
                if (s == null) continue;
                s.recover(recovered);
            }
        }
        return recovered.toArray(new TransactionId[0]);
    }

    public boolean validateUser(String login, String passcode) {
        boolean validated = true;
        HornetQSecurityManager sm = this.server.getSecurityManager();
        if (sm != null && this.server.getConfiguration().isSecurityEnabled()) {
            validated = sm.validateUser(login, passcode);
        }
        return validated;
    }

    public void forgetTransaction(TransactionId xid) throws Exception {
        AMQSession txSession = this.transactions.get(xid);
        if (txSession != null) {
            txSession.forget(xid);
        }
        this.transactions.remove(xid);
    }

    public void registerTx(TransactionId txId, AMQSession amqSession) {
        this.transactions.put(txId, amqSession);
    }
}

