/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire;

import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.ByteSequence;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.SimpleString;

public class OpenWireUtil {
    public static HornetQBuffer toHornetQBuffer(ByteSequence bytes) {
        HornetQBuffer buffer = HornetQBuffers.fixedBuffer((int)bytes.length);
        buffer.writeBytes(bytes.data, bytes.offset, bytes.length);
        return buffer;
    }

    public static SimpleString toCoreAddress(ActiveMQDestination dest) {
        if (dest.isQueue()) {
            return new SimpleString("jms.queue." + dest.getPhysicalName());
        }
        return new SimpleString("jms.topic." + dest.getPhysicalName());
    }

    public static String convertWildcard(String physicalName) {
        return physicalName.replaceAll("(\\.>)+", ".#");
    }
}

