/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire.amq;

import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.Message;
import org.hornetq.core.protocol.openwire.amq.AMQDeadLetterStrategy;

public abstract class AMQAbstractDeadLetterStrategy
implements AMQDeadLetterStrategy {
    private boolean processNonPersistent = false;
    private boolean processExpired = true;
    private boolean enableAudit = true;
    private final ActiveMQMessageAudit messageAudit = new ActiveMQMessageAudit();

    @Override
    public void rollback(Message message) {
        if (message != null && this.enableAudit) {
            this.messageAudit.rollback((MessageReference)message);
        }
    }

    @Override
    public boolean isSendToDeadLetterQueue(Message message) {
        boolean result = false;
        if (message != null) {
            result = true;
            if (this.enableAudit && this.messageAudit.isDuplicate((MessageReference)message)) {
                result = false;
            }
            if (!message.isPersistent() && !this.processNonPersistent) {
                result = false;
            }
            if (message.isExpired() && !this.processExpired) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public boolean isProcessExpired() {
        return this.processExpired;
    }

    @Override
    public void setProcessExpired(boolean processExpired) {
        this.processExpired = processExpired;
    }

    @Override
    public boolean isProcessNonPersistent() {
        return this.processNonPersistent;
    }

    @Override
    public void setProcessNonPersistent(boolean processNonPersistent) {
        this.processNonPersistent = processNonPersistent;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }
}

