/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire.amq;

import java.io.IOException;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.wireformat.WireFormat;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.openwire.OpenWireMessageConverter;
import org.hornetq.core.protocol.openwire.OpenWireUtil;
import org.hornetq.core.protocol.openwire.amq.AMQServerConsumer;
import org.hornetq.core.protocol.openwire.amq.AMQServerSession;
import org.hornetq.core.protocol.openwire.amq.AMQSession;
import org.hornetq.core.protocol.openwire.amq.BrowserListener;
import org.hornetq.core.protocol.openwire.amq.MessageInfo;
import org.hornetq.core.server.QueueQueryResult;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.jms.client.HornetQDestination;

public class AMQConsumer
implements BrowserListener {
    private AMQSession session;
    private ActiveMQDestination actualDest;
    private ConsumerInfo info;
    private long nativeId = -1L;
    private SimpleString subQueueName = null;
    private final int prefetchSize;
    private AtomicInteger currentSize;
    private final Queue<MessageInfo> deliveringRefs = new ConcurrentLinkedQueue<MessageInfo>();

    public AMQConsumer(AMQSession amqSession, ActiveMQDestination d, ConsumerInfo info) {
        this.session = amqSession;
        this.actualDest = d;
        this.info = info;
        this.prefetchSize = info.getPrefetchSize();
        this.currentSize = new AtomicInteger(0);
    }

    public void init() throws Exception {
        AMQServerSession coreSession = this.session.getCoreSession();
        SimpleString selector = this.info.getSelector() == null ? null : new SimpleString(this.info.getSelector());
        this.nativeId = this.session.getCoreServer().getStorageManager().generateID();
        SimpleString address = new SimpleString(this.actualDest.getPhysicalName());
        if (this.actualDest.isTopic()) {
            String physicalName = this.actualDest.getPhysicalName();
            if (physicalName.contains(".>")) {
                physicalName = OpenWireUtil.convertWildcard(physicalName);
            }
            address = new SimpleString("jms.topic." + physicalName);
            if (this.info.isDurable()) {
                this.subQueueName = new SimpleString(HornetQDestination.createQueueNameForDurableSubscription((boolean)true, (String)this.info.getClientId(), (String)this.info.getSubscriptionName()));
                QueueQueryResult result = coreSession.executeQueueQuery(this.subQueueName);
                if (result.isExists()) {
                    boolean topicChanged;
                    if (result.getConsumerCount() > 0) {
                        throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                    }
                    SimpleString oldFilterString = result.getFilterString();
                    boolean selectorChanged = selector == null && oldFilterString != null || oldFilterString == null && selector != null || oldFilterString != null && selector != null && !oldFilterString.equals((Object)selector);
                    SimpleString oldTopicName = result.getAddress();
                    boolean bl = topicChanged = !oldTopicName.equals((Object)address);
                    if (selectorChanged || topicChanged) {
                        coreSession.deleteQueue(this.subQueueName);
                        coreSession.createQueue(address, this.subQueueName, selector, false, true);
                    }
                } else {
                    coreSession.createQueue(address, this.subQueueName, selector, false, true);
                }
            } else {
                this.subQueueName = new SimpleString(UUID.randomUUID().toString());
                coreSession.createQueue(address, this.subQueueName, selector, true, false);
            }
            coreSession.createConsumer(this.nativeId, this.subQueueName, null, this.info.isBrowser(), false, Integer.MAX_VALUE);
        } else {
            SimpleString queueName = new SimpleString("jms.queue." + this.actualDest.getPhysicalName());
            coreSession.createConsumer(this.nativeId, queueName, selector, this.info.isBrowser(), false, Integer.MAX_VALUE);
        }
        if (this.info.isBrowser()) {
            AMQServerConsumer coreConsumer = coreSession.getConsumer(this.nativeId);
            coreConsumer.setBrowserListener(this);
        }
    }

    public long getNativeId() {
        return this.nativeId;
    }

    public ConsumerId getId() {
        return this.info.getConsumerId();
    }

    public WireFormat getMarshaller() {
        return this.session.getMarshaller();
    }

    public void acquireCredit(int n) throws Exception {
        this.currentSize.addAndGet(-n);
        if (this.currentSize.get() < this.prefetchSize) {
            AtomicInteger credits = this.session.getCoreSession().getConsumerCredits(this.nativeId);
            credits.set(0);
            this.session.getCoreSession().receiveConsumerCredits(this.nativeId, Integer.MAX_VALUE);
        }
    }

    public void checkCreditOnDelivery() throws Exception {
        this.currentSize.incrementAndGet();
        if (this.currentSize.get() == this.prefetchSize) {
            this.session.getCoreSession().receiveConsumerCredits(this.nativeId, 0);
        }
    }

    public int handleDeliver(ServerMessage message, int deliveryCount) {
        try {
            MessageDispatch dispatch = OpenWireMessageConverter.createMessageDispatch(message, deliveryCount - 1, this);
            int size = dispatch.getMessage().getSize();
            this.deliveringRefs.add(new MessageInfo(dispatch.getMessage().getMessageId(), message.getMessageID(), size));
            this.session.deliverMessage(dispatch);
            this.checkCreditOnDelivery();
            return size;
        }
        catch (IOException e) {}
        finally {
            return 0;
        }
    }

    public void acknowledge(MessageAck ack) throws Exception {
        MessageId first = ack.getFirstMessageId();
        MessageId lastm = ack.getLastMessageId();
        TransactionId tid = ack.getTransactionId();
        boolean isLocalTx = tid != null && tid.isLocalTransaction();
        boolean single = lastm.equals((Object)first);
        MessageInfo mi = null;
        int n = 0;
        if (ack.isIndividualAck()) {
            Iterator iter = this.deliveringRefs.iterator();
            while (iter.hasNext()) {
                mi = (MessageInfo)iter.next();
                if (!mi.amqId.equals((Object)lastm)) continue;
                ++n;
                iter.remove();
                this.session.getCoreSession().individualAcknowledge(this.nativeId, mi.nativeId);
                this.session.getCoreSession().commit();
                break;
            }
        } else if (ack.isRedeliveredAck()) {
            n = 1;
        } else if (ack.isPoisonAck()) {
            Iterator iter = this.deliveringRefs.iterator();
            boolean firstFound = false;
            while (iter.hasNext()) {
                mi = (MessageInfo)iter.next();
                if (mi.amqId.equals((Object)first)) {
                    ++n;
                    iter.remove();
                    this.session.getCoreSession().moveToDeadLetterAddress(this.nativeId, mi.nativeId, ack.getPoisonCause());
                    this.session.getCoreSession().commit();
                    if (!single) {
                        firstFound = true;
                        continue;
                    }
                } else {
                    if (!firstFound && first != null) continue;
                    ++n;
                    iter.remove();
                    this.session.getCoreSession().moveToDeadLetterAddress(this.nativeId, mi.nativeId, ack.getPoisonCause());
                    this.session.getCoreSession().commit();
                    if (!mi.amqId.equals((Object)lastm)) continue;
                }
                break;
            }
        } else if (ack.isDeliveredAck() || ack.isExpiredAck()) {
            n = 1;
        } else {
            Iterator iter = this.deliveringRefs.iterator();
            boolean firstFound = false;
            while (iter.hasNext()) {
                MessageInfo ami = (MessageInfo)iter.next();
                if (ami.amqId.equals((Object)first)) {
                    ++n;
                    if (!isLocalTx) {
                        iter.remove();
                    } else {
                        ami.setLocalAcked(true);
                    }
                    if (single) {
                        mi = ami;
                        break;
                    }
                    firstFound = true;
                    continue;
                }
                if (!firstFound && first != null) continue;
                ++n;
                if (!isLocalTx) {
                    iter.remove();
                } else {
                    ami.setLocalAcked(true);
                }
                if (!ami.amqId.equals((Object)lastm)) continue;
                mi = ami;
                break;
            }
            if (mi != null && !isLocalTx) {
                this.session.getCoreSession().acknowledge(this.nativeId, mi.nativeId);
            }
        }
        this.acquireCredit(n);
    }

    @Override
    public void browseFinished() {
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.info.getConsumerId());
        md.setMessage(null);
        md.setDestination(null);
        this.session.deliverMessage(md);
    }

    public boolean handledTransactionalMsg() {
        return false;
    }

    public void finishTx() throws Exception {
        MessageInfo lastMi = null;
        MessageInfo mi = null;
        Iterator iter = this.deliveringRefs.iterator();
        while (iter.hasNext()) {
            mi = (MessageInfo)iter.next();
            if (!mi.isLocalAcked()) continue;
            iter.remove();
            lastMi = mi;
        }
        if (lastMi != null) {
            this.session.getCoreSession().acknowledge(this.nativeId, lastMi.nativeId);
        }
    }

    public void rollbackTx(Set<Long> acked) throws Exception {
        MessageInfo lastMi = null;
        MessageInfo mi2 = null;
        for (MessageInfo mi2 : this.deliveringRefs) {
            if (!mi2.isLocalAcked()) continue;
            acked.add(mi2.nativeId);
            lastMi = mi2;
        }
        if (lastMi != null) {
            this.session.getCoreSession().acknowledge(this.nativeId, lastMi.nativeId);
        }
    }
}

