/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire.amq;

import java.io.IOException;
import java.util.List;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.Usage;
import org.hornetq.core.protocol.openwire.amq.AMQConnectionContext;
import org.hornetq.core.protocol.openwire.amq.AMQDeadLetterStrategy;
import org.hornetq.core.protocol.openwire.amq.AMQDestinationStatistics;
import org.hornetq.core.protocol.openwire.amq.AMQMessageStore;
import org.hornetq.core.protocol.openwire.amq.AMQProducerBrokerExchange;
import org.hornetq.core.protocol.openwire.amq.AMQSharedDeadLetterStrategy;
import org.hornetq.core.protocol.openwire.amq.AMQSlowConsumerStrategy;
import org.hornetq.core.protocol.openwire.amq.AMQSubscription;

public interface AMQDestination {
    public static final AMQDeadLetterStrategy DEFAULT_DEAD_LETTER_STRATEGY = new AMQSharedDeadLetterStrategy();
    public static final long DEFAULT_BLOCKED_PRODUCER_WARNING_INTERVAL = 30000L;

    public void addSubscription(AMQConnectionContext var1, AMQSubscription var2) throws Exception;

    public void removeSubscription(AMQConnectionContext var1, AMQSubscription var2, long var3) throws Exception;

    public void addProducer(AMQConnectionContext var1, ProducerInfo var2) throws Exception;

    public void removeProducer(AMQConnectionContext var1, ProducerInfo var2) throws Exception;

    public void send(AMQProducerBrokerExchange var1, Message var2) throws Exception;

    public void acknowledge(AMQConnectionContext var1, AMQSubscription var2, MessageAck var3, MessageReference var4) throws IOException;

    public long getInactiveTimoutBeforeGC();

    public void markForGC(long var1);

    public boolean canGC();

    public void gc();

    public ActiveMQDestination getActiveMQDestination();

    public MemoryUsage getMemoryUsage();

    public void setMemoryUsage(MemoryUsage var1);

    public void dispose(AMQConnectionContext var1) throws IOException;

    public boolean isDisposed();

    public AMQDestinationStatistics getDestinationStatistics();

    public AMQDeadLetterStrategy getDeadLetterStrategy();

    public Message[] browse();

    public String getName();

    public AMQMessageStore getMessageStore();

    public boolean isProducerFlowControl();

    public void setProducerFlowControl(boolean var1);

    public boolean isAlwaysRetroactive();

    public void setAlwaysRetroactive(boolean var1);

    public void setBlockedProducerWarningInterval(long var1);

    public long getBlockedProducerWarningInterval();

    public int getMaxProducersToAudit();

    public void setMaxProducersToAudit(int var1);

    public int getMaxAuditDepth();

    public void setMaxAuditDepth(int var1);

    public boolean isEnableAudit();

    public void setEnableAudit(boolean var1);

    public boolean isActive();

    public int getMaxPageSize();

    public void setMaxPageSize(int var1);

    public int getMaxBrowsePageSize();

    public void setMaxBrowsePageSize(int var1);

    public boolean isUseCache();

    public void setUseCache(boolean var1);

    public int getMinimumMessageSize();

    public void setMinimumMessageSize(int var1);

    public int getCursorMemoryHighWaterMark();

    public void setCursorMemoryHighWaterMark(int var1);

    public void wakeup();

    public boolean isLazyDispatch();

    public void setLazyDispatch(boolean var1);

    public void messageExpired(AMQConnectionContext var1, AMQSubscription var2, MessageReference var3);

    public void messageConsumed(AMQConnectionContext var1, MessageReference var2);

    public void messageDelivered(AMQConnectionContext var1, MessageReference var2);

    public void messageDiscarded(AMQConnectionContext var1, AMQSubscription var2, MessageReference var3);

    public void slowConsumer(AMQConnectionContext var1, AMQSubscription var2);

    public void fastProducer(AMQConnectionContext var1, ProducerInfo var2);

    public void isFull(AMQConnectionContext var1, Usage<?> var2);

    public List<AMQSubscription> getConsumers();

    public void processDispatchNotification(MessageDispatchNotification var1) throws Exception;

    public boolean isPrioritizedMessages();

    public AMQSlowConsumerStrategy getSlowConsumerStrategy();

    public boolean isDoOptimzeMessageStorage();

    public void setDoOptimzeMessageStorage(boolean var1);

    public void clearPendingMessages();

    public boolean isDLQ();

    public void duplicateFromStore(Message var1, AMQSubscription var2);
}

