/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire.amq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.SessionId;
import org.hornetq.core.protocol.openwire.amq.AMQTransportConnectionState;
import org.hornetq.core.protocol.openwire.amq.AMQTransportConnectionStateRegister;

public class AMQMapTransportConnectionStateRegister
implements AMQTransportConnectionStateRegister {
    private Map<ConnectionId, AMQTransportConnectionState> connectionStates = new ConcurrentHashMap<ConnectionId, AMQTransportConnectionState>();

    @Override
    public AMQTransportConnectionState registerConnectionState(ConnectionId connectionId, AMQTransportConnectionState state) {
        AMQTransportConnectionState rc = this.connectionStates.put(connectionId, state);
        return rc;
    }

    @Override
    public AMQTransportConnectionState unregisterConnectionState(ConnectionId connectionId) {
        AMQTransportConnectionState rc = this.connectionStates.remove(connectionId);
        if (rc.getReferenceCounter().get() > 1) {
            rc.decrementReference();
            this.connectionStates.put(connectionId, rc);
        }
        return rc;
    }

    @Override
    public List<AMQTransportConnectionState> listConnectionStates() {
        ArrayList<AMQTransportConnectionState> rc = new ArrayList<AMQTransportConnectionState>();
        rc.addAll(this.connectionStates.values());
        return rc;
    }

    @Override
    public AMQTransportConnectionState lookupConnectionState(String connectionId) {
        return this.connectionStates.get(new ConnectionId(connectionId));
    }

    @Override
    public AMQTransportConnectionState lookupConnectionState(ConsumerId id) {
        AMQTransportConnectionState cs = this.lookupConnectionState(id.getConnectionId());
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a consumer from a connection that had not been registered: " + id.getParentId().getParentId());
        }
        return cs;
    }

    @Override
    public AMQTransportConnectionState lookupConnectionState(ProducerId id) {
        AMQTransportConnectionState cs = this.lookupConnectionState(id.getConnectionId());
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a producer from a connection that had not been registered: " + id.getParentId().getParentId());
        }
        return cs;
    }

    @Override
    public AMQTransportConnectionState lookupConnectionState(SessionId id) {
        AMQTransportConnectionState cs = this.lookupConnectionState(id.getConnectionId());
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a session from a connection that had not been registered: " + id.getParentId());
        }
        return cs;
    }

    @Override
    public AMQTransportConnectionState lookupConnectionState(ConnectionId connectionId) {
        AMQTransportConnectionState cs = this.connectionStates.get(connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a connection that had not been registered: " + connectionId);
        }
        return cs;
    }

    @Override
    public boolean doesHandleMultipleConnectionStates() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.connectionStates.isEmpty();
    }

    @Override
    public void clear() {
        this.connectionStates.clear();
    }

    @Override
    public void intialize(AMQTransportConnectionStateRegister other) {
        this.connectionStates.clear();
        this.connectionStates.putAll(other.mapStates());
    }

    @Override
    public Map<ConnectionId, AMQTransportConnectionState> mapStates() {
        HashMap<ConnectionId, AMQTransportConnectionState> map = new HashMap<ConnectionId, AMQTransportConnectionState>(this.connectionStates);
        return map;
    }
}

