/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire.amq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.CoreNotificationType;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.protocol.openwire.AMQTransactionImpl;
import org.hornetq.core.protocol.openwire.amq.AMQServerConsumer;
import org.hornetq.core.protocol.openwire.amq.AMQTransactionFactory;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.RefsOperation;
import org.hornetq.core.server.impl.ServerConsumerImpl;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.TransactionFactory;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.utils.TypedProperties;

public class AMQServerSession
extends ServerSessionImpl {
    private boolean internal;

    public AMQServerSession(String name, String username, String password, int minLargeMessageSize, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean persistDeliveryCountBeforeDelivery, boolean xa, RemotingConnection connection, StorageManager storageManager, PostOffice postOffice, ResourceManager resourceManager, SecurityStore securityStore, ManagementService managementService, HornetQServerImpl hornetQServerImpl, SimpleString managementAddress, SimpleString simpleString, SessionCallback callback, OperationContext context) throws Exception {
        super(name, username, password, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, persistDeliveryCountBeforeDelivery, xa, connection, storageManager, postOffice, resourceManager, securityStore, managementService, (HornetQServer)hornetQServerImpl, managementAddress, simpleString, callback, context, (TransactionFactory)new AMQTransactionFactory());
    }

    public AMQServerSession(String user, String pass) {
        super(user, pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose(boolean failed) throws Exception {
        AMQServerSession aMQServerSession = this;
        synchronized (aMQServerSession) {
            if (this.tx != null && this.tx.getXid() == null) {
                ((AMQTransactionImpl)this.tx).setRollbackForClose();
            }
        }
        super.doClose(failed);
    }

    public AtomicInteger getConsumerCredits(long consumerID) {
        ServerConsumer consumer = (ServerConsumer)this.consumers.get(consumerID);
        if (consumer == null) {
            HornetQServerLogger.LOGGER.debug((Object)("There is no consumer with id " + consumerID));
            return null;
        }
        return ((ServerConsumerImpl)consumer).getAvailableCredits();
    }

    public void enableXA() throws Exception {
        if (!this.xa) {
            if (this.tx != null) {
                this.tx.rollback();
                this.tx = null;
            }
            this.autoCommitAcks = false;
            this.autoCommitSends = false;
            this.xa = true;
        }
    }

    public void enableTx() throws Exception {
        if (this.xa) {
            throw new IllegalStateException("Session is XA");
        }
        this.autoCommitAcks = false;
        this.autoCommitSends = false;
        if (this.tx != null) {
            this.tx.rollback();
            this.tx = null;
        }
        this.tx = this.newTransaction();
    }

    public void amqRollback(Set<Long> acked) throws Exception {
        RefsOperation oper;
        if (this.tx == null) {
            this.tx = this.newTransaction();
        }
        if ((oper = (RefsOperation)this.tx.getProperty(6)) != null) {
            List ackRefs = oper.getReferencesToAcknowledge();
            HashMap<Long, ArrayList<MessageReference>> toAcks = new HashMap<Long, ArrayList<MessageReference>>();
            for (MessageReference ref : ackRefs) {
                Long consumerId = ref.getConsumerId();
                if (this.consumers.containsKey(consumerId)) {
                    if (!acked.contains(ref.getMessage().getMessageID())) continue;
                    ArrayList<MessageReference> ackList = (ArrayList<MessageReference>)toAcks.get(consumerId);
                    if (ackList == null) {
                        ackList = new ArrayList<MessageReference>();
                        toAcks.put(consumerId, ackList);
                    }
                    ackList.add(ref);
                    continue;
                }
                ref.getQueue().cancel(this.tx, ref);
            }
            if (toAcks.size() > 0) {
                for (Map.Entry entry : toAcks.entrySet()) {
                    ServerConsumer consumer = (ServerConsumer)this.consumers.get(entry.getKey());
                    ((AMQServerConsumer)consumer).amqPutBackToDeliveringList((List)entry.getValue());
                }
            }
        }
        this.tx.rollback();
        this.tx = this.xa ? null : this.newTransaction();
    }

    public void amqCloseConsumer(long consumerID, boolean failed) throws Exception {
        ServerConsumer consumer = (ServerConsumer)this.consumers.get(consumerID);
        if (consumer != null) {
            consumer.close(failed);
        } else {
            HornetQServerLogger.LOGGER.cannotFindConsumer(consumerID);
        }
    }

    public ServerConsumer createConsumer(long consumerID, SimpleString queueName, SimpleString filterString, boolean browseOnly, boolean supportLargeMessage, Integer credits) throws Exception {
        if (this.internal) {
            Binding binding = this.postOffice.getBinding(queueName);
            if (binding == null || binding.getType() != BindingType.LOCAL_QUEUE) {
                throw HornetQMessageBundle.BUNDLE.noSuchQueue(queueName);
            }
            Filter filter = FilterImpl.createFilter((SimpleString)filterString);
            ServerConsumer consumer = this.newConsumer(consumerID, this, (QueueBinding)binding, filter, this.started, browseOnly, this.storageManager, this.callback, this.preAcknowledge, this.strictUpdateDeliveryCount, this.managementService, supportLargeMessage, credits);
            this.consumers.put(consumer.getID(), consumer);
            if (!browseOnly) {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
                props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
                props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
                props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
                Queue theQueue = (Queue)binding.getBindable();
                props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, theQueue.getConsumerCount());
                props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)this.username));
                props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)this.remotingConnection.getRemoteAddress()));
                props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)this.name));
                if (filterString != null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
                }
                Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_CREATED, props);
                if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                    HornetQServerLogger.LOGGER.debug((Object)("Session with user=" + this.username + ", connection=" + this.remotingConnection + " created a consumer on queue " + queueName + ", filter = " + filterString));
                }
                this.managementService.sendNotification(notification);
            }
            return consumer;
        }
        return super.createConsumer(consumerID, queueName, filterString, browseOnly, supportLargeMessage, credits);
    }

    public void createQueue(SimpleString address, SimpleString name, SimpleString filterString, boolean temporary, boolean durable) throws Exception {
        if (!this.internal) {
            super.createQueue(address, name, filterString, temporary, durable);
            return;
        }
        this.server.createQueue(address, name, filterString, durable, temporary);
        if (temporary) {
            ServerSessionImpl.TempQueueCleanerUpper cleaner = new ServerSessionImpl.TempQueueCleanerUpper(this.server, name);
            this.remotingConnection.addCloseListener((CloseListener)cleaner);
            this.remotingConnection.addFailureListener((FailureListener)cleaner);
            this.tempQueueCleannerUppers.put(name, cleaner);
        }
        if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
            HornetQServerLogger.LOGGER.debug((Object)("Queue " + name + " created on address " + name + " with filter=" + filterString + " temporary = " + temporary + " durable=" + durable + " on session user=" + this.username + ", connection=" + this.remotingConnection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(ServerMessage msg, boolean direct) throws Exception {
        if (!this.internal) {
            super.doSend(msg, direct);
            return;
        }
        if (this.tx != null && !this.autoCommitSends) {
            this.routingContext.setTransaction(this.tx);
        }
        try {
            this.postOffice.route(msg, this.routingContext, direct);
            Pair value = (Pair)this.targetAddressInfos.get(msg.getAddress());
            if (value == null) {
                this.targetAddressInfos.put(msg.getAddress(), new Pair((Object)msg.getUserID(), (Object)new AtomicLong(1L)));
            } else {
                value.setA((Object)msg.getUserID());
                ((AtomicLong)value.getB()).incrementAndGet();
            }
        }
        finally {
            this.routingContext.clear();
        }
    }

    protected ServerConsumer newConsumer(long consumerID, ServerSessionImpl serverSessionImpl, QueueBinding binding, Filter filter, boolean started2, boolean browseOnly, StorageManager storageManager2, SessionCallback callback2, boolean preAcknowledge2, boolean strictUpdateDeliveryCount2, ManagementService managementService2, boolean supportLargeMessage, Integer credits) throws Exception {
        return new AMQServerConsumer(consumerID, this, binding, filter, this.started, browseOnly, this.storageManager, this.callback, this.preAcknowledge, this.strictUpdateDeliveryCount, this.managementService, supportLargeMessage, credits);
    }

    public AMQServerConsumer getConsumer(long nativeId) {
        return (AMQServerConsumer)((Object)this.consumers.get(nativeId));
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void moveToDeadLetterAddress(long consumerId, long mid, Throwable cause) throws Exception {
        AMQServerConsumer consumer = this.getConsumer(consumerId);
        consumer.moveToDeadLetterAddress(mid, cause);
    }
}

