/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.openwire.amq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.SessionId;
import org.hornetq.core.protocol.openwire.amq.AMQTransportConnectionState;
import org.hornetq.core.protocol.openwire.amq.AMQTransportConnectionStateRegister;

public class AMQSingleTransportConnectionStateRegister
implements AMQTransportConnectionStateRegister {
    private AMQTransportConnectionState connectionState;
    private ConnectionId connectionId;

    @Override
    public AMQTransportConnectionState registerConnectionState(ConnectionId connectionId, AMQTransportConnectionState state) {
        AMQTransportConnectionState rc = this.connectionState;
        this.connectionState = state;
        this.connectionId = connectionId;
        return rc;
    }

    @Override
    public synchronized AMQTransportConnectionState unregisterConnectionState(ConnectionId connectionId) {
        AMQTransportConnectionState rc = null;
        if (connectionId != null && this.connectionState != null && this.connectionId != null && this.connectionId.equals((Object)connectionId)) {
            rc = this.connectionState;
            this.connectionState = null;
            connectionId = null;
        }
        return rc;
    }

    @Override
    public synchronized List<AMQTransportConnectionState> listConnectionStates() {
        ArrayList<AMQTransportConnectionState> rc = new ArrayList<AMQTransportConnectionState>();
        if (this.connectionState != null) {
            rc.add(this.connectionState);
        }
        return rc;
    }

    @Override
    public synchronized AMQTransportConnectionState lookupConnectionState(String connectionId) {
        AMQTransportConnectionState cs = this.connectionState;
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a connectionId for a connection that had not been registered: " + connectionId);
        }
        return cs;
    }

    @Override
    public synchronized AMQTransportConnectionState lookupConnectionState(ConsumerId id) {
        AMQTransportConnectionState cs = this.connectionState;
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a consumer from a connection that had not been registered: " + id.getParentId().getParentId());
        }
        return cs;
    }

    @Override
    public synchronized AMQTransportConnectionState lookupConnectionState(ProducerId id) {
        AMQTransportConnectionState cs = this.connectionState;
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a producer from a connection that had not been registered: " + id.getParentId().getParentId());
        }
        return cs;
    }

    @Override
    public synchronized AMQTransportConnectionState lookupConnectionState(SessionId id) {
        AMQTransportConnectionState cs = this.connectionState;
        if (cs == null) {
            throw new IllegalStateException("Cannot lookup a session from a connection that had not been registered: " + id.getParentId());
        }
        return cs;
    }

    @Override
    public synchronized AMQTransportConnectionState lookupConnectionState(ConnectionId connectionId) {
        AMQTransportConnectionState cs = this.connectionState;
        return cs;
    }

    @Override
    public synchronized boolean doesHandleMultipleConnectionStates() {
        return false;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.connectionState == null;
    }

    @Override
    public void intialize(AMQTransportConnectionStateRegister other) {
        if (other.isEmpty()) {
            this.clear();
        } else {
            Map<ConnectionId, AMQTransportConnectionState> map = other.mapStates();
            Iterator<Map.Entry<ConnectionId, AMQTransportConnectionState>> i = map.entrySet().iterator();
            Map.Entry<ConnectionId, AMQTransportConnectionState> entry = i.next();
            this.connectionId = entry.getKey();
            this.connectionState = entry.getValue();
        }
    }

    @Override
    public Map<ConnectionId, AMQTransportConnectionState> mapStates() {
        HashMap<ConnectionId, AMQTransportConnectionState> map = new HashMap<ConnectionId, AMQTransportConnectionState>();
        if (!this.isEmpty()) {
            map.put(this.connectionId, this.connectionState);
        }
        return map;
    }

    @Override
    public void clear() {
        this.connectionState = null;
        this.connectionId = null;
    }
}

