/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context;

import java.util.concurrent.TimeUnit;
import org.proton.plug.exceptions.HornetQAMQPException;
import org.proton.plug.exceptions.HornetQAMQPIllegalStateException;
import org.proton.plug.exceptions.HornetQAMQPTimeoutException;
import org.proton.plug.util.FutureRunnable;

public class ProtonInitializable {
    private Runnable afterInit;
    private boolean initialized = false;

    public void afterInit(Runnable afterInit) {
        this.afterInit = afterInit;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() throws Exception {
        if (!this.initialized) {
            this.initialized = false;
            try {
                if (this.afterInit != null) {
                    this.afterInit.run();
                }
            }
            finally {
                this.afterInit = null;
            }
        }
    }

    public void waitWithTimeout(FutureRunnable latch) throws HornetQAMQPException {
        try {
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                throw new HornetQAMQPTimeoutException("Timed out waiting for response");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HornetQAMQPIllegalStateException(e.getMessage());
        }
    }
}

