/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context.client;

import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.proton.plug.AMQPClientConnectionContext;
import org.proton.plug.AMQPClientSessionContext;
import org.proton.plug.AMQPConnectionCallback;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.ClientSASL;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.ProtonInitializable;
import org.proton.plug.context.client.ProtonClientSessionContext;
import org.proton.plug.exceptions.HornetQAMQPException;
import org.proton.plug.util.FutureRunnable;

public class ProtonClientConnectionContext
extends AbstractConnectionContext
implements AMQPClientConnectionContext {
    public ProtonClientConnectionContext(AMQPConnectionCallback connectionCallback) {
        super(connectionCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientOpen(ClientSASL sasl) throws Exception {
        FutureRunnable future = new FutureRunnable(1);
        Object object = this.handler.getLock();
        synchronized (object) {
            this.afterInit(future);
            if (sasl != null) {
                this.handler.createClientSasl(sasl);
            }
            this.handler.getConnection().open();
        }
        this.flush();
        this.waitWithTimeout(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMQPClientSessionContext createClientSession() throws HornetQAMQPException {
        ProtonClientSessionContext sessionImpl;
        FutureRunnable futureRunnable = new FutureRunnable(1);
        Object object = this.handler.getLock();
        synchronized (object) {
            Session session = this.handler.getConnection().session();
            sessionImpl = (ProtonClientSessionContext)this.getSessionExtension(session);
            sessionImpl.afterInit(futureRunnable);
            session.open();
        }
        this.flush();
        this.waitWithTimeout(futureRunnable);
        return sessionImpl;
    }

    @Override
    protected AbstractProtonSessionContext newSessionExtension(Session realSession) throws HornetQAMQPException {
        AMQPSessionCallback sessionSPI = this.connectionCallback.createSessionCallback(this);
        ProtonClientSessionContext protonSession = new ProtonClientSessionContext(sessionSPI, this, realSession);
        return protonSession;
    }

    @Override
    protected void remoteLinkOpened(Link link) throws Exception {
        Object context = link.getContext();
        if (context != null && context instanceof ProtonInitializable) {
            ((ProtonInitializable)context).initialise();
        }
    }
}

