/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.message.ProtonJMessage;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.proton.plug.AMQPClientReceiverContext;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonReceiverContext;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.exceptions.HornetQAMQPException;
import org.proton.plug.util.DeliveryUtil;

public class ProtonClientReceiverContext
extends AbstractProtonReceiverContext
implements AMQPClientReceiverContext {
    LinkedBlockingDeque<MessageImpl> queues = new LinkedBlockingDeque();

    public ProtonClientReceiverContext(AMQPSessionCallback sessionSPI, AbstractConnectionContext connection, AbstractProtonSessionContext protonSession, Receiver receiver) {
        super(sessionSPI, connection, protonSession, receiver);
    }

    @Override
    public void onFlow(int credits) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws HornetQAMQPException {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        try {
            Object object = this.connection.getLock();
            synchronized (object) {
                DeliveryUtil.readDelivery(this.receiver, buffer);
                MessageImpl clientMessage = DeliveryUtil.decodeMessageImpl(buffer);
                this.receiver.advance();
                delivery.disposition((DeliveryState)Accepted.getInstance());
                this.queues.add(clientMessage);
            }
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public ProtonJMessage receiveMessage(int time, TimeUnit unit) throws Exception {
        return (ProtonJMessage)this.queues.poll(time, unit);
    }
}

