/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context.server;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonContextSender;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.ProtonInitializable;
import org.proton.plug.context.ProtonTransactionHandler;
import org.proton.plug.context.server.ProtonServerReceiverContext;
import org.proton.plug.context.server.ProtonServerSenderContext;
import org.proton.plug.exceptions.HornetQAMQPException;

public class ProtonServerSessionContext
extends AbstractProtonSessionContext {
    protected Map<Object, AbstractProtonContextSender> serverSenders = new HashMap<Object, AbstractProtonContextSender>();

    public ProtonServerSessionContext(AMQPSessionCallback sessionSPI, AbstractConnectionContext connection, Session session) {
        super(sessionSPI, connection, session);
    }

    public int serverDelivery(Object message, Object consumer, int deliveryCount) throws Exception {
        ProtonServerSenderContext protonSender = (ProtonServerSenderContext)this.serverSenders.get(consumer);
        if (protonSender != null) {
            return protonSender.deliverMessage(message, deliveryCount);
        }
        return 0;
    }

    public void addTransactionHandler(Coordinator coordinator, Receiver receiver) {
        ProtonTransactionHandler transactionHandler = new ProtonTransactionHandler(this.sessionSPI);
        receiver.setContext((Object)transactionHandler);
        receiver.open();
        receiver.flow(100);
    }

    public void addSender(Sender sender) throws Exception {
        ProtonServerSenderContext protonSender = new ProtonServerSenderContext(this.connection, sender, this, this.sessionSPI);
        try {
            protonSender.initialise();
            this.senders.put(sender, protonSender);
            this.serverSenders.put(protonSender.getBrokerConsumer(), protonSender);
            sender.setContext((Object)protonSender);
            sender.open();
            protonSender.start();
        }
        catch (HornetQAMQPException e) {
            this.senders.remove(sender);
            sender.setSource(null);
            sender.setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            sender.close();
        }
    }

    @Override
    public void removeSender(Sender sender) throws HornetQAMQPException {
        ProtonServerSenderContext senderRemoved = (ProtonServerSenderContext)this.senders.remove(sender);
        if (senderRemoved != null) {
            this.serverSenders.remove(senderRemoved.getBrokerConsumer());
        }
    }

    public void addReceiver(Receiver receiver) throws Exception {
        try {
            ProtonServerReceiverContext protonReceiver = new ProtonServerReceiverContext(this.sessionSPI, this.connection, this, receiver);
            ((ProtonInitializable)protonReceiver).initialise();
            this.receivers.put(receiver, protonReceiver);
            receiver.setContext((Object)protonReceiver);
            receiver.open();
        }
        catch (HornetQAMQPException e) {
            this.receivers.remove(receiver);
            receiver.setTarget(null);
            receiver.setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            receiver.close();
        }
    }
}

