/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.resource.spi.ConnectionRequestInfo;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRAProperties;
import org.hornetq.ra.Util;

public class HornetQRAConnectionRequestInfo
implements ConnectionRequestInfo {
    private static final Logger log = Logger.getLogger(HornetQRAConnectionRequestInfo.class);
    private static boolean trace = log.isTraceEnabled();
    private String userName;
    private String password;
    private String clientID;
    private boolean useXA;
    private final int type;
    private final boolean transacted;
    private final int acknowledgeMode;

    public HornetQRAConnectionRequestInfo(HornetQRAProperties prop, int type) {
        if (trace) {
            log.trace((Object)("constructor(" + prop + ")"));
        }
        this.userName = prop.getUserName();
        this.password = prop.getPassword();
        this.clientID = prop.getClientID();
        this.useXA = prop.isUseXA();
        this.type = type;
        this.transacted = true;
        this.acknowledgeMode = 1;
    }

    public HornetQRAConnectionRequestInfo(int type) {
        if (trace) {
            log.trace((Object)("constructor(" + type + ")"));
        }
        this.type = type;
        this.transacted = true;
        this.acknowledgeMode = 1;
    }

    public HornetQRAConnectionRequestInfo(boolean transacted, int acknowledgeMode, int type) {
        if (trace) {
            log.trace((Object)("constructor(" + transacted + ", " + acknowledgeMode + ", " + type + ")"));
        }
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.type = type;
    }

    public void setDefaults(HornetQRAProperties prop) {
        if (trace) {
            log.trace((Object)("setDefaults(" + prop + ")"));
        }
        if (this.userName == null) {
            this.userName = prop.getUserName();
        }
        if (this.password == null) {
            this.password = prop.getPassword();
        }
        if (this.clientID == null) {
            this.clientID = prop.getClientID();
        }
        this.useXA = prop.isUseXA();
    }

    public String getUserName() {
        if (trace) {
            log.trace((Object)"getUserName()");
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        if (trace) {
            log.trace((Object)("setUserName(" + userName + ")"));
        }
        this.userName = userName;
    }

    public String getPassword() {
        if (trace) {
            log.trace((Object)"getPassword()");
        }
        return this.password;
    }

    public void setPassword(String password) {
        if (trace) {
            log.trace((Object)"setPassword(****)");
        }
        this.password = password;
    }

    public String getClientID() {
        if (trace) {
            log.trace((Object)"getClientID()");
        }
        return this.clientID;
    }

    public void setClientID(String clientID) {
        if (trace) {
            log.trace((Object)("setClientID(" + clientID + ")"));
        }
        this.clientID = clientID;
    }

    public int getType() {
        if (trace) {
            log.trace((Object)"getType()");
        }
        return this.type;
    }

    public boolean isUseXA() {
        if (trace) {
            log.trace((Object)("isUseXA() " + this.useXA));
        }
        return this.useXA;
    }

    public boolean isTransacted() {
        if (trace) {
            log.trace((Object)("isTransacted() " + this.transacted));
        }
        return this.transacted;
    }

    public int getAcknowledgeMode() {
        if (trace) {
            log.trace((Object)"getAcknowledgeMode()");
        }
        return this.acknowledgeMode;
    }

    public boolean equals(Object obj) {
        if (trace) {
            log.trace((Object)("equals(" + obj + ")"));
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HornetQRAConnectionRequestInfo) {
            HornetQRAConnectionRequestInfo you = (HornetQRAConnectionRequestInfo)obj;
            return Util.compare(this.userName, you.getUserName()) && Util.compare(this.password, you.getPassword()) && Util.compare(this.clientID, you.getClientID()) && this.type == you.getType() && this.useXA == you.isUseXA() && this.transacted == you.isTransacted() && this.acknowledgeMode == you.getAcknowledgeMode();
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            log.trace((Object)"hashCode()");
        }
        int hash = 7;
        hash += 31 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        hash += 31 * hash + (this.password != null ? this.password.hashCode() : 0);
        hash += 31 * hash + Integer.valueOf(this.type).hashCode();
        hash += 31 * hash + (this.useXA ? 1 : 0);
        hash += 31 * hash + (this.transacted ? 1 : 0);
        hash += 31 * hash + Integer.valueOf(this.acknowledgeMode).hashCode();
        return hash;
    }

    public String toString() {
        return "HornetQRAConnectionRequestInfo[type=" + this.type + ", useXA=" + this.useXA + ", transacted=" + this.transacted + ", acknowledgeMode=" + this.acknowledgeMode + ", clientID=" + this.clientID + ", userName=" + this.userName + ", password=" + this.password + "]";
    }
}

