/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRAManagedConnection;

public class HornetQRAXAResource
implements XAResource {
    private static final Logger log = Logger.getLogger(HornetQRAXAResource.class);
    private static boolean trace = log.isTraceEnabled();
    private final HornetQRAManagedConnection managedConnection;
    private final XAResource xaResource;

    public HornetQRAXAResource(HornetQRAManagedConnection managedConnection, XAResource xaResource) {
        if (trace) {
            log.trace((Object)("constructor(" + managedConnection + ", " + xaResource + ")"));
        }
        this.managedConnection = managedConnection;
        this.xaResource = xaResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        if (trace) {
            log.trace((Object)("start(" + xid + ", " + flags + ")"));
        }
        this.managedConnection.lock();
        try {
            this.xaResource.start(xid, flags);
        }
        finally {
            this.managedConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        if (trace) {
            log.trace((Object)("end(" + xid + ", " + flags + ")"));
        }
        this.managedConnection.lock();
        try {
            this.xaResource.end(xid, flags);
        }
        finally {
            this.managedConnection.unlock();
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("prepare(" + xid + ")"));
        }
        return this.xaResource.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (trace) {
            log.trace((Object)("commit(" + xid + ", " + onePhase + ")"));
        }
        this.xaResource.commit(xid, onePhase);
    }

    public void rollback(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("rollback(" + xid + ")"));
        }
        this.xaResource.rollback(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("forget(" + xid + ")"));
        }
        this.managedConnection.lock();
        try {
            this.xaResource.forget(xid);
        }
        finally {
            this.managedConnection.unlock();
        }
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (trace) {
            log.trace((Object)("isSameRM(" + xaRes + ")"));
        }
        return this.xaResource.isSameRM(xaRes);
    }

    public Xid[] recover(int flag) throws XAException {
        if (trace) {
            log.trace((Object)("recover(" + flag + ")"));
        }
        return this.xaResource.recover(flag);
    }

    public int getTransactionTimeout() throws XAException {
        if (trace) {
            log.trace((Object)"getTransactionTimeout()");
        }
        return this.xaResource.getTransactionTimeout();
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (trace) {
            log.trace((Object)("setTransactionTimeout(" + seconds + ")"));
        }
        return this.xaResource.setTransactionTimeout(seconds);
    }
}

