/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.transaction.TransactionManager;
import org.hornetq.core.logging.Logger;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class);

    private Util() {
    }

    public static boolean compare(String me, String you) {
        if (me == you) {
            return true;
        }
        if (me == null && you != null) {
            return false;
        }
        return me.equals(you);
    }

    public static boolean compare(Integer me, Integer you) {
        if (me == you) {
            return true;
        }
        if (me == null && you != null) {
            return false;
        }
        return me.equals(you);
    }

    public static boolean compare(Long me, Long you) {
        if (me == you) {
            return true;
        }
        if (me == null && you != null) {
            return false;
        }
        return me.equals(you);
    }

    public static boolean compare(Double me, Double you) {
        if (me == you) {
            return true;
        }
        if (me == null && you != null) {
            return false;
        }
        return me.equals(you);
    }

    public static boolean compare(Boolean me, Boolean you) {
        if (me == you) {
            return true;
        }
        if (me == null && you != null) {
            return false;
        }
        return me.equals(you);
    }

    public static Object lookup(Context context, String name, Class clazz) throws Exception {
        return context.lookup(name);
    }

    public static List<Map<String, Object>> parseConfig(String config) {
        String[] topElements;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String topElement : topElements = config.split(",")) {
            String[] elements;
            HashMap<String, String> map = new HashMap<String, String>();
            result.add(map);
            for (String element : elements = topElement.split(";")) {
                String[] expression = element.split("=");
                if (expression.length != 2) {
                    throw new IllegalArgumentException("Invalid expression " + element + " at " + config);
                }
                map.put(expression[0].trim(), expression[1].trim());
            }
        }
        return result;
    }

    public static List<String> parseConnectorConnectorConfig(String config) {
        String[] elements;
        ArrayList<String> res = new ArrayList<String>();
        for (String element : elements = config.split(",")) {
            res.add(element.trim());
        }
        return res;
    }

    public static TransactionManager locateTM(String locatorClass, String locatorMethod) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> aClass = loader.loadClass(locatorClass);
            Object o = aClass.newInstance();
            Method m = aClass.getMethod(locatorMethod, new Class[0]);
            return (TransactionManager)m.invoke(o, new Object[0]);
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage(), e);
            return null;
        }
    }
}

