/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra.inflow;

import java.util.UUID;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.ra.inflow.HornetQActivation;
import org.hornetq.ra.inflow.HornetQActivationSpec;

public class HornetQMessageHandler
implements MessageHandler {
    private static final Logger log = Logger.getLogger(HornetQMessageHandler.class);
    private static boolean trace = log.isTraceEnabled();
    private final ClientSessionInternal session;
    private ClientConsumer consumer;
    private MessageEndpoint endpoint;
    private final HornetQActivation activation;
    private boolean useLocalTx;
    private boolean transacted;
    private boolean useXA = false;
    private final int sessionNr;
    private final TransactionManager tm;

    public HornetQMessageHandler(HornetQActivation activation, TransactionManager tm, ClientSessionInternal session, int sessionNr) {
        this.activation = activation;
        this.session = session;
        this.sessionNr = sessionNr;
        this.tm = tm;
    }

    public void setup() throws Exception {
        HornetQActivationSpec spec;
        String selector;
        SimpleString selectorString;
        if (trace) {
            log.trace((Object)"setup()");
        }
        SimpleString simpleString = selectorString = (selector = (spec = this.activation.getActivationSpec()).getMessageSelector()) == null || selector.trim().equals("") ? null : new SimpleString(selector);
        if (this.activation.isTopic() && spec.isSubscriptionDurable()) {
            String subscriptionName = spec.getSubscriptionName();
            String clientID = spec.getClientID();
            if (clientID == null) {
                throw new InvalidClientIDException("Cannot create durable subscription for " + subscriptionName + " - client ID has not been set");
            }
            SimpleString queueName = new SimpleString(HornetQDestination.createQueueNameForDurableSubscription((String)clientID, (String)subscriptionName));
            ClientSession.QueueQuery subResponse = this.session.queueQuery(queueName);
            if (!subResponse.isExists()) {
                this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
            } else {
                boolean topicChanged;
                if (this.sessionNr == 0 && subResponse.getConsumerCount() > 0) {
                    throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                }
                SimpleString oldFilterString = subResponse.getFilterString();
                boolean selectorChanged = selector == null && oldFilterString != null || oldFilterString == null && selector != null || oldFilterString != null && selector != null && !oldFilterString.toString().equals(selector);
                SimpleString oldTopicName = subResponse.getAddress();
                boolean bl = topicChanged = !oldTopicName.equals((Object)this.activation.getAddress());
                if (selectorChanged || topicChanged) {
                    this.session.deleteQueue(queueName);
                    this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
                }
            }
            this.consumer = this.session.createConsumer(queueName, null, false);
        } else {
            SimpleString queueName;
            if (this.activation.isTopic()) {
                if (this.activation.getTopicTemporaryQueue() == null) {
                    queueName = new SimpleString(UUID.randomUUID().toString());
                    this.session.createQueue(this.activation.getAddress(), queueName, selectorString, false);
                    this.activation.setTopicTemporaryQueue(queueName);
                } else {
                    queueName = this.activation.getTopicTemporaryQueue();
                }
            } else {
                queueName = this.activation.getAddress();
            }
            this.consumer = this.session.createConsumer(queueName, selectorString);
        }
        MessageEndpointFactory endpointFactory = this.activation.getMessageEndpointFactory();
        this.useLocalTx = !this.activation.isDeliveryTransacted() && this.activation.getActivationSpec().isUseLocalTx() != false;
        this.transacted = this.activation.isDeliveryTransacted();
        if (this.activation.isDeliveryTransacted() && !this.activation.getActivationSpec().isUseLocalTx().booleanValue()) {
            this.endpoint = endpointFactory.createEndpoint((XAResource)this.session);
            this.useXA = true;
        } else {
            this.endpoint = endpointFactory.createEndpoint(null);
            this.useXA = false;
        }
        this.consumer.setMessageHandler((MessageHandler)this);
    }

    public void teardown() {
        if (trace) {
            log.trace((Object)"teardown()");
        }
        try {
            if (this.endpoint != null) {
                this.endpoint.release();
                this.endpoint = null;
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing endpoint " + this.endpoint), t);
        }
        try {
            SimpleString tmpQueue;
            ClientSession.QueueQuery subResponse;
            this.consumer.close();
            if (this.activation.getTopicTemporaryQueue() != null && (subResponse = this.session.queueQuery(tmpQueue = this.activation.getTopicTemporaryQueue())).getConsumerCount() == 0) {
                this.session.deleteQueue(tmpQueue);
            }
        }
        catch (Throwable t) {
            log.debug((Object)"Error closing core-queue consumer", t);
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing session " + this.session), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ClientMessage message) {
        if (trace) {
            log.trace((Object)("onMessage(" + message + ")"));
        }
        HornetQMessage msg = HornetQMessage.createMessage((ClientMessage)message, (ClientSession)this.session);
        boolean beforeDelivery = false;
        try {
            if (this.activation.getActivationSpec().getTransactionTimeout() > 0 && this.tm != null) {
                this.tm.setTransactionTimeout(this.activation.getActivationSpec().getTransactionTimeout().intValue());
            }
            this.endpoint.beforeDelivery(HornetQActivation.ONMESSAGE);
            beforeDelivery = true;
            msg.doBeforeReceive();
            if (this.transacted) {
                message.acknowledge();
            }
            ((MessageListener)this.endpoint).onMessage((Message)msg);
            if (!this.transacted) {
                message.acknowledge();
            }
            try {
                this.endpoint.afterDelivery();
            }
            catch (ResourceException e) {
                log.warn((Object)"Unable to call after delivery", (Throwable)e);
                try {
                    this.session.resetIfNeeded();
                }
                catch (HornetQException e2) {
                    log.warn((Object)"unable to reset session after failure");
                }
                return;
            }
            if (this.useLocalTx) {
                this.session.commit();
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to deliver message", e);
            if (beforeDelivery) {
                if (this.useXA && this.tm != null) {
                    try {
                        Transaction tx = this.tm.getTransaction();
                        if (tx != null) {
                            tx.setRollbackOnly();
                        }
                    }
                    catch (Exception e1) {
                        log.warn((Object)"unnable to clear the transaction", (Throwable)e1);
                        try {
                            this.session.rollback();
                        }
                        catch (HornetQException e2) {
                            log.warn((Object)"Unable to rollback", (Throwable)e2);
                            return;
                        }
                    }
                }
                try {
                    this.endpoint.afterDelivery();
                }
                catch (ResourceException e1) {
                    log.warn((Object)"Unable to call after delivery", e);
                }
            }
            if (this.useLocalTx || !this.activation.isDeliveryTransacted()) {
                try {
                    this.session.rollback(true);
                }
                catch (HornetQException e1) {
                    log.warn((Object)"Unable to roll local transaction back");
                }
            }
        }
        finally {
            try {
                this.session.resetIfNeeded();
            }
            catch (HornetQException e) {
                log.warn((Object)"unable to reset session after failure");
            }
        }
    }
}

