/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.io.Serializable;
import java.util.Hashtable;
import org.hornetq.api.core.HornetQException;
import org.hornetq.ra.ConnectionFactoryProperties;
import org.hornetq.ra.HornetQRABundle;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.utils.DefaultSensitiveStringCodec;
import org.hornetq.utils.PasswordMaskingUtil;
import org.hornetq.utils.SensitiveDataCodec;

public class HornetQRAProperties
extends ConnectionFactoryProperties
implements Serializable {
    static final long serialVersionUID = -2772367477755473248L;
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    private String userName;
    private String password = null;
    private Boolean localTx = false;
    private String transactionManagerLocatorClass = "org.hornetq.integration.jboss.tm.JBoss5TransactionManagerLocator;org.hornetq.integration.jboss.tm.JBoss4TransactionManagerLocator";
    private String transactionManagerLocatorMethod = "getTm;getTM";
    private static final int DEFAULT_SETUP_ATTEMPTS = -1;
    private static final long DEFAULT_SETUP_INTERVAL = 2000L;
    private int setupAttempts = -1;
    private long setupInterval = 2000L;
    private Hashtable<?, ?> jndiParams;
    private boolean useJNDI;
    private boolean useMaskedPassword = false;
    private String passwordCodec;
    private boolean initialized = false;
    private transient SensitiveDataCodec<String> codecInstance;
    private String jgroupsChannelLocatorClass;
    private String jgroupsChannelRefName;

    public HornetQRAProperties() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor()");
        }
    }

    public String getUserName() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getUserName()");
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setUserName(" + userName + ")");
        }
        this.userName = userName;
    }

    public String getPassword() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getPassword()");
        }
        return this.password;
    }

    public void setPassword(String password) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.password = password;
    }

    public boolean isUseJNDI() {
        return this.useJNDI;
    }

    public void setUseJNDI(Boolean value) {
        this.useJNDI = value;
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        return this.jndiParams;
    }

    public void setParsedJndiParams(Hashtable<?, ?> params) {
        this.jndiParams = params;
    }

    public Boolean getUseLocalTx() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getUseLocalTx()");
        }
        return this.localTx;
    }

    public void setUseLocalTx(Boolean localTx) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setUseLocalTx(" + localTx + ")");
        }
        this.localTx = localTx;
    }

    public void setTransactionManagerLocatorClass(String transactionManagerLocatorClass) {
        this.transactionManagerLocatorClass = transactionManagerLocatorClass;
    }

    public String getTransactionManagerLocatorClass() {
        return this.transactionManagerLocatorClass;
    }

    public String getTransactionManagerLocatorMethod() {
        return this.transactionManagerLocatorMethod;
    }

    public void setTransactionManagerLocatorMethod(String transactionManagerLocatorMethod) {
        this.transactionManagerLocatorMethod = transactionManagerLocatorMethod;
    }

    public int getSetupAttempts() {
        return this.setupAttempts;
    }

    public void setSetupAttempts(Integer setupAttempts) {
        this.setupAttempts = setupAttempts;
    }

    public long getSetupInterval() {
        return this.setupInterval;
    }

    public void setSetupInterval(Long setupInterval) {
        this.setupInterval = setupInterval;
    }

    public boolean isUseMaskedPassword() {
        return this.useMaskedPassword;
    }

    public void setUseMaskedPassword(boolean useMaskedPassword) {
        this.useMaskedPassword = useMaskedPassword;
    }

    public String getPasswordCodec() {
        return this.passwordCodec;
    }

    public void setPasswordCodec(String codecs) {
        this.passwordCodec = codecs;
    }

    public String toString() {
        return "HornetQRAProperties[localTx=" + this.localTx + ", userName=" + this.userName + ", password=****]";
    }

    public synchronized void init() throws HornetQException {
        if (this.initialized) {
            return;
        }
        if (this.useMaskedPassword) {
            this.codecInstance = new DefaultSensitiveStringCodec();
            if (this.passwordCodec != null) {
                this.codecInstance = PasswordMaskingUtil.getCodec((String)this.passwordCodec);
            }
            try {
                if (this.password != null) {
                    this.password = (String)this.codecInstance.decode((Object)this.password);
                }
            }
            catch (Exception e) {
                throw HornetQRABundle.BUNDLE.errorDecodingPassword(e);
            }
        }
        this.initialized = true;
    }

    public SensitiveDataCodec<String> getCodecInstance() {
        return this.codecInstance;
    }

    public String getJgroupsChannelLocatorClass() {
        return this.jgroupsChannelLocatorClass;
    }

    public void setJgroupsChannelLocatorClass(String jgroupsChannelLocatorClass) {
        this.jgroupsChannelLocatorClass = jgroupsChannelLocatorClass;
    }

    public String getJgroupsChannelRefName() {
        return this.jgroupsChannelRefName;
    }

    public void setJgroupsChannelRefName(String jgroupsChannelRefName) {
        this.jgroupsChannelRefName = jgroupsChannelRefName;
    }
}

