/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.JGroupsBroadcastGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.jms.HornetQJMSClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.ra.ConnectionFactoryProperties;
import org.hornetq.ra.HornetQRABundle;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRAManagedConnectionFactory;
import org.hornetq.ra.HornetQRAProperties;
import org.hornetq.ra.HornetQRaUtils;
import org.hornetq.ra.inflow.HornetQActivation;
import org.hornetq.ra.inflow.HornetQActivationSpec;
import org.hornetq.ra.recovery.RecoveryManager;
import org.hornetq.utils.SensitiveDataCodec;
import org.jgroups.JChannel;

public class HornetQResourceAdapter
implements ResourceAdapter,
Serializable {
    private static final long serialVersionUID = 4756893709825838770L;
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    private BootstrapContext ctx;
    private final HornetQRAProperties raProperties;
    private String unparsedProperties;
    private String unparsedConnectors;
    private final AtomicBoolean configured;
    private final Map<ActivationSpec, HornetQActivation> activations;
    private HornetQConnectionFactory defaultHornetQConnectionFactory;
    private HornetQConnectionFactory recoveryHornetQConnectionFactory;
    private TransactionManager tm;
    private String unparsedJndiParams;
    private final RecoveryManager recoveryManager;
    private boolean useAutoRecovery = true;
    private final List<HornetQRAManagedConnectionFactory> managedConnectionFactories = new ArrayList<HornetQRAManagedConnectionFactory>();

    public HornetQResourceAdapter() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor()");
        }
        this.raProperties = new HornetQRAProperties();
        this.configured = new AtomicBoolean(false);
        this.activations = new ConcurrentHashMap<ActivationSpec, HornetQActivation>();
        this.recoveryManager = new RecoveryManager();
    }

    public TransactionManager getTM() {
        return this.tm;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        if (spec == null) {
            throw HornetQRABundle.BUNDLE.noActivationSpec();
        }
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (HornetQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        if (trace) {
            HornetQRALogger.LOGGER.trace("endpointActivation(" + endpointFactory + ", " + spec + ")");
        }
        HornetQActivation activation = new HornetQActivation(this, endpointFactory, (HornetQActivationSpec)spec);
        this.activations.put(spec, activation);
        activation.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        HornetQActivation activation;
        if (trace) {
            HornetQRALogger.LOGGER.trace("endpointDeactivation(" + endpointFactory + ", " + spec + ")");
        }
        if ((activation = this.activations.remove(spec)) != null) {
            activation.stop();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getXAResources(" + Arrays.toString(specs) + ")");
        }
        if (this.useAutoRecovery) {
            return null;
        }
        ArrayList<XAResource> xaresources = new ArrayList<XAResource>();
        for (ActivationSpec spec : specs) {
            HornetQActivation activation = this.activations.get(spec);
            if (activation == null) continue;
            xaresources.addAll(activation.getXAResources());
        }
        return xaresources.toArray(new XAResource[xaresources.size()]);
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("start(" + ctx + ")");
        }
        this.locateTM();
        this.recoveryManager.start(this.useAutoRecovery);
        this.ctx = ctx;
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (HornetQException e) {
                throw new ResourceAdapterInternalException("Unable to create activation", (Throwable)e);
            }
        }
        HornetQRALogger.LOGGER.info("HornetQ resource adaptor started");
    }

    public void stop() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("stop()");
        }
        for (Map.Entry<ActivationSpec, HornetQActivation> entry : this.activations.entrySet()) {
            try {
                entry.getValue().stop();
            }
            catch (Exception ignored) {
                HornetQRALogger.LOGGER.debug("Ignored", ignored);
            }
        }
        this.activations.clear();
        for (HornetQRAManagedConnectionFactory managedConnectionFactory : this.managedConnectionFactories) {
            managedConnectionFactory.stop();
        }
        this.managedConnectionFactories.clear();
        if (this.defaultHornetQConnectionFactory != null) {
            this.defaultHornetQConnectionFactory.close();
        }
        if (this.recoveryHornetQConnectionFactory != null) {
            this.recoveryHornetQConnectionFactory.close();
        }
        this.recoveryManager.stop();
        HornetQRALogger.LOGGER.raStopped();
    }

    public void setUseAutoRecovery(Boolean useAutoRecovery) {
        this.useAutoRecovery = useAutoRecovery;
    }

    public Boolean isUseAutoRecovery() {
        return this.useAutoRecovery;
    }

    public Boolean isUseMaskedPassword() {
        return this.raProperties.isUseMaskedPassword();
    }

    public void setUseMaskedPassword(Boolean useMaskedPassword) {
        this.raProperties.setUseMaskedPassword(useMaskedPassword);
    }

    public void setPasswordCodec(String passwordCodec) {
        this.raProperties.setPasswordCodec(passwordCodec);
    }

    public String getPasswordCodec() {
        return this.raProperties.getPasswordCodec();
    }

    public void setConnectorClassName(String connectorClassName) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setTransportType(" + connectorClassName + ")");
        }
        this.unparsedConnectors = connectorClassName;
        this.raProperties.setParsedConnectorClassNames(HornetQRaUtils.parseConnectorConnectorConfig(connectorClassName));
    }

    public String getConnectorClassName() {
        return this.unparsedConnectors;
    }

    public String getConnectionParameters() {
        return this.unparsedProperties;
    }

    public void setConnectionParameters(String config) {
        if (config != null) {
            this.unparsedProperties = config;
            this.raProperties.setParsedConnectionParameters(HornetQRaUtils.parseConfig(config));
        }
    }

    public Boolean getHA() {
        return this.raProperties.isHA();
    }

    public void setHA(Boolean ha) {
        this.raProperties.setHA(ha);
    }

    public String getDiscoveryAddress() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDiscoveryGroupAddress()");
        }
        return this.raProperties.getDiscoveryAddress();
    }

    public void setJgroupsFile(String jgroupsFile) {
        this.raProperties.setJgroupsFile(jgroupsFile);
    }

    public String getJgroupsFile() {
        return this.raProperties.getJgroupsFile();
    }

    public String getJgroupsChannelName() {
        return this.raProperties.getJgroupsChannelName();
    }

    public void setJgroupsChannelName(String jgroupsChannelName) {
        this.raProperties.setJgroupsChannelName(jgroupsChannelName);
    }

    public void setDiscoveryAddress(String dgn) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDiscoveryGroupAddress(" + dgn + ")");
        }
        this.raProperties.setDiscoveryAddress(dgn);
    }

    public Integer getDiscoveryPort() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDiscoveryGroupPort()");
        }
        return this.raProperties.getDiscoveryPort();
    }

    public void setDiscoveryLocalBindAddress(String discoveryLocalBindAddress) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDiscoveryLocalBindAddress(" + discoveryLocalBindAddress + ")");
        }
        this.raProperties.setDiscoveryLocalBindAddress(discoveryLocalBindAddress);
    }

    public String getDiscoveryLocalBindAddress() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDiscoveryLocalBindAddress()");
        }
        return this.raProperties.getDiscoveryLocalBindAddress();
    }

    public void setDiscoveryPort(Integer dgp) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDiscoveryGroupPort(" + dgp + ")");
        }
        this.raProperties.setDiscoveryPort(dgp);
    }

    public Long getDiscoveryRefreshTimeout() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDiscoveryRefreshTimeout()");
        }
        return this.raProperties.getDiscoveryRefreshTimeout();
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDiscoveryRefreshTimeout(" + discoveryRefreshTimeout + ")");
        }
        this.raProperties.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public Long getDiscoveryInitialWaitTimeout() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDiscoveryInitialWaitTimeout()");
        }
        return this.raProperties.getDiscoveryInitialWaitTimeout();
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDiscoveryInitialWaitTimeout(" + discoveryInitialWaitTimeout + ")");
        }
        this.raProperties.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public Long getClientFailureCheckPeriod() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getClientFailureCheckPeriod()");
        }
        return this.raProperties.getClientFailureCheckPeriod();
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setClientFailureCheckPeriod(" + clientFailureCheckPeriod + ")");
        }
        this.raProperties.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public Long getConnectionTTL() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getConnectionTTL()");
        }
        return this.raProperties.getConnectionTTL();
    }

    public void setConnectionTTL(Long connectionTTL) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setConnectionTTL(" + connectionTTL + ")");
        }
        this.raProperties.setConnectionTTL(connectionTTL);
    }

    public Boolean isCacheLargeMessagesClient() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("isCacheLargeMessagesClient()");
        }
        return this.raProperties.isCacheLargeMessagesClient();
    }

    public void setCacheLargeMessagesClient(Boolean cacheLargeMessagesClient) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setCacheLargeMessagesClient(" + cacheLargeMessagesClient + ")");
        }
        this.raProperties.setCacheLargeMessagesClient(cacheLargeMessagesClient);
    }

    public Boolean isCompressLargeMessage() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("isCompressLargeMessage()");
        }
        return this.raProperties.isCompressLargeMessage();
    }

    public void setFailoverOnInitialConnection(Boolean failoverOnInitialConnection) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setFailoverOnInitialConnection(" + failoverOnInitialConnection + ")");
        }
        this.raProperties.setFailoverOnInitialConnection(failoverOnInitialConnection);
    }

    public Boolean isFailoverOnInitialConnection() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("isFailoverOnInitialConnection()");
        }
        return this.raProperties.isFailoverOnInitialConnection();
    }

    public void setCompressLargeMessage(Boolean compressLargeMessage) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setCompressLargeMessage(" + compressLargeMessage + ")");
        }
        this.raProperties.setCompressLargeMessage(compressLargeMessage);
    }

    public Long getCallTimeout() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getCallTimeout()");
        }
        return this.raProperties.getCallTimeout();
    }

    public void setCallTimeout(Long callTimeout) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setCallTimeout(" + callTimeout + ")");
        }
        this.raProperties.setCallTimeout(callTimeout);
    }

    public Long getCallFailoverTimeout() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getCallFailoverTimeout()");
        }
        return this.raProperties.getCallFailoverTimeout();
    }

    public void setCallFailoverTimeout(Long callFailoverTimeout) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setCallFailoverTimeout(" + callFailoverTimeout + ")");
        }
        this.raProperties.setCallFailoverTimeout(callFailoverTimeout);
    }

    public Integer getDupsOKBatchSize() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDupsOKBatchSize()");
        }
        return this.raProperties.getDupsOKBatchSize();
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDupsOKBatchSize(" + dupsOKBatchSize + ")");
        }
        this.raProperties.setDupsOKBatchSize(dupsOKBatchSize);
    }

    public Integer getTransactionBatchSize() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getTransactionBatchSize()");
        }
        return this.raProperties.getTransactionBatchSize();
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setTransactionBatchSize(" + transactionBatchSize + ")");
        }
        this.raProperties.setTransactionBatchSize(transactionBatchSize);
    }

    public Integer getConsumerWindowSize() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getConsumerWindowSize()");
        }
        return this.raProperties.getConsumerWindowSize();
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setConsumerWindowSize(" + consumerWindowSize + ")");
        }
        this.raProperties.setConsumerWindowSize(consumerWindowSize);
    }

    public Integer getConsumerMaxRate() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getConsumerMaxRate()");
        }
        return this.raProperties.getConsumerMaxRate();
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setConsumerMaxRate(" + consumerMaxRate + ")");
        }
        this.raProperties.setConsumerMaxRate(consumerMaxRate);
    }

    public Integer getConfirmationWindowSize() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getConfirmationWindowSize()");
        }
        return this.raProperties.getConfirmationWindowSize();
    }

    public void setConfirmationWindowSize(Integer confirmationWindowSize) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setConfirmationWindowSize(" + confirmationWindowSize + ")");
        }
        this.raProperties.setConfirmationWindowSize(confirmationWindowSize);
    }

    public Integer getProducerMaxRate() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getProducerMaxRate()");
        }
        return this.raProperties.getProducerMaxRate();
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setProducerMaxRate(" + producerMaxRate + ")");
        }
        this.raProperties.setProducerMaxRate(producerMaxRate);
    }

    public Integer getProducerWindowSize() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getProducerWindowSize()");
        }
        return this.raProperties.getProducerWindowSize();
    }

    public void setProducerWindowSize(Integer producerWindowSize) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setProducerWindowSize(" + producerWindowSize + ")");
        }
        this.raProperties.setProducerWindowSize(producerWindowSize);
    }

    public String getDeserializationBlackList() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDeserializationBlackList()");
        }
        return this.raProperties.getDeserializationBlackList();
    }

    public void setDeserializationBlackList(String deserializationBlackList) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDeserializationBlackList(" + deserializationBlackList + ")");
        }
        this.raProperties.setDeserializationBlackList(deserializationBlackList);
    }

    public String getDeserializationWhiteList() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDeserializationWhiteList()");
        }
        return this.raProperties.getDeserializationWhiteList();
    }

    public void setDeserializationWhiteList(String deserializationWhiteList) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDeserializationWhiteList(" + deserializationWhiteList + ")");
        }
        this.raProperties.setDeserializationWhiteList(deserializationWhiteList);
    }

    public Integer getMinLargeMessageSize() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getMinLargeMessageSize()");
        }
        return this.raProperties.getMinLargeMessageSize();
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setMinLargeMessageSize(" + minLargeMessageSize + ")");
        }
        this.raProperties.setMinLargeMessageSize(minLargeMessageSize);
    }

    public Boolean getBlockOnAcknowledge() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getBlockOnAcknowledge()");
        }
        return this.raProperties.isBlockOnAcknowledge();
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setBlockOnAcknowledge(" + blockOnAcknowledge + ")");
        }
        this.raProperties.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public Boolean getBlockOnNonDurableSend() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getBlockOnNonDurableSend()");
        }
        return this.raProperties.isBlockOnNonDurableSend();
    }

    public void setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setBlockOnNonDurableSend(" + blockOnNonDurableSend + ")");
        }
        this.raProperties.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    public Boolean getBlockOnDurableSend() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getBlockOnDurableSend()");
        }
        return this.raProperties.isBlockOnDurableSend();
    }

    public void setBlockOnDurableSend(Boolean blockOnDurableSend) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setBlockOnDurableSend(" + blockOnDurableSend + ")");
        }
        this.raProperties.setBlockOnDurableSend(blockOnDurableSend);
    }

    public Boolean getAutoGroup() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getAutoGroup()");
        }
        return this.raProperties.isAutoGroup();
    }

    public void setAutoGroup(Boolean autoGroup) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setAutoGroup(" + autoGroup + ")");
        }
        this.raProperties.setAutoGroup(autoGroup);
    }

    public Boolean getPreAcknowledge() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getPreAcknowledge()");
        }
        return this.raProperties.isPreAcknowledge();
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setPreAcknowledge(" + preAcknowledge + ")");
        }
        this.raProperties.setPreAcknowledge(preAcknowledge);
    }

    public Integer getInitialConnectAttempts() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getInitialConnectAttempts()");
        }
        return this.raProperties.getInitialConnectAttempts();
    }

    public void setInitialConnectAttempts(Integer initialConnectAttempts) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setInitialConnectionAttempts(" + initialConnectAttempts + ")");
        }
        this.raProperties.setInitialConnectAttempts(initialConnectAttempts);
    }

    public Integer getInitialMessagePacketSize() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getInitialMessagePacketSize()");
        }
        return this.raProperties.getInitialMessagePacketSize();
    }

    public void setInitialMessagePacketSize(Integer initialMessagePacketSize) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setInitialMessagePacketSize(" + initialMessagePacketSize + ")");
        }
        this.raProperties.setInitialMessagePacketSize(initialMessagePacketSize);
    }

    public Long getRetryInterval() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getRetryInterval()");
        }
        return this.raProperties.getRetryInterval();
    }

    public void setRetryInterval(Long retryInterval) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setRetryInterval(" + retryInterval + ")");
        }
        this.raProperties.setRetryInterval(retryInterval);
    }

    public Double getRetryIntervalMultiplier() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getRetryIntervalMultiplier()");
        }
        return this.raProperties.getRetryIntervalMultiplier();
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setRetryIntervalMultiplier(" + retryIntervalMultiplier + ")");
        }
        this.raProperties.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public Long getMaxRetryInterval() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getMaxRetryInterval()");
        }
        return this.raProperties.getMaxRetryInterval();
    }

    public void setMaxRetryInterval(Long maxRetryInterval) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setMaxRetryInterval(" + maxRetryInterval + ")");
        }
        this.raProperties.setMaxRetryInterval(maxRetryInterval);
    }

    public Integer getReconnectAttempts() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getReconnectAttempts()");
        }
        return this.raProperties.getReconnectAttempts();
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setReconnectAttempts(" + reconnectAttempts + ")");
        }
        this.raProperties.setReconnectAttempts(reconnectAttempts);
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        return this.raProperties.getConnectionLoadBalancingPolicyClassName();
    }

    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setFailoverOnServerShutdown(" + connectionLoadBalancingPolicyClassName + ")");
        }
        this.raProperties.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public Integer getScheduledThreadPoolMaxSize() {
        return this.raProperties.getScheduledThreadPoolMaxSize();
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setFailoverOnServerShutdown(" + scheduledThreadPoolMaxSize + ")");
        }
        this.raProperties.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public Integer getThreadPoolMaxSize() {
        return this.raProperties.getThreadPoolMaxSize();
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setFailoverOnServerShutdown(" + threadPoolMaxSize + ")");
        }
        this.raProperties.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public Boolean getUseGlobalPools() {
        return this.raProperties.isUseGlobalPools();
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setFailoverOnServerShutdown(" + useGlobalPools + ")");
        }
        this.raProperties.setUseGlobalPools(useGlobalPools);
    }

    public String getUserName() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getUserName()");
        }
        return this.raProperties.getUserName();
    }

    public void setUserName(String userName) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setUserName(" + userName + ")");
        }
        this.raProperties.setUserName(userName);
    }

    public String getPassword() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getPassword()");
        }
        return this.raProperties.getPassword();
    }

    public void setPassword(String password) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setPassword(****)");
        }
        this.raProperties.setPassword(password);
    }

    public boolean isUseJNDI() {
        return this.raProperties.isUseJNDI();
    }

    public void setUseJNDI(Boolean value) {
        this.raProperties.setUseJNDI(value);
    }

    public String getJndiParams() {
        return this.unparsedJndiParams;
    }

    public void setJndiParams(String jndiParams) {
        this.unparsedJndiParams = jndiParams;
        this.raProperties.setParsedJndiParams(HornetQRaUtils.parseHashtableConfig(jndiParams));
    }

    public Hashtable<?, ?> getParsedJndiParams() {
        return this.raProperties.getParsedJndiParams();
    }

    public String getClientID() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getClientID()");
        }
        return this.raProperties.getClientID();
    }

    public void setClientID(String clientID) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setClientID(" + clientID + ")");
        }
        this.raProperties.setClientID(clientID);
    }

    public String getGroupID() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getGroupID()");
        }
        return this.raProperties.getGroupID();
    }

    public void setGroupID(String groupID) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setGroupID(" + groupID + ")");
        }
        this.raProperties.setGroupID(groupID);
    }

    public Boolean getUseLocalTx() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getUseLocalTx()");
        }
        return this.raProperties.getUseLocalTx();
    }

    public void setUseLocalTx(Boolean localTx) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setUseXA(" + localTx + ")");
        }
        this.raProperties.setUseLocalTx(localTx);
    }

    public int getSetupAttempts() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getSetupAttempts()");
        }
        return this.raProperties.getSetupAttempts();
    }

    public void setSetupAttempts(Integer setupAttempts) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setSetupAttempts(" + setupAttempts + ")");
        }
        this.raProperties.setSetupAttempts(setupAttempts);
    }

    public long getSetupInterval() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getSetupInterval()");
        }
        return this.raProperties.getSetupInterval();
    }

    public void setSetupInterval(Long interval) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setSetupInterval(" + interval + ")");
        }
        this.raProperties.setSetupInterval(interval);
    }

    public boolean equals(Object obj) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("equals(" + obj + ")");
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HornetQResourceAdapter) {
            return this.raProperties.equals(((HornetQResourceAdapter)obj).getProperties());
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("hashCode()");
        }
        return this.raProperties.hashCode();
    }

    public WorkManager getWorkManager() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getWorkManager()");
        }
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.getWorkManager();
    }

    public ClientSession createSession(ClientSessionFactory parameterFactory, int ackMode, String user, String pass, Boolean preAck, Integer dupsOkBatchSize, Integer transactionBatchSize, boolean deliveryTransacted, boolean useLocalTx, Integer txTimeout) throws Exception {
        ClientSession result;
        if (deliveryTransacted || useLocalTx) {
            result = useLocalTx ? parameterFactory.createSession(user, pass, false, false, false, false, 0) : parameterFactory.createSession(user, pass, true, false, false, false, 0);
        } else if (preAck != null && preAck.booleanValue()) {
            result = parameterFactory.createSession(user, pass, false, true, true, true, -1);
        } else {
            switch (ackMode) {
                case 1: {
                    result = parameterFactory.createSession(user, pass, false, true, true, false, 0);
                    break;
                }
                case 3: {
                    int actDupsOkBatchSize = dupsOkBatchSize != null ? dupsOkBatchSize : 0x100000;
                    result = parameterFactory.createSession(user, pass, false, true, true, false, actDupsOkBatchSize);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ackmode: " + ackMode);
                }
            }
        }
        HornetQRALogger.LOGGER.debug("Using queue connection " + result);
        return result;
    }

    public RecoveryManager getRecoveryManager() {
        return this.recoveryManager;
    }

    protected HornetQRAProperties getProperties() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getProperties()");
        }
        return this.raProperties;
    }

    protected void setup() throws HornetQException {
        this.raProperties.init();
        this.defaultHornetQConnectionFactory = this.createHornetQConnectionFactory(this.raProperties);
        this.recoveryHornetQConnectionFactory = this.createRecoveryHornetQConnectionFactory(this.raProperties);
        this.recoveryManager.register(this.recoveryHornetQConnectionFactory, this.raProperties.getUserName(), this.raProperties.getPassword());
    }

    public Map<ActivationSpec, HornetQActivation> getActivations() {
        return this.activations;
    }

    public HornetQConnectionFactory getDefaultHornetQConnectionFactory() throws ResourceException {
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (HornetQException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        return this.defaultHornetQConnectionFactory;
    }

    public void setTransactionManagerLocatorClass(String transactionManagerLocatorClass) {
        this.raProperties.setTransactionManagerLocatorClass(transactionManagerLocatorClass);
    }

    public String getTransactionManagerLocatorClass() {
        return this.raProperties.getTransactionManagerLocatorClass();
    }

    public String getJgroupsChannelLocatorClass() {
        return this.raProperties.getJgroupsChannelLocatorClass();
    }

    public void setJgroupsChannelLocatorClass(String jgroupsChannelLocatorClass) {
        this.raProperties.setJgroupsChannelLocatorClass(jgroupsChannelLocatorClass);
    }

    public String getJgroupsChannelRefName() {
        return this.raProperties.getJgroupsChannelRefName();
    }

    public void setJgroupsChannelRefName(String jgroupsChannelRefName) {
        this.raProperties.setJgroupsChannelRefName(jgroupsChannelRefName);
    }

    public String getTransactionManagerLocatorMethod() {
        return this.raProperties.getTransactionManagerLocatorMethod();
    }

    public void setTransactionManagerLocatorMethod(String transactionManagerLocatorMethod) {
        this.raProperties.setTransactionManagerLocatorMethod(transactionManagerLocatorMethod);
    }

    public HornetQConnectionFactory createHornetQConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        HornetQConnectionFactory cf;
        List<String> connectorClassName = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectorClassNames() : this.raProperties.getParsedConnectorClassNames();
        String discoveryAddress = overrideProperties.getDiscoveryAddress() != null ? overrideProperties.getDiscoveryAddress() : this.getDiscoveryAddress();
        Boolean ha = overrideProperties.isHA() != null ? overrideProperties.isHA() : this.getHA();
        String jgroupsFileName = overrideProperties.getJgroupsFile() != null ? overrideProperties.getJgroupsFile() : this.getJgroupsFile();
        String jgroupsChannel = overrideProperties.getJgroupsChannelName() != null ? overrideProperties.getJgroupsChannelName() : this.getJgroupsChannelName();
        String jgroupsLocatorClassName = this.raProperties.getJgroupsChannelLocatorClass();
        if (ha == null) {
            ha = false;
        }
        if (discoveryAddress != null || jgroupsFileName != null || jgroupsLocatorClassName != null) {
            Long initialTimeout;
            Long refreshTimeout;
            JGroupsBroadcastGroupConfiguration endpointFactoryConfiguration = null;
            if (jgroupsLocatorClassName != null) {
                String jchannelRefName = this.raProperties.getJgroupsChannelRefName();
                JChannel jchannel = HornetQRaUtils.locateJGroupsChannel(jgroupsLocatorClassName, jchannelRefName);
                endpointFactoryConfiguration = new JGroupsBroadcastGroupConfiguration(jchannel, jgroupsChannel);
            } else if (discoveryAddress != null) {
                Integer discoveryPort;
                Integer n = discoveryPort = overrideProperties.getDiscoveryPort() != null ? overrideProperties.getDiscoveryPort() : this.getDiscoveryPort();
                if (discoveryPort == null) {
                    discoveryPort = 9876;
                }
                String localBindAddress = overrideProperties.getDiscoveryLocalBindAddress() != null ? overrideProperties.getDiscoveryLocalBindAddress() : this.raProperties.getDiscoveryLocalBindAddress();
                endpointFactoryConfiguration = new UDPBroadcastGroupConfiguration(discoveryAddress, discoveryPort.intValue(), localBindAddress, -1);
            } else if (jgroupsFileName != null) {
                endpointFactoryConfiguration = new JGroupsBroadcastGroupConfiguration(jgroupsFileName, jgroupsChannel);
            }
            Long l = refreshTimeout = overrideProperties.getDiscoveryRefreshTimeout() != null ? overrideProperties.getDiscoveryRefreshTimeout() : this.raProperties.getDiscoveryRefreshTimeout();
            if (refreshTimeout == null) {
                refreshTimeout = 10000L;
            }
            Long l2 = initialTimeout = overrideProperties.getDiscoveryInitialWaitTimeout() != null ? overrideProperties.getDiscoveryInitialWaitTimeout() : this.raProperties.getDiscoveryInitialWaitTimeout();
            if (initialTimeout == null) {
                initialTimeout = 10000L;
            }
            DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration(refreshTimeout.longValue(), initialTimeout.longValue(), (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
            if (HornetQRALogger.LOGGER.isDebugEnabled()) {
                HornetQRALogger.LOGGER.debug("Creating Connection Factory on the resource adapter for discovery=" + groupConfiguration + " with ha=" + ha);
            }
            cf = ha.booleanValue() ? HornetQJMSClient.createConnectionFactoryWithHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF) : HornetQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF);
        } else if (connectorClassName != null) {
            Object[] transportConfigurations = new TransportConfiguration[connectorClassName.size()];
            List<Map<String, Object>> connectionParams = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectionParameters() : this.raProperties.getParsedConnectionParameters();
            for (int i = 0; i < connectorClassName.size(); ++i) {
                TransportConfiguration tc;
                if (connectionParams == null || i >= connectionParams.size()) {
                    tc = new TransportConfiguration(connectorClassName.get(i));
                    HornetQRALogger.LOGGER.debug("No connector params provided using default");
                } else {
                    tc = new TransportConfiguration(connectorClassName.get(i), connectionParams.get(i));
                }
                transportConfigurations[i] = tc;
            }
            if (HornetQRALogger.LOGGER.isDebugEnabled()) {
                HornetQRALogger.LOGGER.debug("Creating Connection Factory on the resource adapter for transport=" + Arrays.toString(transportConfigurations) + " with ha=" + ha);
            }
            cf = ha.booleanValue() ? HornetQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations) : HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations);
        } else {
            throw new IllegalArgumentException("must provide either TransportType or DiscoveryGroupAddress and DiscoveryGroupPort for HornetQ ResourceAdapter Connection Factory");
        }
        this.setParams(cf, overrideProperties);
        return cf;
    }

    public HornetQConnectionFactory createRecoveryHornetQConnectionFactory(ConnectionFactoryProperties overrideProperties) {
        HornetQConnectionFactory cf;
        String jgroupsChannel;
        List<String> connectorClassName = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectorClassNames() : this.raProperties.getParsedConnectorClassNames();
        String discoveryAddress = overrideProperties.getDiscoveryAddress() != null ? overrideProperties.getDiscoveryAddress() : this.getDiscoveryAddress();
        String jgroupsFileName = overrideProperties.getJgroupsFile() != null ? overrideProperties.getJgroupsFile() : this.getJgroupsFile();
        String string = jgroupsChannel = overrideProperties.getJgroupsChannelName() != null ? overrideProperties.getJgroupsChannelName() : this.getJgroupsChannelName();
        if (connectorClassName == null) {
            Long initialTimeout;
            Long refreshTimeout;
            JGroupsBroadcastGroupConfiguration endpointFactoryConfiguration = null;
            if (discoveryAddress != null) {
                Integer discoveryPort;
                Integer n = discoveryPort = overrideProperties.getDiscoveryPort() != null ? overrideProperties.getDiscoveryPort() : this.getDiscoveryPort();
                if (discoveryPort == null) {
                    discoveryPort = 9876;
                }
                String localBindAddress = overrideProperties.getDiscoveryLocalBindAddress() != null ? overrideProperties.getDiscoveryLocalBindAddress() : this.raProperties.getDiscoveryLocalBindAddress();
                endpointFactoryConfiguration = new UDPBroadcastGroupConfiguration(discoveryAddress, discoveryPort.intValue(), localBindAddress, -1);
            } else if (jgroupsFileName != null) {
                endpointFactoryConfiguration = new JGroupsBroadcastGroupConfiguration(jgroupsFileName, jgroupsChannel);
            } else {
                String jgroupsLocatorClass = this.raProperties.getJgroupsChannelLocatorClass();
                if (jgroupsLocatorClass != null) {
                    String jgroupsChannelRefName = this.raProperties.getJgroupsChannelRefName();
                    JChannel jchannel = HornetQRaUtils.locateJGroupsChannel(jgroupsLocatorClass, jgroupsChannelRefName);
                    endpointFactoryConfiguration = new JGroupsBroadcastGroupConfiguration(jchannel, jgroupsChannel);
                }
                if (endpointFactoryConfiguration == null) {
                    throw new IllegalArgumentException("must provide either TransportType or DiscoveryGroupAddress and DiscoveryGroupPort for HornetQ ResourceAdapter Connection Factory");
                }
            }
            Long l = refreshTimeout = overrideProperties.getDiscoveryRefreshTimeout() != null ? overrideProperties.getDiscoveryRefreshTimeout() : this.raProperties.getDiscoveryRefreshTimeout();
            if (refreshTimeout == null) {
                refreshTimeout = 10000L;
            }
            Long l2 = initialTimeout = overrideProperties.getDiscoveryInitialWaitTimeout() != null ? overrideProperties.getDiscoveryInitialWaitTimeout() : this.raProperties.getDiscoveryInitialWaitTimeout();
            if (initialTimeout == null) {
                initialTimeout = 10000L;
            }
            DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration(refreshTimeout.longValue(), initialTimeout.longValue(), (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
            groupConfiguration.setRefreshTimeout(refreshTimeout.longValue());
            if (HornetQRALogger.LOGGER.isDebugEnabled()) {
                HornetQRALogger.LOGGER.debug("Creating Recovery Connection Factory on the resource adapter for discovery=" + groupConfiguration);
            }
            cf = HornetQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.XA_CF);
        } else {
            Object[] transportConfigurations = new TransportConfiguration[connectorClassName.size()];
            List<Map<String, Object>> connectionParams = overrideProperties.getParsedConnectorClassNames() != null ? overrideProperties.getParsedConnectionParameters() : this.raProperties.getParsedConnectionParameters();
            for (int i = 0; i < connectorClassName.size(); ++i) {
                TransportConfiguration tc;
                if (connectionParams == null || i >= connectionParams.size()) {
                    tc = new TransportConfiguration(connectorClassName.get(i));
                    HornetQRALogger.LOGGER.debug("No connector params provided using default");
                } else {
                    tc = new TransportConfiguration(connectorClassName.get(i), connectionParams.get(i));
                }
                transportConfigurations[i] = tc;
            }
            if (HornetQRALogger.LOGGER.isDebugEnabled()) {
                HornetQRALogger.LOGGER.debug("Creating Recovery Connection Factory on the resource adapter for transport=" + Arrays.toString(transportConfigurations));
            }
            cf = HornetQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.XA_CF, (TransportConfiguration[])transportConfigurations);
        }
        this.setParams(cf, overrideProperties);
        cf.setReconnectAttempts(0);
        cf.setInitialConnectAttempts(0);
        return cf;
    }

    public Map<String, Object> overrideConnectionParameters(Map<String, Object> connectionParams, Map<String, Object> overrideConnectionParams) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (connectionParams != null) {
            map.putAll(connectionParams);
        }
        if (overrideConnectionParams != null) {
            for (Map.Entry<String, Object> stringObjectEntry : overrideConnectionParams.entrySet()) {
                map.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
            }
        }
        return map;
    }

    private void locateTM() {
        String[] locatorClasses = this.raProperties.getTransactionManagerLocatorClass().split(";");
        String[] locatorMethods = this.raProperties.getTransactionManagerLocatorMethod().split(";");
        for (int i = 0; i < locatorClasses.length; ++i) {
            this.tm = HornetQRaUtils.locateTM(locatorClasses[i], locatorMethods[i]);
            if (this.tm != null) break;
        }
        if (this.tm == null) {
            HornetQRALogger.LOGGER.noTXLocator();
        } else {
            HornetQRALogger.LOGGER.debug("TM located = " + this.tm);
        }
    }

    private void setParams(HornetQConnectionFactory cf, ConnectionFactoryProperties overrideProperties) {
        String val5;
        Double val4;
        Long val3;
        Integer val2;
        Boolean val;
        Boolean bl = val = overrideProperties.isAutoGroup() != null ? overrideProperties.isAutoGroup() : this.raProperties.isAutoGroup();
        if (val != null) {
            cf.setAutoGroup(val.booleanValue());
        }
        Boolean bl2 = val = overrideProperties.isBlockOnAcknowledge() != null ? overrideProperties.isBlockOnAcknowledge() : this.raProperties.isBlockOnAcknowledge();
        if (val != null) {
            cf.setBlockOnAcknowledge(val.booleanValue());
        }
        Boolean bl3 = val = overrideProperties.isBlockOnNonDurableSend() != null ? overrideProperties.isBlockOnNonDurableSend() : this.raProperties.isBlockOnNonDurableSend();
        if (val != null) {
            cf.setBlockOnNonDurableSend(val.booleanValue());
        }
        Boolean bl4 = val = overrideProperties.isBlockOnDurableSend() != null ? overrideProperties.isBlockOnDurableSend() : this.raProperties.isBlockOnDurableSend();
        if (val != null) {
            cf.setBlockOnDurableSend(val.booleanValue());
        }
        Boolean bl5 = val = overrideProperties.isPreAcknowledge() != null ? overrideProperties.isPreAcknowledge() : this.raProperties.isPreAcknowledge();
        if (val != null) {
            cf.setPreAcknowledge(val.booleanValue());
        }
        Boolean bl6 = val = overrideProperties.isUseGlobalPools() != null ? overrideProperties.isUseGlobalPools() : this.raProperties.isUseGlobalPools();
        if (val != null) {
            cf.setUseGlobalPools(val.booleanValue());
        }
        Boolean bl7 = val = overrideProperties.isCacheLargeMessagesClient() != null ? overrideProperties.isCacheLargeMessagesClient() : this.raProperties.isCacheLargeMessagesClient();
        if (val != null) {
            cf.setCacheLargeMessagesClient(val.booleanValue());
        }
        Boolean bl8 = val = overrideProperties.isCompressLargeMessage() != null ? overrideProperties.isCompressLargeMessage() : this.raProperties.isCompressLargeMessage();
        if (val != null) {
            cf.setCompressLargeMessage(val.booleanValue());
        }
        Boolean bl9 = val = overrideProperties.isFailoverOnInitialConnection() != null ? overrideProperties.isFailoverOnInitialConnection() : this.raProperties.isFailoverOnInitialConnection();
        if (val != null) {
            cf.setFailoverOnInitialConnection(val.booleanValue());
        }
        Integer n = val2 = overrideProperties.getConsumerMaxRate() != null ? overrideProperties.getConsumerMaxRate() : this.raProperties.getConsumerMaxRate();
        if (val2 != null) {
            cf.setConsumerMaxRate(val2.intValue());
        }
        Integer n2 = val2 = overrideProperties.getConsumerWindowSize() != null ? overrideProperties.getConsumerWindowSize() : this.raProperties.getConsumerWindowSize();
        if (val2 != null) {
            cf.setConsumerWindowSize(val2.intValue());
        }
        Integer n3 = val2 = overrideProperties.getDupsOKBatchSize() != null ? overrideProperties.getDupsOKBatchSize() : this.raProperties.getDupsOKBatchSize();
        if (val2 != null) {
            cf.setDupsOKBatchSize(val2.intValue());
        }
        Integer n4 = val2 = overrideProperties.getMinLargeMessageSize() != null ? overrideProperties.getMinLargeMessageSize() : this.raProperties.getMinLargeMessageSize();
        if (val2 != null) {
            cf.setMinLargeMessageSize(val2.intValue());
        }
        Integer n5 = val2 = overrideProperties.getProducerMaxRate() != null ? overrideProperties.getProducerMaxRate() : this.raProperties.getProducerMaxRate();
        if (val2 != null) {
            cf.setProducerMaxRate(val2.intValue());
        }
        Integer n6 = val2 = overrideProperties.getProducerWindowSize() != null ? overrideProperties.getProducerWindowSize() : this.raProperties.getProducerWindowSize();
        if (val2 != null) {
            cf.setProducerWindowSize(val2.intValue());
        }
        Integer n7 = val2 = overrideProperties.getConfirmationWindowSize() != null ? overrideProperties.getConfirmationWindowSize() : this.raProperties.getConfirmationWindowSize();
        if (val2 != null) {
            cf.setConfirmationWindowSize(val2.intValue());
        }
        Integer n8 = val2 = overrideProperties.getReconnectAttempts() != null ? overrideProperties.getReconnectAttempts() : this.raProperties.getReconnectAttempts();
        if (val2 != null) {
            cf.setReconnectAttempts(val2.intValue());
        } else {
            cf.setReconnectAttempts(-1);
        }
        Integer n9 = val2 = overrideProperties.getThreadPoolMaxSize() != null ? overrideProperties.getThreadPoolMaxSize() : this.raProperties.getThreadPoolMaxSize();
        if (val2 != null) {
            cf.setThreadPoolMaxSize(val2.intValue());
        }
        Integer n10 = val2 = overrideProperties.getScheduledThreadPoolMaxSize() != null ? overrideProperties.getScheduledThreadPoolMaxSize() : this.raProperties.getScheduledThreadPoolMaxSize();
        if (val2 != null) {
            cf.setScheduledThreadPoolMaxSize(val2.intValue());
        }
        Integer n11 = val2 = overrideProperties.getTransactionBatchSize() != null ? overrideProperties.getTransactionBatchSize() : this.raProperties.getTransactionBatchSize();
        if (val2 != null) {
            cf.setTransactionBatchSize(val2.intValue());
        }
        Integer n12 = val2 = overrideProperties.getInitialConnectAttempts() != null ? overrideProperties.getInitialConnectAttempts() : this.raProperties.getInitialConnectAttempts();
        if (val2 != null) {
            cf.setInitialConnectAttempts(val2.intValue());
        }
        Integer n13 = val2 = overrideProperties.getInitialMessagePacketSize() != null ? overrideProperties.getInitialMessagePacketSize() : this.raProperties.getInitialMessagePacketSize();
        if (val2 != null) {
            cf.setInitialMessagePacketSize(val2.intValue());
        }
        Long l = val3 = overrideProperties.getClientFailureCheckPeriod() != null ? overrideProperties.getClientFailureCheckPeriod() : this.raProperties.getClientFailureCheckPeriod();
        if (val3 != null) {
            cf.setClientFailureCheckPeriod(val3.longValue());
        }
        Long l2 = val3 = overrideProperties.getCallTimeout() != null ? overrideProperties.getCallTimeout() : this.raProperties.getCallTimeout();
        if (val3 != null) {
            cf.setCallTimeout(val3.longValue());
        }
        Long l3 = val3 = overrideProperties.getCallFailoverTimeout() != null ? overrideProperties.getCallFailoverTimeout() : this.raProperties.getCallFailoverTimeout();
        if (val3 != null) {
            cf.setCallFailoverTimeout(val3.longValue());
        }
        Long l4 = val3 = overrideProperties.getConnectionTTL() != null ? overrideProperties.getConnectionTTL() : this.raProperties.getConnectionTTL();
        if (val3 != null) {
            cf.setConnectionTTL(val3.longValue());
        }
        Long l5 = val3 = overrideProperties.getRetryInterval() != null ? overrideProperties.getRetryInterval() : this.raProperties.getRetryInterval();
        if (val3 != null) {
            cf.setRetryInterval(val3.longValue());
        }
        Long l6 = val3 = overrideProperties.getMaxRetryInterval() != null ? overrideProperties.getMaxRetryInterval() : this.raProperties.getMaxRetryInterval();
        if (val3 != null) {
            cf.setMaxRetryInterval(val3.longValue());
        }
        Double d = val4 = overrideProperties.getRetryIntervalMultiplier() != null ? overrideProperties.getRetryIntervalMultiplier() : this.raProperties.getRetryIntervalMultiplier();
        if (val4 != null) {
            cf.setRetryIntervalMultiplier(val4.doubleValue());
        }
        String string = val5 = overrideProperties.getClientID() != null ? overrideProperties.getClientID() : this.raProperties.getClientID();
        if (val5 != null) {
            cf.setClientID(val5);
        }
        String string2 = val5 = overrideProperties.getConnectionLoadBalancingPolicyClassName() != null ? overrideProperties.getConnectionLoadBalancingPolicyClassName() : this.raProperties.getConnectionLoadBalancingPolicyClassName();
        if (val5 != null) {
            cf.setConnectionLoadBalancingPolicyClassName(val5);
        }
        String string3 = val5 = overrideProperties.getDeserializationBlackList() != null ? overrideProperties.getDeserializationBlackList() : this.raProperties.getDeserializationBlackList();
        if (val5 != null) {
            cf.setDeserializationBlackList(val5);
        }
        String string4 = val5 = overrideProperties.getDeserializationWhiteList() != null ? overrideProperties.getDeserializationWhiteList() : this.raProperties.getDeserializationWhiteList();
        if (val5 != null) {
            cf.setDeserializationWhiteList(val5);
        }
    }

    public void setManagedConnectionFactory(HornetQRAManagedConnectionFactory hornetQRAManagedConnectionFactory) {
        this.managedConnectionFactories.add(hornetQRAManagedConnectionFactory);
    }

    public SensitiveDataCodec<String> getCodecInstance() {
        return this.raProperties.getCodecInstance();
    }
}

