/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.core.client.impl.HornetQXAResource;
import org.hornetq.utils.VersionLoader;
import org.jboss.tm.XAResourceWrapper;

public class HornetQXAResourceWrapper
implements XAResourceWrapper,
org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper,
HornetQXAResource {
    private final XAResource xaResource;
    private final String productName;
    private final String productVersion;
    private final String jndiNameNodeId;

    public HornetQXAResourceWrapper(XAResource xaResource, String jndiName, String nodeId) {
        this.xaResource = xaResource;
        this.productName = "HornetQ";
        this.productVersion = VersionLoader.getVersion().getFullVersion();
        this.jndiNameNodeId = jndiName + " NodeId:" + nodeId;
    }

    public XAResource getResource() {
        return this.xaResource;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getJndiName() {
        return this.jndiNameNodeId;
    }

    public void commit(Xid xid, boolean b) throws XAException {
        this.getResource().commit(xid, b);
    }

    public void end(Xid xid, int i) throws XAException {
        this.getResource().end(xid, i);
    }

    public void forget(Xid xid) throws XAException {
        this.getResource().forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.getResource().getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this.getResource().isSameRM(xaResource);
    }

    public int prepare(Xid xid) throws XAException {
        return this.getResource().prepare(xid);
    }

    public Xid[] recover(int i) throws XAException {
        return this.getResource().recover(i);
    }

    public void rollback(Xid xid) throws XAException {
        this.getResource().rollback(xid);
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        return this.getResource().setTransactionTimeout(i);
    }

    public void start(Xid xid, int i) throws XAException {
        this.getResource().start(xid, i);
    }
}

