/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config;

import java.io.Serializable;
import java.util.List;

public class BridgeConfiguration
implements Serializable {
    private static final long serialVersionUID = -1057244274380572226L;
    private String name;
    private String queueName;
    private String forwardingAddress;
    private String filterString;
    private List<String> staticConnectors;
    private String discoveryGroupName;
    private boolean ha;
    private String transformerClassName;
    private long retryInterval;
    private double retryIntervalMultiplier;
    private int reconnectAttempts;
    private boolean useDuplicateDetection;
    private int confirmationWindowSize;
    private final long clientFailureCheckPeriod;
    private String user;
    private String password;
    private final long connectionTTL;
    private final long maxRetryInterval;
    private final int minLargeMessageSize;
    private long callTimeout = 30000L;

    public BridgeConfiguration(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, int minLargeMessageSize, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, long maxRetryInterval, double retryIntervalMultiplier, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, List<String> staticConnectors, boolean ha, String user, String password) {
        this.name = name;
        this.queueName = queueName;
        this.forwardingAddress = forwardingAddress;
        this.minLargeMessageSize = minLargeMessageSize;
        this.filterString = filterString;
        this.transformerClassName = transformerClassName;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.reconnectAttempts = reconnectAttempts;
        this.useDuplicateDetection = useDuplicateDetection;
        this.confirmationWindowSize = confirmationWindowSize;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.staticConnectors = staticConnectors;
        this.user = user;
        this.password = password;
        this.connectionTTL = connectionTTL;
        this.maxRetryInterval = maxRetryInterval;
        this.ha = ha;
        this.discoveryGroupName = null;
    }

    public BridgeConfiguration(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, int minLargeMessageSize, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, long maxRetryInterval, double retryIntervalMultiplier, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, String discoveryGroupName, boolean ha, String user, String password) {
        this.name = name;
        this.queueName = queueName;
        this.forwardingAddress = forwardingAddress;
        this.filterString = filterString;
        this.transformerClassName = transformerClassName;
        this.minLargeMessageSize = minLargeMessageSize;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.reconnectAttempts = reconnectAttempts;
        this.useDuplicateDetection = useDuplicateDetection;
        this.confirmationWindowSize = confirmationWindowSize;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.staticConnectors = null;
        this.discoveryGroupName = discoveryGroupName;
        this.ha = ha;
        this.user = user;
        this.password = password;
        this.connectionTTL = connectionTTL;
        this.maxRetryInterval = maxRetryInterval;
    }

    public String getName() {
        return this.name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public List<String> getStaticConnectors() {
        return this.staticConnectors;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public boolean isHA() {
        return this.ha;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public boolean isUseDuplicateDetection() {
        return this.useDuplicateDetection;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public void setForwardingAddress(String forwardingAddress) {
        this.forwardingAddress = forwardingAddress;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public void setStaticConnectors(List<String> staticConnectors) {
        this.staticConnectors = staticConnectors;
    }

    public void setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
    }

    public void setHA(boolean ha) {
        this.ha = ha;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.transformerClassName = transformerClassName;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    public void setUseDuplicateDetection(boolean useDuplicateDetection) {
        this.useDuplicateDetection = useDuplicateDetection;
    }

    public void setConfirmationWindowSize(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public void setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.callTimeout ^ this.callTimeout >>> 32);
        result = 31 * result + (int)(this.clientFailureCheckPeriod ^ this.clientFailureCheckPeriod >>> 32);
        result = 31 * result + this.confirmationWindowSize;
        result = 31 * result + (int)(this.connectionTTL ^ this.connectionTTL >>> 32);
        result = 31 * result + (this.discoveryGroupName == null ? 0 : this.discoveryGroupName.hashCode());
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.forwardingAddress == null ? 0 : this.forwardingAddress.hashCode());
        result = 31 * result + (this.ha ? 1231 : 1237);
        result = 31 * result + (int)(this.maxRetryInterval ^ this.maxRetryInterval >>> 32);
        result = 31 * result + this.minLargeMessageSize;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + this.reconnectAttempts;
        result = 31 * result + (int)(this.retryInterval ^ this.retryInterval >>> 32);
        long temp = Double.doubleToLongBits(this.retryIntervalMultiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.staticConnectors == null ? 0 : ((Object)this.staticConnectors).hashCode());
        result = 31 * result + (this.transformerClassName == null ? 0 : this.transformerClassName.hashCode());
        result = 31 * result + (this.useDuplicateDetection ? 1231 : 1237);
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgeConfiguration other = (BridgeConfiguration)obj;
        if (this.callTimeout != other.callTimeout) {
            return false;
        }
        if (this.clientFailureCheckPeriod != other.clientFailureCheckPeriod) {
            return false;
        }
        if (this.confirmationWindowSize != other.confirmationWindowSize) {
            return false;
        }
        if (this.connectionTTL != other.connectionTTL) {
            return false;
        }
        if (this.discoveryGroupName == null ? other.discoveryGroupName != null : !this.discoveryGroupName.equals(other.discoveryGroupName)) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.forwardingAddress == null ? other.forwardingAddress != null : !this.forwardingAddress.equals(other.forwardingAddress)) {
            return false;
        }
        if (this.ha != other.ha) {
            return false;
        }
        if (this.maxRetryInterval != other.maxRetryInterval) {
            return false;
        }
        if (this.minLargeMessageSize != other.minLargeMessageSize) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        if (this.reconnectAttempts != other.reconnectAttempts) {
            return false;
        }
        if (this.retryInterval != other.retryInterval) {
            return false;
        }
        if (Double.doubleToLongBits(this.retryIntervalMultiplier) != Double.doubleToLongBits(other.retryIntervalMultiplier)) {
            return false;
        }
        if (this.staticConnectors == null ? other.staticConnectors != null : !((Object)this.staticConnectors).equals(other.staticConnectors)) {
            return false;
        }
        if (this.transformerClassName == null ? other.transformerClassName != null : !this.transformerClassName.equals(other.transformerClassName)) {
            return false;
        }
        if (this.useDuplicateDetection != other.useDuplicateDetection) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

