/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.Pair;
import org.hornetq.core.deployers.Deployer;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.server.HornetQServerLogger;

public class FileDeploymentManager
implements Runnable,
DeploymentManager {
    private final List<Deployer> deployers = new ArrayList<Deployer>();
    private final Map<Pair<URI, Deployer>, DeployInfo> deployed = new HashMap<Pair<URI, Deployer>, DeployInfo>();
    private ScheduledExecutorService scheduler;
    private boolean started;
    private final long period;
    private ScheduledFuture<?> future;

    public FileDeploymentManager(long period) {
        this.period = period;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.future = this.scheduler.scheduleWithFixedDelay(this, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.scheduler.shutdown();
        this.scheduler = null;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void registerDeployer(Deployer deployer) throws Exception {
        if (!this.deployers.contains(deployer)) {
            String[] filenames;
            this.deployers.add(deployer);
            for (String filename : filenames = deployer.getConfigFileNames()) {
                HornetQServerLogger.LOGGER.debug("the filename is " + filename);
                Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(filename);
                while (urls.hasMoreElements()) {
                    URI uri = urls.nextElement().toURI();
                    HornetQServerLogger.LOGGER.debug("Got URI " + uri);
                    try {
                        HornetQServerLogger.LOGGER.debug("Deploying " + uri + " for " + deployer.getClass().getSimpleName());
                        deployer.deploy(uri);
                    }
                    catch (Exception e) {
                        HornetQServerLogger.LOGGER.errorDeployingURI(e, uri);
                    }
                    Pair pair = new Pair((Object)uri, (Object)deployer);
                    this.deployed.put((Pair<URI, Deployer>)pair, new DeployInfo(deployer, this.getFileFromURI(uri).lastModified()));
                }
            }
        }
    }

    @Override
    public synchronized void unregisterDeployer(Deployer deployer) throws Exception {
        if (this.deployers.remove(deployer)) {
            String[] filenames;
            for (String filename : filenames = deployer.getConfigFileNames()) {
                Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(filename);
                while (urls.hasMoreElements()) {
                    URI url = urls.nextElement().toURI();
                    Pair pair = new Pair((Object)url, (Object)deployer);
                    this.deployed.remove(pair);
                }
            }
        }
    }

    private File getFileFromURI(URI uri) throws MalformedURLException, UnsupportedEncodingException {
        return new File(URLDecoder.decode(uri.toURL().getFile(), "UTF-8"));
    }

    @Override
    public synchronized void run() {
        if (!this.started) {
            return;
        }
        try {
            for (Deployer deployer : this.deployers) {
                String[] stringArray;
                for (String filename : stringArray = deployer.getConfigFileNames()) {
                    Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(filename);
                    while (urls.hasMoreElements()) {
                        URI uri;
                        URL url = urls.nextElement();
                        try {
                            uri = url.toURI();
                        }
                        catch (URISyntaxException e) {
                            HornetQServerLogger.LOGGER.errorDeployingURI(e);
                            continue;
                        }
                        Pair pair = new Pair((Object)uri, (Object)deployer);
                        DeployInfo info = this.deployed.get(pair);
                        long newLastModified = this.getFileFromURI(uri).lastModified();
                        if (info == null) {
                            try {
                                deployer.deploy(uri);
                                this.deployed.put((Pair<URI, Deployer>)pair, new DeployInfo(deployer, this.getFileFromURI(uri).lastModified()));
                            }
                            catch (Exception e) {
                                HornetQServerLogger.LOGGER.errorDeployingURI(e, uri);
                            }
                            continue;
                        }
                        if (newLastModified <= info.lastModified) continue;
                        try {
                            deployer.redeploy(uri);
                            this.deployed.put((Pair<URI, Deployer>)pair, new DeployInfo(deployer, this.getFileFromURI(uri).lastModified()));
                        }
                        catch (Exception e) {
                            HornetQServerLogger.LOGGER.errorDeployingURI(e, uri);
                        }
                    }
                }
            }
            ArrayList<Pair<URI, Deployer>> toRemove = new ArrayList<Pair<URI, Deployer>>();
            for (Map.Entry<Pair<URI, Deployer>, DeployInfo> entry : this.deployed.entrySet()) {
                Pair<URI, Deployer> pair = entry.getKey();
                try {
                    if (this.fileExists((URI)pair.getA())) continue;
                    Deployer deployer = entry.getValue().deployer;
                    HornetQServerLogger.LOGGER.debug("Undeploying " + deployer + " with url " + pair.getA());
                    deployer.undeploy((URI)pair.getA());
                    toRemove.add(pair);
                }
                catch (URISyntaxException e) {
                    HornetQServerLogger.LOGGER.errorUnDeployingURI(e, (URI)pair.getA());
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.errorUnDeployingURI(e, (URI)pair.getA());
                }
            }
            for (Pair pair : toRemove) {
                this.deployed.remove(pair);
            }
        }
        catch (IOException e) {
            HornetQServerLogger.LOGGER.errorScanningURLs(e);
        }
    }

    public synchronized List<Deployer> getDeployers() {
        return this.deployers;
    }

    public synchronized Map<Pair<URI, Deployer>, DeployInfo> getDeployed() {
        return this.deployed;
    }

    private boolean fileExists(URI resourceURI) throws URISyntaxException {
        try {
            File f = this.getFileFromURI(resourceURI);
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(f.getName());
            while (resources.hasMoreElements()) {
                URI url = resources.nextElement().toURI();
                if (!url.equals(resourceURI)) continue;
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public static class DeployInfo {
        public Deployer deployer;
        public long lastModified;

        DeployInfo(Deployer deployer, long lastModified) {
            this.deployer = deployer;
            this.lastModified = lastModified;
        }
    }
}

