/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.deployers.Deployer;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmlDeployer
implements Deployer {
    protected static final String NAME_ATTR = "name";
    private final Map<URI, Map<String, Node>> configuration = new HashMap<URI, Map<String, Node>>();
    private final DeploymentManager deploymentManager;
    private boolean started;
    private String[] configFileNames;

    public XmlDeployer(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
        this.configFileNames = this.getDefaultConfigFileNames();
    }

    public synchronized void addToConfiguration(URI url, String name, Node e) {
        Map<String, Node> map = this.configuration.get(url);
        if (map == null) {
            map = new HashMap<String, Node>();
            this.configuration.put(url, map);
        }
        map.put(name, e);
    }

    @Override
    public synchronized void redeploy(URI url) throws Exception {
        String[] elements;
        Element e = this.getRootElement(url);
        ArrayList<String> added = new ArrayList<String>();
        for (String element : elements = this.getElementTagName()) {
            NodeList children = e.getElementsByTagName(element);
            for (int i = 0; i < children.getLength(); ++i) {
                String name;
                Node node = children.item(i);
                try {
                    name = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
                }
                catch (NullPointerException npe) {
                    throw new HornetQException("Could not find " + this.getKeyAttribute() + " in " + node.getAttributes());
                }
                added.add(name);
                Map<String, Node> map = this.configuration.get(url);
                if (map == null || map.get(name) == null) {
                    this.deploy(node);
                    continue;
                }
                if (!this.hasNodeChanged(url, node, name)) continue;
                this.undeploy(node);
                this.deploy(node);
                this.addToConfiguration(url, name, node);
            }
        }
        if (this.configuration.get(url) != null) {
            Set<String> keys = this.configuration.get(url).keySet();
            ArrayList<String> removed = new ArrayList<String>();
            for (String key : keys) {
                if (added.contains(key)) continue;
                this.undeploy(this.configuration.get(url).get(key));
                removed.add(key);
            }
            for (String s : removed) {
                this.configuration.get(url).remove(s);
            }
        }
    }

    @Override
    public synchronized void undeploy(URI uri) throws Exception {
        Set<String> keys = this.configuration.get(uri).keySet();
        for (String key : keys) {
            this.undeploy(this.configuration.get(uri).get(key));
        }
        this.configuration.remove(uri);
    }

    @Override
    public synchronized void deploy(URI url) throws Exception {
        String[] elements;
        Element e = this.getRootElement(url);
        this.validate(e);
        Map<String, Node> map = this.configuration.get(url);
        if (map == null) {
            map = new HashMap<String, Node>();
            this.configuration.put(url, map);
        }
        for (String element : elements = this.getElementTagName()) {
            NodeList children = e.getElementsByTagName(element);
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                String keyAttr = this.getKeyAttribute();
                String name = null;
                if (keyAttr != null) {
                    Node keyNode = node.getAttributes().getNamedItem(this.getKeyAttribute());
                    if (keyNode == null) {
                        HornetQServerLogger.LOGGER.keyAttributeMissing(node);
                        continue;
                    }
                    name = keyNode.getNodeValue();
                }
                try {
                    this.deploy(node);
                }
                catch (Exception e1) {
                    HornetQServerLogger.LOGGER.unableToDeployNode(e1, node);
                    continue;
                }
                this.addToConfiguration(url, name, node);
            }
        }
    }

    public String getKeyAttribute() {
        return NAME_ATTR;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.deploymentManager.registerDeployer(this);
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        Collection<Map<String, Node>> urls = this.configuration.values();
        for (Map<String, Node> hashMap : urls) {
            for (Node node : hashMap.values()) {
                try {
                    this.undeploy(node);
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.problemUndeployingNode(e, node);
                }
            }
        }
        this.deploymentManager.unregisterDeployer(this);
        this.started = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public String[] getConfigFileNames() {
        return this.configFileNames;
    }

    public void setConfigFileNames(String[] configFileNames) {
        this.configFileNames = configFileNames;
    }

    public abstract String[] getElementTagName();

    public abstract String[] getDefaultConfigFileNames();

    public abstract void deploy(Node var1) throws Exception;

    public abstract void validate(Node var1) throws Exception;

    public abstract void undeploy(Node var1) throws Exception;

    protected Element getRootElement(URI url) throws Exception {
        InputStreamReader reader = new InputStreamReader(url.toURL().openStream());
        String xml = XMLUtil.readerToString((Reader)reader);
        xml = XMLUtil.replaceSystemProps((String)xml);
        return XMLUtil.stringToElement((String)xml);
    }

    private boolean hasNodeChanged(URI url, Node child, String name) {
        String origTextContent;
        String newTextContent = child.getTextContent();
        return !newTextContent.equals(origTextContent = this.configuration.get(url).get(name).getTextContent());
    }
}

