/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.group.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.group.impl.Proposal;
import org.hornetq.core.server.group.impl.Response;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.utils.TypedProperties;

public final class LocalGroupingHandler
implements GroupingHandler {
    private final ConcurrentHashMap<SimpleString, GroupBinding> map = new ConcurrentHashMap();
    private final ConcurrentHashMap<SimpleString, List<GroupBinding>> groupMap = new ConcurrentHashMap();
    private final SimpleString name;
    private final ManagementService managementService;
    private final SimpleString address;
    private final StorageManager storageManager;
    private final int timeout;

    public LocalGroupingHandler(ManagementService managementService, SimpleString name, SimpleString address, StorageManager storageManager, int timeout) {
        this.managementService = managementService;
        this.name = name;
        this.address = address;
        this.storageManager = storageManager;
        this.timeout = timeout;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response propose(Proposal proposal) throws Exception {
        OperationContext originalCtx = this.storageManager.getContext();
        try {
            this.storageManager.setContext(this.storageManager.newSingleThreadContext());
            if (proposal.getClusterName() == null) {
                GroupBinding original = this.map.get(proposal.getGroupId());
                Response response = original == null ? null : new Response(proposal.getGroupId(), original.getClusterName());
                return response;
            }
            GroupBinding groupBinding = new GroupBinding(proposal.getGroupId(), proposal.getClusterName());
            if (this.map.putIfAbsent(groupBinding.getGroupId(), groupBinding) == null) {
                groupBinding.setId(this.storageManager.generateUniqueID());
                List<GroupBinding> newList = new ArrayList<GroupBinding>();
                List oldList = this.groupMap.putIfAbsent(groupBinding.getClusterName(), newList);
                if (oldList != null) {
                    newList = oldList;
                }
                newList.add(groupBinding);
                this.storageManager.addGrouping(groupBinding);
                if (!this.storageManager.waitOnOperations(this.timeout)) {
                    throw HornetQMessageBundle.BUNDLE.ioTimeout();
                }
                Response response = new Response(groupBinding.getGroupId(), groupBinding.getClusterName());
                return response;
            }
            groupBinding = this.map.get(proposal.getGroupId());
            Response response = new Response(groupBinding.getGroupId(), proposal.getClusterName(), groupBinding.getClusterName());
            return response;
        }
        finally {
            this.storageManager.setContext(originalCtx);
        }
    }

    @Override
    public void proposed(Response response) throws Exception {
    }

    @Override
    public void send(Response response, int distance) throws Exception {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, response.getGroupId());
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, response.getClusterName());
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_ALT_VALUE, response.getAlternativeClusterName());
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.address);
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance);
        Notification notification = new Notification(null, NotificationType.PROPOSAL_RESPONSE, props);
        this.managementService.sendNotification(notification);
    }

    @Override
    public Response receive(Proposal proposal, int distance) throws Exception {
        HornetQServerLogger.LOGGER.trace("received proposal " + proposal);
        return this.propose(proposal);
    }

    @Override
    public void addGroupBinding(GroupBinding groupBinding) {
        this.map.put(groupBinding.getGroupId(), groupBinding);
        List<GroupBinding> newList = new ArrayList<GroupBinding>();
        List oldList = this.groupMap.putIfAbsent(groupBinding.getClusterName(), newList);
        if (oldList != null) {
            newList = oldList;
        }
        newList.add(groupBinding);
    }

    @Override
    public Response getProposal(SimpleString fullID) {
        GroupBinding original = this.map.get(fullID);
        return original == null ? null : new Response(fullID, original.getClusterName());
    }

    public void onNotification(Notification notification) {
        SimpleString clusterName;
        List<GroupBinding> list;
        if (notification.getType() == NotificationType.BINDING_REMOVED && (list = this.groupMap.remove(clusterName = notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME))) != null) {
            for (GroupBinding val : list) {
                if (val == null) continue;
                this.map.remove(val.getGroupId());
                try {
                    this.storageManager.deleteGrouping(val);
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.unableToDeleteGroupBindings(e, val.getGroupId());
                }
            }
        }
    }
}

