/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config;

import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static ClusterConnectionConfiguration getReplicationClusterConfiguration(Configuration conf) throws HornetQIllegalStateException {
        String replicationCluster = conf.getReplicationClustername();
        if (replicationCluster == null || replicationCluster.isEmpty()) {
            return conf.getClusterConfigurations().get(0);
        }
        for (ClusterConnectionConfiguration clusterConf : conf.getClusterConfigurations()) {
            if (!replicationCluster.equals(clusterConf.getName())) continue;
            return clusterConf;
        }
        throw new HornetQIllegalStateException("Missing cluster-configuration for replication-cluster-name '" + replicationCluster + "'.");
    }
}

