/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.spring;

import org.hornetq.spi.core.naming.BindingRegistry;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public class SpringBindingRegistry
implements BindingRegistry {
    private ConfigurableBeanFactory factory;

    public SpringBindingRegistry(ConfigurableBeanFactory factory) {
        this.factory = factory;
    }

    public Object lookup(String name) {
        try {
            return this.factory.getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public boolean bind(String name, Object obj) {
        this.factory.registerSingleton(name, obj);
        return true;
    }

    public void unbind(String name) {
    }

    public void close() {
    }

    public Object getContext() {
        return this.factory;
    }

    public void setContext(Object ctx) {
        this.factory = (ConfigurableBeanFactory)ctx;
    }
}

