/*
 * JGrass - Free Open Source Java GIS http://www.jgrass.org 
 * (C) HydroloGIS - www.hydrologis.com 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option) any
 * later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.hortonmachine.gears.i18n;

import static org.hortonmachine.gears.libs.modules.HMConstants.FEATUREREADER;
import static org.hortonmachine.gears.libs.modules.HMConstants.FEATUREWRITER;
import static org.hortonmachine.gears.libs.modules.HMConstants.GENERICREADER;
import static org.hortonmachine.gears.libs.modules.HMConstants.GENERICWRITER;
import static org.hortonmachine.gears.libs.modules.HMConstants.GRIDGEOMETRYREADER;
import static org.hortonmachine.gears.libs.modules.HMConstants.HASHMAP_READER;
import static org.hortonmachine.gears.libs.modules.HMConstants.HASHMAP_WRITER;
import static org.hortonmachine.gears.libs.modules.HMConstants.LIST_READER;
import static org.hortonmachine.gears.libs.modules.HMConstants.LIST_WRITER;
import static org.hortonmachine.gears.libs.modules.HMConstants.MATRIXREADER;
import static org.hortonmachine.gears.libs.modules.HMConstants.OTHER;
import static org.hortonmachine.gears.libs.modules.HMConstants.RASTERPROCESSING;
import static org.hortonmachine.gears.libs.modules.HMConstants.RASTERREADER;
import static org.hortonmachine.gears.libs.modules.HMConstants.RASTERWRITER;
import static org.hortonmachine.gears.libs.modules.HMConstants.VECTORPROCESSING;
/**
 * Messages for the JGrassGears.
 * 
 * @author Andrea Antonello (www.hydrologis.com)
 */
public class GearsMessages {
    public static final String OMSHYDRO_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSHYDRO_AUTHORNAMES = "Andrea Antonello, Silvia Franceschi";
    public static final String OMSHYDRO_AUTHORCONTACTS = "www.hydrologis.com";
    public static final int OMSHYDRO_DRAFT = 10;
    public static final int OMSHYDRO_CERTIFIED = 40;
    
    public static final String GENERIC_P_NORTH_DESCRIPTION = "The north bound of the region to consider";
    public static final String GENERIC_P_SOUTH_DESCRIPTION = "The south bound of the region to consider";
    public static final String GENERIC_P_WEST_DESCRIPTION = "The west bound of the region to consider";
    public static final String GENERIC_P_EAST_DESCRIPTION = "The east bound of the region to consider";
    public static final String GENERIC_P_ROWS_DESCRIPTION = "The rows of the region to consider";
    public static final String GENERIC_P_COLS_DESCRIPTION = "The cols of the region to consider";
    public static final String GENERIC_P_X_RES_DESCRIPTION = "The requested resolution in x.";
    public static final String GENERIC_P_Y_RES_DESCRIPTION = "The requested resolution in y.";

    public static final String OMSLINESMOOTHERMCMASTER_DESCRIPTION = "The McMasters Sliding Averaging smoothing algorithm.";
    public static final String OMSLINESMOOTHERMCMASTER_DOCUMENTATION = "OmsLineSmootherMcMaster.html";
    public static final String OMSLINESMOOTHERMCMASTER_KEYWORDS = "Smoothing, Vector, OmsLineSmootherJaitools";
    public static final String OMSLINESMOOTHERMCMASTER_LABEL = VECTORPROCESSING;
    public static final String OMSLINESMOOTHERMCMASTER_NAME = "linesmoother";
    public static final int OMSLINESMOOTHERMCMASTER_STATUS = 40;
    public static final String OMSLINESMOOTHERMCMASTER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSLINESMOOTHERMCMASTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSLINESMOOTHERMCMASTER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSLINESMOOTHERMCMASTER_IN_VECTOR_DESCRIPTION = "The vector containing the lines to be smoothed.";
    public static final String OMSLINESMOOTHERMCMASTER_P_LOOK_AHEAD_DESCRIPTION = "The number of points to consider in every smoothing step (default = 7).";
    public static final String OMSLINESMOOTHERMCMASTER_P_LIMIT_DESCRIPTION = "Minimum length for a line to be smoothed.";
    public static final String OMSLINESMOOTHERMCMASTER_P_SLIDE_DESCRIPTION = "Slide parameter.";
    public static final String OMSLINESMOOTHERMCMASTER_P_DENSIFY_DESCRIPTION = "Densifier interval.";
    public static final String OMSLINESMOOTHERMCMASTER_P_SIMPLIFY_DESCRIPTION = "Simplifier tollerance.";
    public static final String OMSLINESMOOTHERMCMASTER_OUT_VECTOR_DESCRIPTION = "The vector with smoothed features.";

    public static final String OMSVECTORCONVERTER_DESCRIPTION = "A simple middleman module to do feature conversion.";
    public static final String OMSVECTORCONVERTER_DOCUMENTATION = "";
    public static final String OMSVECTORCONVERTER_KEYWORDS = "IO, Feature, Vector, Convert";
    public static final String OMSVECTORCONVERTER_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORCONVERTER_NAME = "vconvert";
    public static final int OMSVECTORCONVERTER_STATUS = 5;
    public static final String OMSVECTORCONVERTER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSVECTORCONVERTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORCONVERTER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSVECTORCONVERTER_UI = "hide";
    public static final String OMSVECTORCONVERTER_IN_GEODATA_DESCRIPTION = "The input features.";
    public static final String OMSVECTORCONVERTER_OUT_GEODATA_DESCRIPTION = "The output features.";

    public static final String OMSTIMESERIESITERATORWRITER_DESCRIPTION = "Utility class for writing a id2values map to a OMS formatted csv file.";
    public static final String OMSTIMESERIESITERATORWRITER_DOCUMENTATION = "OmsTimeSeriesIteratorWriter.html";
    public static final String OMSTIMESERIESITERATORWRITER_KEYWORDS = "IO, Writing";
    public static final String OMSTIMESERIESITERATORWRITER_LABEL = HASHMAP_WRITER;
    public static final String OMSTIMESERIESITERATORWRITER_NAME = "tsitwriter";
    public static final int OMSTIMESERIESITERATORWRITER_STATUS = 40;
    public static final String OMSTIMESERIESITERATORWRITER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSTIMESERIESITERATORWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSTIMESERIESITERATORWRITER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSTIMESERIESITERATORWRITER_FILE_DESCRIPTION = "The csv file to write to.";
    public static final String OMSTIMESERIESITERATORWRITER_IN_TABLENAME_DESCRIPTION = "The table name.";
    public static final String OMSTIMESERIESITERATORWRITER_IN_DATA_DESCRIPTION = "The hashmap of ids and values to write.";
    public static final String OMSTIMESERIESITERATORWRITER_T_START_DESCRIPTION = "The start date. If available time is added as first column.";
    public static final String OMSTIMESERIESITERATORWRITER_T_TIMESTEP_DESCRIPTION = "The timestep. If available time is added as first column.";
    public static final String OMSTIMESERIESITERATORWRITER_FILE_NOVALUE_DESCRIPTION = "The novalue to use in the file (default is -9999.0).";

    public static final String OMSLINESRASTERIZER_DESCRIPTION = "Module to convert vector lines to raster.";
    public static final String OMSLINESRASTERIZER_DOCUMENTATION = "";
    public static final String OMSLINESRASTERIZER_KEYWORDS = "Raster, Vector, Lines";
    public static final String OMSLINESRASTERIZER_LABEL = RASTERPROCESSING;
    public static final String OMSLINESRASTERIZER_NAME = "rasterizelines";
    public static final int OMSLINESRASTERIZER_STATUS = 5;
    public static final String OMSLINESRASTERIZER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSLINESRASTERIZER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSLINESRASTERIZER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSLINESRASTERIZER_IN_VECTOR_DESCRIPTION = "The lines vector.";
    public static final String OMSLINESRASTERIZER_F_CAT_DESCRIPTION = "The optional field of the vector to take the category from.";
    public static final String OMSLINESRASTERIZER_P_CAT_DESCRIPTION = "The category to use if no field was set.";
    public static final String OMSLINESRASTERIZER_P_NORTH_DESCRIPTION = "The north bound of the region to consider";
    public static final String OMSLINESRASTERIZER_P_SOUTH_DESCRIPTION = "The south bound of the region to consider";
    public static final String OMSLINESRASTERIZER_P_WEST_DESCRIPTION = "The west bound of the region to consider";
    public static final String OMSLINESRASTERIZER_P_EAST_DESCRIPTION = "The east bound of the region to consider";
    public static final String OMSLINESRASTERIZER_P_ROWS_DESCRIPTION = "The rows of the region to consider";
    public static final String OMSLINESRASTERIZER_P_COLS_DESCRIPTION = "The cols of the region to consider";
    public static final String OMSLINESRASTERIZER_OUT_RASTER_DESCRIPTION = "The output raster.";

    public static final String OMSCONTOURLINESLABELER_DESCRIPTION = "Generates a layer of point features with a given label text and angle, following reference lines intersecting them with a layer of countourlines.";
    public static final String OMSCONTOURLINESLABELER_DOCUMENTATION = "";
    public static final String OMSCONTOURLINESLABELER_KEYWORDS = "Contourlines, Vector";
    public static final String OMSCONTOURLINESLABELER_LABEL = VECTORPROCESSING;
    public static final String OMSCONTOURLINESLABELER_NAME = "contourlineslabeler";
    public static final int OMSCONTOURLINESLABELER_STATUS = 5;
    public static final String OMSCONTOURLINESLABELER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSCONTOURLINESLABELER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSCONTOURLINESLABELER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSCONTOURLINESLABELER_IN_CONTOUR_DESCRIPTION = "The contour lines.";
    public static final String OMSCONTOURLINESLABELER_F_ELEVATION_DESCRIPTION = "Field name of the contour elevation";
    public static final String OMSCONTOURLINESLABELER_INLINES_DESCRIPTION = "The lines to intersect with the contours to generate label points.";
    public static final String OMSCONTOURLINESLABELER_BUFFER_DESCRIPTION = "The buffer to consider for every line.";
    public static final String OMSCONTOURLINESLABELER_OUTPOINTS_DESCRIPTION = "The labeled point layer.";

    public static final String EXIFREADER_DESCRIPTION = "Utility class for reading exif tags in jpegs.";
    public static final String EXIFREADER_DOCUMENTATION = "";
    public static final String EXIFREADER_KEYWORDS = "IO, Jpeg, Exif, Reading";
    public static final String EXIFREADER_LABEL = GENERICREADER;
    public static final String EXIFREADER_NAME = "exifreader";
    public static final int EXIFREADER_STATUS = 10;
    public static final String EXIFREADER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String EXIFREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String EXIFREADER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String EXIFREADER_FILE_DESCRIPTION = "The jpeg file.";
    public static final String EXIFREADER_OUTTAGS_DESCRIPTION = "The read exif tags.";

    public static final String OMSGRASSLEGACYREADER_DESCRIPTION = "Legacy class for reading grass data the old way.";
    public static final String OMSGRASSLEGACYREADER_DOCUMENTATION = "";
    public static final String OMSGRASSLEGACYREADER_KEYWORDS = "IO, Grass, Raster, Reading";
    public static final String OMSGRASSLEGACYREADER_LABEL = RASTERREADER;
    public static final String OMSGRASSLEGACYREADER_NAME = "grasslegacyreader";
    public static final int OMSGRASSLEGACYREADER_STATUS = 40;
    public static final String OMSGRASSLEGACYREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSGRASSLEGACYREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSGRASSLEGACYREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSGRASSLEGACYREADER_UI = "hide";
    public static final String OMSGRASSLEGACYREADER_FILE_DESCRIPTION = "The file to the map to be read (the cell file).";
    public static final String OMSGRASSLEGACYREADER_DOACTIVE_DESCRIPTION = "Flag that defines if the map should be read as a whole (false) or on the active region (true and default).";
    public static final String OMSGRASSLEGACYREADER_IN_WINDOW_DESCRIPTION = "The region to read.";
    public static final String OMSGRASSLEGACYREADER_OUT_GC_DESCRIPTION = "The read output map as limited coverage version.";
    public static final String OMSGRASSLEGACYREADER_GEO_DATA_DESCRIPTION = "The read output map data.";

    public static final String OMSMATRIXCHARTER_DESCRIPTION = "Utility class for charting matrix data.";
    public static final String OMSMATRIXCHARTER_DOCUMENTATION = "";
    public static final String OMSMATRIXCHARTER_KEYWORDS = "Viewer, UI, Chart";
    public static final String OMSMATRIXCHARTER_LABEL = OTHER;
    public static final String OMSMATRIXCHARTER_NAME = "matrixcharter";
    public static final int OMSMATRIXCHARTER_STATUS = 5;
    public static final String OMSMATRIXCHARTER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSMATRIXCHARTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSMATRIXCHARTER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSMATRIXCHARTER_UI = "hide";
    public static final String OMSMATRIXCHARTER_IN_DATA_DESCRIPTION = "The matrix to chart.";
    public static final String OMSMATRIXCHARTER_IN_TITLE_DESCRIPTION = "The data title.";
    public static final String OMSMATRIXCHARTER_IN_SUBTITLE_DESCRIPTION = "The subtitle.";
    public static final String OMSMATRIXCHARTER_IN_SERIES_DESCRIPTION = "The data series names.";
    public static final String OMSMATRIXCHARTER_IN_COLORS_DESCRIPTION = "The optional data series colors. Format is rbg triplets delimited by semicolon: ex. 0,0,255;0,255,0;255,0,0. The colors have to be the same number as the series.";
    public static final String OMSMATRIXCHARTER_IN_LABELS_DESCRIPTION = "The axis labels (x, y1, y2, ...).";
    public static final String OMSMATRIXCHARTER_IN_FORMATS_DESCRIPTION = "The data formats (dates and numeric formatting patterns).";
    public static final String OMSMATRIXCHARTER_IN_TYPES_DESCRIPTION = "The data types (dates or numerics like double, int).";
    public static final String OMSMATRIXCHARTER_P_TYPE_DESCRIPTION = "Chart type: 0 = line, 1 = histogram (default is 0).";
    public static final String OMSMATRIXCHARTER_DO_CHART_DESCRIPTION = "Chart the data.";
    public static final String OMSMATRIXCHARTER_DO_DUMP_DESCRIPTION = "Dump the chart to disk.";
    public static final String OMSMATRIXCHARTER_DO_LEGEND_DESCRIPTION = "Show the legend.";
    public static final String OMSMATRIXCHARTER_DO_POINTS_DESCRIPTION = "Show shapes in line charts.";
    public static final String OMSMATRIXCHARTER_DO_CUMULATE_DESCRIPTION = "Cumulate data.";
    public static final String OMSMATRIXCHARTER_DO_NORMALIZE_DESCRIPTION = "Normalize data.";
    public static final String OMSMATRIXCHARTER_P_WIDTH_DESCRIPTION = "Chart image width (in case of doDump=true, defaults to 800 px).";
    public static final String OMSMATRIXCHARTER_P_HEIGHT_DESCRIPTION = "Chart image height (in case of doDump=true, defaults to 600 px).";
    public static final String OMSMATRIXCHARTER_IN_CHARTPATH_DESCRIPTION = "Chart dump path (in case of doDump=true).";

    public static final String OMSPOINTSVECTORIZER_DESCRIPTION = "Module that creates a points vector layer from raster values.";
    public static final String OMSPOINTSVECTORIZER_DOCUMENTATION = "";
    public static final String OMSPOINTSVECTORIZER_KEYWORDS = "Raster, Vector";
    public static final String OMSPOINTSVECTORIZER_LABEL = VECTORPROCESSING;
    public static final String OMSPOINTSVECTORIZER_NAME = "pvectorizer";
    public static final int OMSPOINTSVECTORIZER_STATUS = 5;
    public static final String OMSPOINTSVECTORIZER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSPOINTSVECTORIZER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSPOINTSVECTORIZER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSPOINTSVECTORIZER_IN_RASTER_DESCRIPTION = "The raster that has to be converted.";
    public static final String OMSPOINTSVECTORIZER_F_DEFAULT_DESCRIPTION = "The field name to use as a name for the raster value in the vector.";
    public static final String OMSPOINTSVECTORIZER_OUT_VECTOR_DESCRIPTION = "The extracted vector.";

    public static final String OMSLINESVECTORIZER_DESCRIPTION = "Module that creates a lines vector layer from a thinned raster.";
    public static final String OMSLINESVECTORIZER_DOCUMENTATION = "";
    public static final String OMSLINESVECTORIZER_KEYWORDS = "Raster, Vector";
    public static final String OMSLINESVECTORIZER_LABEL = VECTORPROCESSING;
    public static final String OMSLINESVECTORIZER_NAME = "lvectorizer";
    public static final int OMSLINESVECTORIZER_STATUS = 5;
    public static final String OMSLINESVECTORIZER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSLINESVECTORIZER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSLINESVECTORIZER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSLINESVECTORIZER_IN_RASTER_DESCRIPTION = "The raster that has to be converted.";
    public static final String OMSLINESVECTORIZER_F_DEFAULT_DESCRIPTION = "The field name to use as a name for the raster value in the vector.";
    public static final String OMSLINESVECTORIZER_OUT_VECTOR_DESCRIPTION = "The extracted vector.";

    public static final String OMSRASTERWRITER_DESCRIPTION = "Raster writer module.";
    public static final String OMSRASTERWRITER_DOCUMENTATION = "OmsRasterWriter.html";
    public static final String OMSRASTERWRITER_KEYWORDS = "IO, Grass, Coverage, Raster, Writing";
    public static final String OMSRASTERWRITER_LABEL = RASTERWRITER;
    public static final String OMSRASTERWRITER_NAME = "rasterwriter";
    public static final int OMSRASTERWRITER_STATUS = 40;
    public static final String OMSRASTERWRITER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERWRITER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERWRITER_IN_RASTER_DESCRIPTION = "The raster map to write.";
    public static final String OMSRASTERWRITER_FILE_DESCRIPTION = "The file to write the raster to with extension (supported are: asc, tiff, grass).";

    public static final String OMSGROUNDCONTROLPOINTS2WORLD_DESCRIPTION = "A module to calculate world file coefficients from set of GCPs";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_DOCUMENTATION = "";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_KEYWORDS = "gcp, wld";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_LABEL = OTHER;
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_NAME = "gcps2wld";
    public static final int OMSGROUNDCONTROLPOINTS2WORLD_STATUS = 5;
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_AUTHORNAMES = "Jan Jezek";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_AUTHORCONTACTS = "http://code.google.com/p/oldmapsonline/";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_IN_FILE_DESCRIPTION = "The file containing the ground control points.";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_P_SKEW_DESCRIPTION = "pSkew";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_P_PHIX_DESCRIPTION = "pPhix";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_P_PHIY_DESCRIPTION = "pPhiy";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_P_T_X_DESCRIPTION = "pTx";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_P_T_Y_DESCRIPTION = "pTy";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_P_S_X_DESCRIPTION = "pSx";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_P_S_Y_DESCRIPTION = "pSy";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_DO_SIMILAR_DESCRIPTION = "doSimilar";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_SCALE_Y_DESCRIPTION = "outScaley";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_SCALE_X_DESCRIPTION = "outScalex";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_SHEAR_Y_DESCRIPTION = "outSheary";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_SHEAR_X_DESCRIPTION = "outShearx";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_TRANSLATE_X_DESCRIPTION = "outTranslatex";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_TRANSLATE_Y_DESCRIPTION = "outTranslatey";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_ERR_MEAN_DESCRIPTION = "outErrmean";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_ERR_RMS_DESCRIPTION = "outErrrms";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_ERR_MAX_DESCRIPTION = "outErrmax";
    public static final String OMSGROUNDCONTROLPOINTS2WORLD_OUT_ERR_MIN_DESCRIPTION = "outErrmin";

    public static final String OMSWINDOWSAMPLER_DESCRIPTION = "Module to do coverage downsampling on defined windows.";
    public static final String OMSWINDOWSAMPLER_DOCUMENTATION = "";
    public static final String OMSWINDOWSAMPLER_KEYWORDS = "IO, Coverage, Raster, Downsampling, Interpolation";
    public static final String OMSWINDOWSAMPLER_LABEL = RASTERPROCESSING;
    public static final String OMSWINDOWSAMPLER_NAME = "winsampler";
    public static final int OMSWINDOWSAMPLER_STATUS = 5;
    public static final String OMSWINDOWSAMPLER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSWINDOWSAMPLER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSWINDOWSAMPLER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSWINDOWSAMPLER_IN_GEODATA_DESCRIPTION = "The input coverage.";
    public static final String OMSWINDOWSAMPLER_P_MODE_DESCRIPTION = "The mode to use: average (0 = default), sum (1), max (2), min (3).";
    public static final String OMSWINDOWSAMPLER_P_ROWS_DESCRIPTION = "The windows rows to use (default is 3).";
    public static final String OMSWINDOWSAMPLER_P_COLS_DESCRIPTION = "The window cols to use (default is 3).";
    public static final String OMSWINDOWSAMPLER_P_MIN_VALID_DESCRIPTION = "Minimum percentage of valid surrounding cells needed to validate the maximum.";
    public static final String OMSWINDOWSAMPLER_P_X_STEP_DESCRIPTION = "The cols to move the window forward (default is = pCols).";
    public static final String OMSWINDOWSAMPLER_P_Y_STEP_DESCRIPTION = "The rows to move the window forward (default is = pRows).";
    public static final String OMSWINDOWSAMPLER_OUT_GEODATA_DESCRIPTION = "The output coverage.";

    public static final String OMSGRASSLEGACYWRITER_DESCRIPTION = "Legacy class for writing grass rasters.";
    public static final String OMSGRASSLEGACYWRITER_DOCUMENTATION = "";
    public static final String OMSGRASSLEGACYWRITER_KEYWORDS = "IO, Grass, Raster, Writing";
    public static final String OMSGRASSLEGACYWRITER_LABEL = RASTERWRITER;
    public static final String OMSGRASSLEGACYWRITER_NAME = "grasslegacywriter";
    public static final int OMSGRASSLEGACYWRITER_STATUS = 40;
    public static final String OMSGRASSLEGACYWRITER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSGRASSLEGACYWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSGRASSLEGACYWRITER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSGRASSLEGACYWRITER_UI = "hide";
    public static final String OMSGRASSLEGACYWRITER_GEODATA_DESCRIPTION = "The map that needs to be written.";
    public static final String OMSGRASSLEGACYWRITER_IN_WINDOW_DESCRIPTION = "The region for the map to be written.";
    public static final String OMSGRASSLEGACYWRITER_FILE_DESCRIPTION = "The file to the map to be written (the cell file).";

    public static final String OMSEIENERGYWRITER_DESCRIPTION = "Utility class for writing energy data to csv files.";
    public static final String OMSEIENERGYWRITER_DOCUMENTATION = "";
    public static final String OMSEIENERGYWRITER_KEYWORDS = "IO, Writing";
    public static final String OMSEIENERGYWRITER_LABEL = LIST_WRITER;
    public static final String OMSEIENERGYWRITER_NAME = "eienergywriter";
    public static final int OMSEIENERGYWRITER_STATUS = 40;
    public static final String OMSEIENERGYWRITER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSEIENERGYWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSEIENERGYWRITER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSEIENERGYWRITER_IN_ENERGY_DESCRIPTION = "The data to write.";
    public static final String OMSEIENERGYWRITER_FILE_DESCRIPTION = "The csv file to write to.";
    public static final String OMSEIENERGYWRITER_P_SEPARATOR_DESCRIPTION = "The csv separator.";

    public static final String OMSID2VALUEARRAYREADER_DESCRIPTION = "Utility class for reading data from csv file that have the form: id1 value1[] id2 value2[] ... idn valuen[].";
    public static final String OMSID2VALUEARRAYREADER_DOCUMENTATION = "";
    public static final String OMSID2VALUEARRAYREADER_KEYWORDS = "IO, Reading";
    public static final String OMSID2VALUEARRAYREADER_LABEL = HASHMAP_READER;
    public static final String OMSID2VALUEARRAYREADER_NAME = "id2valuearrayreader";
    public static final int OMSID2VALUEARRAYREADER_STATUS = 5;
    public static final String OMSID2VALUEARRAYREADER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSID2VALUEARRAYREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSID2VALUEARRAYREADER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSID2VALUEARRAYREADER_UI = "hide";
    public static final String OMSID2VALUEARRAYREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String OMSID2VALUEARRAYREADER_P_COLS_DESCRIPTION = "The number of columns of the array.";
    public static final String OMSID2VALUEARRAYREADER_P_SEPARATOR_DESCRIPTION = "The csv separator.";
    public static final String OMSID2VALUEARRAYREADER_FILE_NOVALUE_DESCRIPTION = "The file novalue.";
    public static final String OMSID2VALUEARRAYREADER_DATA_DESCRIPTION = "The read map of ids and values arrays.";

    public static final String OMSEIAREASREADER_DESCRIPTION = "Utility class for reading area data (for EICalculator) from csv files.";
    public static final String OMSEIAREASREADER_DOCUMENTATION = "";
    public static final String OMSEIAREASREADER_KEYWORDS = "IO, Reading";
    public static final String OMSEIAREASREADER_LABEL = LIST_READER;
    public static final String OMSEIAREASREADER_NAME = "eiareasreader";
    public static final int OMSEIAREASREADER_STATUS = 40;
    public static final String OMSEIAREASREADER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSEIAREASREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSEIAREASREADER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSEIAREASREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String OMSEIAREASREADER_P_SEPARATOR_DESCRIPTION = "The csv separator.";
    public static final String OMSEIAREASREADER_OUT_AREAS_DESCRIPTION = "The read data.";

    public static final String ADIGEBOUNDARYCONDITIONWRITER_DESCRIPTION = "Utility class for writing the final boundary conditions of the model adige to an OMS formatted csv file.";
    public static final String ADIGEBOUNDARYCONDITIONWRITER_DOCUMENTATION = "";
    public static final String ADIGEBOUNDARYCONDITIONWRITER_KEYWORDS = "IO, Writing";
    public static final String ADIGEBOUNDARYCONDITIONWRITER_LABEL = GENERICWRITER;
    public static final String ADIGEBOUNDARYCONDITIONWRITER_NAME = "adigeboundcondwriter";
    public static final int ADIGEBOUNDARYCONDITIONWRITER_STATUS = 40;
    public static final String ADIGEBOUNDARYCONDITIONWRITER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String ADIGEBOUNDARYCONDITIONWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String ADIGEBOUNDARYCONDITIONWRITER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String ADIGEBOUNDARYCONDITIONWRITER_FILE_DESCRIPTION = "The csv file to write to.";
    public static final String ADIGEBOUNDARYCONDITIONWRITER_TABLENAME_DESCRIPTION = "The table name.";
    public static final String ADIGEBOUNDARYCONDITIONWRITER_DATA_DESCRIPTION = "The list of boundary conditions to write.";

    public static final String OMSEIENERGYREADER_DESCRIPTION = "Utility class for reading energy data from csv files.";
    public static final String OMSEIENERGYREADER_DOCUMENTATION = "";
    public static final String OMSEIENERGYREADER_KEYWORDS = "IO, Reading";
    public static final String OMSEIENERGYREADER_LABEL = LIST_READER;
    public static final String OMSEIENERGYREADER_NAME = "eienergyreader";
    public static final int OMSEIENERGYREADER_STATUS = 40;
    public static final String OMSEIENERGYREADER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSEIENERGYREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSEIENERGYREADER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSEIENERGYREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String OMSEIENERGYREADER_P_SEPARATOR_DESCRIPTION = "The csv separator.";
    public static final String OMSEIENERGYREADER_OUT_ENERGY_DESCRIPTION = "The read data.";

    public static final String OMSVECTORTRANSFORMER_DESCRIPTION = "Module for vector tranforms. Currently only translation is supported.";
    public static final String OMSVECTORTRANSFORMER_DOCUMENTATION = "";
    public static final String OMSVECTORTRANSFORMER_KEYWORDS = "Transform, Vector";
    public static final String OMSVECTORTRANSFORMER_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORTRANSFORMER_NAME = "vtrans";
    public static final int OMSVECTORTRANSFORMER_STATUS = 40;
    public static final String OMSVECTORTRANSFORMER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORTRANSFORMER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORTRANSFORMER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSVECTORTRANSFORMER_IN_VECTOR_DESCRIPTION = "The feature collection that has to be transformed.";
    public static final String OMSVECTORTRANSFORMER_P_TRANS_X_DESCRIPTION = "The translation along the X axis.";
    public static final String OMSVECTORTRANSFORMER_P_TRANS_Y_DESCRIPTION = "The translation along the Y axis.";
    public static final String OMSVECTORTRANSFORMER_OUT_VECTOR_DESCRIPTION = "The transformed feature collection.";

    public static final String OMSVECTORFIELDROUNDER_DESCRIPTION = "Module that rounds a defined field attribute.";
    public static final String OMSVECTORFIELDROUNDER_DOCUMENTATION = "OmsVectorFieldRounder.html";
    public static final String OMSVECTORFIELDROUNDER_KEYWORDS = "Round, VectorFieldJoiner";
    public static final String OMSVECTORFIELDROUNDER_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORFIELDROUNDER_NAME = "vround";
    public static final int OMSVECTORFIELDROUNDER_STATUS = 40;
    public static final String OMSVECTORFIELDROUNDER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORFIELDROUNDER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORFIELDROUNDER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORFIELDROUNDER_IN_VECTOR_DESCRIPTION = "The vector of which to round a numeric value.";
    public static final String OMSVECTORFIELDROUNDER_F_ROUND_DESCRIPTION = "The double field of the number to round.";
    public static final String OMSVECTORFIELDROUNDER_P_PATTERN_DESCRIPTION = "The rounding pattern.";
    public static final String OMSVECTORFIELDROUNDER_OUT_VECTOR_DESCRIPTION = "The modified vector.";

    public static final String OMSVECTORMERGER_DESCRIPTION = "Module for merging vecotrs into one single.";
    public static final String OMSVECTORMERGER_DOCUMENTATION = "OmsVectorMerger.html";
    public static final String OMSVECTORMERGER_KEYWORDS = "IO, Feature, Vector, Merge";
    public static final String OMSVECTORMERGER_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORMERGER_NAME = "vmerge";
    public static final int OMSVECTORMERGER_STATUS = 40;
    public static final String OMSVECTORMERGER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORMERGER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORMERGER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORMERGER_IN_VECTORS_DESCRIPTION = "The input vectors to be merged.";
    public static final String OMSVECTORMERGER_IN_VECTOR1_DESCRIPTION = "The first vector to be merged.";
    public static final String OMSVECTORMERGER_IN_VECTOR2_DESCRIPTION = "The second vector to be merged.";
    public static final String OMSVECTORMERGER_OUT_VECTOR_DESCRIPTION = "The output vector.";

    public static final String OMSDATETIME2VALUEMAPWRITER_DESCRIPTION = "Utility class for writing data to csv file that have the form: time1 value1[] time2 value2[] ... timen valuen[].";
    public static final String OMSDATETIME2VALUEMAPWRITER_DOCUMENTATION = "";
    public static final String OMSDATETIME2VALUEMAPWRITER_KEYWORDS = "IO, Writing";
    public static final String OMSDATETIME2VALUEMAPWRITER_LABEL = HASHMAP_WRITER;
    public static final String OMSDATETIME2VALUEMAPWRITER_NAME = "datetime2valuemapwriter";
    public static final int OMSDATETIME2VALUEMAPWRITER_STATUS = 5;
    public static final String OMSDATETIME2VALUEMAPWRITER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSDATETIME2VALUEMAPWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSDATETIME2VALUEMAPWRITER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSDATETIME2VALUEMAPWRITER_UI = "hide";
    public static final String OMSDATETIME2VALUEMAPWRITER_FILE_DESCRIPTION = "The csv file to write to.";
    public static final String OMSDATETIME2VALUEMAPWRITER_P_SEPARATOR_DESCRIPTION = "The csv separator.";
    public static final String OMSDATETIME2VALUEMAPWRITER_FILE_NOVALUE_DESCRIPTION = "The file novalue.";
    public static final String OMSDATETIME2VALUEMAPWRITER_DATA_DESCRIPTION = "The map of ids and values arrays to write.";

    public static final String VEGETATIONLIBRARYREADER_DESCRIPTION = "Utility class for reading data from a OMS formatted csv file assumed to be containing the Vegetation library data.";
    public static final String VEGETATIONLIBRARYREADER_DOCUMENTATION = "";
    public static final String VEGETATIONLIBRARYREADER_KEYWORDS = "IO, Reading";
    public static final String VEGETATIONLIBRARYREADER_LABEL = GENERICREADER;
    public static final String VEGETATIONLIBRARYREADER_NAME = "vegetationlibraryreader";
    public static final int VEGETATIONLIBRARYREADER_STATUS = 40;
    public static final String VEGETATIONLIBRARYREADER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String VEGETATIONLIBRARYREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String VEGETATIONLIBRARYREADER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String VEGETATIONLIBRARYREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String VEGETATIONLIBRARYREADER_DATA_DESCRIPTION = "The list of arrays representing the values in the rows.";

    public static final String OMSLINESPOLYGONIZER_DESCRIPTION = "Polygonizes a layer of lines.";
    public static final String OMSLINESPOLYGONIZER_DOCUMENTATION = "";
    public static final String OMSLINESPOLYGONIZER_KEYWORDS = "Vector, Polygonize";
    public static final String OMSLINESPOLYGONIZER_LABEL = VECTORPROCESSING;
    public static final String OMSLINESPOLYGONIZER_NAME = "linespolygonizer";
    public static final int OMSLINESPOLYGONIZER_STATUS = 10;
    public static final String OMSLINESPOLYGONIZER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSLINESPOLYGONIZER_AUTHORNAMES = "Antonio Falciano, Andrea Antonello";
    public static final String OMSLINESPOLYGONIZER_AUTHORCONTACTS = "afalciano@yahoo.it, http://blog.spaziogis.it/, http://www.hydrologis.com";
    public static final String OMSLINESPOLYGONIZER_IN_MAP_DESCRIPTION = "The map of lines to polygonize.";
    public static final String OMSLINESPOLYGONIZER_IN_POINTS_DESCRIPTION = "The map of points containing the id to put in the polygons attributes (optional).";
    public static final String OMSLINESPOLYGONIZER_F_ID_DESCRIPTION = "The field of the points layer containing the id for the polygons (necessary if inPoints is defined).";
    public static final String OMSLINESPOLYGONIZER_F_NEW_ID_DESCRIPTION = "The field of the polygonized layer containing the id (default is 'id').";
    public static final String OMSLINESPOLYGONIZER_OUT_MAP_DESCRIPTION = "The map of polygons.";

    public static final String OMSRASTERCORRECTOR_DESCRIPTION = "Raster corrector module.";
    public static final String OMSRASTERCORRECTOR_DOCUMENTATION = "";
    public static final String OMSRASTERCORRECTOR_KEYWORDS = "IO, Coverage, Raster, Correct, OmsRasterReader";
    public static final String OMSRASTERCORRECTOR_LABEL = RASTERPROCESSING;
    public static final String OMSRASTERCORRECTOR_NAME = "rcorrect";
    public static final int OMSRASTERCORRECTOR_STATUS = 5;
    public static final String OMSRASTERCORRECTOR_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERCORRECTOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERCORRECTOR_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERCORRECTOR_IN_RASTER_DESCRIPTION = "The input raster.";
    public static final String OMSRASTERCORRECTOR_P_CORRECTIONS_DESCRIPTION = "The values to correct as a CSV list of triplets (format is col1,row1,value1,col2,row2,value2...).";
    public static final String OMSRASTERCORRECTOR_OUT_RASTER_DESCRIPTION = "The output raster.";

    public static final String OMSRASTERDIFF_DESCRIPTION = "Raster diff module.";
    public static final String OMSRASTERDIFF_DOCUMENTATION = "";
    public static final String OMSRASTERDIFF_KEYWORDS = "IO, Coverage, Raster, Correct, OmsRasterReader";
    public static final String OMSRASTERDIFF_LABEL = RASTERPROCESSING;
    public static final String OMSRASTERDIFF_NAME = "rdiff";
    public static final int OMSRASTERDIFF_STATUS = 5;
    public static final String OMSRASTERDIFF_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERDIFF_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERDIFF_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERDIFF_IN_RASTER1_DESCRIPTION = "The input raster.";
    public static final String OMSRASTERDIFF_IN_RASTER2_DESCRIPTION = "The raster to subtract.";
    public static final String OMSRASTERDIFF_P_THRESHOLD_DESCRIPTION = "The threshold, under which to set novalue.";
    public static final String OMSRASTERDIFF_DO_NEGATIVES_DESCRIPTION = "Allow negative values.";
    public static final String OMSRASTERDIFF_OUT_RASTER_DESCRIPTION = "The output raster.";

    public static final String OMSRASTERRESOLUTIONRESAMPLER_DESCRIPTION = "Module to do coverage resolution resampling.";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_DOCUMENTATION = "";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_KEYWORDS = "IO, Coverage, Raster, Convert";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_LABEL = RASTERPROCESSING;
    public static final String OMSRASTERRESOLUTIONRESAMPLER_NAME = "rresolresampler";
    public static final int OMSRASTERRESOLUTIONRESAMPLER_STATUS = 5;
    public static final String OMSRASTERRESOLUTIONRESAMPLER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_IN_GEODATA_DESCRIPTION = "The input coverage.";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_P_INTERPOLATION_DESCRIPTION = "The interpolation type to use";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_P_X_RES_DESCRIPTION = "The new resolution in X";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_P_Y_RES_DESCRIPTION = "The new resolution in Y (if null taken same as pXres)";
    public static final String OMSRASTERRESOLUTIONRESAMPLER_OUT_GEODATA_DESCRIPTION = "The output coverage.";

    public static final String OMSVECTORTABLEJOINER_DESCRIPTION = "Module that joins attributes from one vector into another based on a common field.";
    public static final String OMSVECTORTABLEJOINER_DOCUMENTATION = "OmsVectorTableJoiner.html";
    public static final String OMSVECTORTABLEJOINER_KEYWORDS = "Join, OmsVectorFieldRounder";
    public static final String OMSVECTORTABLEJOINER_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORTABLEJOINER_NAME = "vjoin";
    public static final int OMSVECTORTABLEJOINER_STATUS = 40;
    public static final String OMSVECTORTABLEJOINER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORTABLEJOINER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORTABLEJOINER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORTABLEJOINER_IN_VECTOR_DESCRIPTION = "The vector to extend.";
    public static final String OMSVECTORTABLEJOINER_TABLEDATA_DESCRIPTION = "The dbf tabledata to merge in.";
    public static final String OMSVECTORTABLEJOINER_F_COMMON_DESCRIPTION = "The common field (if different in the two sources, commaseparated, first shapefile, then dbf.";
    public static final String OMSVECTORTABLEJOINER_P_FIELDS_DESCRIPTION = "The commaseparated list of fields to merge in.";
    public static final String OMSVECTORTABLEJOINER_OUT_VECTOR_DESCRIPTION = "The joined vector.";

    public static final String OMSMAPCALC_DESCRIPTION = "Module for doing raster map algebra.";
    public static final String OMSMAPCALC_DOCUMENTATION = "OmsMapcalc.html";
    public static final String OMSMAPCALC_KEYWORDS = "OmsMapcalc, Raster, OmsCutOut";
    public static final String OMSMAPCALC_LABEL = RASTERPROCESSING;
    public static final String OMSMAPCALC_NAME = "omsmapcalc";
    public static final int OMSMAPCALC_STATUS = 40;
    public static final String OMSMAPCALC_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSMAPCALC_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSMAPCALC_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSMAPCALC_IN_RASTERS_DESCRIPTION = "The maps that are used in the calculation.";
    public static final String OMSMAPCALC_P_FUNCTION_DESCRIPTION = "The function to process.";
    public static final String OMSMAPCALC_OUT_RASTER_DESCRIPTION = "The resulting map picked from the inserted function.";

    public static final String OMSMOSAIC12_DESCRIPTION = "Module for patching max 12 rasters.";
    public static final String OMSMOSAIC12_DOCUMENTATION = "";
    public static final String OMSMOSAIC12_KEYWORDS = "OmsMosaic, Raster";
    public static final String OMSMOSAIC12_LABEL = RASTERPROCESSING;
    public static final String OMSMOSAIC12_NAME = "mosaic12";
    public static final int OMSMOSAIC12_STATUS = 40;
    public static final String OMSMOSAIC12_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSMOSAIC12_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSMOSAIC12_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSMOSAIC12_IN_MAP1_DESCRIPTION = "The Map N.1 to be patched";
    public static final String OMSMOSAIC12_IN_MAP2_DESCRIPTION = "The Map N.2 to be patched";
    public static final String OMSMOSAIC12_IN_MAP3_DESCRIPTION = "The optional Map N.3 to be patched";
    public static final String OMSMOSAIC12_IN_MAP4_DESCRIPTION = "The optional Map N.4 to be patched";
    public static final String OMSMOSAIC12_IN_MAP5_DESCRIPTION = "The optional Map N.5 to be patched";
    public static final String OMSMOSAIC12_IN_MAP6_DESCRIPTION = "The optional Map N.6 to be patched";
    public static final String OMSMOSAIC12_IN_MAP7_DESCRIPTION = "The optional Map N.7 to be patched";
    public static final String OMSMOSAIC12_IN_MAP8_DESCRIPTION = "The optional Map N.8 to be patched";
    public static final String OMSMOSAIC12_IN_MAP9_DESCRIPTION = "The optional Map N.9 to be patched";
    public static final String OMSMOSAIC12_IN_MAP10_DESCRIPTION = "The optional Map N.10 to be patched";
    public static final String OMSMOSAIC12_IN_MAP11_DESCRIPTION = "The optional Map N.11 to be patched";
    public static final String OMSMOSAIC12_IN_MAP12_DESCRIPTION = "The optional Map N.12 to be patched";
    public static final String OMSMOSAIC12_P_INTERPOLATION_DESCRIPTION = "The interpolation type to use";
    public static final String OMSMOSAIC12_OUT_MAP_DESCRIPTION = "The patched map.";

    public static final String OMSVECTORFILTER_DESCRIPTION = "Module that creates a subset of a vector based on a filtered vector.";
    public static final String OMSVECTORFILTER_DOCUMENTATION = "OmsVectorFilter.html";
    public static final String OMSVECTORFILTER_KEYWORDS = "Filter, Vector, OmsVectorReshaper";
    public static final String OMSVECTORFILTER_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORFILTER_NAME = "vfilter";
    public static final int OMSVECTORFILTER_STATUS = 40;
    public static final String OMSVECTORFILTER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORFILTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORFILTER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORFILTER_IN_VECTOR_DESCRIPTION = "The vector to filter.";
    public static final String OMSVECTORFILTER_P_CQL_DESCRIPTION = "The ECQL filter function.";
    public static final String OMSVECTORFILTER_OUT_VECTOR_DESCRIPTION = "The filtered vector.";

    public static final String OMSCARVER_DESCRIPTION = "Carves a raster using a vector map.";
    public static final String OMSCARVER_DOCUMENTATION = "";
    public static final String OMSCARVER_KEYWORDS = "Carve, Raster";
    public static final String OMSCARVER_LABEL = RASTERPROCESSING;
    public static final String OMSCARVER_NAME = "carver";
    public static final int OMSCARVER_STATUS = 5;
    public static final String OMSCARVER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSCARVER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSCARVER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSCARVER_IN_RASTER_DESCRIPTION = "The input raster.";
    public static final String OMSCARVER_IN_CARVE_R_POLYGONS_DESCRIPTION = "The polygon vector map used to carve the raster.";
    public static final String OMSCARVER_IN_CARVE_R_LINES_DESCRIPTION = "The lines vector map used to carve the raster.";
    public static final String OMSCARVER_F_DEPTH_LINES_DESCRIPTION = "The optional vector lines field containing the depth to be carved.";
    public static final String OMSCARVER_P_DEPTH_LINES_DESCRIPTION = "The carve depth to use for vector lines if no field is supplied.";
    public static final String OMSCARVER_F_DEPTH_POLYGONS_DESCRIPTION = "The optional vector polygons field containing the depth to be carved.";
    public static final String OMSCARVER_P_DEPTH_POLYGONS_DESCRIPTION = "The carve depth to use for vector polygons if no field is supplied.";
    public static final String OMSCARVER_OUT_RASTER_DESCRIPTION = "The carved raster map.";

    public static final String OMSSHAPEFILEFEATUREWRITER_DESCRIPTION = "Utility class for writing geotools featurecollections to shapefile.";
    public static final String OMSSHAPEFILEFEATUREWRITER_DOCUMENTATION = "";
    public static final String OMSSHAPEFILEFEATUREWRITER_KEYWORDS = "IO, Shapefile, Feature, Vector, Writing";
    public static final String OMSSHAPEFILEFEATUREWRITER_LABEL = FEATUREWRITER;
    public static final String OMSSHAPEFILEFEATUREWRITER_NAME = "shapefilefeaturewriter";
    public static final int OMSSHAPEFILEFEATUREWRITER_STATUS = 40;
    public static final String OMSSHAPEFILEFEATUREWRITER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSSHAPEFILEFEATUREWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSSHAPEFILEFEATUREWRITER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSSHAPEFILEFEATUREWRITER_UI = "hide";
    public static final String OMSSHAPEFILEFEATUREWRITER_GEODATA_DESCRIPTION = "The feature collection to write.";
    public static final String OMSSHAPEFILEFEATUREWRITER_FILE_DESCRIPTION = "The shapefile to which to write to.";
    public static final String OMSSHAPEFILEFEATUREWRITER_DO_INDEX_DESCRIPTION = "Create also the spatial index for the file.";
    public static final String OMSSHAPEFILEFEATUREWRITER_P_TYPE_DESCRIPTION = "The feature type. It's mandatory only if you want to write down an empty FeatureCollection";

    public static final String OMSXYZ2RASTER_DESCRIPTION = "Convert evenly spaced XYZ triplets to regular raster grid.";
    public static final String OMSXYZ2RASTER_DOCUMENTATION = "";
    public static final String OMSXYZ2RASTER_KEYWORDS = "Raster, Conversion";
    public static final String OMSXYZ2RASTER_LABEL = RASTERPROCESSING;
    public static final String OMSXYZ2RASTER_NAME = "xyz2raster";
    public static final int OMSXYZ2RASTER_STATUS = 40;
    public static final String OMSXYZ2RASTER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSXYZ2RASTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSXYZ2RASTER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSXYZ2RASTER_IN_FILE_DESCRIPTION = "The file of regularly distributed xyz triplets.";
    public static final String OMSXYZ2RASTER_P_RES_DESCRIPTION = "The resolution to use.";
    public static final String OMSXYZ2RASTER_P_CODE_DESCRIPTION = "The code defining the target coordinate reference system, composed by authority and code number (ex. EPSG:4328).";
    public static final String OMSXYZ2RASTER_P_SEPARATOR_DESCRIPTION = "The value separator (if not set, spaces will be used).";
    public static final String OMSXYZ2RASTER_OUT_RASTER_DESCRIPTION = "The generated raster.";

    public static final String OMSDWGCONVERTER_DESCRIPTION = "Module to convert dxf files to geotools vecotors.";
    public static final String OMSDWGCONVERTER_DOCUMENTATION = "OmsDwgConverter.html";
    public static final String OMSDWGCONVERTER_KEYWORDS = "IO, OmsDxfConverter, Feature, Vector, Reading";
    public static final String OMSDWGCONVERTER_LABEL = VECTORPROCESSING;
    public static final String OMSDWGCONVERTER_NAME = "dwgimport";
    public static final int OMSDWGCONVERTER_STATUS = 5;
    public static final String OMSDWGCONVERTER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSDWGCONVERTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSDWGCONVERTER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSDWGCONVERTER_FILE_DESCRIPTION = "The dwg input file.";
    public static final String OMSDWGCONVERTER_P_CODE_DESCRIPTION = "The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.";
    public static final String OMSDWGCONVERTER_POINTS_VECTOR_DESCRIPTION = "The output point vector.";
    public static final String OMSDWGCONVERTER_LINE_VECTOR_DESCRIPTION = "The output line vector.";
    public static final String OMSDWGCONVERTER_POLYGON_VECTOR_DESCRIPTION = "The output polygon vector.";
    public static final String OMSDWGCONVERTER_TEXT_VECTOR_DESCRIPTION = "The output text vector.";
    public static final String OMSDWGCONVERTER_ATTRIBUTES_VECTOR_DESCRIPTION = "The output attributes vector.";
    public static final String OMSDWGCONVERTER_CONTOUR_VECTOR_DESCRIPTION = "The output contour vector.";

    public static final String OMSEIAREASWRITER_DESCRIPTION = "Utility class for writing area data (for EICalculator) to csv files.";
    public static final String OMSEIAREASWRITER_DOCUMENTATION = "";
    public static final String OMSEIAREASWRITER_KEYWORDS = "IO, Writing";
    public static final String OMSEIAREASWRITER_LABEL = LIST_WRITER;
    public static final String OMSEIAREASWRITER_NAME = "eiareaswriter";
    public static final int OMSEIAREASWRITER_STATUS = 40;
    public static final String OMSEIAREASWRITER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSEIAREASWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSEIAREASWRITER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSEIAREASWRITER_IN_AREAS_DESCRIPTION = "The data to write.";
    public static final String OMSEIAREASWRITER_FILE_DESCRIPTION = "The csv file to write to.";
    public static final String OMSEIAREASWRITER_P_SEPARATOR_DESCRIPTION = "The csv separator.";

    public static final String OMSID2VALUEARRAYWRITER_DESCRIPTION = "Utility class for writing data to csv file that have the form: id1 value1[] id2 value2[] ... idn valuen[].";
    public static final String OMSID2VALUEARRAYWRITER_DOCUMENTATION = "";
    public static final String OMSID2VALUEARRAYWRITER_KEYWORDS = "IO, Writing";
    public static final String OMSID2VALUEARRAYWRITER_LABEL = HASHMAP_WRITER;
    public static final String OMSID2VALUEARRAYWRITER_NAME = "id2valuearraywriter";
    public static final int OMSID2VALUEARRAYWRITER_STATUS = 40;
    public static final String OMSID2VALUEARRAYWRITER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSID2VALUEARRAYWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSID2VALUEARRAYWRITER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSID2VALUEARRAYWRITER_UI = "hide";
    public static final String OMSID2VALUEARRAYWRITER_FILE_DESCRIPTION = "The csv file to write to.";
    public static final String OMSID2VALUEARRAYWRITER_P_SEPARATOR_DESCRIPTION = "The csv separator.";
    public static final String OMSID2VALUEARRAYWRITER_FILE_NOVALUE_DESCRIPTION = "The file novalue.";
    public static final String OMSID2VALUEARRAYWRITER_DATA_DESCRIPTION = "The map of ids and values arrays to write.";

    public static final String OMSINTERSECTIONFINDER_DESCRIPTION = "Finds intersection geometries in feature collections";
    public static final String OMSINTERSECTIONFINDER_DOCUMENTATION = "";
    public static final String OMSINTERSECTIONFINDER_KEYWORDS = "Vector";
    public static final String OMSINTERSECTIONFINDER_LABEL = VECTORPROCESSING;
    public static final String OMSINTERSECTIONFINDER_NAME = "intersectionfinder";
    public static final int OMSINTERSECTIONFINDER_STATUS = 10;
    public static final String OMSINTERSECTIONFINDER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSINTERSECTIONFINDER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSINTERSECTIONFINDER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSINTERSECTIONFINDER_IN_MAP_DESCRIPTION = "The map to test for intersections.";
    public static final String OMSINTERSECTIONFINDER_OUT_POINTS_MAP_DESCRIPTION = "The intersections points map.";
    public static final String OMSINTERSECTIONFINDER_OUT_LINES_MAP_DESCRIPTION = "The intersections lines map.";

    public static final String OMSRANGELOOKUP_DESCRIPTION = "Module for raster rangelookup.";
    public static final String OMSRANGELOOKUP_DOCUMENTATION = "OmsRangeLookup.html";
    public static final String OMSRANGELOOKUP_KEYWORDS = "Raster, Rangelookup";
    public static final String OMSRANGELOOKUP_LABEL = RASTERPROCESSING;
    public static final String OMSRANGELOOKUP_NAME = "rrangelookup";
    public static final int OMSRANGELOOKUP_STATUS = 40;
    public static final String OMSRANGELOOKUP_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRANGELOOKUP_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRANGELOOKUP_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRANGELOOKUP_IN_RASTER_DESCRIPTION = "The raster that has to be processed.";
    public static final String OMSRANGELOOKUP_P_RANGES_DESCRIPTION = "The ranges in the form [r1l r1h),[r2l r2h]";
    public static final String OMSRANGELOOKUP_P_CLASSES_DESCRIPTION = "The classes to substitute in the same order of the ranges (in the form 1,2)";
    public static final String OMSRANGELOOKUP_OUT_RASTER_DESCRIPTION = "The processed raster.";

    public static final String OMSTMSGENERATOR_DESCRIPTION = "Module for the generation of map tiles.";
    public static final String OMSTMSGENERATOR_DOCUMENTATION = "";
    public static final String OMSTMSGENERATOR_KEYWORDS = "Raster, Vector, TMS, Tiles";
    public static final String OMSTMSGENERATOR_LABEL = RASTERPROCESSING;
    public static final String OMSTMSGENERATOR_NAME = "tmsgenerator";
    public static final int OMSTMSGENERATOR_STATUS = 10;
    public static final String OMSTMSGENERATOR_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSTMSGENERATOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSTMSGENERATOR_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSTMSGENERATOR_IN_RASTER_FILE_DESCRIPTION = "A file containing the list of raster map paths to consider (the order is relevant, first layers are placed below others).";
    public static final String OMSTMSGENERATOR_IN_RASTER_BOUNDS_DESCRIPTION = "Optional regions for reading the rasters.";
    public static final String OMSTMSGENERATOR_IN_VECTOR_FILE_DESCRIPTION = "A file containing the list of vector map paths to consider (the order is relevant, first layers are placed below others).";
    public static final String OMSTMSGENERATOR_IN_WMS_DESCRIPTION = "An optional WMS url and layer name in the format: http://wmsurl#layername";
    public static final String OMSTMSGENERATOR_P_NAME_DESCRIPTION = "A name of the tile source.";
    public static final String OMSTMSGENERATOR_P_MIN_ZOOM_DESCRIPTION = "The min zoom for which to generate tiles.";
    public static final String OMSTMSGENERATOR_P_MAX_ZOOM_DESCRIPTION = "The max zoom for which to generate tiles.";
    public static final String OMSTMSGENERATOR_P_NORTH_DESCRIPTION = "The north bound of the region to consider.";
    public static final String OMSTMSGENERATOR_P_SOUTH_DESCRIPTION = "The south bound of the region to consider.";
    public static final String OMSTMSGENERATOR_P_WEST_DESCRIPTION = "The west bound of the region to consider.";
    public static final String OMSTMSGENERATOR_P_EAST_DESCRIPTION = "The east bound of the region to consider.";
    public static final String OMSTMSGENERATOR_P_EPSG_DESCRIPTION = "The coordinate reference system of the bound coordinates and supplied datasets (ex. EPSG:4328).";
    public static final String OMSTMSGENERATOR_DO_LENIENT_DESCRIPTION = "Switch that set to true allows for some error due to different datums. If set to false, it won't reproject without Bursa Wolf parameters.";
    public static final String OMSTMSGENERATOR_P_IMAGE_TYPE_DESCRIPTION = "The image type to generate (0 = png = default, 1 = jpg).";
    public static final String OMSTMSGENERATOR_P_CHECK_COLOR_DESCRIPTION = "A color rgb tripled. if it is not null and a tiles is made only of that color, then the tiles is not generated. Usefull to avoid generation of empty tiles.";
    public static final String OMSTMSGENERATOR_DO_LEGACY_GRASS_DESCRIPTION = "Optional flag to force a legacy GRASS driver usage.";
    public static final String OMSTMSGENERATOR_IN_PATH_DESCRIPTION = "The folder inside which to create the tiles.";
    public static final String OMSTMSGENERATOR_P_MAX_THREADS_DESCRIPTION = "Max threads to use (default 1)";

    public static final String OMSCOVERAGELISTER_DESCRIPTION = "A module that reads rasters.";
    public static final String OMSCOVERAGELISTER_DOCUMENTATION = "";
    public static final String OMSCOVERAGELISTER_KEYWORDS = "Iterator, Raster";
    public static final String OMSCOVERAGELISTER_LABEL = LIST_READER;
    public static final String OMSCOVERAGELISTER_NAME = "rasterlister";
    public static final int OMSCOVERAGELISTER_STATUS = 40;
    public static final String OMSCOVERAGELISTER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSCOVERAGELISTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSCOVERAGELISTER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSCOVERAGELISTER_IN_FILES_DESCRIPTION = "The list of file from which to read rasters.";
    public static final String OMSCOVERAGELISTER_FILE_NOVALUE_DESCRIPTION = "The file novalue.";
    public static final String OMSCOVERAGELISTER_GEODATA_NOVALUE_DESCRIPTION = "The novalue wanted in the raster.";
    public static final String OMSCOVERAGELISTER_P_NORTH_DESCRIPTION = "The optional requested boundary north coordinate.";
    public static final String OMSCOVERAGELISTER_P_SOUTH_DESCRIPTION = "The optional requested boundary south coordinate.";
    public static final String OMSCOVERAGELISTER_P_WEST_DESCRIPTION = "The optional requested boundary west coordinate.";
    public static final String OMSCOVERAGELISTER_P_EAST_DESCRIPTION = "The optional requested boundary east coordinate.";
    public static final String OMSCOVERAGELISTER_P_X_RES_DESCRIPTION = "The optional requested resolution in x.";
    public static final String OMSCOVERAGELISTER_P_Y_RES_DESCRIPTION = "The optional requested resolution in y.";
    public static final String OMSCOVERAGELISTER_P_ROWS_DESCRIPTION = "The optional requested numer of rows.";
    public static final String OMSCOVERAGELISTER_P_COLS_DESCRIPTION = "The optional requested numer of cols.";
    public static final String OMSCOVERAGELISTER_OUT_GC_DESCRIPTION = "All rasters matching read from the input files.";

    public static final String OMSVECTORIZER_DESCRIPTION = "Module for raster to vector conversion.";
    public static final String OMSVECTORIZER_DOCUMENTATION = "OmsVectorizer.html";
    public static final String OMSVECTORIZER_KEYWORDS = "Raster, Vector, OmsScanLineRasterizer";
    public static final String OMSVECTORIZER_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORIZER_NAME = "vectorizer";
    public static final int OMSVECTORIZER_STATUS = 40;
    public static final String OMSVECTORIZER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORIZER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORIZER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORIZER_IN_RASTER_DESCRIPTION = "The raster that has to be converted.";
    public static final String OMSVECTORIZER_P_VALUE_DESCRIPTION = "The value to use to trace the polygons. If it is null then all the value of the raster are used.";
    public static final String OMSVECTORIZER_F_DEFAULT_DESCRIPTION = "The field name to use as a name for the raster value in the vector.";
    public static final String OMSVECTORIZER_DO_REMOVE_HOLES_DESCRIPTION = "If true, wholes are removed form polygons.";
    public static final String OMSVECTORIZER_P_THRES_DESCRIPTION = "A threshold on cell number to filter away polygons with cells less than that.";
    public static final String OMSVECTORIZER_DO_REGION_CHECK_DESCRIPTION = "Make a check on the raster first and shrink the boundaries on the region with data.";
    public static final String OMSVECTORIZER_OUT_VECTOR_DESCRIPTION = "The extracted vector.";

    public static final String OMSRASTER2XYZ_DESCRIPTION = "Convert a raster to XYZ triplets.";
    public static final String OMSRASTER2XYZ_DOCUMENTATION = "";
    public static final String OMSRASTER2XYZ_KEYWORDS = "Raster, Conversion";
    public static final String OMSRASTER2XYZ_LABEL = RASTERPROCESSING;
    public static final String OMSRASTER2XYZ_NAME = "raster2xyz";
    public static final int OMSRASTER2XYZ_STATUS = 40;
    public static final String OMSRASTER2XYZ_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTER2XYZ_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTER2XYZ_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTER2XYZ_IN_RASTER_DESCRIPTION = "The map to convert.";
    public static final String OMSRASTER2XYZ_IN_FILE_DESCRIPTION = "The file into which to save the result.";
    public static final String OMSRASTER2XYZ_DO_REMOVE_NV_DESCRIPTION = "Flag to remove novalues.";

    public static final String OMSPLAINID2VALUEREADER_DESCRIPTION = "Utility class for reading data from csv file that have the form: id1 value1 id2 value2 ... idn valuen.";
    public static final String OMSPLAINID2VALUEREADER_DOCUMENTATION = "";
    public static final String OMSPLAINID2VALUEREADER_KEYWORDS = "IO, Reading";
    public static final String OMSPLAINID2VALUEREADER_LABEL = HASHMAP_READER;
    public static final String OMSPLAINID2VALUEREADER_NAME = "plainid2valuereader";
    public static final int OMSPLAINID2VALUEREADER_STATUS = 5;
    public static final String OMSPLAINID2VALUEREADER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSPLAINID2VALUEREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSPLAINID2VALUEREADER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSPLAINID2VALUEREADER_UI = "hide";
    public static final String OMSPLAINID2VALUEREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String OMSPLAINID2VALUEREADER_P_SEPARATOR_DESCRIPTION = "The csv separator.";
    public static final String OMSPLAINID2VALUEREADER_FILE_NOVALUE_DESCRIPTION = "The file novalue.";
    public static final String OMSPLAINID2VALUEREADER_NOVALUE_DESCRIPTION = "The novalue wanted in the coverage.";
    public static final String OMSPLAINID2VALUEREADER_DATA_DESCRIPTION = "The read map of ids and values.";

    public static final String OMSVECTORCLIPPER_DESCRIPTION = "A vector clipping module.";
    public static final String OMSVECTORCLIPPER_DOCUMENTATION = "";
    public static final String OMSVECTORCLIPPER_KEYWORDS = "JTS, Clip, Vector";
    public static final String OMSVECTORCLIPPER_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORCLIPPER_NAME = "clipper";
    public static final int OMSVECTORCLIPPER_STATUS = 5;
    public static final String OMSVECTORCLIPPER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSVECTORCLIPPER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORCLIPPER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSVECTORCLIPPER_IN_MAP_DESCRIPTION = "The vector map to be clipped.";
    public static final String OMSVECTORCLIPPER_IN_CLIPPER_DESCRIPTION = "The clipping vector map.";
    public static final String OMSVECTORCLIPPER_P_MAX_THREADS_DESCRIPTION = "Max threads to use (default 1)";
    public static final String OMSVECTORCLIPPER_OUT_MAP_DESCRIPTION = "The resulting vector map.";

    public static final String IDVALUESARRAY2IDVALUESCONVERTER_DESCRIPTION = "Utility class for converting from 'id1 value1[]' to 'id1 value1' by averaging.";
    public static final String IDVALUESARRAY2IDVALUESCONVERTER_DOCUMENTATION = "";
    public static final String IDVALUESARRAY2IDVALUESCONVERTER_KEYWORDS = "IO, Reading";
    public static final String IDVALUESARRAY2IDVALUESCONVERTER_LABEL = OTHER;
    public static final String IDVALUESARRAY2IDVALUESCONVERTER_NAME = "valuesarray2idvaluesconverter";
    public static final int IDVALUESARRAY2IDVALUESCONVERTER_STATUS = 10;
    public static final String IDVALUESARRAY2IDVALUESCONVERTER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String IDVALUESARRAY2IDVALUESCONVERTER_AUTHORNAMES = "Andrea Antonello";
    public static final String IDVALUESARRAY2IDVALUESCONVERTER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String IDVALUESARRAY2IDVALUESCONVERTER_IN_DATA_DESCRIPTION = "Input data.";
    public static final String IDVALUESARRAY2IDVALUESCONVERTER_OUT_DATA_DESCRIPTION = "Output data.";

    public static final String OMSDBFTABLEREADER_DESCRIPTION = "Utility class for reading dbf tables.";
    public static final String OMSDBFTABLEREADER_DOCUMENTATION = "";
    public static final String OMSDBFTABLEREADER_KEYWORDS = "IO, Shapefile, Feature, Vector, Reading";
    public static final String OMSDBFTABLEREADER_LABEL = HASHMAP_READER;
    public static final String OMSDBFTABLEREADER_NAME = "dbfreader";
    public static final int OMSDBFTABLEREADER_STATUS = 10;
    public static final String OMSDBFTABLEREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSDBFTABLEREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSDBFTABLEREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSDBFTABLEREADER_FILE_DESCRIPTION = "The dbf file.";
    public static final String OMSDBFTABLEREADER_OUT_TABLE_DATA_DESCRIPTION = "The read dbf table.";

    public static final String OMSPROPERTIESFEATUREREADER_DESCRIPTION = "Utility class for reading properties files to geotools featurecollections.";
    public static final String OMSPROPERTIESFEATUREREADER_DOCUMENTATION = "";
    public static final String OMSPROPERTIESFEATUREREADER_KEYWORDS = "IO, Properties, Feature, Vector, Reading";
    public static final String OMSPROPERTIESFEATUREREADER_LABEL = FEATUREREADER;
    public static final String OMSPROPERTIESFEATUREREADER_NAME = "propertiesfeaturereader";
    public static final int OMSPROPERTIESFEATUREREADER_STATUS = 40;
    public static final String OMSPROPERTIESFEATUREREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSPROPERTIESFEATUREREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSPROPERTIESFEATUREREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSPROPERTIESFEATUREREADER_UI = "hide";
    public static final String OMSPROPERTIESFEATUREREADER_FILE_DESCRIPTION = "The properties file.";
    public static final String OMSPROPERTIESFEATUREREADER_GEODATA_DESCRIPTION = "The read feature collection.";

    public static final String OMSJSONFEATUREREADER_DESCRIPTION = "Utility class for reading JSON files to geotools featurecollections. Each line represents a json feature.";
    public static final String OMSJSONFEATUREREADER_DOCUMENTATION = "";
    public static final String OMSJSONFEATUREREADER_KEYWORDS = "IO, JSON, Feature, Vector, Reading";
    public static final String OMSJSONFEATUREREADER_LABEL = FEATUREREADER;
    public static final String OMSJSONFEATUREREADER_NAME = "jsonfeaturereader";
    public static final int OMSJSONFEATUREREADER_STATUS = 40;
    public static final String OMSJSONFEATUREREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSJSONFEATUREREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSJSONFEATUREREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSJSONFEATUREREADER_UI = "hide";
    public static final String OMSJSONFEATUREREADER_FILE_DESCRIPTION = "The JSON file to convert (it has to contain a lat and lon attribute).";
    public static final String OMSJSONFEATUREREADER_GEODATA_DESCRIPTION = "The read feature collection.";

    public static final String OMSSURFACEINTERPOLATOR_DESCRIPTION = "Thin Plate Spline and IWD Interpolators";
    public static final String OMSSURFACEINTERPOLATOR_DOCUMENTATION = "";
    public static final String OMSSURFACEINTERPOLATOR_KEYWORDS = "Interpolation, Raster, Spline";
    public static final String OMSSURFACEINTERPOLATOR_LABEL = RASTERPROCESSING;
    public static final String OMSSURFACEINTERPOLATOR_NAME = "surfaceinterpolator";
    public static final int OMSSURFACEINTERPOLATOR_STATUS = 10;
    public static final String OMSSURFACEINTERPOLATOR_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSSURFACEINTERPOLATOR_AUTHORNAMES = "Jan Jezek, Andrea Antonello";
    public static final String OMSSURFACEINTERPOLATOR_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSSURFACEINTERPOLATOR_IN_VECTOR_DESCRIPTION = "The input vector map of points.";
    public static final String OMSSURFACEINTERPOLATOR_IN_GRID_DESCRIPTION = "The grid on which to interpolate.";
    public static final String OMSSURFACEINTERPOLATOR_IN_MASK_DESCRIPTION = "A mask raster map. Values will be computed only where the mask has values.";
    public static final String OMSSURFACEINTERPOLATOR_F_CAT_DESCRIPTION = "Field from which to take the category value.";
    public static final String OMSSURFACEINTERPOLATOR_P_MODE_DESCRIPTION = "Interpolation mode.";
    public static final String OMSSURFACEINTERPOLATOR_P_BUFFER_DESCRIPTION = "The buffer to use for interpolation.";
    public static final String OMSSURFACEINTERPOLATOR_P_MAX_THREADS_DESCRIPTION = "Max threads to use.";
    public static final String OMSSURFACEINTERPOLATOR_OUT_RASTER_DESCRIPTION = "The interpolated raster";

    public static final String OMSDATETIME2VALUEMAPREADER_DESCRIPTION = "Utility class for reading data from csv file that have the form: time1 value1[] time2 value2[] ... timen valuen[].";
    public static final String OMSDATETIME2VALUEMAPREADER_DOCUMENTATION = "";
    public static final String OMSDATETIME2VALUEMAPREADER_KEYWORDS = "IO, Reading";
    public static final String OMSDATETIME2VALUEMAPREADER_LABEL = HASHMAP_READER;
    public static final String OMSDATETIME2VALUEMAPREADER_NAME = "datetime2valuemapreader";
    public static final int OMSDATETIME2VALUEMAPREADER_STATUS = 5;
    public static final String OMSDATETIME2VALUEMAPREADER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSDATETIME2VALUEMAPREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSDATETIME2VALUEMAPREADER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSDATETIME2VALUEMAPREADER_UI = "hide";
    public static final String OMSDATETIME2VALUEMAPREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String OMSDATETIME2VALUEMAPREADER_P_COLS_DESCRIPTION = "The number of columns of the array.";
    public static final String OMSDATETIME2VALUEMAPREADER_P_SEPARATOR_DESCRIPTION = "The csv separator.";
    public static final String OMSDATETIME2VALUEMAPREADER_FILE_NOVALUE_DESCRIPTION = "The file novalue.";
    public static final String OMSDATETIME2VALUEMAPREADER_DATA_DESCRIPTION = "The read map of ids and values arrays.";

    public static final String GRASSMOSAICLEGACY_DESCRIPTION = "Module for GRASS raster patching.";
    public static final String GRASSMOSAICLEGACY_DOCUMENTATION = "GrassMosaicLegacy.html";
    public static final String GRASSMOSAICLEGACY_KEYWORDS = "OmsMosaic, Raster";
    public static final String GRASSMOSAICLEGACY_LABEL = OTHER;
    public static final String GRASSMOSAICLEGACY_NAME = "grassmosaic";
    public static final int GRASSMOSAICLEGACY_STATUS = 5;
    public static final String GRASSMOSAICLEGACY_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String GRASSMOSAICLEGACY_AUTHORNAMES = "Andrea Antonello";
    public static final String GRASSMOSAICLEGACY_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String GRASSMOSAICLEGACY_IN_FILES_DESCRIPTION = "The list of files that have to be patched (used if inGeodata is null).";
    public static final String GRASSMOSAICLEGACY_P_RES_DESCRIPTION = "The output file resolution in meters.";
    public static final String GRASSMOSAICLEGACY_P_BOUNDS_DESCRIPTION = "The optional requested boundary coordinates as array of [n, s, w, e].";
    public static final String GRASSMOSAICLEGACY_OUT_GRASS_FILE_DESCRIPTION = "The GRASS file path to which to write to.";

    public static final String OMSMOSAIC_DESCRIPTION = "Module for raster patching.";
    public static final String OMSMOSAIC_DOCUMENTATION = "OmsMosaic.html";
    public static final String OMSMOSAIC_KEYWORDS = "OmsMosaic, Raster";
    public static final String OMSMOSAIC_LABEL = RASTERPROCESSING;
    public static final String OMSMOSAIC_NAME = "mosaic";
    public static final int OMSMOSAIC_STATUS = 40;
    public static final String OMSMOSAIC_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSMOSAIC_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSMOSAIC_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSMOSAIC_IN_FILES_DESCRIPTION = "The list of maps that have to be patched.";
    public static final String OMSMOSAIC_P_INTERPOLATION_DESCRIPTION = "The interpolation type to use";
    public static final String OMSMOSAIC_OUT_RASTER_DESCRIPTION = "The patched map.";

    public static final String EXIFGPSWRITER_DESCRIPTION = "Utility class for writing exif tags in jpegs.";
    public static final String EXIFGPSWRITER_DOCUMENTATION = "";
    public static final String EXIFGPSWRITER_KEYWORDS = "IO, Jpeg, Exif, Reading";
    public static final String EXIFGPSWRITER_LABEL = OTHER;
    public static final String EXIFGPSWRITER_NAME = "exifgpswriter";
    public static final int EXIFGPSWRITER_STATUS = 10;
    public static final String EXIFGPSWRITER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String EXIFGPSWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String EXIFGPSWRITER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String EXIFGPSWRITER_FILE_DESCRIPTION = "The jpeg file.";
    public static final String EXIFGPSWRITER_P_LAT_DESCRIPTION = "The latitude to add to the exif tags.";
    public static final String EXIFGPSWRITER_P_LON_DESCRIPTION = "The longitude to add to the exif tags.";
    public static final String EXIFGPSWRITER_T_TIMESTAMP_DESCRIPTION = "The timestamp to add to the exif tags (format yyyy-MM-dd HH:mm:ss).";
    public static final String EXIFGPSWRITER_P_ALTITUDE_DESCRIPTION = "The altidude in meters to add to the exif tags.";
    public static final String EXIFGPSWRITER_DO_NORTH_DESCRIPTION = "Switch to define if latitude is northern or southern hemisphere (default is true, i.e northern).";
    public static final String EXIFGPSWRITER_DO_EAST_DESCRIPTION = "Switch to define if longitude is eastern or western part (default is true, i.e eastern).";

    public static final String OMSCSVMATRIXREADER_DESCRIPTION = "Utility class for reading data from a OMS formatted csv file to a double matrix (dates are saved as longs).";
    public static final String OMSCSVMATRIXREADER_DOCUMENTATION = "";
    public static final String OMSCSVMATRIXREADER_KEYWORDS = "IO, Reading, csv";
    public static final String OMSCSVMATRIXREADER_LABEL = MATRIXREADER;
    public static final String OMSCSVMATRIXREADER_NAME = "csvmatrixreader";
    public static final int OMSCSVMATRIXREADER_STATUS = 5;
    public static final String OMSCSVMATRIXREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSCSVMATRIXREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSCSVMATRIXREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSCSVMATRIXREADER_UI = "hide";
    public static final String OMSCSVMATRIXREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String OMSCSVMATRIXREADER_FILE_NOVALUE_DESCRIPTION = "The file novalue to be translated into the internal novalue (defaults to -9999.0). Can be also a string.";
    public static final String OMSCSVMATRIXREADER_NOVALUE_DESCRIPTION = "The internal novalue to use (defaults to NaN).";
    public static final String OMSCSVMATRIXREADER_OUT_DATA_DESCRIPTION = "The matrix of read data.";
    public static final String OMSCSVMATRIXREADER_OUT_TITLE_DESCRIPTION = "The data title.";
    public static final String OMSCSVMATRIXREADER_OUT_SUBTITLE_DESCRIPTION = "The data subtitle.";
    public static final String OMSCSVMATRIXREADER_OUT_IDS_DESCRIPTION = "The data series names.";
    public static final String OMSCSVMATRIXREADER_OUT_LABELS_DESCRIPTION = "The data labels or null.";
    public static final String OMSCSVMATRIXREADER_OUT_FORMATS_DESCRIPTION = "The data formats (dates and numeric formatting patterns) or null.";
    public static final String OMSCSVMATRIXREADER_OUT_TYPES_DESCRIPTION = "The data types (dates or numerics like double, int) or null.";

    public static final String OMSTIMESERIESWRITER_DESCRIPTION = "Utility class for writing a set of timestamps and an array of values to an OMS formatted csv file.";
    public static final String OMSTIMESERIESWRITER_DOCUMENTATION = "OmsTimeSeriesWriter.html";
    public static final String OMSTIMESERIESWRITER_KEYWORDS = "IO, Writing";
    public static final String OMSTIMESERIESWRITER_LABEL = HASHMAP_WRITER;
    public static final String OMSTIMESERIESWRITER_NAME = "tswriter";
    public static final int OMSTIMESERIESWRITER_STATUS = 40;
    public static final String OMSTIMESERIESWRITER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSTIMESERIESWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSTIMESERIESWRITER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSTIMESERIESWRITER_FILE_DESCRIPTION = "The csv file to write to.";
    public static final String OMSTIMESERIESWRITER_TABLE_NAME_DESCRIPTION = "The table name.";
    public static final String OMSTIMESERIESWRITER_IN_DATA_DESCRIPTION = "The hashmap of data to write. IMPORTANT: The hashmap is assumed to be sorted.";
    public static final String OMSTIMESERIESWRITER_DO_DATES_DESCRIPTION = "A switch that defines whether to write the timestamps as dates or as intervals of seconds if a date doesn't make sense.";
    public static final String OMSTIMESERIESWRITER_COLUMNS_DESCRIPTION = "The comma separated list of column names.";
    public static final String OMSTIMESERIESWRITER_IN_META_DATA_DESCRIPTION = "A list of lists of metadata that can be attached to the column of the csv file.";

    public static final String OMSDXFCONVERTER_DESCRIPTION = "Module to convert dxf files to geotools vecotors.";
    public static final String OMSDXFCONVERTER_DOCUMENTATION = "OmsDxfConverter.html";
    public static final String OMSDXFCONVERTER_KEYWORDS = "IO, OmsDwgConverter, Feature, Vector, Reading";
    public static final String OMSDXFCONVERTER_LABEL = VECTORPROCESSING;
    public static final String OMSDXFCONVERTER_NAME = "dxfimport";
    public static final int OMSDXFCONVERTER_STATUS = 40;
    public static final String OMSDXFCONVERTER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSDXFCONVERTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSDXFCONVERTER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSDXFCONVERTER_FILE_DESCRIPTION = "The dxf file.";
    public static final String OMSDXFCONVERTER_P_CODE_DESCRIPTION = "The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328). Applied in the case the file is missing.";
    public static final String OMSDXFCONVERTER_POINTS_VECTOR_DESCRIPTION = "The output point vector.";
    public static final String OMSDXFCONVERTER_LINE_VECTOR_DESCRIPTION = "The output lines vector.";
    public static final String OMSDXFCONVERTER_POLYGON_VECTOR_DESCRIPTION = "The output polygons vector.";

    public static final String OMSGRIDGEOMETRYREADER_DESCRIPTION = "GridGeometry reader module.";
    public static final String OMSGRIDGEOMETRYREADER_DOCUMENTATION = "";
    public static final String OMSGRIDGEOMETRYREADER_KEYWORDS = "IO, GridGeometry, Raster, Reading";
    public static final String OMSGRIDGEOMETRYREADER_LABEL = GRIDGEOMETRYREADER;
    public static final String OMSGRIDGEOMETRYREADER_NAME = "gridgeomreader";
    public static final int OMSGRIDGEOMETRYREADER_STATUS = 40;
    public static final String OMSGRIDGEOMETRYREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSGRIDGEOMETRYREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSGRIDGEOMETRYREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSGRIDGEOMETRYREADER_P_NORTH_DESCRIPTION = "The boundary north coordinate.";
    public static final String OMSGRIDGEOMETRYREADER_P_SOUTH_DESCRIPTION = "The boundary south coordinate.";
    public static final String OMSGRIDGEOMETRYREADER_P_WEST_DESCRIPTION = "The boundary west coordinate.";
    public static final String OMSGRIDGEOMETRYREADER_P_EAST_DESCRIPTION = "The boundary east coordinate.";
    public static final String OMSGRIDGEOMETRYREADER_P_X_RES_DESCRIPTION = "The resolution in x.";
    public static final String OMSGRIDGEOMETRYREADER_P_Y_RES_DESCRIPTION = "The resolution in y.";
    public static final String OMSGRIDGEOMETRYREADER_P_CODE_DESCRIPTION = "The code defining the coordinate reference system, composed by authority and code number (ex. EPSG:4328).";
    public static final String OMSGRIDGEOMETRYREADER_OUT_GRID_GEOM_DESCRIPTION = "The output GridGeometry.";

    public static final String OMSRASTERVALUEROUNDER_DESCRIPTION = "Module that rounds the values of a raster map.";
    public static final String OMSRASTERVALUEROUNDER_DOCUMENTATION = "";
    public static final String OMSRASTERVALUEROUNDER_KEYWORDS = "Round, Raster";
    public static final String OMSRASTERVALUEROUNDER_LABEL = RASTERPROCESSING;
    public static final String OMSRASTERVALUEROUNDER_NAME = "rround";
    public static final int OMSRASTERVALUEROUNDER_STATUS = 40;
    public static final String OMSRASTERVALUEROUNDER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERVALUEROUNDER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERVALUEROUNDER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSRASTERVALUEROUNDER_IN_RASTER_DESCRIPTION = "The raster of which to round the values.";
    public static final String OMSRASTERVALUEROUNDER_P_PATTERN_DESCRIPTION = "The rounding pattern.";
    public static final String OMSRASTERVALUEROUNDER_OUT_RASTER_DESCRIPTION = "The rounded raster.";

    public static final String OMSMARCHINGSQUARESVECTORIALIZER_DESCRIPTION = "Module for raster to vector conversion";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_DOCUMENTATION = "";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_KEYWORDS = "Raster, Vector";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_LABEL = VECTORPROCESSING;
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_NAME = "marchingsquaresvectorizer";
    public static final int OMSMARCHINGSQUARESVECTORIALIZER_STATUS = 10;
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_AUTHORNAMES = "Andrea Antonello, Daniele Andreis";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_UI = "hide";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_IN_GEODATA_DESCRIPTION = "The coverage that has to be converted.";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_P_VALUE_DESCRIPTION = "The value to use to trace the polygons. If it is null then all the value of the raster are used";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_DEFAULT_FEATURE_FIELD_DESCRIPTION = "The value to use as a name for the raster value in the Feature.";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_P_THRES_DESCRIPTION = "A threshold on cell number to filter away polygons with cells less than that.";
    public static final String OMSMARCHINGSQUARESVECTORIALIZER_OUT_GEODATA_DESCRIPTION = "The extracted features.";

    public static final String OMSRASTERTRANSFORMER_DESCRIPTION = "Module for raster tranforms.";
    public static final String OMSRASTERTRANSFORMER_DOCUMENTATION = "";
    public static final String OMSRASTERTRANSFORMER_KEYWORDS = "Transform, Raster";
    public static final String OMSRASTERTRANSFORMER_LABEL = RASTERPROCESSING;
    public static final String OMSRASTERTRANSFORMER_NAME = "rtrans";
    public static final int OMSRASTERTRANSFORMER_STATUS = 10;
    public static final String OMSRASTERTRANSFORMER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSRASTERTRANSFORMER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSRASTERTRANSFORMER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSRASTERTRANSFORMER_IN_RASTER_DESCRIPTION = "The raster that has to be transformed.";
    public static final String OMSRASTERTRANSFORMER_P_INTERPOLATION_DESCRIPTION = "The interpolation type to use";
    public static final String OMSRASTERTRANSFORMER_P_TRANS_X_DESCRIPTION = "The translation along the X axis.";
    public static final String OMSRASTERTRANSFORMER_P_TRANS_Y_DESCRIPTION = "The translation along the Y axis.";
    public static final String OMSRASTERTRANSFORMER_P_SCALE_X_DESCRIPTION = "The scale factor along X axis.";
    public static final String OMSRASTERTRANSFORMER_P_SCALE_Y_DESCRIPTION = "The scale factor along the Y axis.";
    public static final String OMSRASTERTRANSFORMER_DO_FLIP_HORIZONTAL_DESCRIPTION = "Flip horizontally.";
    public static final String OMSRASTERTRANSFORMER_DO_FLIP_VERTICAL_DESCRIPTION = "Flip vertically.";
    public static final String OMSRASTERTRANSFORMER_P_NORTH_DESCRIPTION = "The northern coordinate of the rotation point.";
    public static final String OMSRASTERTRANSFORMER_P_EAST_DESCRIPTION = "The eastern coordinate of the rotation point.";
    public static final String OMSRASTERTRANSFORMER_P_ANGLE_DESCRIPTION = "The rotation angle in degree (rotation is performed before translation).";
    public static final String OMSRASTERTRANSFORMER_OUT_RASTER_DESCRIPTION = "The transformed raster.";
    public static final String OMSRASTERTRANSFORMER_OUT_BOUNDS_DESCRIPTION = "The new raster geometry.";

    public static final String OMSLINESMOOTHERJAITOOLS_DESCRIPTION = "The line smoother from the jaitools project.";
    public static final String OMSLINESMOOTHERJAITOOLS_DOCUMENTATION = "OmsLineSmootherJaitools.html";
    public static final String OMSLINESMOOTHERJAITOOLS_KEYWORDS = "Smoothing, Vector";
    public static final String OMSLINESMOOTHERJAITOOLS_LABEL = VECTORPROCESSING;
    public static final String OMSLINESMOOTHERJAITOOLS_NAME = "linesmootherjai";
    public static final int OMSLINESMOOTHERJAITOOLS_STATUS = 40;
    public static final String OMSLINESMOOTHERJAITOOLS_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSLINESMOOTHERJAITOOLS_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSLINESMOOTHERJAITOOLS_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSLINESMOOTHERJAITOOLS_IN_VECTOR_DESCRIPTION = "The vector containing the lines to be smoothed.";
    public static final String OMSLINESMOOTHERJAITOOLS_P_ALPHA_DESCRIPTION = "A value between 0 and 1 (inclusive) specifying the tightness of fit of the smoothed boundary (0 is loose).";
    public static final String OMSLINESMOOTHERJAITOOLS_OUT_VECTOR_DESCRIPTION = "The smoothed features.";

    public static final String OMSPOLYGONSMOOTHERJAITOOLS_DESCRIPTION = "The polygon smoother from the jaitools project.";
    public static final String OMSPOLYGONSMOOTHERJAITOOLS_KEYWORDS = "Smoothing, Vector";
    public static final String OMSPOLYGONSMOOTHERJAITOOLS_LABEL = VECTORPROCESSING;
    public static final String OMSPOLYGONSMOOTHERJAITOOLS_NAME = "polygonsmootherjai";
    public static final int OMSPOLYGONSMOOTHERJAITOOLS_STATUS = 40;
    public static final String OMSPOLYGONSMOOTHERJAITOOLS_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSPOLYGONSMOOTHERJAITOOLS_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSPOLYGONSMOOTHERJAITOOLS_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSPOLYGONSMOOTHERJAITOOLS_IN_VECTOR_DESCRIPTION = "The vector containing the polygons to be smoothed.";
    public static final String OMSPOLYGONSMOOTHERJAITOOLS_P_ALPHA_DESCRIPTION = "A value between 0 and 1 (inclusive) specifying the tightness of fit of the smoothed boundary (0 is loose).";
    public static final String OMSPOLYGONSMOOTHERJAITOOLS_OUT_VECTOR_DESCRIPTION = "The smoothed features.";

    public static final String OMSFEATURESLISTER_DESCRIPTION = "A module that reads vectors.";
    public static final String OMSFEATURESLISTER_DOCUMENTATION = "";
    public static final String OMSFEATURESLISTER_KEYWORDS = "Iterator, Vector";
    public static final String OMSFEATURESLISTER_LABEL = LIST_READER;
    public static final String OMSFEATURESLISTER_NAME = "vectorlister";
    public static final int OMSFEATURESLISTER_STATUS = 40;
    public static final String OMSFEATURESLISTER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSFEATURESLISTER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSFEATURESLISTER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSFEATURESLISTER_IN_FILES_DESCRIPTION = "The list of file from which to read features.";
    public static final String OMSFEATURESLISTER_OUT_FC_DESCRIPTION = "All features read from the input files.";

    public static final String OMSCOVERAGEVIEWER_DESCRIPTION = "Utility class for viewing coverages.";
    public static final String OMSCOVERAGEVIEWER_DOCUMENTATION = "";
    public static final String OMSCOVERAGEVIEWER_KEYWORDS = "Coverage, Raster, Viewer, UI";
    public static final String OMSCOVERAGEVIEWER_LABEL = OTHER;
    public static final String OMSCOVERAGEVIEWER_NAME = "coverageviewer";
    public static final int OMSCOVERAGEVIEWER_STATUS = 40;
    public static final String OMSCOVERAGEVIEWER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSCOVERAGEVIEWER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSCOVERAGEVIEWER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSCOVERAGEVIEWER_UI = "hide";
    public static final String OMSCOVERAGEVIEWER_RASTER_DESCRIPTION = "The coverage to visualize.";

    public static final String OMSIMAGEMOSAICCREATOR_DESCRIPTION = "Module for creating an mosaic shapefile for images.";
    public static final String OMSIMAGEMOSAICCREATOR_DOCUMENTATION = "";
    public static final String OMSIMAGEMOSAICCREATOR_KEYWORDS = "Imagemosaic, Raster";
    public static final String OMSIMAGEMOSAICCREATOR_LABEL = RASTERPROCESSING;
    public static final String OMSIMAGEMOSAICCREATOR_NAME = "imagemosaic";
    public static final int OMSIMAGEMOSAICCREATOR_STATUS = 40;
    public static final String OMSIMAGEMOSAICCREATOR_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSIMAGEMOSAICCREATOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSIMAGEMOSAICCREATOR_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSIMAGEMOSAICCREATOR_IN_FOLDER_DESCRIPTION = "The folder containing the images to mosaic.";

    public static final String OMSEIALTIMETRYREADER_DESCRIPTION = "Utility class for reading altimetry data from csv files.";
    public static final String OMSEIALTIMETRYREADER_DOCUMENTATION = "";
    public static final String OMSEIALTIMETRYREADER_KEYWORDS = "IO, Reading";
    public static final String OMSEIALTIMETRYREADER_LABEL = LIST_READER;
    public static final String OMSEIALTIMETRYREADER_NAME = "eialtimetryreader";
    public static final int OMSEIALTIMETRYREADER_STATUS = 40;
    public static final String OMSEIALTIMETRYREADER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSEIALTIMETRYREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSEIALTIMETRYREADER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSEIALTIMETRYREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String OMSEIALTIMETRYREADER_P_SEPARATOR_DESCRIPTION = "The csv separator.";
    public static final String OMSEIALTIMETRYREADER_OUT_ALTIMETRY_DESCRIPTION = "The read data.";

    public static final String OMSEIALTIMETRYWRITER_DESCRIPTION = "Utility class for writing altimetry data to csv files.";
    public static final String OMSEIALTIMETRYWRITER_DOCUMENTATION = "eialtimetrywriter";
    public static final String OMSEIALTIMETRYWRITER_KEYWORDS = "IO, Writing";
    public static final String OMSEIALTIMETRYWRITER_LABEL = LIST_WRITER;
    public static final String OMSEIALTIMETRYWRITER_NAME = "eialtimetrywriter";
    public static final int OMSEIALTIMETRYWRITER_STATUS = 40;
    public static final String OMSEIALTIMETRYWRITER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSEIALTIMETRYWRITER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSEIALTIMETRYWRITER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSEIALTIMETRYWRITER_IN_ALTIMETRY_DESCRIPTION = "The data to write.";
    public static final String OMSEIALTIMETRYWRITER_FILE_DESCRIPTION = "The csv file to write to.";
    public static final String OMSEIALTIMETRYWRITER_P_SEPARATOR_DESCRIPTION = "The csv separator.";

    public static final String ADIGEBOUNDARYCONDITIONREADER_DESCRIPTION = "Utility class for reading the initial boundary conditions of the model adige from an OMS formatted csv file.";
    public static final String ADIGEBOUNDARYCONDITIONREADER_DOCUMENTATION = "";
    public static final String ADIGEBOUNDARYCONDITIONREADER_KEYWORDS = "IO, Reading";
    public static final String ADIGEBOUNDARYCONDITIONREADER_LABEL = GENERICREADER;
    public static final String ADIGEBOUNDARYCONDITIONREADER_NAME = "adigeboundcondreader";
    public static final int ADIGEBOUNDARYCONDITIONREADER_STATUS = 40;
    public static final String ADIGEBOUNDARYCONDITIONREADER_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String ADIGEBOUNDARYCONDITIONREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String ADIGEBOUNDARYCONDITIONREADER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String ADIGEBOUNDARYCONDITIONREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String ADIGEBOUNDARYCONDITIONREADER_DATA_DESCRIPTION = "The list initial boundary conditions.";

    public static final String OMSBOBTHEBUILDER_DESCRIPTION = "Builds rasterized artifacts on a raster.";
    public static final String OMSBOBTHEBUILDER_DOCUMENTATION = "";
    public static final String OMSBOBTHEBUILDER_KEYWORDS = "Build, Raster";
    public static final String OMSBOBTHEBUILDER_LABEL = RASTERPROCESSING;
    public static final String OMSBOBTHEBUILDER_NAME = "bobbuilder";
    public static final int OMSBOBTHEBUILDER_STATUS = 5;
    public static final String OMSBOBTHEBUILDER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSBOBTHEBUILDER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSBOBTHEBUILDER_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSBOBTHEBUILDER_IN_RASTER_DESCRIPTION = "The input raster.";
    public static final String OMSBOBTHEBUILDER_IN_AREA_DESCRIPTION = "The vector map containing the polygonal area to modify.";
    public static final String OMSBOBTHEBUILDER_IN_ELEVATIONS_DESCRIPTION = "The vector map containing the points that provide the new elevations.";
    public static final String OMSBOBTHEBUILDER_P_MAX_BUFFER_DESCRIPTION = "The maximum radius to use for interpolation.";
    public static final String OMSBOBTHEBUILDER_F_ELEVATION_DESCRIPTION = "The field of the elevations map that contain the elevation of the point.";
    public static final String OMSBOBTHEBUILDER_DO_ERODE_DESCRIPTION = "Switch that defines if the module should erode in places the actual raster is higher (default is false).";
    public static final String OMSBOBTHEBUILDER_DO_USE_ONLY_INTERNAL_DESCRIPTION = "Switch that defines if the module should use only points contained in the polygon for the interpolation (default is false. i.e. use all).";
    public static final String OMSBOBTHEBUILDER_DO_POLYGON_BORDER_DESCRIPTION = "Switch that defines if the module should add the border of the polygon as elevation point to aid connection between new and old (default is false).";
    public static final String OMSBOBTHEBUILDER_OUT_RASTER_DESCRIPTION = "The modified raster map.";

    public static final String OMSPOINTSRASTERIZER_DESCRIPTION = "Module to convert vector points to raster. Currently this does simply put the point in the nearest cell, without check.";
    public static final String OMSPOINTSRASTERIZER_DOCUMENTATION = "";
    public static final String OMSPOINTSRASTERIZER_KEYWORDS = "Raster, Vector, Points";
    public static final String OMSPOINTSRASTERIZER_LABEL = RASTERPROCESSING;
    public static final String OMSPOINTSRASTERIZER_NAME = "rasterizepoints";
    public static final int OMSPOINTSRASTERIZER_STATUS = 5;
    public static final String OMSPOINTSRASTERIZER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSPOINTSRASTERIZER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSPOINTSRASTERIZER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSPOINTSRASTERIZER_IN_VECTOR_DESCRIPTION = "The points vector.";
    public static final String OMSPOINTSRASTERIZER_IN_GRID_DESCRIPTION = "The grid on which to place the values.";
    public static final String OMSPOINTSRASTERIZER_F_CAT_DESCRIPTION = "The field of the vector to take the category from.";
    public static final String OMSPOINTSRASTERIZER_OUT_RASTER_DESCRIPTION = "The output raster.";

    public static final String OMSTIMESERIESITERATORREADER_DESCRIPTION = "Utility class for reading data from a OMS formatted csv file. The file needs a metadata line containing the id of the station. The table is supposed to have a first column of timestamp and all olther columns of data related to the ids defined.";
    public static final String OMSTIMESERIESITERATORREADER_DOCUMENTATION = "OmsTimeSeriesIteratorReader.html";
    public static final String OMSTIMESERIESITERATORREADER_KEYWORDS = "IO, Reading";
    public static final String OMSTIMESERIESITERATORREADER_LABEL = HASHMAP_READER;
    public static final String OMSTIMESERIESITERATORREADER_NAME = "tsitreader";
    public static final int OMSTIMESERIESITERATORREADER_STATUS = 40;
    public static final String OMSTIMESERIESITERATORREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSTIMESERIESITERATORREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSTIMESERIESITERATORREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSTIMESERIESITERATORREADER_FILE_DESCRIPTION = "The csv file to read from.";
    public static final String OMSTIMESERIESITERATORREADER_ID_FIELD_DESCRIPTION = "The id metadata field.";
    public static final String OMSTIMESERIESITERATORREADER_FILE_NOVALUE_DESCRIPTION = "The file novalue to be translated into the internal novalue. Can be a string also";
    public static final String OMSTIMESERIESITERATORREADER_NOVALUE_DESCRIPTION = "The internal novalue to use (usually not changed).";
    public static final String OMSTIMESERIESITERATORREADER_P_NUM_DESCRIPTION = "The number of rows to aggregate (default is 1, i.e. no aggregation).";
    public static final String OMSTIMESERIESITERATORREADER_P_AGGREGATION_DESCRIPTION = "The aggregation type to use (0 = sum, 1 = avg).";
    public static final String OMSTIMESERIESITERATORREADER_T_CURRENT_DESCRIPTION = "The current time read (format: yyyy-MM-dd HH:mm ).";
    public static final String OMSTIMESERIESITERATORREADER_T_PREVIOUS_DESCRIPTION = "The previous time read (format: yyyy-MM-dd HH:mm ).";
    public static final String OMSTIMESERIESITERATORREADER_OUT_DATA_DESCRIPTION = "The read map of ids and values.";
    public static final String OMSTIMESERIESITERATORREADER_T_START_DESCRIPTION = "The optional time at which start to read (format: yyyy-MM-dd HH:mm ).";
    public static final String OMSTIMESERIESITERATORREADER_T_END_DESCRIPTION = "The optional time at which end to read (format: yyyy-MM-dd HH:mm ).";
    public static final String OMSTIMESERIESITERATORREADER_T_TIMESTEP_DESCRIPTION = "The reading timestep in minutes.";

    public static final String OMSPOINTDIRECTIONCALCULATOR_DESCRIPTION = "Calculates the direction of maximum slope for a source point on a dem.";
    public static final String OMSPOINTDIRECTIONCALCULATOR_DOCUMENTATION = "";
    public static final String OMSPOINTDIRECTIONCALCULATOR_KEYWORDS = "Raster, Vector";
    public static final String OMSPOINTDIRECTIONCALCULATOR_LABEL = VECTORPROCESSING;
    public static final String OMSPOINTDIRECTIONCALCULATOR_NAME = "pointdirectioncalculator";
    public static final int OMSPOINTDIRECTIONCALCULATOR_STATUS = 10;
    public static final String OMSPOINTDIRECTIONCALCULATOR_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSPOINTDIRECTIONCALCULATOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSPOINTDIRECTIONCALCULATOR_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSPOINTDIRECTIONCALCULATOR_IN_SOURCES_DESCRIPTION = "The source point features.";
    public static final String OMSPOINTDIRECTIONCALCULATOR_P_RES_DESCRIPTION = "Resolution to use.";
    public static final String OMSPOINTDIRECTIONCALCULATOR_IN_COVERAGE_DESCRIPTION = "The input coverage.";
    public static final String OMSPOINTDIRECTIONCALCULATOR_OUT_SOURCES_DESCRIPTION = "The source point features with the added azimuth angle.";

    public static final String OMSLINEINTERSECTIONCORRECTOR_DESCRIPTION = "Collection of Smoothing Algorithms. Type 0: McMasters Sliding Averaging Algorithm. The new position of each point is the average of the pLookahead  points around. Parameter pSlide is used for linear interpolation between old and new position.";
    public static final String OMSLINEINTERSECTIONCORRECTOR_DOCUMENTATION = "";
    public static final String OMSLINEINTERSECTIONCORRECTOR_KEYWORDS = "Smoothing, Vector";
    public static final String OMSLINEINTERSECTIONCORRECTOR_LABEL = VECTORPROCESSING;
    public static final String OMSLINEINTERSECTIONCORRECTOR_NAME = "lineintersectioncorrector";
    public static final int OMSLINEINTERSECTIONCORRECTOR_STATUS = 10;
    public static final String OMSLINEINTERSECTIONCORRECTOR_LICENSE = "http://www.gnu.org/licenses/gpl-3.0.html";
    public static final String OMSLINEINTERSECTIONCORRECTOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSLINEINTERSECTIONCORRECTOR_AUTHORCONTACTS = "www.hydrologis.com";
    public static final String OMSLINEINTERSECTIONCORRECTOR_LINES_FEATURES_DESCRIPTION = "The features to be corrected.";
    public static final String OMSLINEINTERSECTIONCORRECTOR_POINT_FEATURES_DESCRIPTION = "The point features that define intersections.";
    public static final String OMSLINEINTERSECTIONCORRECTOR_P_BUFFER_DESCRIPTION = "Protection buffer.";
    public static final String OMSLINEINTERSECTIONCORRECTOR_F_SORT_DESCRIPTION = "Field name of sorting attribute.";
    public static final String OMSLINEINTERSECTIONCORRECTOR_DO_REVERSE_DESCRIPTION = "Sorting order (default is true).";
    public static final String OMSLINEINTERSECTIONCORRECTOR_UNTOUCHED_FEATURES_DESCRIPTION = "The untouched features.";
    public static final String OMSLINEINTERSECTIONCORRECTOR_CORRECTED_FEATURES_DESCRIPTION = "The corrected features.";
    public static final String OMSLINEINTERSECTIONCORRECTOR_ERROR_FEATURES_DESCRIPTION = "The non corrected features.";

    public static final String OMSSHAPEFILEFEATUREREADER_DESCRIPTION = "Utility class for reading shapefiles to geotools featurecollections.";
    public static final String OMSSHAPEFILEFEATUREREADER_DOCUMENTATION = "";
    public static final String OMSSHAPEFILEFEATUREREADER_KEYWORDS = "IO, Shapefile, Feature, Vector, Reading";
    public static final String OMSSHAPEFILEFEATUREREADER_LABEL = FEATUREREADER;
    public static final String OMSSHAPEFILEFEATUREREADER_NAME = "shapefilefeaturereader";
    public static final int OMSSHAPEFILEFEATUREREADER_STATUS = 40;
    public static final String OMSSHAPEFILEFEATUREREADER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSSHAPEFILEFEATUREREADER_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSSHAPEFILEFEATUREREADER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSSHAPEFILEFEATUREREADER_UI = "hide";
    public static final String OMSSHAPEFILEFEATUREREADER_FILE_DESCRIPTION = "The shapefile.";
    public static final String OMSSHAPEFILEFEATUREREADER_GEODATA_DESCRIPTION = "The read feature collection.";

    public static final String OMSVECTORRESHAPER_DESCRIPTION = "Module to reshape a vector.";
    public static final String OMSVECTORRESHAPER_DOCUMENTATION = "OmsVectorReshaper.html";
    public static final String OMSVECTORRESHAPER_KEYWORDS = "Reshape, Vector, OmsVectorFilter";
    public static final String OMSVECTORRESHAPER_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORRESHAPER_NAME = "reshape";
    public static final int OMSVECTORRESHAPER_STATUS = 40;
    public static final String OMSVECTORRESHAPER_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORRESHAPER_AUTHORNAMES = "Andrea Antonello, Jody Garnett";
    public static final String OMSVECTORRESHAPER_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORRESHAPER_IN_VECTOR_DESCRIPTION = "The vector to reshape.";
    public static final String OMSVECTORRESHAPER_P_CQL_DESCRIPTION = "The ECQL reshape function.";
    public static final String OMSVECTORRESHAPER_P_REMOVE_DESCRIPTION = "The list of fields to remove, comma separated.";
    public static final String OMSVECTORRESHAPER_OUT_VECTOR_DESCRIPTION = "The new reshaped vector.";

    public static final String OMSVECTORREPROJECTOR_DESCRIPTION = "Module for vector reprojection.";
    public static final String OMSVECTORREPROJECTOR_DOCUMENTATION = "OmsVectorReprojector.html";
    public static final String OMSVECTORREPROJECTOR_KEYWORDS = "CRS, Reprojection, Vector";
    public static final String OMSVECTORREPROJECTOR_LABEL = VECTORPROCESSING;
    public static final String OMSVECTORREPROJECTOR_NAME = "vreproject";
    public static final int OMSVECTORREPROJECTOR_STATUS = 40;
    public static final String OMSVECTORREPROJECTOR_LICENSE = "General Public License Version 3 (GPLv3)";
    public static final String OMSVECTORREPROJECTOR_AUTHORNAMES = "Andrea Antonello";
    public static final String OMSVECTORREPROJECTOR_AUTHORCONTACTS = "http://www.hydrologis.com";
    public static final String OMSVECTORREPROJECTOR_IN_VECTOR_DESCRIPTION = "The vector that has to be reprojected.";
    public static final String OMSVECTORREPROJECTOR_P_CODE_DESCRIPTION = "The code defining the target coordinate reference system, composed by authority and code number (ex. EPSG:4328).";
    public static final String OMSVECTORREPROJECTOR_DO_LONGITUDE_FIRST_DESCRIPTION = "A flag to modify the axes order.";
    public static final String OMSVECTORREPROJECTOR_P_FORCE_CODE_DESCRIPTION = "A coordinate reference system on which to force the input, composed by authority and code number (ex. EPSG:4328).";
    public static final String OMSVECTORREPROJECTOR_DO_LENIENT_DESCRIPTION = "Switch that set to true allows for some error due to different datums. If set to false, it won't reproject without Bursa Wolf parameters.";
    public static final String OMSVECTORREPROJECTOR_OUT_VECTOR_DESCRIPTION = "The output reprojected vector.";

    private GearsMessages() {}

}
