/*
 * JGrass - Free Open Source Java GIS http://www.jgrass.org 
 * (C) HydroloGIS - www.hydrologis.com 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option) any
 * later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.hortonmachine.gears.io.dxfdwg.libs.dwg.utils;

/**
 * Class that contains the tables for Autocad to Unicode text conversions
 * 
 * @author jmorell
 */
class Unicode {
    private static final char UCNONE = 65535;
    private static final char unicode[][] = {
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\177', '\200', '\201', '\202', '\203',
                    '\204', '\205', '\206', '\207', '\210', '\211', '\212', '\213', '\214', '\215', '\216', '\217', '\220',
                    '\221', '\222', '\223', '\224', '\225', '\226', '\227', '\230', '\231', '\232', '\233', '\234', '\235',
                    '\236', '\237', '\240', '\241', '\242', '\243', '\244', '\245', '\246', '\247', '\250', '\251', '\252',
                    '\253', '\254', '\255', '\256', '\257', '\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
                    '\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277', '\300', '\301', '\302', '\303', '\304',
                    '\305', '\306', '\307', '\310', '\311', '\312', '\313', '\314', '\315', '\316', '\317', '\320', '\321',
                    '\322', '\323', '\324', '\325', '\326', '\327', '\330', '\331', '\332', '\333', '\334', '\335', '\336',
                    '\337', '\340', '\341', '\342', '\343', '\344', '\345', '\346', '\347', '\350', '\351', '\352', '\353',
                    '\354', '\355', '\356', '\357', '\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367', '\370',
                    '\371', '\372', '\373', '\374', '\375', '\376', '\377'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\177', '\200', '\201', '\202', '\203',
                    '\204', '\205', '\206', '\207', '\210', '\211', '\212', '\213', '\214', '\215', '\216', '\217', '\220',
                    '\221', '\222', '\223', '\224', '\225', '\226', '\227', '\230', '\231', '\232', '\233', '\234', '\235',
                    '\236', '\237', '\240', '\u0104', '\u02D8', '\u0141', '\244', '\u013D', '\u015A', '\247', '\250', '\u0160',
                    '\u015E', '\u0164', '\u0179', '\255', '\u017D', '\u017B', '\260', '\u0105', '\u02DB', '\u0142', '\264',
                    '\u013E', '\u015B', '\u02C7', '\270', '\u0161', '\u015F', '\u0165', '\u017A', '\u02DD', '\u017E', '\u017C',
                    '\u0154', '\301', '\302', '\u0102', '\304', '\u0139', '\u0106', '\307', '\u010C', '\311', '\u0118', '\313',
                    '\u011A', '\315', '\316', '\u010E', '\u0110', '\u0143', '\u0147', '\323', '\324', '\u0150', '\326', '\327',
                    '\u0158', '\u016E', '\332', '\u0170', '\334', '\335', '\u0162', '\337', '\u0155', '\341', '\342', '\u0103',
                    '\344', '\u013A', '\u0107', '\347', '\u010D', '\351', '\u0119', '\353', '\u011B', '\355', '\356', '\u010F',
                    '\u0111', '\u0144', '\u0148', '\363', '\364', '\u0151', '\366', '\367', '\u0159', '\u016F', '\372', '\u0171',
                    '\374', '\375', '\u0163', '\u02D9'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\307', '\374', '\351',
                    '\342', '\344', '\340', '\345', '\347', '\352', '\353', '\350', '\357', '\356', '\354', '\304', '\305',
                    '\311', '\346', '\306', '\364', '\366', '\362', '\373', '\371', '\377', '\326', '\334', '\242', '\243',
                    '\245', '\u20A7', '\u0192', '\341', '\355', '\363', '\372', '\361', '\321', '\252', '\272', '\277', '\u2310',
                    '\254', '\275', '\274', '\241', '\253', '\273', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561',
                    '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255D', '\u255C', '\u255B', '\u2510', '\u2514',
                    '\u2534', '\u252C', '\u251C', '\u2500', '\u253C', '\u255E', '\u255F', '\u255A', '\u2554', '\u2569', '\u2566',
                    '\u2560', '\u2550', '\u256C', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553',
                    '\u256B', '\u256A', '\u2518', '\u250C', '\u2588', '\u2584', '\u258C', '\u2590', '\u2580', '\u03B1', '\337',
                    '\u0393', '\u03C0', '\u03A3', '\u03C3', '\265', '\u03C4', '\u03A6', '\u0398', '\u03A9', '\u03B4', '\u221E',
                    '\u03C6', '\u03B5', '\u2229', '\u2261', '\261', '\u2265', '\u2264', '\u2320', '\u2321', '\367', '\u2248',
                    '\260', '\u2219', '\267', '\u221A', '\u207F', '\262', '\u25A0', '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\307', '\374', '\351',
                    '\342', '\344', '\340', '\345', '\347', '\352', '\353', '\350', '\357', '\356', '\354', '\304', '\305',
                    '\311', '\346', '\306', '\364', '\366', '\362', '\373', '\371', '\377', '\326', '\334', '\370', '\243',
                    '\330', '\327', '\u0192', '\341', '\355', '\363', '\372', '\361', '\321', '\252', '\272', '\277', '\256',
                    '\254', '\275', '\274', '\241', '\253', '\273', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\301',
                    '\302', '\300', '\251', '\u2563', '\u2551', '\u2557', '\u255D', '\242', '\245', '\u2510', '\u2514', '\u2534',
                    '\u252C', '\u251C', '\u2500', '\u253C', '\343', '\303', '\u255A', '\u2554', '\u2569', '\u2566', '\u2560',
                    '\u2550', '\u256C', '\244', '\360', '\320', '\312', '\313', '\310', '\u0131', '\315', '\316', '\317',
                    '\u2518', '\u250C', '\u2588', '\u2584', '\246', '\314', '\u2580', '\323', '\337', '\324', '\322', '\365',
                    '\325', '\265', '\376', '\336', '\332', '\333', '\331', '\375', '\335', '\257', '\264', '\255', '\261',
                    '\u2017', '\276', '\266', '\247', '\367', '\270', '\260', '\250', '\267', '\271', '\263', '\262', '\u25A0',
                    '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\307', '\374', '\351',
                    '\342', '\344', '\u016F', '\u0107', '\347', '\u0142', '\353', '\u0150', '\u0151', '\356', '\u0179', '\304',
                    '\u0106', '\311', '\u0139', '\u013A', '\364', '\366', '\u013D', '\u013E', '\u015A', '\u015B', '\326', '\334',
                    '\u0164', '\u0165', '\u0141', '\327', '\u010D', '\341', '\355', '\363', '\372', '\u0104', '\u0105', '\u017D',
                    '\u017E', '\u0118', '\u0119', '\254', '\u017A', '\u010C', '\u015F', '\253', '\273', '\u2591', '\u2592',
                    '\u2593', '\u2502', '\u2524', '\301', '\302', '\u011A', '\u015E', '\u2563', '\u2551', '\u2557', '\u255D',
                    '\u017B', '\u017C', '\u2510', '\u2514', '\u2534', '\u252C', '\u251C', '\u2500', '\u253C', '\u0102', '\u0103',
                    '\u255A', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256C', '\244', '\u0111', '\u0110', '\u010E',
                    '\313', '\u010F', '\u0147', '\315', '\316', '\u011B', '\u2518', '\u250C', '\u2588', '\u2584', '\u0162',
                    '\u016E', '\u2580', '\323', '\337', '\324', '\u0143', '\u0144', '\u0148', '\u0160', '\u0161', '\u0154',
                    '\332', '\u0155', '\u0170', '\375', '\335', '\u0163', '\264', '\255', '\u02DD', '\u02DB', '\u02C7', '\u02D8',
                    '\247', '\367', '\270', '\260', '\250', '\u02D9', '\u0171', '\u0158', '\u0159', '\u25A0', '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\u0452', '\u0402', '\u0453',
                    '\u0403', '\u0451', '\u0401', '\u0454', '\u0404', '\u0455', '\u0405', '\u0456', '\u0406', '\u0457', '\u0407',
                    '\u0456', '\u0408', '\u0459', '\u0409', '\u045A', '\u040A', '\u045B', '\u040B', '\u045C', '\u040C', '\u045E',
                    '\u040E', '\u045F', '\u040F', '\u044E', '\u042E', '\u044A', '\u042A', '\u0430', '\u0410', '\u0431', '\u0411',
                    '\u0446', '\u0426', '\u0434', '\u0414', '\u0435', '\u0415', '\u0444', '\u0424', '\u0433', '\u0413', '\253',
                    '\273', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u0445', '\u0425', '\u0438', '\u0418', '\u2563',
                    '\u2551', '\u2557', '\u255D', '\u0439', '\u0419', '\u2510', '\u2514', '\u2534', '\u252C', '\u251C', '\u2500',
                    '\u253C', '\u043A', '\u041A', '\u255A', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256C', '\244',
                    '\u043B', '\u041B', '\u043C', '\u041C', '\u043D', '\u041D', '\u043E', '\u041E', '\u043F', '\u2518', '\u250C',
                    '\u2588', '\u2584', '\u041F', '\u044F', '\u2580', '\u042F', '\u0440', '\u0420', '\u0441', '\u0421', '\u0442',
                    '\u0422', '\u0443', '\u0423', '\u0436', '\u0416', '\u0432', '\u0412', '\u044C', '\u042C', '\u2116', '\255',
                    '\u044B', '\u042B', '\u0437', '\u0417', '\u0448', '\u0428', '\u044D', '\u042D', '\u0449', '\u0429', '\u0447',
                    '\u0427', '\uFFFF', '\u25A0', '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\307', '\374', '\351',
                    '\342', '\344', '\340', '\345', '\347', '\352', '\353', '\350', '\357', '\356', '\u0131', '\304', '\305',
                    '\311', '\346', '\306', '\364', '\366', '\362', '\373', '\371', '\u0130', '\326', '\334', '\370', '\243',
                    '\330', '\u015E', '\u015F', '\341', '\355', '\363', '\372', '\361', '\321', '\u011E', '\u011F', '\277',
                    '\256', '\254', '\275', '\274', '\241', '\253', '\273', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524',
                    '\301', '\302', '\300', '\251', '\u2563', '\u2551', '\u2557', '\u255D', '\242', '\245', '\u2510', '\u2514',
                    '\u2534', '\u252C', '\u251C', '\u2500', '\u253C', '\343', '\303', '\u255A', '\u2554', '\u2569', '\u2566',
                    '\u2560', '\u2550', '\u256C', '\244', '\272', '\252', '\312', '\313', '\310', '\uFFFF', '\315', '\316',
                    '\317', '\u2518', '\u250C', '\u2588', '\u2584', '\246', '\314', '\u2580', '\323', '\337', '\324', '\322',
                    '\365', '\325', '\265', '\uFFFF', '\327', '\332', '\333', '\331', '\354', '\377', '\257', '\264', '\255',
                    '\261', '\uFFFF', '\276', '\266', '\247', '\367', '\270', '\260', '\250', '\267', '\271', '\263', '\262',
                    '\u25A0', '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\307', '\374', '\351',
                    '\342', '\343', '\340', '\301', '\347', '\352', '\312', '\350', '\315', '\324', '\354', '\303', '\302',
                    '\311', '\300', '\310', '\364', '\365', '\362', '\332', '\371', '\314', '\325', '\334', '\242', '\243',
                    '\331', '\u20A7', '\323', '\341', '\355', '\363', '\372', '\361', '\321', '\252', '\272', '\277', '\322',
                    '\254', '\275', '\274', '\241', '\253', '\273', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561',
                    '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255D', '\u255C', '\u255B', '\u2510', '\u2514',
                    '\u2534', '\u252C', '\u251C', '\u2500', '\u253C', '\u255E', '\u255F', '\u255A', '\u2554', '\u2569', '\u2566',
                    '\u2560', '\u2550', '\u256C', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553',
                    '\u256B', '\u256A', '\u2518', '\u250C', '\u2588', '\u2584', '\u258C', '\u2590', '\u2580', '\u03B1', '\337',
                    '\u0393', '\u03C0', '\u03A3', '\u03C3', '\265', '\u03C4', '\u03A6', '\u0398', '\u03A9', '\u03B4', '\u221E',
                    '\u03C6', '\u03B5', '\u2229', '\u2261', '\261', '\u2265', '\u2264', '\u2320', '\u2321', '\367', '\u2248',
                    '\260', '\u2219', '\267', '\u221A', '\u207F', '\262', '\u25A0', '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\307', '\374', '\351',
                    '\342', '\343', '\340', '\345', '\347', '\352', '\353', '\350', '\320', '\360', '\336', '\304', '\305',
                    '\311', '\346', '\306', '\364', '\366', '\376', '\373', '\335', '\375', '\326', '\334', '\370', '\243',
                    '\330', '\u20A7', '\u0192', '\341', '\355', '\363', '\372', '\301', '\315', '\323', '\332', '\277', '\u2310',
                    '\254', '\275', '\274', '\241', '\253', '\273', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561',
                    '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255D', '\u255C', '\u255B', '\u2510', '\u2514',
                    '\u2534', '\u252C', '\u251C', '\u2500', '\u253C', '\u255E', '\u255F', '\u255A', '\u2554', '\u2569', '\u2566',
                    '\u2560', '\u2550', '\u256C', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553',
                    '\u256B', '\u256A', '\u2518', '\u250C', '\u2588', '\u2584', '\u258C', '\u2590', '\u2580', '\u03B1', '\337',
                    '\u0393', '\u03C0', '\u03A3', '\u03C3', '\265', '\u03C4', '\u03A6', '\u0398', '\u03A9', '\u03B4', '\u221E',
                    '\u03C6', '\u03B5', '\u2229', '\u2261', '\261', '\u2265', '\u2264', '\u2320', '\u2321', '\367', '\u2248',
                    '\260', '\u2219', '\267', '\u221A', '\u207F', '\262', '\u25A0', '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\307', '\374', '\351',
                    '\342', '\343', '\340', '\266', '\347', '\352', '\353', '\350', '\357', '\356', '\u2017', '\300', '\247',
                    '\311', '\310', '\312', '\364', '\313', '\317', '\373', '\371', '\244', '\324', '\334', '\242', '\243',
                    '\331', '\333', '\u0192', '\246', '\264', '\363', '\372', '\250', '\270', '\263', '\257', '\316', '\u2310',
                    '\254', '\275', '\274', '\276', '\253', '\273', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561',
                    '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255D', '\u255C', '\u255B', '\u2510', '\u2514',
                    '\u2534', '\u252C', '\u251C', '\u2500', '\u253C', '\u255E', '\u255F', '\u255A', '\u2554', '\u2569', '\u2566',
                    '\u2560', '\u2550', '\u256C', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553',
                    '\u256B', '\u256A', '\u2518', '\u250C', '\u2588', '\u2584', '\u258C', '\u2590', '\u2580', '\u03B1', '\337',
                    '\u0393', '\u03C0', '\u03A3', '\u03C3', '\265', '\u03C4', '\u03A6', '\u0398', '\u03A9', '\u03B4', '\u221E',
                    '\u03C6', '\u03B5', '\u2229', '\u2261', '\261', '\u2265', '\u2264', '\u2320', '\u2321', '\367', '\u2248',
                    '\260', '\u2219', '\267', '\u221A', '\u207F', '\262', '\u25A0', '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\260', '\267', '\u2219',
                    '\u221A', '\u2592', '\u2500', '\u2502', '\u253C', '\u2524', '\u252C', '\u251C', '\u2534', '\u2510', '\u250C',
                    '\u2514', '\u2518', '\u03B2', '\u221E', '\u03C6', '\261', '\275', '\274', '\u2248', '\253', '\273', '\uFEF7',
                    '\uFEF8', '\uFFFF', '\uFFFF', '\uFEFB', '\uFEFC', '\uFFFF', '\240', '\255', '\uFE82', '\243', '\244',
                    '\uFE84', '\uFFFF', '\uFFFF', '\uFE8E', '\uFE8F', '\uFE95', '\uFE99', '\u060C', '\uFE9D', '\uFEA1', '\uFEA5',
                    '\u0660', '\u0661', '\u0662', '\u0663', '\u0664', '\u0665', '\u0666', '\u0667', '\u0668', '\u0669', '\uFED1',
                    '\u061B', '\uFEB1', '\uFEB5', '\uFEB9', '\u061F', '\242', '\uFE80', '\uFE81', '\uFE83', '\uFE85', '\uFECC',
                    '\uFE8A', '\uFE8D', '\uFE90', '\uFE93', '\uFE96', '\uFE9A', '\uFE9E', '\uFEA2', '\uFEA6', '\uFEA9', '\uFEAB',
                    '\uFEAD', '\uFEAF', '\uFEB2', '\uFEB6', '\uFEBA', '\uFEBE', '\uFEC1', '\uFEC5', '\uFECA', '\uFECE', '\246',
                    '\254', '\367', '\327', '\uFEC9', '\u0640', '\uFED2', '\uFED6', '\uFEDA', '\uFEDE', '\uFEE2', '\uFEE6',
                    '\uFEEA', '\uFEED', '\uFEEF', '\uFEF2', '\uFEBD', '\uFECB', '\uFED0', '\uFECD', '\uFEE1', '\uFE7D', '\u0651',
                    '\uFEE5', '\uFEE9', '\uFEEB', '\uFEF0', '\uFEF4', '\uFECF', '\uFED5', '\uFEF5', '\uFEF6', '\uFEDD', '\uFED9',
                    '\uFEF1', '\u25A0', '\uFFFF'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\307', '\374', '\351',
                    '\342', '\344', '\340', '\265', '\347', '\352', '\353', '\350', '\357', '\356', '\354', '\304', '\305',
                    '\311', '\346', '\306', '\364', '\366', '\362', '\373', '\371', '\377', '\326', '\334', '\370', '\243',
                    '\330', '\u20A7', '\u0192', '\341', '\355', '\363', '\372', '\361', '\321', '\252', '\272', '\277', '\u2310',
                    '\254', '\275', '\274', '\241', '\253', '\244', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561',
                    '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255D', '\u255C', '\u255B', '\u2510', '\u2514',
                    '\u2534', '\u252C', '\u251C', '\u2500', '\u253C', '\u255E', '\u255F', '\u255A', '\u2554', '\u2569', '\u2566',
                    '\u2560', '\u2550', '\u256C', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553',
                    '\u256B', '\u256A', '\u2518', '\u250C', '\u2588', '\u2584', '\u258C', '\u2590', '\u2580', '\u03B1', '\337',
                    '\u0393', '\u03C0', '\u03A3', '\u03C3', '\265', '\u03C4', '\u03A6', '\u0398', '\u03A9', '\u03B4', '\u221E',
                    '\u03C6', '\u03B5', '\u2229', '\u2261', '\261', '\u2265', '\u2264', '\u2320', '\u2321', '\367', '\u2248',
                    '\260', '\u2219', '\267', '\u221A', '\u207F', '\262', '\u25A0', '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2302', '\uFFFF', '\uFFFF', '\uFFFF',
                    '\uFFFF', '\uFFFF', '\uFFFF', '\u0386', '\uFFFF', '\267', '\254', '\246', '\u2018', '\u2019', '\u0388',
                    '\u2015', '\u0389', '\u038A', '\u03AA', '\u038C', '\uFFFF', '\uFFFF', '\u038E', '\u03AB', '\251', '\u038F',
                    '\262', '\263', '\u03AC', '\243', '\u03AD', '\u03AE', '\u03AF', '\u03CA', '\u0390', '\u03CC', '\u03CD',
                    '\u0391', '\u0392', '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\275', '\u0398', '\u0399', '\253',
                    '\273', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u039A', '\u039B', '\u039C', '\u039D', '\u2563',
                    '\u2551', '\u2557', '\u255D', '\u039E', '\u039F', '\u2510', '\u2514', '\u2534', '\u252C', '\u251C', '\u2500',
                    '\u253C', '\u03A0', '\u03A1', '\u255A', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256C', '\u03A3',
                    '\u03A4', '\u03A5', '\u03A6', '\u03A7', '\u03A8', '\u03A9', '\u03B1', '\u03B2', '\u03B3', '\u2518', '\u250C',
                    '\u2588', '\u2584', '\u03B4', '\u03B5', '\u2580', '\u03B6', '\u03B7', '\u03B8', '\u03B9', '\u03BA', '\u03BB',
                    '\u03BC', '\u03BD', '\u03BE', '\u03BF', '\u03C0', '\u03C1', '\u03C3', '\u03C2', '\u03C4', '\264', '\255',
                    '\261', '\u03C5', '\u03C6', '\u03C7', '\247', '\u03C8', '\u03F4', '\260', '\250', '\u03C9', '\u03CB',
                    '\u03B0', '\u03CE', '\u25A0', '\240'},
            {'\0', '\001', '\002', '\003', '\004', '\005', '\006', '\007', '\b', '\t', '\n', '\013', '\f', '\r', '\016', '\017',
                    '\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027', '\030', '\031', '\032', '\033', '\034',
                    '\035', '\036', '\037', ' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0',
                    '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F',
                    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',
                    '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
                    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\177', '\304', '\305', '\307', '\311',
                    '\321', '\326', '\334', '\341', '\340', '\342', '\344', '\343', '\345', '\347', '\351', '\350', '\352',
                    '\353', '\355', '\354', '\356', '\357', '\361', '\363', '\362', '\364', '\366', '\365', '\372', '\371',
                    '\373', '\374', '\u2020', '\260', '\242', '\243', '\247', '\u2022', '\266', '\337', '\256', '\251', '\u2122',
                    '\264', '\250', '\u2260', '\306', '\330', '\u221E', '\261', '\u2264', '\u2265', '\245', '\265', '\u2202',
                    '\u2211', '\u220F', '\u03C0', '\u222B', '\252', '\272', '\u2126', '\346', '\370', '\277', '\241', '\254',
                    '\u221A', '\u0192', '\u2248', '\u2206', '\253', '\273', '\u2026', '\240', '\300', '\303', '\325', '\u0152',
                    '\u0153', '\u2010', '\u2014', '\u201C', '\u201D', '\u2018', '\u2019', '\367', '\u25CA', '\377', '\u0178',
                    '\u2044', '\244', '\u2039', '\u203A', 'f', 'f', '\u2021', '\267', '\u201A', '\u201E', '\u2030', '\302',
                    '\312', '\301', '\313', '\310', '\315', '\316', '\317', '\314', '\323', '\324', '\uFDFF', '\322', '\332',
                    '\333', '\331', '\u0131', '\u02C6', '\u02DC', '\257', '\u02D8', '\u02D9', '\u02DA', '\270', '\u02DD',
                    '\u02DB', '\u02C7'}};
    private static char unicode2DOS437[];

    /**
     * Char to DOS437 converter
     * 
     * @param stringbuffer
     * @param i
     * @param c
     * @return String 
     */
    public static synchronized String char2DOS437( StringBuffer stringbuffer, int i, char c ) {
        if (unicode2DOS437 == null) {
            unicode2DOS437 = new char[0x10000];
            for( int j = 0; j < 256; j++ ) {
                char c1;
                if ((c1 = unicode[2][j]) != '\uFFFF')
                    unicode2DOS437[c1] = (char) j;
            }
        }
        if (i != 2) {
            StringBuffer stringbuffer1 = new StringBuffer(stringbuffer.length());
            for( int k = 0; k < stringbuffer.length(); k++ ) {
                char c2 = unicode2DOS437[stringbuffer.charAt(k)];
                stringbuffer1.append(c2 == 0 ? c : c2);
            }

            return new String(stringbuffer1);
        } else {
            return new String(stringbuffer);
        }
    }
}
