/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import java.lang.reflect.Field;
import oms3.Access;
import oms3.ComponentException;
import oms3.FieldContent;

class AsyncFieldAccess
implements Access {
    Access fa;

    AsyncFieldAccess(Access fa) {
        this.fa = fa;
    }

    @Override
    public boolean isValid() {
        return this.fa.isValid();
    }

    @Override
    public void in() throws Exception {
        if (this.fa.getData() == null) {
            throw new ComponentException("Not connected: " + this.toString());
        }
        Object val = this.fa.getData().getShadow();
        this.fa.setFieldValue(val);
    }

    @Override
    public void out() throws Exception {
        Object val = this.fa.getFieldValue();
        if (this.fa.getData() != null) {
            this.fa.getData().setValue0(val);
        }
        this.fa.out();
    }

    @Override
    public Object getComponent() {
        return this.fa.getComponent();
    }

    @Override
    public Field getField() {
        return this.fa.getField();
    }

    public String toString() {
        return "AsyncFieldAccess [" + this.fa.toString() + "]";
    }

    @Override
    public Object getFieldValue() throws Exception {
        return this.fa.getFieldValue();
    }

    @Override
    public void setFieldValue(Object o) throws Exception {
        this.fa.setFieldValue(o);
    }

    @Override
    public FieldContent getData() {
        return this.fa.getData();
    }

    @Override
    public void setData(FieldContent data) {
        this.fa.setData(data);
    }
}

