/*
 * Decompiled with CFR 0.152.
 */
package oms3;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oms3.Access;
import oms3.AsyncFieldAccess;
import oms3.ComponentException;
import oms3.Conversions;
import oms3.FieldAccess;
import oms3.FieldObjectAccess;
import oms3.FieldValueAccess;
import oms3.Notification;
import oms3.Utils;
import oms3.annotations.Bound;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Out;
import oms3.annotations.Range;
import oms3.annotations.Role;
import oms3.gen.MethodInvoker;
import oms3.util.Annotations;

public class ComponentAccess {
    private static final Logger log = Logger.getLogger("oms3.sim");
    Object comp;
    Map<String, Access> ins = new LinkedHashMap<String, Access>();
    Map<String, Access> outs = new LinkedHashMap<String, Access>();
    Notification ens;
    final MethodInvoker exec;

    public ComponentAccess(Object cmd) {
        this(cmd, null);
    }

    ComponentAccess(Object comp, Notification ens) {
        this.comp = comp;
        this.ens = ens;
        Method execute = ComponentAccess.getMethodOfInterest(comp, Execute.class);
        this.exec = Utils.reflective(comp, execute);
        ComponentAccess.findAll(comp, this.ins, this.outs, ens);
    }

    public Object getComponent() {
        return this.comp;
    }

    void setInput(String name, Access fa) {
        this.ins.put(name, fa);
    }

    void setOutput(String name, Access fa) {
        this.outs.put(name, fa);
    }

    public Collection<Access> inputs() {
        return this.ins.values();
    }

    public Collection<Access> outputs() {
        return this.outs.values();
    }

    public Access input(String field) {
        return this.ins.get(field);
    }

    public Access output(String field) {
        return this.outs.get(field);
    }

    final void exec() throws ComponentException {
        try {
            this.ens.fireWait(this);
            for (Access a : this.ins.values()) {
                if (a.getClass() != FieldAccess.class) continue;
                a.in();
            }
            for (Access a : this.ins.values()) {
                if (a.getClass() != FieldObjectAccess.class && a.getClass() != FieldValueAccess.class && a.getClass() != AsyncFieldAccess.class) continue;
                a.in();
            }
            this.ens.fireStart(this);
            this.exec.invoke();
            this.ens.fireFinnish(this);
            for (Access a : this.outs.values()) {
                if (a.getClass() != FieldObjectAccess.class && a.getClass() != AsyncFieldAccess.class) continue;
                a.out();
            }
            for (Access a : this.outs.values()) {
                if (a.getClass() != FieldAccess.class) continue;
                a.out();
            }
        }
        catch (InvocationTargetException ex) {
            throw new ComponentException(ex.getCause(), this.comp);
        }
        catch (Exception ex) {
            throw new ComponentException(ex, this.comp);
        }
    }

    void callAnnotatedMethod(Class<? extends Annotation> ann, boolean lazy) {
        block4: {
            try {
                ComponentAccess.getMethodOfInterest(this.comp, ann).invoke(this.comp, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex.getCause());
            }
            catch (IllegalArgumentException ex) {
                if (lazy) break block4;
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    private static Method getMethodOfInterest(Object cmp, Class<? extends Annotation> ann) {
        Method[] ms;
        Class<?> cmpClass = cmp.getClass();
        Class infoClass = ComponentAccess.infoClass(cmpClass);
        for (Method m : ms = infoClass.getMethods()) {
            if (m.getAnnotation(ann) == null) continue;
            if (m.getReturnType() != Void.TYPE || m.getParameterTypes().length > 0) {
                throw new IllegalArgumentException("Invalid Method signature: " + m);
            }
            try {
                return cmpClass.getMethod(m.getName(), new Class[0]);
            }
            catch (Exception ex) {
                throw new ComponentException("Cannot find/access method: " + m);
            }
        }
        throw new IllegalArgumentException("No " + ann.getCanonicalName() + " found in " + cmp.getClass());
    }

    private static void findAll(Object cmp, Map<String, Access> ins, Map<String, Access> outs, Notification ens) {
        Class<?> cmpClass = cmp.getClass();
        Class infoClass = ComponentAccess.infoClass(cmpClass);
        for (Field f : infoClass.getFields()) {
            try {
                if (f.getAnnotation(In.class) != null) {
                    ins.put(f.getName(), new FieldAccess(cmp, cmpClass.getField(f.getName()), ens));
                }
                if (f.getAnnotation(Out.class) == null) continue;
                outs.put(f.getName(), new FieldAccess(cmp, cmpClass.getField(f.getName()), ens));
            }
            catch (Exception ex) {
                throw new ComponentException("Cannot find/access field: " + f);
            }
        }
    }

    public static void callAnnotated(Object o, Class<? extends Annotation> ann, boolean lazy) {
        block4: {
            try {
                ComponentAccess.getMethodOfInterest(o, ann).invoke(o, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex.getCause());
            }
            catch (IllegalArgumentException ex) {
                if (lazy) break block4;
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    public static Class infoClass(Class cmp) {
        Class<?> info = null;
        try {
            info = Class.forName(cmp.getName() + "CompInfo");
        }
        catch (ClassNotFoundException E) {
            info = cmp;
        }
        return info;
    }

    public static boolean adjustOutputPath(File outputDir, Object comp, Logger log) {
        boolean adjusted = false;
        ComponentAccess cp = new ComponentAccess(comp);
        for (Access in : cp.inputs()) {
            Role role;
            String fieldName = in.getField().getName();
            Class<?> fieldType = in.getField().getType();
            if (fieldType != File.class || (role = in.getField().getAnnotation(Role.class)) == null || !Annotations.plays(role, "Output ")) continue;
            try {
                File f = (File)in.getField().get(comp);
                if (f == null || f.isAbsolute()) continue;
                f = new File(outputDir, f.getName());
                in.setFieldValue(f);
                adjusted = true;
                if (!log.isLoggable(Level.CONFIG)) continue;
                log.config("Adjusting output for '" + fieldName + "' to " + f);
            }
            catch (Exception ex) {
                throw new ComponentException("Failed adjusting output path for '" + fieldName);
            }
        }
        return adjusted;
    }

    public static Properties createDefault(Object comp) {
        Properties p = new Properties();
        ComponentAccess ca = new ComponentAccess(comp);
        for (Access in : ca.inputs()) {
            try {
                String name = in.getField().getName();
                Object o = in.getField().get(comp);
                if (o == null) continue;
                String value = o.toString();
                p.put(name, value);
            }
            catch (Exception ex) {
                throw new ComponentException("Failed access to field: " + in.getField().getName());
            }
        }
        return p;
    }

    static Map<String, Object> convert(Map<String, Object> m) {
        LinkedHashMap<String, Object> hm = new LinkedHashMap<String, Object>();
        Set<Map.Entry<String, Object>> entrySet = m.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            key = key.replace('.', '_');
            Object value = entry.getValue();
            hm.put(key, value);
        }
        return hm;
    }

    public static Object conv(Object inpValue, Class<?> fieldType) {
        Class<?> inpType = inpValue.getClass();
        if (inpType == String.class && fieldType != String.class) {
            inpValue = Conversions.convert((String)inpValue, fieldType);
        } else if (inpType == BigDecimal.class && fieldType != BigDecimal.class) {
            inpValue = Conversions.convert(inpValue.toString(), fieldType);
        } else if (inpValue instanceof CharSequence) {
            inpValue = Conversions.convert(inpValue.toString(), fieldType);
        }
        return inpValue;
    }

    public static boolean setInputData(Map<String, Object> inp, Object comp, Logger log) {
        PrintWriter w = null;
        File file = null;
        boolean success = true;
        ComponentAccess cp = new ComponentAccess(comp);
        inp = ComponentAccess.convert(inp);
        for (Access in : cp.inputs()) {
            String fieldName = in.getField().getName();
            Class<?> fieldType = in.getField().getType();
            Object inpValue = inp.get(fieldName);
            if (inpValue != null) {
                try {
                    double v;
                    Range range;
                    inpValue = ComponentAccess.conv(inpValue, fieldType);
                    if ((Number.class.isAssignableFrom(fieldType) || fieldType == Double.TYPE || fieldType == Float.TYPE || fieldType == Integer.TYPE) && (range = in.getField().getAnnotation(Range.class)) != null && !Annotations.inRange(range, v = ((Number)inpValue).doubleValue()) && log.isLoggable(Level.WARNING)) {
                        log.warning("Value '" + v + "' not in Range: " + range);
                    }
                    in.setFieldValue(inpValue);
                    if (!log.isLoggable(Level.CONFIG)) continue;
                    log.config("@In " + comp.getClass().getName() + "@" + fieldName + " <- '" + inpValue + "'");
                    continue;
                }
                catch (Exception ex) {
                    throw new ComponentException("Failed setting '" + fieldName + "' type " + in.getField().getType().getCanonicalName() + " <- " + ex.getMessage());
                }
            }
            if (System.getProperty("oms.check_params") != null) {
                try {
                    if (w == null) {
                        file = new File(System.getProperty("oms3.work", System.getProperty("user.dir")), "missing_params.csv");
                        w = new PrintWriter(new FileWriter(file));
                        w.println("# Missing parameter, copy those entries into one of your parameter files.");
                    }
                    String val = null;
                    Bound b = null;
                    Object o = in.getFieldValue();
                    if (o != null) {
                        val = o.toString();
                    } else {
                        b = in.getField().getAnnotation(Bound.class);
                        if (b != null) {
                            try {
                                Object v = inp.get(b.value());
                                if (v == null) {
                                    v = new Integer(0);
                                }
                                int dim = Integer.parseInt(v.toString());
                                int[] d = new int[dim];
                                val = Conversions.convert(d, String.class);
                            }
                            catch (NumberFormatException E) {
                                val = "?";
                            }
                        } else {
                            val = "?";
                        }
                    }
                    w.println("@P, " + fieldName + ",  \"" + val + "\"");
                    if (b != null) {
                        w.println(" bound, " + b.value());
                    }
                }
                catch (Exception E) {
                    throw new RuntimeException(E);
                }
            }
            if (!log.isLoggable(Level.WARNING)) continue;
            log.warning("No Input for '" + fieldName + "'");
        }
        if (w != null) {
            w.close();
            System.out.println("Missing parameter [" + file + "]");
            success = false;
        }
        return success;
    }

    public static String dump(Object comp) throws Exception {
        Object val;
        String name;
        StringBuilder b = new StringBuilder();
        b.append("//" + comp.toString() + ":\n");
        b.append("// In\n");
        ComponentAccess cp = new ComponentAccess(comp);
        for (Access in : cp.inputs()) {
            name = in.getField().getName();
            val = in.getFieldValue();
            b.append("    " + name + ": " + Conversions.convert(val, String.class) + "\n");
        }
        b.append("// Out\n");
        for (Access in : cp.outputs()) {
            name = in.getField().getName();
            val = in.getFieldValue();
            b.append("    " + name + ": " + Conversions.convert(val, String.class) + "\n");
        }
        b.append("\n");
        return b.toString();
    }

    public static void rangeCheck(Object comp, boolean in, boolean out) throws Exception {
        ComponentAccess cp = new ComponentAccess(comp);
        ArrayList<Access> acc = new ArrayList<Access>();
        if (in) {
            acc.addAll(cp.inputs());
        }
        if (out) {
            acc.addAll(cp.outputs());
        }
        for (Access a : acc) {
            String name = a.getField().getName();
            Object val = a.getFieldValue();
            Range range = a.getField().getAnnotation(Range.class);
            if (range == null) continue;
            if (val instanceof Number) {
                double v = ((Number)val).doubleValue();
                if (Annotations.inRange(range, v)) continue;
                throw new ComponentException(name + " not in range " + v);
            }
            if (!(val instanceof double[])) continue;
            double[] v = (double[])val;
            for (int i = 0; i < v.length; ++i) {
                if (Annotations.inRange(range, v[i])) continue;
                throw new ComponentException(name + " not in range " + v[i]);
            }
        }
    }
}

