/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import oms3.ComponentException;
import oms3.annotations.Name;
import oms3.annotations.Role;
import oms3.compiler.ModelCompiler;
import oms3.dsl.Buildable;
import oms3.dsl.KVP;
import oms3.dsl.KVPContainer;
import oms3.dsl.Logging;
import oms3.dsl.Param;
import oms3.dsl.Params;
import oms3.dsl.Resource;
import oms3.io.CSProperties;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.util.Components;

public class Model
implements Buildable {
    protected static final Logger log = Logger.getLogger("oms3.sim");
    String classname;
    Resource res;
    List<Params> params = new ArrayList<Params>();
    Logging l = new Logging();
    KVPContainer comps = new KVPContainer();
    KVPContainer out2in = new KVPContainer();
    KVPContainer feedback = new KVPContainer();
    String control = null;
    String controlClass = "oms3.Compound";
    URLClassLoader modelClassLoader;
    Map<String, String> nameClassMap;

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("parameter")) {
            Params p = new Params();
            this.params.add(p);
            return p;
        }
        if (name.equals("resource")) {
            this.res.addResource(value);
            return LEAF;
        }
        if (name.equals("logging")) {
            return this.l;
        }
        if (name.equals("components")) {
            return this.comps;
        }
        if (name.equals("connect")) {
            return this.out2in;
        }
        if (name.equals("feedback")) {
            return this.feedback;
        }
        throw new ComponentException("Unknown element: '" + name.toString() + "'");
    }

    KVPContainer getComponents() {
        return this.comps;
    }

    KVPContainer getConnects() {
        return this.out2in;
    }

    Logging getComponentLogging() {
        return this.l;
    }

    Resource getRes() {
        return this.res;
    }

    void setRes(Resource res) {
        this.res = res;
    }

    public List<Params> getParams() {
        return this.params;
    }

    @Deprecated
    public void setIter(String c) {
        this.setWhile(c);
    }

    public void setWhile(String c) {
        this.control = c;
        this.controlClass = "oms3.control.While";
    }

    public void setUntil(String c) {
        this.control = c;
        this.controlClass = "oms3.control.Until";
    }

    public void setIf(String c) {
        this.control = c;
        this.controlClass = "oms3.control.If";
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getLibpath() {
        List<File> f = this.res.filterDirectories();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < f.size(); ++i) {
            b.append(f.get(i));
            if (i >= f.size() - 1) continue;
            b.append(File.pathSeparatorChar);
        }
        return b.toString();
    }

    private static List<File> getExtraResources() {
        ArrayList<File> sc = new ArrayList<File>();
        String simPath = System.getProperty("oms.sim.resources");
        if (log.isLoggable(Level.CONFIG)) {
            log.config("oms.sim.resources '" + simPath + "'");
        }
        if (simPath != null && !simPath.isEmpty()) {
            simPath = simPath.replaceAll("\"", "");
            for (String s : simPath.split("\\s*" + File.pathSeparator + "\\s*")) {
                sc.add(new File(s));
            }
        }
        return sc;
    }

    private synchronized URLClassLoader getClassLoader() {
        if (this.modelClassLoader == null) {
            List<File> jars = this.res.filterFiles("jar");
            List<File> cli_jars = Model.getExtraResources();
            List<File> dirs = this.res.filterDirectories();
            ArrayList<URL> urls = new ArrayList<URL>();
            try {
                int i;
                for (i = 0; i < jars.size(); ++i) {
                    urls.add(jars.get(i).toURI().toURL());
                    if (!log.isLoggable(Level.CONFIG)) continue;
                    log.config("classpath entry from simulation: " + jars.get(i));
                }
                for (i = 0; i < dirs.size(); ++i) {
                    urls.add(dirs.get(i).toURI().toURL());
                    if (!log.isLoggable(Level.CONFIG)) continue;
                    log.config("dir entry: " + dirs.get(i));
                }
                for (i = 0; i < cli_jars.size(); ++i) {
                    urls.add(cli_jars.get(i).toURI().toURL());
                    if (!log.isLoggable(Level.CONFIG)) continue;
                    log.config("classpath entry from CLI: " + cli_jars.get(i));
                }
                urls.add(new URL("file:" + System.getProperty("oms.prj") + "/dist/"));
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Sim loading classpath : file:" + System.getProperty("oms.prj") + "/dist/");
                }
            }
            catch (MalformedURLException ex) {
                throw new ComponentException("Illegal resource:" + ex.getMessage());
            }
            this.modelClassLoader = new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        }
        return this.modelClassLoader;
    }

    public Object getComponent() throws Exception {
        URLClassLoader loader = this.getClassLoader();
        Class<?> c = null;
        if (this.classname == null) {
            c = this.getGeneratedComponent(loader);
        } else {
            try {
                c = loader.loadClass(this.getComponentClassName(this.classname));
            }
            catch (ClassNotFoundException E) {
                throw new IllegalArgumentException("Component/Model not found '" + this.classname + "'");
            }
        }
        return c.newInstance();
    }

    public List<Param> getParam() {
        ArrayList<Param> parameter = new ArrayList<Param>();
        for (Params paras : this.getParams()) {
            parameter.addAll(paras.getParam());
        }
        return parameter;
    }

    public CSProperties getParameter() throws IOException {
        CSProperties p = DataIO.properties();
        for (Params paras : this.getParams()) {
            String f = paras.getFile();
            if (f != null) {
                p.putAll(DataIO.properties(new FileReader(new File(f)), "Parameter"));
                List<String> tables = DataIO.tables(new File(f));
                if (!tables.isEmpty()) {
                    for (String name : tables) {
                        CSTable t = DataIO.table(new File(f), name);
                        CSProperties prop = DataIO.fromTable(t);
                        p.putAll(prop);
                    }
                }
            }
            for (Param param : paras.getParam()) {
                p.put(param.getName(), param.getValue());
            }
        }
        return p;
    }

    static Object get(Map<String, Object> inst, String key) {
        Object val = inst.get(key);
        if (val == null) {
            throw new IllegalArgumentException("No such component name '" + key + "'");
        }
        return val;
    }

    private Map<String, String> getName_ClassMap() {
        if (this.nameClassMap == null) {
            this.nameClassMap = new HashMap<String, String>();
            for (URL url : this.getClassLoader().getURLs()) {
                try {
                    if (url.toString().startsWith("file:null")) continue;
                    List<Class<?>> componentClasses = Components.getComponentClasses(url);
                    for (Class<?> class1 : componentClasses) {
                        Name name = class1.getAnnotation(Name.class);
                        if (name == null || name.value().isEmpty()) continue;
                        if (name.value().indexOf(".") > -1) {
                            log.warning("@Name cannot contain '.' character : " + name.value() + " in  " + class1.getName());
                            continue;
                        }
                        String prev = this.nameClassMap.put(name.value(), class1.getName());
                        if (prev != null) {
                            log.warning("duplicate @Name: " + name.value() + " for " + prev + " and " + class1.getName());
                        }
                        if (!log.isLoggable(Level.CONFIG)) continue;
                        log.config("Added '@Name' alias '" + name.value() + "' for class: " + class1.getName());
                    }
                }
                catch (IOException E) {
                    throw new ComponentException("Cannot access: " + url);
                }
            }
        }
        return this.nameClassMap;
    }

    private String getComponentClassName(String id) {
        if (id.indexOf(46) == -1) {
            String cn = this.getName_ClassMap().get(id);
            if (cn == null) {
                throw new ComponentException("Unknown component name: " + id);
            }
            return cn;
        }
        return id;
    }

    private Class<?> getGeneratedComponent(URLClassLoader loader) {
        try {
            String name = "Comp_" + UUID.randomUUID().toString().replace('-', '_');
            String source = this.generateSource(name);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Generated Class :" + name);
                log.fine("Generated Source:\n" + source);
            }
            ModelCompiler mc = ModelCompiler.create(System.getProperty("oms.modelcompiler"));
            Class<?> jc = mc.compile(log, loader, name, source);
            return jc;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String generateSource(String cname) throws Exception {
        if (this.control != null && this.control.indexOf(46) == -1) {
            throw new IllegalArgumentException("Not a valid control reference (object.field): '" + this.control + "'");
        }
        StringBuilder b = new StringBuilder();
        b.append("import java.util.*;\n");
        b.append("import oms3.*;\n");
        b.append("import oms3.annotations.*;\n");
        b.append("public class " + cname + " extends " + this.controlClass + " {\n");
        b.append("\n");
        for (Param param : this.getParam()) {
            String p = param.getName();
            if (p.indexOf(46) == -1) {
                throw new IllegalArgumentException("Not a valid parameter reference (object.field): '" + p + "'");
            }
            String[] name = p.split("\\.");
            String type = this.getClassForParameter(name[0], name[1], true);
            String role = this.getClassForParameter(name[0], name[1], false);
            b.append(" // " + p + "\n");
            b.append(" @Role(\"" + role + "\")\n");
            b.append(" @In public " + type + " " + name[0] + "_" + name[1] + ";\n");
            b.append("\n");
        }
        for (KVP def : this.comps.entries) {
            String compClass = def.getValue().toString();
            compClass = this.getComponentClassName(compClass);
            b.append(" public " + compClass + " " + def.getKey() + " = new " + compClass + "();\n");
        }
        b.append("\n\n");
        b.append(" @Initialize\n");
        b.append(" public void init() {\n");
        if (this.control != null) {
            String[] it = this.control.split("\\.");
            b.append("  conditional(" + it[0] + ", \"" + it[1] + "\");\n");
        }
        for (Param param : this.getParam()) {
            String[] name = param.getName().split("\\.");
            b.append("  in2in(\"" + name[0] + "_" + name[1] + "\", " + name[0] + ", \"" + name[1] + "\");\n");
        }
        this.kvpExpand(b, this.out2in.entries, "out2in");
        this.kvpExpand(b, this.feedback.entries, "feedback");
        b.append("  initializeComponents();\n");
        b.append(" }\n");
        b.append("}\n");
        return b.toString();
    }

    void kvpExpand(StringBuilder b, List<KVP> l, String method) {
        for (KVP c : l) {
            String[] t;
            String[] from = c.getKey().split("\\.");
            String tos = c.getValue().toString().trim();
            String[] stringArray = t = tos.split("\\s+");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String kvp;
                String to_obj = kvp = stringArray[i];
                String to_field = from[1];
                if (kvp.indexOf(46) > 0) {
                    String[] to = kvp.split("\\.");
                    to_obj = to[0];
                    to_field = to[1];
                }
                b.append("  " + method + "(" + from[0] + ", \"" + from[1] + "\", " + to_obj + ", \"" + to_field + "\");\n");
            }
        }
    }

    String getClassForParameter(String object, String field, boolean type) {
        for (KVP def : this.comps.entries) {
            Class<?> c;
            if (!object.equals(def.getKey())) continue;
            String clname = def.getValue().toString();
            clname = this.getComponentClassName(clname);
            try {
                c = this.getClassLoader().loadClass(clname);
            }
            catch (ClassNotFoundException ex) {
                throw new ComponentException("Class not found: '" + clname + "'");
            }
            try {
                if (type) {
                    String canName = c.getField(field).getType().getCanonicalName();
                    if (canName == null) {
                        throw new ComponentException("No canonical type name for : " + field);
                    }
                    return canName;
                }
                Role r = c.getField(field).getAnnotation(Role.class);
                if (r != null) {
                    return r.value();
                }
                return "Variable ";
            }
            catch (NoSuchFieldException ex) {
                throw new ComponentException("No such field: " + field);
            }
            catch (SecurityException ex) {
                throw new ComponentException("Cannot access : " + field);
            }
        }
        throw new ComponentException("Cannot find component '" + object + "'. in '" + object + "." + field + "'");
    }
}

