/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Logger;
import oms3.Compound;
import oms3.Conversions;
import oms3.Notification;
import oms3.dsl.Buildable;
import oms3.dsl.Util;

public class Output
implements Buildable {
    protected static final Logger log = Logger.getLogger("oms3.sim");
    final List<V> vars = new ArrayList<V>();
    Set<String> d = new TreeSet<String>();
    String file;
    PrintWriter w;
    boolean printHeader = true;
    String fformat = "%7.3f";
    String dformat = "%10d";
    SimpleDateFormat dfmt = Conversions.ISO();

    public void setDateformat(String dateformat) {
        this.dfmt = new SimpleDateFormat(dateformat);
    }

    public void setFloatformat(String format) {
        this.fformat = !format.startsWith("%") ? "%" + format : format;
    }

    public void setDecimalformat(String format) {
        this.dformat = !format.startsWith("%") ? "%" + format : format;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setVars(String varlist) {
        StringTokenizer t = new StringTokenizer(varlist, ";,:");
        while (t.hasMoreTokens()) {
            String var = t.nextToken().trim();
            String[] l = Conversions.parseArrayElement(var);
            this.vars.add(new V(var, l[0], Util.arraysDims(l)));
            this.d.add(l[0]);
        }
    }

    @Override
    public Buildable create(Object name, Object value) {
        return LEAF;
    }

    public void setup(Object comp, File dir, final String header) throws IOException {
        this.printHeader = true;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (this.vars.isEmpty()) {
            throw new IllegalArgumentException("no variables to output.");
        }
        if (comp instanceof Compound) {
            Compound c = (Compound)comp;
            this.w = this.file != null ? new PrintWriter(new FileWriter(new File(dir, this.file), false)) : new PrintWriter(new OutputStreamWriter(System.out));
            c.addListener(new Notification.Listener(){
                int count = 0;
                int vars_size;
                {
                    this.vars_size = Output.this.vars.size();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void notice(Notification.Type T, EventObject E) {
                    Notification.DataflowEvent e;
                    String fieldName;
                    if (T == Notification.Type.OUT && Output.this.d.contains(fieldName = (e = (Notification.DataflowEvent)E).getAccess().getField().getName())) {
                        List<V> list = Output.this.vars;
                        synchronized (list) {
                            for (V v : Output.this.vars) {
                                if (!v.name.equals(fieldName)) continue;
                                v.val = e.getValue();
                                ++this.count;
                            }
                            if (this.count == this.vars_size) {
                                if (Output.this.printHeader) {
                                    Output.this.printHeader(header);
                                }
                                Output.this.printRow();
                                this.count = 0;
                            }
                        }
                    }
                }
            });
        }
    }

    void printHeader(String header) {
        this.w.println("@T, \"" + header + "\"");
        this.w.println(" created_at, \"" + new Date() + "\"");
        this.w.println(" date_format, " + this.dfmt.toPattern());
        String dig = System.getProperty("oms3.digest");
        if (dig != null) {
            this.w.println(" digest," + dig);
        }
        this.w.print("@H");
        for (V v : this.vars) {
            this.w.print(", " + v.token());
        }
        this.w.println();
        this.w.print(" type");
        for (V v : this.vars) {
            this.w.print(", " + v.type());
        }
        this.w.println();
        this.printHeader = false;
    }

    void printRow() {
        for (V v : this.vars) {
            this.w.print(", " + v.valueString());
        }
        this.w.println();
    }

    public void done() throws IOException {
        this.w.flush();
        if (this.file != null) {
            this.w.close();
        }
    }

    private class V {
        String token;
        String name;
        int[] idx;
        Object val;

        V(String token, String name, int[] idx) {
            this.token = token;
            this.name = name;
            this.idx = idx;
        }

        Object value() {
            return this.idx == null ? this.val : Util.accessArray(this.name, this.val, this.idx);
        }

        String token() {
            if (this.idx == null && this.val.getClass().isArray()) {
                int len = Array.getLength(this.val);
                StringBuilder b = new StringBuilder();
                for (int i = 0; i < len - 1; ++i) {
                    b.append(this.token + "[" + i + "],");
                }
                b.append(this.token + "[" + (len - 1) + "]");
                return b.toString();
            }
            return this.token;
        }

        String valueString() {
            Object v = this.value();
            if (v == null) {
                throw new IllegalArgumentException("Missing output: " + this.token);
            }
            if (v.getClass() == Double.class) {
                return String.format(Locale.US, Output.this.fformat, v);
            }
            if (v instanceof Calendar) {
                return Output.this.dfmt.format(((Calendar)v).getTime());
            }
            if (v instanceof double[]) {
                return this.dblfmt((double[])v);
            }
            return v.toString();
        }

        String dblfmt(double[] d) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < d.length - 1; ++i) {
                b.append(String.format(Locale.US, Output.this.fformat, d[i]));
                b.append(',');
            }
            b.append(String.format(Locale.US, Output.this.fformat, d[d.length - 1]));
            return b.toString();
        }

        String type() {
            if (this.idx == null && this.val.getClass().isArray()) {
                String t = this.val.getClass().getComponentType().getSimpleName();
                int len = Array.getLength(this.val);
                StringBuilder b = new StringBuilder();
                for (int i = 0; i < len - 1; ++i) {
                    b.append(t + ",");
                }
                b.append(t);
                return b.toString();
            }
            if (this.val != null && this.value() instanceof Calendar) {
                return "Date";
            }
            return this.val == null ? "null" : this.value().getClass().getSimpleName();
        }
    }
}

