/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl;

import java.io.File;
import oms3.dsl.Buildable;
import oms3.ngmf.util.DateDirectoryOutput;
import oms3.ngmf.util.NumDirectoryOutput;
import oms3.ngmf.util.OutputStragegy;
import oms3.ngmf.util.SimpleDirectoryOutput;

public class OutputDescriptor
implements Buildable {
    int scheme = 0;
    File dir = new File(System.getProperty("user.dir"));

    public void setDir(String d) {
        this.dir = new File(d);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory " + this.dir);
        }
    }

    File getDir() {
        return this.dir;
    }

    public void setScheme(int scheme) {
        if (scheme != 0 && scheme != 1 && scheme != 2) {
            throw new IllegalArgumentException("Invalid output strategy scheme.");
        }
        this.scheme = scheme;
    }

    public OutputStragegy getOutputStrategy(String simName) {
        OutputStragegy st = null;
        if (this.scheme == 0) {
            st = new SimpleDirectoryOutput(this.getDir(), simName);
        } else if (this.scheme == 1) {
            st = new NumDirectoryOutput(this.getDir(), simName);
        } else if (this.scheme == 2) {
            st = new DateDirectoryOutput(this.getDir());
        }
        return st;
    }

    @Override
    public Buildable create(Object name, Object value) {
        return LEAF;
    }
}

