/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.analysis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oms3.dsl.Buildable;
import oms3.dsl.analysis.Axis;
import oms3.ngmf.ui.graph.ValueSet;

public class FlowDur
implements Buildable {
    List<ValueSet> y = new ArrayList<ValueSet>();
    String title = "Flow Duration";

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    List<ValueSet> getY() {
        ArrayList<ValueSet> fd = new ArrayList<ValueSet>();
        for (ValueSet valueSet : this.y) {
            fd.add(new VS(valueSet));
        }
        return fd;
    }

    @Override
    public Buildable create(Object name, Object value) {
        if (name.equals("y")) {
            Axis a = new Axis();
            this.y.add(a);
            return a;
        }
        throw new IllegalArgumentException("flowduration cannot handle :" + name);
    }

    static class VS
    implements ValueSet {
        ValueSet v;

        VS(ValueSet v) {
            this.v = v;
        }

        @Override
        public Double[] getDoubles(File st, String simName) throws IOException {
            Double[] duration = new Double[100];
            Object[] y = this.v.getDoubles(st, simName);
            Arrays.sort(y);
            int l1 = y.length / 100;
            for (int i2 = 0; i2 < 100; ++i2) {
                duration[99 - i2] = y[(i2 + 1) * l1];
            }
            return duration;
        }

        @Override
        public String getName() {
            return this.v.getName();
        }

        @Override
        public boolean isLine() {
            return true;
        }

        @Override
        public boolean isShape() {
            return false;
        }
    }
}

