/*
 * Decompiled with CFR 0.152.
 */
package oms3.dsl.cosu;

public final class Matrix {
    public final int M;
    public final int N;
    public final double[][] data;

    public Matrix(int M, int N) {
        this.M = M;
        this.N = N;
        this.data = new double[M][N];
    }

    public Matrix(double[][] data) {
        this.M = data.length;
        this.N = data[0].length;
        this.data = new double[this.M][this.N];
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                this.data[i][j] = data[i][j];
            }
        }
    }

    private Matrix(Matrix A) {
        this(A.data);
    }

    public static Matrix random(int M, int N) {
        Matrix A = new Matrix(M, N);
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < N; ++j) {
                A.data[i][j] = Math.random();
            }
        }
        return A;
    }

    public static Matrix identity(int N) {
        Matrix I = new Matrix(N, N);
        for (int i = 0; i < N; ++i) {
            I.data[i][i] = 1.0;
        }
        return I;
    }

    private void swap(int i, int j) {
        double[] temp = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = temp;
    }

    public Matrix copy() {
        return new Matrix(this);
    }

    public Matrix transpose() {
        Matrix A = new Matrix(this.N, this.M);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                A.data[j][i] = this.data[i][j];
            }
        }
        return A;
    }

    public Matrix plus(Matrix B) {
        Matrix A = this;
        if (B.M != A.M || B.N != A.N) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix C = new Matrix(this.M, this.N);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                C.data[i][j] = A.data[i][j] + B.data[i][j];
            }
        }
        return C;
    }

    public Matrix minus(Matrix B) {
        Matrix A = this;
        if (B.M != A.M || B.N != A.N) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix C = new Matrix(this.M, this.N);
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                C.data[i][j] = A.data[i][j] - B.data[i][j];
            }
        }
        return C;
    }

    public boolean eq(Matrix B) {
        Matrix A = this;
        if (B.M != A.M || B.N != A.N) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                if (A.data[i][j] == B.data[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public Matrix times(Matrix B) {
        Matrix A = this;
        if (A.N != B.M) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix C = new Matrix(A.M, B.N);
        for (int i = 0; i < C.M; ++i) {
            for (int j = 0; j < C.N; ++j) {
                for (int k = 0; k < A.N; ++k) {
                    double[] dArray = C.data[i];
                    int n = j;
                    dArray[n] = dArray[n] + A.data[i][k] * B.data[k][j];
                }
            }
        }
        return C;
    }

    public Matrix timesbyelement(Matrix B) {
        Matrix A = this;
        if (A.M != B.M && A.N != B.N) {
            throw new RuntimeException("Unable to do element matrix multiplication.");
        }
        Matrix C = new Matrix(A.M, A.N);
        for (int i = 0; i < C.M; ++i) {
            for (int j = 0; j < C.N; ++j) {
                C.data[i][j] = A.data[i][j] * B.data[i][j];
            }
        }
        return C;
    }

    public Matrix solve(Matrix rhs) {
        if (this.M != this.N || rhs.M != this.N || rhs.N != 1) {
            throw new RuntimeException("Illegal matrix dimensions.");
        }
        Matrix A = new Matrix(this);
        Matrix b = new Matrix(rhs);
        for (int i = 0; i < this.N; ++i) {
            int j;
            int max = i;
            for (j = i + 1; j < this.N; ++j) {
                if (!(Math.abs(A.data[j][i]) > Math.abs(A.data[max][i]))) continue;
                max = j;
            }
            A.swap(i, max);
            b.swap(i, max);
            if (A.data[i][i] == 0.0) {
                throw new RuntimeException("Matrix is singular.");
            }
            for (j = i + 1; j < this.N; ++j) {
                double[] dArray = b.data[j];
                dArray[0] = dArray[0] - b.data[i][0] * A.data[j][i] / A.data[i][i];
            }
            for (j = i + 1; j < this.N; ++j) {
                double m = A.data[j][i] / A.data[i][i];
                for (int k = i + 1; k < this.N; ++k) {
                    double[] dArray = A.data[j];
                    int n = k;
                    dArray[n] = dArray[n] - A.data[i][k] * m;
                }
                A.data[j][i] = 0.0;
            }
        }
        Matrix x = new Matrix(this.N, 1);
        for (int j = this.N - 1; j >= 0; --j) {
            double t = 0.0;
            for (int k = j + 1; k < this.N; ++k) {
                t += A.data[j][k] * x.data[k][0];
            }
            x.data[j][0] = (b.data[j][0] - t) / A.data[j][j];
        }
        return x;
    }

    public void print() {
        for (int i = 0; i < this.M; ++i) {
            for (int j = 0; j < this.N; ++j) {
                System.out.printf("%9.4f ", this.data[i][j]);
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        double[][] d = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {9.0, 1.0, 3.0}};
        Matrix D = new Matrix(d);
        D.print();
        System.out.println();
        Matrix A = Matrix.random(5, 5);
        A.print();
        System.out.println();
        A.swap(1, 2);
        A.print();
        System.out.println();
        Matrix B = A.transpose();
        B.print();
        System.out.println();
        Matrix C = Matrix.identity(5);
        C.print();
        System.out.println();
        A.plus(B).print();
        System.out.println();
        B.times(A).print();
        System.out.println();
        System.out.println(A.times(B).eq(B.times(A)));
        System.out.println();
        Matrix b = Matrix.random(5, 1);
        b.print();
        System.out.println();
        Matrix x = A.solve(b);
        x.print();
        System.out.println();
        A.times(x).print();
    }
}

