/*
 * Decompiled with CFR 0.152.
 */
package oms3.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oms3.io.CSTable;

public class MemoryTable
implements CSTable,
TableModel {
    String name;
    Map<Integer, Map<String, String>> info = new HashMap<Integer, Map<String, String>>();
    List<String[]> rows = new ArrayList<String[]>();
    List<String> columnNames = new ArrayList<String>();

    public MemoryTable(CSTable src, boolean skipContent) {
        this.name = src.getName();
        this.info.put(-1, new LinkedHashMap<String, String>(src.getInfo()));
        for (int i = 1; i <= src.getColumnCount(); ++i) {
            this.columnNames.add(src.getColumnName(i));
            this.info.put(i, new LinkedHashMap<String, String>(src.getColumnInfo(i)));
        }
        if (skipContent) {
            return;
        }
        for (String[] row : src.rows()) {
            this.rows.add(row);
        }
    }

    public MemoryTable(CSTable src) {
        this(src, false);
    }

    public MemoryTable() {
        this.info.put(-1, new LinkedHashMap(new HashMap()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getInfo() {
        return this.getColumnInfo(-1);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column - 1);
    }

    public void setColumns(String ... columns) {
        this.columnNames = Arrays.asList(columns);
        for (int i = 0; i < this.columnNames.size(); ++i) {
            this.info.put(i + 1, new LinkedHashMap(new HashMap()));
        }
    }

    public Iterator<String[]> iterator() {
        return this.rows.iterator();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex)[columnIndex];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.rows.get((int)rowIndex)[columnIndex] = (String)aValue;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addRow(Object ... row) {
        if (row.length != this.columnNames.size()) {
            throw new IllegalArgumentException("row data != column count : " + row.length + "!=" + this.columnNames.size());
        }
        String[] s = new String[this.columnNames.size() + 1];
        s[0] = Integer.toString(this.rows.size());
        for (int i = 1; i < s.length; ++i) {
            s[i] = row[i - 1].toString();
        }
        this.rows.add(s);
    }

    public void addRows(List<String[]> r) {
        for (String[] s : r) {
            String[] ns = new String[s.length];
            for (int i = 0; i < ns.length; ++i) {
                ns[i] = new String(s[i]);
            }
            this.rows.add(ns);
        }
    }

    public void clearRows() {
        this.rows.clear();
    }

    public List<String[]> getRows(int from, int to) {
        return this.rows.subList(from, to + 1);
    }

    public List<String[]> getRows() {
        return this.rows;
    }

    @Override
    public Map<String, String> getColumnInfo(int column) {
        return this.info.get(column);
    }

    @Override
    public Iterable<String[]> rows() {
        return this.rows;
    }

    @Override
    public Iterable<String[]> rows(int skipRow) {
        return this.rows.subList(skipRow, this.rows.size() - 1);
    }
}

