/*
 * Decompiled with CFR 0.152.
 */
package oms3.nap;

import java.io.File;
import java.io.FileInputStream;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oms3.nap.AnnotationHandler;

public class AnnotationParser {
    private static Pattern annPattern = Pattern.compile("@(\\w+)(\\s*\\(([^\\)]*)\\))?[^\\n]*\\n", 32);
    private static Pattern annTestPattern = Pattern.compile("@(\\w+)", 8);

    private AnnotationParser() {
    }

    public static void handle(File srcFile, AnnotationHandler ah) throws Exception {
        FileInputStream fis = new FileInputStream(srcFile);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        CharsetDecoder cd = Charset.forName("8859_1").newDecoder();
        CharBuffer cb = cd.decode(bb);
        ah.start(cb.toString());
        AnnotationParser.handle(cb.toString(), ah);
        ah.done();
        fis.close();
    }

    public static void handle(String s, AnnotationHandler ah) {
        LinkedHashMap<String, Map<String, String>> l = new LinkedHashMap<String, Map<String, String>>();
        Matcher m = annPattern.matcher(s);
        while (m.find()) {
            String rest = s.substring(m.end(0)).trim();
            String srcLine = null;
            srcLine = rest.indexOf(10) > -1 ? rest.substring(0, rest.indexOf(10)) : rest;
            LinkedHashMap<String, String> val = new LinkedHashMap<String, String>();
            String annArgs = m.group(3);
            if (annArgs != null) {
                if (annArgs.indexOf(61) > -1) {
                    StringTokenizer t = new StringTokenizer(annArgs, ",");
                    while (t.hasMoreTokens()) {
                        String arg = t.nextToken();
                        String key = arg.substring(0, arg.indexOf(61));
                        String value = arg.substring(arg.indexOf(61) + 1);
                        val.put(key.trim(), value.trim());
                    }
                } else {
                    val.put("value", annArgs);
                }
            }
            l.put(m.group(1), val);
            if (annTestPattern.matcher(srcLine).find()) continue;
            ah.handle(l, srcLine);
            ah.log(" Ann -> " + l);
            ah.log(" Src -> " + srcLine);
            l = new LinkedHashMap();
        }
    }

    public static String trimQuotes(String val) {
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    static String toString(Map<String, Map<String, String>> ann) {
        StringBuilder b = new StringBuilder();
        for (String decl : ann.keySet()) {
            b.append(" @" + decl);
            Map<String, String> v = ann.get(decl);
            String value = v.get("value");
            if (value != null) {
                b.append(" (" + value + ")");
            } else if (v.size() > 0) {
                b.append(" (");
                int i = -1;
                for (String string : v.keySet()) {
                    b.append(string + "=" + v.get(string));
                    if (++i >= v.size() - 1) continue;
                    b.append(", ");
                }
                b.append(")");
            }
            b.append("\n");
        }
        return b.toString();
    }
}

