/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import oms3.ngmf.ui.mms.MMSParameterAdapter;

public class Convert {
    public static void main(String[] args) {
        Convert.data("C:/tmp/east.data");
    }

    public static String data(String file) {
        File dataFile = new File(file);
        if (!dataFile.isAbsolute()) {
            String work = System.getProperty("oms3.work");
            if (work == null) {
                return "Error no $work property found, use full qualifies name instead.)";
            }
            dataFile = new File(work + "/data", file);
        }
        String name = dataFile.getName().substring(0, dataFile.getName().indexOf(46));
        File out = new File(dataFile.getParentFile(), name + ".csv");
        StringBuffer head = new StringBuffer("@H, date");
        StringBuffer type = new StringBuffer(" type, Date");
        StringBuffer dout = new StringBuffer(",");
        try {
            String data;
            FileReader fr = new FileReader(dataFile);
            BufferedReader br = new BufferedReader(fr);
            String h = br.readLine();
            String statHdr = br.readLine();
            while (!statHdr.startsWith("###")) {
                if (statHdr.startsWith("//") || statHdr.isEmpty()) {
                    statHdr = br.readLine();
                    continue;
                }
                String[] st = statHdr.split("\\s+");
                int cols = Integer.parseInt(st[1]);
                for (int i = 0; i < cols; ++i) {
                    head.append(", " + st[0] + "[" + i + "]");
                    type.append(", double");
                }
                statHdr = br.readLine();
            }
            PrintWriter w = new PrintWriter(out);
            w.println("@T, \"Table\"");
            w.println(" created_at, \"" + new Date() + "\"");
            w.println(" converted_from, \"" + dataFile + "\"");
            w.println(" date_format, yyyy MM dd H m s");
            w.println(" Title, \"" + h + "\"");
            w.println(head);
            w.println(type);
            while ((data = br.readLine()) != null) {
                int i;
                String[] str = data.split(" ");
                for (i = 0; i < 6; ++i) {
                    dout.append(str[i] + " ");
                }
                for (i = 6; i < str.length; ++i) {
                    dout.append("," + str[i]);
                }
                w.println(dout);
                dout.delete(1, dout.length());
            }
            fr.close();
            w.close();
            return "  Converted: '" + file + "' -> '" + out + "'\n";
        }
        catch (IOException ioe) {
            return "Error : " + ioe.getMessage() + "\n";
        }
    }

    public static String param(String file) {
        File param = new File(file);
        if (!param.isAbsolute()) {
            String work = System.getProperty("oms3.work");
            if (work == null) {
                return "Error no $work property found, use full qualifies name instead.)";
            }
            param = new File(work + "/data", file);
        }
        String name = param.getName().substring(0, param.getName().indexOf(46));
        File out = new File(param.getParentFile(), name + ".csv");
        try {
            MMSParameterAdapter.MmsParamInfo info = MMSParameterAdapter.map(param);
            info.store(new FileOutputStream(out));
            return "  Converted: '" + file + "' -> '" + out + "'\n";
        }
        catch (IOException ex) {
            return "Error: " + ex.getMessage();
        }
    }

    public static String statvar(String file) {
        StringBuffer head = new StringBuffer("@H, date");
        StringBuffer type = new StringBuffer(" type, Date");
        StringBuffer dout = new StringBuffer(",");
        File statvar = new File(file);
        if (!statvar.isAbsolute()) {
            String work = System.getProperty("oms3.work");
            if (work == null) {
                return "Error no $work property found, use full qualifies name instead.)";
            }
            statvar = new File(work + "/data", file);
        }
        String name = statvar.getName().substring(0, statvar.getName().indexOf(46));
        File out = new File(statvar.getParentFile(), name + ".csv");
        try {
            String data;
            FileReader fr = new FileReader(statvar);
            BufferedReader br = new BufferedReader(fr);
            String statHdr = br.readLine();
            int varNum = Integer.parseInt(statHdr);
            for (int i = 0; i < varNum; ++i) {
                String s = br.readLine();
                String[] st = s.split("\\s+");
                head.append(", " + st[0]);
                type.append(", double");
            }
            PrintWriter w = new PrintWriter(out);
            w.println("@T, \"Table\"");
            w.println(" created_at, \"" + new Date() + "\"");
            w.println(" converted_from, \"" + statvar + "\"");
            w.println(" date_format, yyyy MM dd H m s");
            w.println(head);
            w.println(type);
            while ((data = br.readLine()) != null) {
                int i;
                String[] str = data.split(" ");
                for (i = 1; i < 7; ++i) {
                    dout.append(str[i] + " ");
                }
                dout.append(",");
                for (i = 7; i < str.length - 1; ++i) {
                    dout.append(str[i] + ",");
                }
                dout.append(str[str.length - 1]);
                w.println(dout);
                dout.delete(1, dout.length());
            }
            fr.close();
            w.close();
            return "  Converted: '" + file + "' -> '" + out + "'\n";
        }
        catch (IOException ioe) {
            return "Error : " + ioe.getMessage() + "\n";
        }
    }
}

