/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.ui;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Element;
import oms3.ngmf.ui.CommandHandler;

public class JConsolePanel
extends JTextArea {
    private static final long serialVersionUID = 1L;
    private PrintWriter w = new PrintWriter(new Writer(){

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            JConsolePanel.this.append(new String(cbuf, off, len));
            JConsolePanel.this.setCaretPosition(JConsolePanel.this.getText().length());
            JConsolePanel.this.cp = JConsolePanel.this.getCaretPosition();
            JConsolePanel.this.scrollRectToVisible(new Rectangle(0, JConsolePanel.this.getHeight(), 1, 1));
        }
    });
    CommandHandler cmd;
    Prompt prompt;
    History history;
    int cp;

    public JConsolePanel(Prompt p, CommandHandler cmd, History hist) {
        this.setPromptProvider(p);
        this.setCommandHandler(cmd);
        this.setHistory(hist);
        this.setText(this.prompt.getPrompt());
        this.cp = this.prompt.getPrompt().length();
        this.setEditable(true);
        this.setLineWrap(true);
        this.addKeyListener(new KListener());
        this.setCaretPosition(this.getText().length());
        this.setFont(new Font("Monospaced", 1, 12));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int last;
                int caretPosition = JConsolePanel.this.getCaretPosition();
                Element el = JConsolePanel.this.getDocument().getDefaultRootElement();
                int msel = el.getElementIndex(caretPosition) + 1;
                if (msel != (last = el.getElementIndex(JConsolePanel.this.getText().length()) + 1)) {
                    JConsolePanel.this.setCaretPosition(JConsolePanel.this.getText().length());
                }
            }
        });
    }

    public JConsolePanel() {
        this(new Prompt(), null, new History());
        this.setCommandHandler(new DefaultCommandHandler());
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                JConsolePanel.this.append(Character.toString((char)b));
                JConsolePanel.this.setCaretPosition(JConsolePanel.this.getText().length());
                JConsolePanel.this.cp = JConsolePanel.this.getCaretPosition();
                JConsolePanel.this.scrollRectToVisible(new Rectangle(0, JConsolePanel.this.getHeight(), 1, 1));
            }
        };
    }

    public void prompt() {
        this.append(this.prompt.getPrompt());
        this.setCaretPosition(this.getText().length());
        this.cp = this.getCaretPosition();
        this.scrollRectToVisible(new Rectangle(0, this.getHeight(), 1, 1));
    }

    public void clear() {
        this.setText("");
        this.cp = this.prompt.getPrompt().length();
    }

    public void setCommandHandler(CommandHandler h) {
        this.cmd = h;
    }

    public void setPromptProvider(Prompt p) {
        this.prompt = p;
    }

    public void setHistory(History h) {
        this.history = h;
    }

    public PrintWriter getOut() {
        return this.w;
    }

    public static void main(String[] args) throws Exception {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JConsolePanel cp = new JConsolePanel();
        cp.getOut().println("test hetre");
        cp.getOut().println("test next");
        cp.prompt();
        JScrollPane sp = new JScrollPane(cp);
        sp.setHorizontalScrollBarPolicy(31);
        sp.setVerticalScrollBarPolicy(22);
        f.getContentPane().add(sp);
        f.setSize(500, 500);
        f.setLocation(300, 300);
        f.setVisible(true);
    }

    private class KListener
    extends KeyAdapter {
        private KListener() {
        }

        @Override
        public void keyPressed(KeyEvent key) {
            switch (key.getKeyCode()) {
                case 67: {
                    if (!key.isControlDown()) break;
                    key.consume();
                    JConsolePanel.this.append("\n");
                    JConsolePanel.this.append(JConsolePanel.this.prompt.getPrompt());
                    JConsolePanel.this.setCaretPosition(JConsolePanel.this.getText().length());
                    JConsolePanel.this.cp = JConsolePanel.this.getCaretPosition();
                    break;
                }
                case 38: {
                    String prev = JConsolePanel.this.history.prev();
                    if (prev != null) {
                        JConsolePanel.this.replaceRange(prev, JConsolePanel.this.cp, JConsolePanel.this.getText().length());
                    }
                    key.consume();
                    break;
                }
                case 40: {
                    String next = JConsolePanel.this.history.next();
                    if (next != null) {
                        JConsolePanel.this.replaceRange(next, JConsolePanel.this.cp, JConsolePanel.this.getText().length());
                    }
                    key.consume();
                    break;
                }
                case 8: 
                case 37: {
                    if (JConsolePanel.this.cp != JConsolePanel.this.getCaretPosition()) break;
                    key.consume();
                    break;
                }
                case 10: {
                    String c;
                    key.consume();
                    String t = JConsolePanel.this.getText();
                    JConsolePanel.this.append("\n");
                    if (JConsolePanel.this.cmd != null && !(c = t.substring(JConsolePanel.this.cp)).isEmpty()) {
                        JConsolePanel.this.append(JConsolePanel.this.cmd.handle(c));
                        JConsolePanel.this.history.appendCommand(c);
                    }
                    JConsolePanel.this.append(JConsolePanel.this.prompt.getPrompt());
                    JConsolePanel.this.setCaretPosition(JConsolePanel.this.getText().length());
                    JConsolePanel.this.cp = JConsolePanel.this.getCaretPosition();
                }
            }
        }
    }

    static class History {
        List<String> cmds = new ArrayList<String>();
        int cursor;

        History() {
        }

        public String next() {
            if (this.cmds.size() == 0) {
                return null;
            }
            if (this.cursor < this.cmds.size() - 1) {
                ++this.cursor;
            }
            return this.cmds.get(this.cursor);
        }

        public String prev() {
            if (this.cmds.size() == 0) {
                return null;
            }
            if (this.cursor > 0) {
                --this.cursor;
            }
            return this.cmds.get(this.cursor);
        }

        public void appendCommand(String command) {
            this.cmds.add(command);
            this.cursor = this.cmds.size();
        }
    }

    static class Prompt {
        Prompt() {
        }

        public String getPrompt() {
            return "> ";
        }
    }

    class DefaultCommandHandler
    implements CommandHandler {
        DefaultCommandHandler() {
        }

        @Override
        public String handle(String cmd) {
            if (!cmd.equals("clear")) {
                return "unknown command '" + cmd + "'\n";
            }
            JConsolePanel.this.setText("");
            return null;
        }
    }
}

