/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.ui.mms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import oms3.ngmf.ui.mms.Dimension;
import oms3.ngmf.ui.mms.MmsParamsReader;
import oms3.ngmf.ui.mms.ParameterSet;

public class MMSParameterAdapter {
    public static MmsParamInfo map(File mmsParamFile) throws IOException {
        MmsParamInfo info = new MmsParamInfo();
        info.omsParams = new Properties();
        MmsParamsReader mmsReader = new MmsParamsReader(mmsParamFile.toString());
        ParameterSet ps = mmsReader.read();
        info.description = ps.getDescription();
        info.version = ps.getVersion();
        Map m = ps.getDims();
        for (Object param : m.values()) {
            info.omsParams.put(param.getName(), Integer.toString(param.getSize()));
            info.meta.put(param.getName(), " role, dimension");
        }
        m = ps.getParams();
        for (Object param : m.values()) {
            int j1;
            int j;
            int idx;
            Dimension d2;
            Object[] v;
            Object val = param.getVals();
            StringBuffer b = new StringBuffer();
            if (!param.getDimension(0).getName().equals("one")) {
                b.append("{");
            }
            if (val.getClass() == int[].class) {
                v = (int[])val;
                if (param.getNumDim() == 2) {
                    Dimension d1 = param.getDimension(0);
                    d2 = param.getDimension(1);
                    info.meta.put(param.getName(), " bound, " + d1.getName() + ", " + d2.getName());
                    idx = 0;
                    if (d1.getSize() * d2.getSize() == 0) {
                        b.append("{ }");
                    } else {
                        for (j = 0; j < d2.getSize(); ++j) {
                            b.append("{");
                            for (j1 = 0; j1 < d1.getSize(); ++j1) {
                                b.append(v[idx++] + (j1 < d1.getSize() - 1 ? ", " : ""));
                            }
                            b.append("}" + (j < d2.getSize() - 1 ? ", " : ""));
                        }
                    }
                } else if (!param.getDimension(0).getName().equals("one")) {
                    for (int j2 = 0; j2 < v.length; ++j2) {
                        b.append(v[j2] + (j2 < v.length - 1 ? ", " : ""));
                    }
                    info.meta.put(param.getName(), " bound, " + param.getDimension(0).getName());
                } else {
                    b.append(v[0]);
                }
            } else if (val.getClass() == double[].class) {
                v = (double[])val;
                if (param.getNumDim() == 2) {
                    Dimension d1 = param.getDimension(0);
                    d2 = param.getDimension(1);
                    info.meta.put(param.getName(), " bound, " + d1.getName() + ", " + d2.getName());
                    idx = 0;
                    if (d1.getSize() * d2.getSize() == 0) {
                        b.append("{ }");
                    } else {
                        for (j = 0; j < d2.getSize(); ++j) {
                            b.append("{");
                            for (j1 = 0; j1 < d1.getSize(); ++j1) {
                                b.append(v[idx++] + (j1 < d1.getSize() - 1 ? ", " : ""));
                            }
                            b.append("}" + (j < d2.getSize() - 1 ? ", " : ""));
                        }
                    }
                } else if (!param.getDimension(0).getName().equals("one")) {
                    for (int j3 = 0; j3 < v.length; ++j3) {
                        b.append(v[j3] + (j3 < v.length - 1 ? ", " : ""));
                    }
                    info.meta.put(param.getName(), " bound, " + param.getDimension(0).getName());
                } else {
                    b.append((double)v[0]);
                }
            }
            if (!param.getDimension(0).getName().equals("one")) {
                b.append("}");
            }
            Object result = param.getName().equals("snarea_curve") ? "{" + b.toString() + "}" : b.toString();
            info.omsParams.put(param.getName(), result);
        }
        return info;
    }

    public static void main(String[] args) throws Exception {
        MmsParamInfo info = MMSParameterAdapter.map(new File("c:/omswork/prms/data/efcarson.params"));
        info.omsParams.store(new FileOutputStream(new File("c:/omswork/prms/data/efcarson1.pps")), info.description + " (" + info.version + ")");
    }

    public static class MmsParamInfo {
        String description;
        String version;
        Properties omsParams;
        Properties meta = new Properties();

        public void store(OutputStream out) throws IOException {
            PrintStream p = new PrintStream(out);
            TreeMap<Object, Object> tm = new TreeMap<Object, Object>(this.omsParams);
            int maxlen = -1;
            for (String string : tm.keySet()) {
                maxlen = Math.max(string.length(), maxlen);
            }
            p.println("@S, Parameter");
            p.println(" Descr, \"" + this.description + "\"");
            p.println(" Version, \"" + this.version + "\"");
            p.println(" CreatedAt, \"" + new Date() + "\"");
            for (String string : tm.keySet()) {
                p.println("@P, " + this.format(string, maxlen) + "\"" + tm.get(string) + "\"");
                p.println(this.meta.get(string) == null ? "" : this.meta.get(string));
            }
            p.close();
        }

        private String format(String inp, int fillLength) {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < fillLength - inp.length(); ++i) {
                b.append(' ');
            }
            return inp + "," + b.toString();
        }
    }
}

