/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.ui.mms;

import oms3.ngmf.ui.mms.Dimension;
import oms3.ngmf.ui.mms.MmsDimension;
import oms3.ngmf.ui.mms.Parameter;

public class MmsParameter
implements Parameter,
Comparable {
    private String name;
    private int width = 0;
    private Dimension[] dimensions;
    private int[] size;
    private Class type;
    private Object vals;
    private Object origVals;
    private int total_size = 0;

    public MmsParameter(String name, int width, Dimension[] dimensions, Class type, Object vals) {
        this.name = name;
        this.width = width;
        this.dimensions = dimensions;
        this.type = type;
        this.vals = vals;
        this.size = new int[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            this.size[i] = dimensions[i].getSize();
            if (i == 0) {
                this.total_size = this.size[0];
                continue;
            }
            this.total_size *= this.size[i];
        }
        if (type == Integer.class) {
            int[] temp = new int[this.total_size];
            for (int i = 0; i < this.total_size; ++i) {
                temp[i] = ((int[])vals)[i];
            }
            this.origVals = temp;
        } else {
            double[] temp = new double[this.total_size];
            for (int i = 0; i < this.total_size; ++i) {
                temp[i] = ((double[])vals)[i];
            }
            this.origVals = temp;
        }
    }

    static void figureOutIndexes(int index, int[] sizes, int[] indexes) {
        int prev_div = 0;
        for (int i = sizes.length - 1; i > 0; --i) {
            int div = sizes[0];
            for (int j = 1; j < i; ++j) {
                div *= sizes[j];
            }
            indexes[i] = (index - prev_div) / div;
            prev_div = indexes[i] * div + prev_div;
        }
        indexes[0] = index - prev_div;
    }

    static int figureOutIndex(Dimension[] dimensions, int[] indexes) {
        int index = 0;
        for (int i = dimensions.length - 1; i > 0; --i) {
            int mult = dimensions[0].getSize();
            for (int j = 1; j < i; ++j) {
                mult *= dimensions[j].getSize();
            }
            index += mult * indexes[i];
        }
        return index += indexes[0];
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getNumDim() {
        return this.dimensions.length;
    }

    @Override
    public Dimension getDimension(int index) {
        return this.dimensions[index];
    }

    @Override
    public int getSize() {
        return this.total_size;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Object getVals() {
        return this.vals;
    }

    @Override
    public void setVals(Object vals) {
        this.vals = vals;
    }

    @Override
    public void setValueAt(Object val, int index) {
        if (this.type == Integer.class) {
            int[] foo = (int[])this.vals;
            foo[index] = (Integer)val;
        } else {
            double[] foo = (double[])this.vals;
            foo[index] = (Double)val;
        }
    }

    @Override
    public boolean isDimensionedBy(Dimension dim) {
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (this.dimensions[i] != dim) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getMean() {
        if (this.total_size == 0) {
            return Double.NaN;
        }
        double mean = 0.0;
        if (this.type == Integer.class) {
            for (int i = 0; i < this.total_size; ++i) {
                mean += (double)((int[])this.vals)[i];
            }
            mean /= (double)this.total_size;
        } else {
            for (int i = 0; i < this.total_size; ++i) {
                mean += ((double[])this.vals)[i];
            }
            mean /= (double)this.total_size;
        }
        return mean;
    }

    @Override
    public double getMin() {
        if (this.total_size == 0) {
            return Double.NaN;
        }
        double min = Double.POSITIVE_INFINITY;
        if (this.type == Integer.class) {
            for (int i = 0; i < this.total_size; ++i) {
                if (!(min > (double)((int[])this.vals)[i])) continue;
                min = ((int[])this.vals)[i];
            }
        } else {
            for (int i = 0; i < this.total_size; ++i) {
                if (!(min > ((double[])this.vals)[i])) continue;
                min = ((double[])this.vals)[i];
            }
        }
        return min;
    }

    @Override
    public double getMax() {
        if (this.total_size == 0) {
            return Double.NaN;
        }
        double max = Double.NEGATIVE_INFINITY;
        if (this.type == Integer.class) {
            for (int i = 0; i < this.total_size; ++i) {
                if (!(max < (double)((int[])this.vals)[i])) continue;
                max = ((int[])this.vals)[i];
            }
        } else {
            for (int i = 0; i < this.total_size; ++i) {
                if (!(max < ((double[])this.vals)[i])) continue;
                max = ((double[])this.vals)[i];
            }
        }
        return max;
    }

    @Override
    public void resize() {
        int j;
        boolean within_bounds;
        int i;
        int[] old_index;
        Object[] temp;
        int new_size = 0;
        for (int i2 = 0; i2 < this.dimensions.length; ++i2) {
            if (i2 == 0) {
                new_size = this.dimensions[0].getSize();
                continue;
            }
            new_size *= this.dimensions[i2].getSize();
        }
        if (this.type == Integer.class) {
            temp = new int[new_size];
            old_index = new int[this.dimensions.length];
            for (i = 0; i < new_size; ++i) {
                temp[i] = Integer.MIN_VALUE;
            }
            block2: for (i = 0; i < this.total_size; ++i) {
                MmsParameter.figureOutIndexes(i, this.size, old_index);
                within_bounds = true;
                for (j = 0; j < this.dimensions.length; ++j) {
                    if (old_index[j] >= this.dimensions[j].getSize()) {
                        within_bounds = false;
                        continue block2;
                    }
                    if (!within_bounds) continue;
                    temp[MmsParameter.figureOutIndex((Dimension[])this.dimensions, (int[])old_index)] = ((int[])this.vals)[i];
                }
            }
            this.vals = temp;
        } else {
            temp = new double[new_size];
            old_index = new int[this.dimensions.length];
            for (i = 0; i < new_size; ++i) {
                temp[i] = (int)Double.MIN_VALUE;
            }
            block5: for (i = 0; i < this.total_size; ++i) {
                MmsParameter.figureOutIndexes(i, this.size, old_index);
                within_bounds = true;
                for (j = 0; j < this.dimensions.length; ++j) {
                    if (old_index[j] >= this.dimensions[j].getSize()) {
                        within_bounds = false;
                        continue block5;
                    }
                    if (!within_bounds) continue;
                    temp[MmsParameter.figureOutIndex((Dimension[])this.dimensions, (int[])old_index)] = (int)((double[])this.vals)[i];
                }
            }
            this.vals = temp;
        }
        for (int i3 = 0; i3 < this.dimensions.length; ++i3) {
            this.size[i3] = this.dimensions[i3].getSize();
            if (i3 == 0) {
                this.total_size = this.size[0];
                continue;
            }
            this.total_size *= this.size[i3];
        }
    }

    public int compareTo(Object o) {
        if (o.getClass() == MmsParameter.class) {
            return this.name.compareTo(((MmsParameter)o).getName());
        }
        return this.name.compareTo((String)o);
    }

    public static void main(String[] arg) {
        int[] indexes = new int[3];
        Dimension[] dims = new MmsDimension[]{new MmsDimension("nlapse", 4), new MmsDimension("nmonth", 3), new MmsDimension("foo", 2)};
        for (int ifoo = 0; ifoo < 2; ++ifoo) {
            for (int imonth = 0; imonth < 3; ++imonth) {
                int ilapse = 0;
                while (ilapse < 4) {
                    indexes[0] = ilapse++;
                    indexes[1] = imonth;
                    indexes[2] = ifoo;
                    System.out.println(MmsParameter.figureOutIndex(dims, indexes) + " " + indexes[0] + " " + indexes[1] + " " + indexes[2]);
                }
            }
        }
    }
}

