/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.ui.mms;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import oms3.ngmf.ui.mms.MmsDimension;
import oms3.ngmf.ui.mms.MmsParameter;

public class ParameterSetHistory {
    private String date;
    private String who;
    private String comment;
    private String source;
    private String what;
    private final Throwable tracer = new Throwable();
    private DateFormat df = DateFormat.getDateTimeInstance();

    public ParameterSetHistory(String hist_string) {
        StringTokenizer st = new StringTokenizer(hist_string);
        st.nextToken("\"");
        this.date = st.nextToken("\"");
        st.nextToken("\"");
        this.who = st.nextToken("\"");
        st.nextToken("\"");
        this.what = st.nextToken("\"");
        st.nextToken("\"");
        this.source = st.nextToken("\"");
        st.nextToken("\"");
        this.comment = st.nextToken("\"");
    }

    public ParameterSetHistory(String date, String who, String what, String source, String comment) {
        this.date = date;
        this.who = who;
        this.what = what;
        this.source = source;
        this.comment = comment;
    }

    public ParameterSetHistory(Object what, String comment) {
        this.comment = comment;
        this.date = this.df.format(new Date());
        this.who = System.getProperty("user.name");
        this.source = this.findCaller(2);
        if (what.getClass() == MmsParameter.class) {
            MmsParameter param = (MmsParameter)what;
            this.what = "parameter " + param.getName() + " changed";
        } else if (what.getClass() == MmsDimension.class) {
            MmsDimension dim = (MmsDimension)what;
            this.what = "dimension " + dim.getName() + " changed";
        } else if (what.getClass() == File.class) {
            File file = (File)what;
            this.what = "file renamed from " + file.getPath();
        } else {
            System.out.println("MmsParameterSetHistory unknown object type");
        }
    }

    private String findCaller(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException();
        }
        this.tracer.fillInStackTrace();
        return this.tracer.getStackTrace()[depth + 1].toString();
    }

    public String getDate() {
        return this.date;
    }

    public String getWho() {
        return this.who;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getSource() {
        return this.source;
    }

    public String getWhat() {
        return this.what;
    }

    public String toString() {
        return "<history date=\"" + this.date + "\" who=\"" + this.who + "\" what=\"" + this.what + "\" source=\"" + this.source + "\" comment=\"" + this.comment + "\"\\>";
    }
}

