/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Control {
    static final String SSH_KEY = "ssh";
    static final String KEY_KEY = "key";
    static final String SCP_KEY = "scp";
    static final String USER_KEY = "user";
    static final String CLUSTER_KEY = "cluster.";
    final File tempFolder = new File(System.getProperty("java.io.tmpdir"));
    final Properties conf = new Properties();
    String[] nodes;
    List<Integer> idx;
    boolean verbose = true;
    boolean sync;

    private OutputStream getOutputStream(final String s) {
        return new OutputStream(){
            StringBuffer o = new StringBuffer();
            boolean done = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int b) throws IOException {
                if (b == 10 && !Control.this.sync) {
                    Properties properties = Control.this.conf;
                    synchronized (properties) {
                        System.out.printf("[%s] %s \n", s, this.o.toString());
                    }
                    this.o = new StringBuffer();
                }
                this.o.append((char)b);
            }

            @Override
            public void flush() throws IOException {
                if (!this.done) {
                    if (Control.this.sync) {
                        System.out.printf("************* %s **************\n", s);
                    }
                    System.out.printf(this.o.toString(), new Object[0]);
                    this.done = true;
                }
            }
        };
    }

    private String[] getNodes(String clusterName) {
        String s = this.conf.getProperty(CLUSTER_KEY + clusterName);
        if (s != null) {
            String[] n = s.split("\\s+");
            if (n.length < 1) {
                throw new IllegalArgumentException("No nodes in cluster " + clusterName);
            }
            return n;
        }
        throw new IllegalArgumentException("No such cluster '" + clusterName + "'");
    }

    public void runCExec(List<String> nodes, final String cmd) {
        this.run(nodes, new RCmd(){

            @Override
            public File file() {
                return new File(Control.this.conf.getProperty(Control.SSH_KEY));
            }

            @Override
            public String[] args(String node) {
                return new String[]{"-i", Control.this.conf.getProperty(Control.KEY_KEY), "-l", Control.this.conf.getProperty(Control.USER_KEY), node, cmd};
            }
        });
    }

    public void runCPut(List<String> nodes, final String from, final String to) {
        this.run(nodes, new RCmd(){

            @Override
            public File file() {
                return new File(Control.this.conf.getProperty(Control.SCP_KEY));
            }

            @Override
            public String[] args(String node) {
                return new String[]{"-i", Control.this.conf.getProperty(Control.KEY_KEY), from, Control.this.conf.getProperty(Control.USER_KEY) + "@" + node + ":" + to};
            }
        });
    }

    public void runCGet(List<String> nodes, final String from, final String to) {
        this.run(nodes, new RCmd(){

            @Override
            public File file() {
                return new File(Control.this.conf.getProperty(Control.SCP_KEY));
            }

            @Override
            public String[] args(String node) {
                return new String[]{"-i", Control.this.conf.getProperty(Control.KEY_KEY), Control.this.conf.getProperty(Control.USER_KEY) + "@" + node + ":" + from, to};
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(List<String> nodes, RCmd rcmd) {
        final CountDownLatch latch = new CountDownLatch(this.idx.size());
        ExecutorService e = Executors.newFixedThreadPool(this.idx.size());
        File userDir = new File(System.getProperty("user.dir"));
        for (String node : nodes) {
            e.submit(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        finally {
            e.shutdown();
        }
    }

    public Control() throws IOException {
        FileInputStream is = new FileInputStream(new File(System.getProperty("user.home"), "nc2.conf"));
        this.conf.load(is);
        ((InputStream)is).close();
        if (!(this.conf.containsKey(SSH_KEY) && this.conf.containsKey(KEY_KEY) && this.conf.containsKey(SCP_KEY) && this.conf.containsKey(USER_KEY) && this.conf.containsKey("cluster.default"))) {
            throw new IllegalArgumentException("Missing entries in nc2.conf");
        }
        this.conf.list(System.out);
        this.nodes = this.getNodes("default");
        this.idx = Control.parseRange("0-*", this.nodes.length);
        System.out.printf(" NGMF Cluster Control v0.1\n\n", new Object[0]);
    }

    public void process(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-exec")) {
                Object cmd = "";
                ++i;
                while (i < args.length) {
                    cmd = (String)cmd + " " + args[i];
                    ++i;
                }
                continue;
            }
            if (arg.startsWith("-put")) continue;
            if (arg.equals("-list")) {
                for (int j = 0; j < this.nodes.length; ++j) {
                    System.out.printf(" %0$5d: %s\n", j, this.nodes[j]);
                }
                continue;
            }
            if (arg.equals("-s")) {
                this.sync = true;
                continue;
            }
            if (arg.equals("-v")) {
                this.verbose = true;
                continue;
            }
            if (arg.equals("-c")) {
                String cluster = args[++i];
                String[] cl = cluster.split(":");
                this.nodes = this.getNodes(cl[0]);
                this.idx = Control.parseRange(cl.length == 2 ? cl[1] : "0-*", this.nodes.length);
                continue;
            }
            System.err.printf(" Invalid Option '%s'.\n", arg);
            System.exit(0);
        }
    }

    private static List<Integer> parseRange(String range, int max) {
        String[] n;
        ArrayList<Integer> idx = new ArrayList<Integer>();
        for (String s : n = range.split(",")) {
            String[] d = s.split("-");
            int mi = Integer.parseInt(d[0]);
            if (mi < 0 || mi >= max) {
                throw new IllegalArgumentException(range);
            }
            if (d.length == 2) {
                int ma;
                if (d[1].equals("*")) {
                    d[1] = Integer.toString(max - 1);
                }
                if ((ma = Integer.parseInt(d[1])) <= mi || ma >= max || ma < 0) {
                    throw new IllegalArgumentException(range);
                }
                for (int i = mi; i <= ma; ++i) {
                    idx.add(i);
                }
                continue;
            }
            idx.add(mi);
        }
        return idx;
    }

    private static List<String> ips(List<Integer> a, List<Integer> b, List<Integer> c, List<Integer> d) {
        ArrayList<String> ip = new ArrayList<String>();
        for (Integer ai : a) {
            for (Integer bi : b) {
                for (Integer ci : c) {
                    for (Integer di : d) {
                        ip.add(ai + "." + bi + "." + ci + "." + di);
                    }
                }
            }
        }
        return ip;
    }

    public static void main(String[] args) throws IOException {
        String cmd = "test jsjs {1} {0} ksksks {2}";
        System.out.println(MessageFormat.format(cmd, 1, 2, "test"));
    }

    private static interface RCmd {
        public File file();

        public String[] args(String var1);
    }
}

