/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.util;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.Arrays;
import oms3.ngmf.util.FilenameUtils;
import oms3.ngmf.util.IOCase;

public class WildcardFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 2998954975458664788L;
    private final String wildcards;
    private final IOCase caseSensitivity;

    public WildcardFileFilter(String wildcard) {
        this(wildcard, null);
    }

    public WildcardFileFilter(String wildcard, IOCase caseSensitivity) {
        if (wildcard == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = wildcard;
        this.caseSensitivity = caseSensitivity == null ? IOCase.SENSITIVE : caseSensitivity;
    }

    @Override
    public boolean accept(File file) {
        String name = file.getName();
        return FilenameUtils.wildcardMatch(name, this.wildcards, this.caseSensitivity);
    }

    public static void main(String[] args) {
        File f = new File("c:/tmp");
        Object[] fi = f.listFiles(new WildcardFileFilter("hey.groovy"));
        System.out.println(Arrays.toString(fi));
    }
}

