/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.util.cosu;

import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import oms3.ngmf.util.cosu.Sample;

public class BranchAndBound {
    double test = 0.0;
    double[] lowBound;
    double[] upBound;
    int mode;
    int currentSampleCount;
    double effValue;
    int maxn;
    int n;
    double[] parameters;
    Vector<Sample> sampleList = new Vector();
    Random generator = new Random();

    double[] VectorAdd(double[] a, double[] b) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] + b[i];
        }
        return sum;
    }

    double[] VectorAdd(double[] a, double b) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] + b;
        }
        return sum;
    }

    double[] VectorSub(double[] a, double[] b) {
        double[] sum = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            sum[i] = a[i] - b[i];
        }
        return sum;
    }

    double[] VectorMul(double[] a, double mul) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * mul;
        }
        return result;
    }

    double[] VectorMul(double[] a, double[] mul) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * mul[i];
        }
        return result;
    }

    boolean VectorLessEq(double[] x, double[] y) {
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] > y[i] - 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    double VectorNorm(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum += Math.abs(v[i]);
        }
        return sum;
    }

    double VectorNorm2(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum += v[i] * v[i];
        }
        return Math.sqrt(sum);
    }

    double VectorMaxNorm(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum = Math.max(Math.abs(v[i]), sum);
        }
        return sum;
    }

    double VectorMin(double[] v) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum = Math.min(v[i], sum);
        }
        return sum;
    }

    int getMin(Vector<Sample> Q) {
        double min = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < Q.size(); ++i) {
            if (!(Q.get((int)i).fx < min)) continue;
            min = Q.get((int)i).fx;
            index = i;
        }
        return index;
    }

    Sample getSample(double[] x) {
        Sample s = new Sample(x, this.funct(x));
        this.sampleList.add(s);
        return s;
    }

    double funct(double[] x) {
        for (int j = 0; j < this.parameters.length; ++j) {
            try {
                this.parameters[j] = x[j];
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error! Parameter No. " + j + " wasn^t found" + e.toString());
            }
        }
        double value = this.effValue;
        double bigNumber = 1.0E7;
        this.effValue = Math.max(this.effValue, -bigNumber);
        this.effValue = Math.min(this.effValue, bigNumber);
        if (Double.isNaN(this.effValue)) {
            this.effValue = -bigNumber;
        }
        ++this.currentSampleCount;
        switch (this.mode) {
            case 2: {
                return value;
            }
            case 1: {
                return -value;
            }
            case 4: {
                return Math.abs(value);
            }
            case 3: {
                return -Math.abs(value);
            }
        }
        return 0.0;
    }

    double[] randomSample() {
        double[] sample = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            sample[i] = this.lowBound[i] + this.generator.nextDouble() * (this.upBound[i] - this.lowBound[i]);
        }
        return sample;
    }

    double ApproxL(Sample a, Sample b, HyperCube myCube) {
        this.lowBound = a.x;
        this.upBound = b.x;
        ArrayList<Sample> list = myCube.InCubeSamples;
        if (myCube.parent != null) {
            for (int i = 0; i < myCube.parent.InCubeSamples.size(); ++i) {
                Sample x = myCube.parent.InCubeSamples.get(i);
                if (!this.VectorLessEq(a.x, x.x) || !this.VectorLessEq(x.x, b.x) || list.contains(x)) continue;
                boolean contains = false;
                for (int j = 0; j < list.size(); ++j) {
                    if (!(this.VectorNorm(this.VectorSub(list.get((int)j).x, x.x)) < 1.0E-4)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                myCube.addCubeSample(x);
            }
        }
        while (list.size() < 3 * this.n + 1) {
            Sample rnd_point = this.getSample(this.randomSample());
            if (rnd_point.fx < a.fx && rnd_point.fx < b.fx) {
                this.test = a.fx - rnd_point.fx + b.fx - rnd_point.fx;
            }
            myCube.addCubeSample(rnd_point);
        }
        double variance = 0.0;
        double mean = 0.0;
        double sL = 0.0;
        double size = (double)((list.size() - 1) * list.size()) / 2.0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                double d = this.VectorNorm2(this.VectorSub(list.get((int)i).x, list.get((int)j).x));
                sL = Math.max(Math.abs((list.get((int)i).fx - list.get((int)j).fx) / d), sL);
                mean += sL;
            }
        }
        mean /= size;
        return sL;
    }

    public void run() {
        double myR;
        Vector<Sample> Q = new Vector<Sample>();
        Vector<HyperCube> cubes = new Vector<HyperCube>();
        int xCount = 0;
        double epsilon1 = 0.1;
        int k = 1;
        System.out.println("***************************");
        System.out.println("****start optimization ****");
        System.out.println("***************************");
        Sample a = this.getSample(this.lowBound);
        Sample b = this.getSample(this.upBound);
        Q.add(a);
        Q.add(b);
        double[] xR_tmp = this.VectorMul(this.VectorAdd(this.lowBound, this.upBound), 0.5);
        Sample xR = this.getSample(xR_tmp);
        Q.add(xR);
        int IndexWithMinimum = this.getMin(Q);
        Sample v = Q.get(IndexWithMinimum);
        double gamma = v.fx;
        HyperCube R = new HyperCube(a, b, xR, null);
        cubes.add(R);
        double L = R.L;
        double my = myR = Math.max(Math.max(a.fx, b.fx) - this.VectorNorm(this.VectorMul(this.VectorSub(a.x, b.x), L)), xR.fx - this.VectorNorm(this.VectorMul(this.VectorSub(a.x, b.x), L)) / 2.0);
        Stack<HyperCube> queue = new Stack<HyperCube>();
        queue.push(R);
        while (true) {
            R = (HyperCube)queue.pop();
            a = R.a;
            b = R.b;
            my = R.highestLowBound;
            if (this.maxn > 0 && this.sampleList.size() >= this.maxn) break;
            if (gamma - my < 0.1) {
                // empty if block
            }
            int sel_j = 0;
            double max = 0.0;
            for (int i = 0; i < this.n; ++i) {
                if (!(b.x[i] - a.x[i] > max)) continue;
                max = b.x[i] - a.x[i];
                sel_j = i;
            }
            Sample a1 = a;
            double[] b1_tmp = new double[this.n];
            double[] a2_tmp = new double[this.n];
            Sample b2 = b;
            for (int i = 0; i < this.n; ++i) {
                if (i == sel_j) {
                    b1_tmp[i] = (a.x[i] + b.x[i]) / 2.0;
                    a2_tmp[i] = (a.x[i] + b.x[i]) / 2.0;
                    continue;
                }
                b1_tmp[i] = b.x[i];
                a2_tmp[i] = a.x[i];
            }
            Sample b1 = this.getSample(b1_tmp);
            Sample a2 = this.getSample(a2_tmp);
            double[] xR1_tmp = this.VectorMul(this.VectorAdd(a1.x, b1.x), 0.5);
            double[] xR2_tmp = this.VectorMul(this.VectorAdd(a2.x, b2.x), 0.5);
            Sample xR1 = this.getSample(xR1_tmp);
            Sample xR2 = this.getSample(xR2_tmp);
            HyperCube R1 = new HyperCube(a1, b1, xR1, R);
            double L1 = R1.L;
            double tmp1 = this.test;
            HyperCube R2 = new HyperCube(a2, b2, xR2, R);
            double L2 = R2.L;
            double tmp2 = this.test;
            Q.clear();
            Q.add(v);
            Q.add(b1);
            Q.add(xR1);
            Q.add(a2);
            Q.add(xR2);
            IndexWithMinimum = this.getMin(Q);
            v = Q.get(IndexWithMinimum);
            gamma = v.fx;
            if (R1.goodOneFactor < tmp1) {
                R1.goodOneFactor = tmp1;
            }
            if (R2.goodOneFactor < tmp2) {
                R2.goodOneFactor = tmp2;
            }
            cubes.remove(R);
            cubes.add(R1);
            cubes.add(R2);
            my = Double.MAX_VALUE;
            ++xCount;
            if (!queue.empty()) continue;
            double[] T = new double[]{0.0};
            int[] IndexForT = new int[T.length];
            for (int t = 0; t < T.length; ++t) {
                int best = -1;
                double bestLdiff = 1.0E10;
                for (int i = 0; i < cubes.size(); ++i) {
                    HyperCube c = (HyperCube)cubes.get(i);
                    double Lstar = c.CalculateLForTarget(gamma - T[t]);
                    double Ldiff = c.highestLowBound;
                    if (Ldiff < bestLdiff) {
                        best = i;
                        bestLdiff = Ldiff;
                    }
                    if (xCount % 20 != 19) continue;
                    best = 0;
                    bestLdiff = Ldiff;
                    break;
                }
                IndexForT[t] = best;
            }
            for (int i = 0; i < IndexForT.length; ++i) {
                if (IndexForT[i] == -1) continue;
                for (int j = i + 1; j < IndexForT.length; ++j) {
                    if (IndexForT[i] != IndexForT[j]) continue;
                    IndexForT[j] = -1;
                }
                queue.push((HyperCube)cubes.get(IndexForT[i]));
            }
            ++k;
        }
    }

    class HyperCube {
        protected Sample a;
        protected Sample b;
        protected Sample midPoint;
        protected double L;
        protected ArrayList<Sample> InCubeSamples;
        public double goodOneFactor;
        protected HyperCube parent;
        protected double highestLowBound;

        HyperCube(Sample a, Sample b, Sample midPoint, HyperCube parent) {
            double minimum;
            this.a = a;
            this.b = b;
            this.midPoint = midPoint;
            this.parent = parent;
            this.InCubeSamples = new ArrayList();
            this.InCubeSamples.add(a);
            this.InCubeSamples.add(b);
            this.InCubeSamples.add(midPoint);
            this.L = BranchAndBound.this.ApproxL(a, b, this);
            if (parent != null) {
                this.highestLowBound = Math.max(Math.max(-1.0E12, Math.max(a.fx, b.fx) - BranchAndBound.this.VectorNorm2(BranchAndBound.this.VectorMul(BranchAndBound.this.VectorSub(b.x, a.x), this.L))), midPoint.fx - BranchAndBound.this.VectorNorm2(BranchAndBound.this.VectorMul(BranchAndBound.this.VectorSub(b.x, a.x), this.L)) / 2.0);
            }
            if (this.highestLowBound > (minimum = Math.min(Math.min(a.fx, b.fx), midPoint.fx))) {
                this.highestLowBound = minimum;
            }
            this.goodOneFactor = midPoint.fx - a.fx + (midPoint.fx - b.fx);
        }

        public void addCubeSample(Sample x) {
            this.InCubeSamples.add(x);
        }

        double CalculateLForTarget(double target) {
            double L_theo1 = (Math.max(this.a.fx, this.b.fx) - target) / BranchAndBound.this.VectorNorm(BranchAndBound.this.VectorSub(this.b.x, this.a.x));
            double L_theo2 = 2.0 * (this.midPoint.fx - target) / BranchAndBound.this.VectorNorm(BranchAndBound.this.VectorSub(this.b.x, this.a.x));
            return Math.min(L_theo1, L_theo2);
        }

        double bound() {
            return this.highestLowBound;
        }

        public String compactDescriptionString() {
            Object s = "";
            s = (String)s + this.a.x[0] + "\t";
            s = (String)s + this.a.x[1] + "\t";
            s = (String)s + this.highestLowBound + "\n";
            s = (String)s + this.b.x[0] + "\t";
            s = (String)s + this.a.x[1] + "\t";
            s = (String)s + this.highestLowBound + "\n";
            s = (String)s + this.b.x[0] + "\t";
            s = (String)s + this.b.x[1] + "\t";
            s = (String)s + this.highestLowBound + "\n";
            s = (String)s + this.a.x[0] + "\t";
            s = (String)s + this.b.x[1] + "\t";
            s = (String)s + this.highestLowBound + "\n";
            return s;
        }

        public String toString() {
            return "a:" + this.a.toString() + "\nb:" + this.b.toString() + "\nmidPoint:" + this.midPoint.toString() + "\nbound:" + this.highestLowBound;
        }
    }
}

