/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.util.cosu;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import oms3.ngmf.util.cosu.Graph;
import oms3.ngmf.util.cosu.MHsetup;
import oms3.ngmf.util.cosu.SCMH;
import oms3.ngmf.util.cosu.TextAreaOutput;

class Controls
extends Frame {
    private MHsetup setup;
    private int dimension;
    private Graph[] graphs;
    private TextAreaOutput taoutput;
    private SCMH mh;
    private TextField iterIn = new TextField(15);
    private TextField ageOut = new TextField(20);
    private Button burnin = new Button("Burn-in (w/o graph)");
    private Button further = new Button("Simulation (with graph)");
    private Checkbox codaout = new Checkbox("CODA output");

    public Controls(MHsetup setup, TextAreaOutput taoutput) {
        super("Simulation controls");
        int d;
        this.resize(300, 150);
        this.setup = setup;
        this.taoutput = taoutput;
        this.dimension = setup.getDimension();
        this.graphs = new Graph[this.dimension];
        for (d = 1; d <= this.dimension; ++d) {
            this.graphs[d - 1] = new Graph("x" + d, 900, 200);
        }
        for (d = 0; d < this.dimension; ++d) {
            this.graphs[d].show();
        }
        this.setLayout(new BorderLayout());
        Panel iters = new Panel();
        iters.setLayout(new GridLayout(2, 2));
        iters.add(new Label("Number of steps per click:"));
        iters.add(this.iterIn);
        this.iterIn.setText("1000");
        iters.add(new Label("Total number of steps:"));
        iters.add(this.ageOut);
        this.ageOut.setEditable(false);
        Panel buttons = new Panel();
        buttons.setLayout(new GridLayout(1, 3));
        buttons.add(this.codaout);
        buttons.add(this.burnin);
        buttons.add(this.further);
        this.add("North", iters);
        this.add("South", buttons);
        this.pack();
    }

    private void simulateAndDraw() {
        int iterations = Integer.parseInt(this.iterIn.getText());
        double[][] obs = new double[this.dimension][iterations];
        for (int i = 0; i < iterations; ++i) {
            double[] obsi = this.mh.next();
            for (int d = 0; d < this.dimension; ++d) {
                obs[d][i] = obsi[d];
            }
        }
        this.ageOut.setText("" + this.mh.getAge());
        for (int d = 0; d < this.dimension; ++d) {
            this.graphs[d].draw(obs[d], iterations, this.mh.getAge() - iterations);
        }
        if (iterations > 0 && this.dimension > 0) {
            if (this.codaout.getState()) {
                this.taoutput.clear();
            }
            this.taoutput.println("Iteration " + (this.mh.getAge() - iterations + 1) + " through " + this.mh.getAge() + ":");
            if (this.codaout.getState()) {
                this.writeCODA(obs, this.dimension, iterations, this.taoutput);
            }
            this.setup.compute(obs, this.dimension, iterations, this.taoutput);
            this.taoutput.println("");
        }
    }

    @Override
    public boolean action(Event e, Object o) {
        int oldcursor = this.getCursorType();
        this.setCursor(3);
        if (e.target == this.burnin) {
            if (this.mh == null) {
                this.mh = this.setup.newMH();
            }
            int iterations = Integer.parseInt(this.iterIn.getText());
            for (int d = 0; d < this.dimension; ++d) {
                this.graphs[d].draw(null, 0, 0);
            }
            for (int i = 0; i < iterations; ++i) {
                this.mh.next();
            }
            this.ageOut.setText("" + this.mh.getAge());
        } else if (e.target == this.further) {
            if (this.mh == null) {
                this.mh = this.setup.newMH();
            }
            this.simulateAndDraw();
        }
        this.setCursor(oldcursor);
        return true;
    }

    void writeCODA(double[][] obs, int dim, int n, TextAreaOutput out) {
        int d;
        StringBuffer buf = new StringBuffer(8 * n + 100);
        buf.append("\nData for file.ind:\n\n");
        for (d = 0; d < dim; ++d) {
            buf.append("x" + (d + 1) + "   " + (d * n + 1) + "  " + (d + 1) * n + "\n");
        }
        buf.append("\nData for file.out:\n\n");
        for (d = 0; d < dim; ++d) {
            for (int i = 0; i < n; ++i) {
                buf.append(i + 1 + "  " + obs[d][i] + "\n");
            }
        }
        buf.append("\n");
        out.print(buf.toString());
    }

    public void stopsimulation() {
        this.mh = null;
        this.taoutput.clear();
        for (int d = 0; d < this.dimension; ++d) {
            this.graphs[d].hide();
            this.graphs[d].dispose();
        }
        this.hide();
        this.dispose();
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.id == 201) {
            this.stopsimulation();
        }
        return super.handleEvent(e);
    }
}

