/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.util.cosu;

import oms3.util.Stats;

public class Efficiencies {
    public static final int MAXIMIZATION = 1;
    public static final int MINIMIZATION = 2;
    public static final int ABSMAXIMIZATION = 3;
    public static final int ABSMINIMIZATION = 4;

    private Efficiencies() {
    }

    private static void sameArrayLen(double[] ... arr) {
        int len = arr[0].length;
        for (double[] a : arr) {
            if (a.length == len) continue;
            throw new IllegalArgumentException("obs and sim data have not same size (" + a.length + "/" + len + ")");
        }
    }

    public static double nashSutcliffe(double[] obs, double[] sim, double pow) {
        int pre_size;
        Efficiencies.sameArrayLen(obs, sim);
        int steps = pre_size = sim.length;
        double sum_td = 0.0;
        double sum_vd = 0.0;
        for (int i = 0; i < steps; ++i) {
            sum_td += sim[i];
            sum_vd += obs[i];
        }
        double mean_vd = sum_vd / (double)steps;
        double td_vd = 0.0;
        double vd_mean = 0.0;
        for (int i = 0; i < steps; ++i) {
            td_vd += Math.pow(Math.abs(obs[i] - sim[i]), pow);
            vd_mean += Math.pow(Math.abs(obs[i] - mean_vd), pow);
        }
        return 1.0 - td_vd / vd_mean;
    }

    public static double nashSutcliffeLog(double[] obs, double[] sim, double pow) {
        int i;
        Efficiencies.sameArrayLen(obs, sim);
        int size = sim.length;
        double sum_log_pd = 0.0;
        double sum_log_vd = 0.0;
        double[] log_preData = new double[size];
        double[] log_valData = new double[size];
        int validPairs = 0;
        for (i = 0; i < size; ++i) {
            if (sim[i] <= 0.0 || obs[i] <= 0.0) {
                log_preData[i] = -1.0;
                log_valData[i] = -1.0;
            }
            if (sim[i] == 0.0 && obs[i] == 0.0) {
                log_preData[i] = 0.0;
                log_valData[i] = 0.0;
                ++validPairs;
            }
            if (!(sim[i] > 0.0) || !(obs[i] > 0.0)) continue;
            log_preData[i] = Math.log(sim[i]);
            log_valData[i] = Math.log(obs[i]);
            ++validPairs;
        }
        for (i = 0; i < size; ++i) {
            if (!(log_preData[i] >= 0.0)) continue;
            sum_log_pd += log_preData[i];
            sum_log_vd += log_valData[i];
        }
        double mean_log_vd = sum_log_vd / (double)validPairs;
        double pd_log_vd = 0.0;
        double vd_log_mean = 0.0;
        for (int i2 = 0; i2 < size; ++i2) {
            if (!(log_preData[i2] >= 0.0)) continue;
            pd_log_vd += Math.pow(Math.abs(log_valData[i2] - log_preData[i2]), pow);
            vd_log_mean += Math.pow(Math.abs(log_valData[i2] - mean_log_vd), pow);
        }
        return 1.0 - pd_log_vd / vd_log_mean;
    }

    public static double ioa(double[] obs, double[] sim, double pow) {
        Efficiencies.sameArrayLen(obs, sim);
        int steps = sim.length;
        double sum_obs = 0.0;
        for (int i = 0; i < steps; ++i) {
            sum_obs += obs[i];
        }
        double mean_obs = sum_obs / (double)steps;
        double td_vd = 0.0;
        double abs_sqDevi = 0.0;
        for (int i = 0; i < steps; ++i) {
            td_vd += Math.pow(Math.abs(obs[i] - sim[i]), pow);
            abs_sqDevi += Math.pow(Math.abs(sim[i] - mean_obs) + Math.abs(obs[i] - mean_obs), pow);
        }
        return 1.0 - td_vd / abs_sqDevi;
    }

    public static double[] linearReg(double[] xData, double[] yData) {
        int i;
        Efficiencies.sameArrayLen(xData, yData);
        double sumYValue = 0.0;
        double meanYValue = 0.0;
        double sumXValue = 0.0;
        double meanXValue = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double prod = 0.0;
        double NODATA = -9999.0;
        int nstat = xData.length;
        double[] regCoef = new double[3];
        int counter = 0;
        for (i = 0; i < nstat; ++i) {
            if (yData[i] == NODATA || xData[i] == NODATA) continue;
            sumYValue += yData[i];
            sumXValue += xData[i];
            ++counter;
        }
        meanYValue = sumYValue / (double)counter;
        meanXValue = sumXValue / (double)counter;
        for (i = 0; i < nstat; ++i) {
            if (yData[i] == NODATA || xData[i] == NODATA) continue;
            sumX += Math.pow(xData[i] - meanXValue, 2.0);
            sumY += Math.pow(yData[i] - meanYValue, 2.0);
            prod += (xData[i] - meanXValue) * (yData[i] - meanYValue);
        }
        if (sumX > 0.0 && sumY > 0.0) {
            regCoef[1] = prod / sumX;
            regCoef[0] = meanYValue - regCoef[1] * meanXValue;
            regCoef[2] = Math.pow(prod / Math.sqrt(sumX * sumY), 2.0);
        } else {
            regCoef[1] = 0.0;
            regCoef[0] = 0.0;
            regCoef[2] = 0.0;
        }
        return regCoef;
    }

    public static double dsGrad(double[] obs, double[] sim) {
        Efficiencies.sameArrayLen(obs, sim);
        int dsLength = sim.length;
        double[] cumPred = new double[dsLength];
        double[] cumVali = new double[dsLength];
        double cp = 0.0;
        double cv = 0.0;
        for (int i = 0; i < dsLength; ++i) {
            cumPred[i] = cp += sim[i];
            cumVali[i] = cv += obs[i];
        }
        double[] regCoef = Efficiencies.linearReg(cumVali, cumPred);
        return regCoef[1];
    }

    public static double absVolumeError(double[] obs, double[] sim) {
        Efficiencies.sameArrayLen(obs, sim);
        double volError = 0.0;
        for (int i = 0; i < sim.length; ++i) {
            volError += sim[i] - obs[i];
        }
        return Math.abs(volError);
    }

    public static double pbias(double[] obs, double[] sim) {
        Efficiencies.sameArrayLen(obs, sim);
        double sumObs = 0.0;
        double sumDif = 0.0;
        for (int i = 0; i < sim.length; ++i) {
            sumDif += sim[i] - obs[i];
            sumObs += obs[i];
        }
        return sumDif / sumObs * 100.0;
    }

    public static double rmse(double[] obs, double[] sim) {
        Efficiencies.sameArrayLen(obs, sim);
        double error = 0.0;
        for (int i = 0; i < sim.length; ++i) {
            error += Math.pow(sim[i] - obs[i], 2.0);
        }
        return Math.sqrt(error / (double)sim.length);
    }

    public static double absDiffLog(double[] obs, double[] sim) {
        Efficiencies.sameArrayLen(obs, sim);
        int N = obs.length;
        double abs = 0.0;
        for (int i = 0; i < N; ++i) {
            double measured = obs[i];
            double simulated = sim[i];
            if (measured == 0.0) {
                measured = 1.0E-7;
            } else if (measured < 0.0) {
                throw new RuntimeException("Error on Absolute Difference (log): Observed value is negative.");
            }
            if (simulated == 0.0) {
                simulated = 1.0E-7;
            } else if (simulated < 0.0) {
                throw new RuntimeException("Error on Absolute Difference (log): Simulated value is negative.");
            }
            abs += Math.abs(Math.log(measured) - Math.log(simulated));
        }
        return abs;
    }

    public static double absDiff(double[] obs, double[] sim) {
        Efficiencies.sameArrayLen(obs, sim);
        int N = obs.length;
        double abs = 0.0;
        for (int i = 0; i < N; ++i) {
            double measured = obs[i];
            if (measured == 0.0) {
                measured = 1.0E-7;
            }
            abs += Math.abs((measured - sim[i]) / measured);
        }
        return abs;
    }

    public static double pearsonsCorrelatrion(double[] obs, double[] sim) {
        int j;
        Efficiencies.sameArrayLen(obs, sim);
        double syy = 0.0;
        double sxy = 0.0;
        double sxx = 0.0;
        double ay = 0.0;
        double ax = 0.0;
        int n = 0;
        for (j = 0; j < obs.length; ++j) {
            ax += obs[j];
            ay += sim[j];
            ++n;
        }
        if (n == 0) {
            throw new RuntimeException("Pearson's Correlation cannot be calculated due to no observed values");
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < obs.length; ++j) {
            double xt = obs[j] - ax;
            double yt = sim[j] - ay;
            sxx += xt * xt;
            syy += yt * yt;
            sxy += xt * yt;
        }
        return sxy / Math.sqrt(sxx * syy);
    }

    public static double transformedRmse(double[] obs, double[] sim) {
        Efficiencies.sameArrayLen(sim, obs);
        double error = 0.0;
        double z_pred = 0.0;
        double z_val = 0.0;
        for (int i = 0; i < sim.length; ++i) {
            z_pred = (Math.pow(1.0 + sim[i], 0.3) - 1.0) / 0.3;
            z_val = (Math.pow(1.0 + obs[i], 0.3) - 1.0) / 0.3;
            error += (z_pred - z_val) * (z_pred - z_val);
        }
        return Math.sqrt(error / (double)sim.length);
    }

    public static double runoffCoefficientError(double[] obs, double[] sim, double[] precip) {
        Efficiencies.sameArrayLen(sim, obs, precip);
        double mean_pred = Stats.mean(sim);
        double mean_val = Stats.mean(obs);
        double mean_ppt = Stats.mean(precip);
        double error = Math.abs(mean_pred / mean_ppt - mean_val / mean_ppt);
        return Math.sqrt(error);
    }
}

