/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.util.cosu;

import java.util.Arrays;

public class Fast {
    public static void main(String[] args) {
        int i;
        int N = 2500;
        double M = 4.0;
        int npar = 4;
        double[] LB = new double[]{1.0, 0.0, 0.0, 0.0};
        double[] UB = new double[]{2.0, 1.0, 1.0, 1.0};
        if (N < 2000) {
            throw new RuntimeException("The number of realizations is less than 2000.");
        }
        double wi = Math.floor((double)N / (2.0 * M));
        double m2 = Math.floor(wi / (2.0 * M));
        double r = Math.floor(m2 / (double)npar);
        double[] w = new double[npar];
        if (r < 1.0) {
            for (int i2 = 0; i2 <= npar - 1; ++i2) {
                w[i2] = 1.0;
            }
        } else {
            double t = Math.floor(m2 / (double)npar);
            w[0] = 1.0;
            for (i = 1; i <= npar - 1; ++i) {
                w[i] = 1.0 + (double)i * t;
            }
        }
        int k1 = 0;
        double[][] w2 = new double[npar][w.length];
        for (i = 0; i <= npar - 1; ++i) {
            for (int j = 0; j <= w.length - 1; ++j) {
                w2[i][j] = j == k1 ? wi : w[j];
            }
            ++k1;
        }
        double inc = Math.PI * 2 / (double)N;
        double[] s = new double[N];
        s[0] = -Math.PI;
        for (int i3 = 1; i3 < s.length; ++i3) {
            s[i3] = s[i3 - 1] + inc;
        }
        double[][] x = new double[N][npar];
        double[] y = new double[N];
        double[] V2 = new double[npar];
        double[] VT = new double[npar];
        double[] Ak = new double[(int)Math.floor((N - 1) / 2)];
        double[] Bk = new double[(int)Math.floor((N - 1) / 2)];
        double[] S_par = new double[npar];
        double[] Vex = new double[npar];
        double[] Sex_par = new double[npar];
        for (int h = 0; h <= npar - 1; ++h) {
            for (int j = 0; j <= N - 1; ++j) {
                for (int i4 = 0; i4 <= npar - 1; ++i4) {
                    double p = 0.5 + Math.asin(Math.sin(w2[h][i4] * s[j])) / Math.PI;
                    p = (double)Math.round(p * 10000.0) / 10000.0;
                    x[j][i4] = p * (UB[i4] - LB[i4]) + LB[i4];
                }
                y[j] = Fast.run_model(x[j][0], x[j][1], x[j][2], x[j][3]);
            }
            V2[h] = 0.0;
            for (int k = 1; k <= (N - 1) / 2; ++k) {
                double A = 0.0;
                double B = 0.0;
                for (int j = 0; j <= N - 1; ++j) {
                    if (j == 0) {
                        A = y[j] * Math.cos(s[j] * (double)k);
                        B = y[j] * Math.sin(s[j] * (double)k);
                    } else {
                        A += y[j] * Math.cos(s[j] * (double)k);
                        B += y[j] * Math.sin(s[j] * (double)k);
                    }
                    A = (double)Math.round(A * 10000.0) / 10000.0;
                    B = (double)Math.round(B * 10000.0) / 10000.0;
                }
                Ak[k - 1] = A * 2.0 / (double)N;
                Bk[k - 1] = B * 2.0 / (double)N;
                V2[h] = V2[h] + Math.pow(A * 2.0 / (double)N, 2.0) + Math.pow(B * 2.0 / (double)N, 2.0);
                V2[h] = (double)Math.round(V2[h] * 10000.0) / 10000.0;
            }
            VT[h] = V2[h] / 2.0;
            V2[h] = 0.0;
            int q = 1;
            while ((double)q <= M) {
                V2[h] = V2[h] + Math.pow(Ak[(int)((double)q * w2[h][h]) - 1], 2.0) + Math.pow(Bk[(int)((double)q * w2[h][h]) - 1], 2.0);
                V2[h] = (double)Math.round(V2[h] * 10000.0) / 10000.0;
                ++q;
            }
            V2[h] = V2[h] / 2.0;
            S_par[h] = V2[h] / VT[h];
            S_par[h] = (double)Math.round(S_par[h] * 1000000.0) / 1000000.0;
            Vex[h] = 0.0;
            q = 1;
            while ((double)q <= M) {
                for (int c = 0; c <= npar - 1; ++c) {
                    if (c == h) continue;
                    Vex[h] = Vex[h] + Math.pow(Ak[(int)((double)q * w2[h][c]) - 1], 2.0) + Math.pow(Bk[(int)((double)q * w2[h][c]) - 1], 2.0);
                    Vex[h] = (double)Math.round(Vex[h] * 10000.0) / 10000.0;
                }
                ++q;
            }
            int n = h;
            Vex[n] = Vex[n] / 2.0;
            Sex_par[h] = 1.0 - Vex[h] / VT[h];
            Sex_par[h] = (double)Math.round(Sex_par[h] * 1000000.0) / 1000000.0;
        }
        System.out.println("S  =" + Arrays.toString(S_par));
        System.out.println("ST =" + Arrays.toString(Sex_par));
    }

    static double run_model(double x1, double x2, double x3, double x4) {
        double y = x1 * x2 + x3 + x4;
        return y;
    }
}

