/*
 * Decompiled with CFR 0.152.
 */
package oms3.ngmf.util.cosu.luca.of;

import oms3.ObjectiveFunction;

public class NormalizedRMSE
implements ObjectiveFunction {
    @Override
    public boolean positiveDirection() {
        return false;
    }

    @Override
    public double calculate(double[] obs, double[] sim, double missing) {
        return NormalizedRMSE.calc(obs, sim, missing);
    }

    static double calc(double[] obs, double[] sim, double missing) {
        double measuredMean = NormalizedRMSE.mean(obs, missing);
        int N = Math.min(obs.length, sim.length);
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < N; ++i) {
            if (!(obs[i] > missing)) continue;
            numerator += (obs[i] - sim[i]) * (obs[i] - sim[i]);
            denominator += (obs[i] - measuredMean) * (obs[i] - measuredMean);
        }
        if (denominator == 0.0) {
            throw new RuntimeException("Error: The denominator is 0.\nThis happens if all observed values are equal to their mean.");
        }
        return Math.sqrt(numerator / denominator);
    }

    static double mean(double[] array, double missing) {
        double sum = 0.0;
        double size = 0.0;
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > missing)) continue;
            sum += array[i];
            size += 1.0;
        }
        return sum / size;
    }
}

